/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot;

import java.io.Serializable;
import java.util.Objects;
import java.util.logging.Level;

public class NBootLogConfig
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static NBootLogConfig BLANK = new NBootLogConfig().readOnly();
    private Level logFileLevel = Level.OFF;
    private Level logTermLevel = Level.OFF;
    private int logFileSize = 0;
    private int logFileCount = 0;
    private String logFileName = null;
    private String logFileBase = null;
    private boolean readOnly;

    public NBootLogConfig() {
    }

    public NBootLogConfig(NBootLogConfig other, boolean readOnly) {
        this.readOnly = readOnly;
        if (other != null) {
            this.logFileLevel = other.logFileLevel;
            this.logTermLevel = other.logTermLevel;
            this.logFileSize = other.logFileSize;
            this.logFileCount = other.logFileCount;
            this.logFileName = other.logFileName;
            this.logFileBase = other.logFileBase;
        }
    }

    public Level getLogFileLevel() {
        return this.logFileLevel;
    }

    public NBootLogConfig setLogFileLevel(Level logFileLevel) {
        if (this.readOnly) {
            throw new IllegalArgumentException("read only");
        }
        this.logFileLevel = logFileLevel;
        return this;
    }

    public Level getLogTermLevel() {
        return this.logTermLevel;
    }

    public NBootLogConfig setLogTermLevel(Level logTermLevel) {
        if (this.readOnly) {
            throw new IllegalArgumentException("read only");
        }
        this.logTermLevel = logTermLevel;
        return this;
    }

    public int getLogFileSize() {
        return this.logFileSize;
    }

    public NBootLogConfig setLogFileSize(int logFileSize) {
        if (this.readOnly) {
            throw new IllegalArgumentException("read only");
        }
        this.logFileSize = logFileSize;
        return this;
    }

    public int getLogFileCount() {
        return this.logFileCount;
    }

    public NBootLogConfig setLogFileCount(int logFileCount) {
        if (this.readOnly) {
            throw new IllegalArgumentException("read only");
        }
        this.logFileCount = logFileCount;
        return this;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public NBootLogConfig setLogFileName(String logFileName) {
        if (this.readOnly) {
            throw new IllegalArgumentException("read only");
        }
        this.logFileName = logFileName;
        return this;
    }

    public String getLogFileBase() {
        return this.logFileBase;
    }

    public NBootLogConfig setLogFileBase(String logFileBase) {
        if (this.readOnly) {
            throw new IllegalArgumentException("read only");
        }
        this.logFileBase = logFileBase;
        return this;
    }

    public NBootLogConfig copy() {
        return new NBootLogConfig(this, false);
    }

    public NBootLogConfig readOnly() {
        if (this.readOnly) {
            return this;
        }
        return new NBootLogConfig(this, true);
    }

    public int hashCode() {
        return Objects.hash(this.logFileLevel, this.logTermLevel, this.logFileSize, this.logFileCount, this.logFileName, this.logFileBase);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NBootLogConfig that = (NBootLogConfig)o;
        return this.logFileSize == that.logFileSize && this.logFileCount == that.logFileCount && Objects.equals(this.logFileLevel, that.logFileLevel) && Objects.equals(this.logTermLevel, that.logTermLevel) && Objects.equals(this.logFileName, that.logFileName) && Objects.equals(this.logFileBase, that.logFileBase);
    }

    public String toString() {
        return "NutsLogConfig{logFileLevel=" + this.logFileLevel + ", logTermLevel=" + this.logTermLevel + ", logFileSize=" + this.logFileSize + ", logFileCount=" + this.logFileCount + ", logFileName='" + this.logFileName + '\'' + ", logFileBase='" + this.logFileBase + '\'' + ", readOnly=" + this.readOnly + '}';
    }
}

