/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.boot.NBootRepositoryLocation;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public class NBootRepositoryConfig
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String name;
    private NBootRepositoryLocation location;
    private Map<String, String> storeLocations = null;
    private String storeStrategy = null;
    private String groups;
    private Map<String, String> env;
    private String authenticationAgent;
    private String[] tags;

    public NBootRepositoryConfig copy() {
        return this.clone();
    }

    protected NBootRepositoryConfig clone() {
        try {
            NBootRepositoryConfig o = (NBootRepositoryConfig)super.clone();
            if (o.location != null) {
                o.location = o.location.copy();
            }
            if (o.storeLocations != null) {
                o.storeLocations = new LinkedHashMap<String, String>(this.storeLocations);
            }
            if (o.env != null) {
                o.env = new LinkedHashMap<String, String>(o.env);
            }
            if (o.tags != null) {
                o.tags = Arrays.copyOf(this.tags, this.tags.length);
            }
            return o;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String[] getTags() {
        return this.tags;
    }

    public NBootRepositoryConfig setTags(String[] tags) {
        this.tags = tags;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public NBootRepositoryConfig setName(String name) {
        this.name = name;
        return this;
    }

    public NBootRepositoryLocation getLocation() {
        return this.location;
    }

    public NBootRepositoryConfig setLocation(NBootRepositoryLocation location) {
        this.location = location;
        return this;
    }

    public String getStoreStrategy() {
        return this.storeStrategy;
    }

    public NBootRepositoryConfig setStoreStrategy(String storeStrategy) {
        this.storeStrategy = storeStrategy;
        return this;
    }

    public String getGroups() {
        return this.groups;
    }

    public NBootRepositoryConfig setGroups(String groups) {
        this.groups = groups;
        return this;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public NBootRepositoryConfig setEnv(Map<String, String> env) {
        this.env = env;
        return this;
    }

    public String getAuthenticationAgent() {
        return this.authenticationAgent;
    }

    public NBootRepositoryConfig setAuthenticationAgent(String authenticationAgent) {
        this.authenticationAgent = authenticationAgent;
        return this;
    }

    public Map<String, String> getStoreLocations() {
        return this.storeLocations;
    }

    public NBootRepositoryConfig setStoreLocations(Map<String, String> storeLocations) {
        this.storeLocations = storeLocations;
        return this;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.name);
        hash = 53 * hash + Objects.hashCode(this.location);
        hash = 53 * hash + Objects.hashCode(this.storeLocations);
        hash = 53 * hash + Objects.hashCode(this.storeStrategy);
        hash = 53 * hash + Objects.hashCode(this.groups);
        hash = 53 * hash + Objects.hashCode(this.env);
        hash = 53 * hash + Objects.hashCode(this.authenticationAgent);
        hash = 53 * hash + Arrays.hashCode(this.tags);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NBootRepositoryConfig other = (NBootRepositoryConfig)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.location, other.location)) {
            return false;
        }
        if (!Objects.equals(this.groups, other.groups)) {
            return false;
        }
        if (!Objects.equals(this.authenticationAgent, other.authenticationAgent)) {
            return false;
        }
        if (!Objects.equals(this.storeLocations, other.storeLocations)) {
            return false;
        }
        if (!NBootUtils.sameEnum(this.storeStrategy, other.storeStrategy)) {
            return false;
        }
        if (!Objects.equals(this.env, other.env)) {
            return false;
        }
        return Arrays.equals(this.tags, other.tags);
    }

    public String toString() {
        return "NutsRepositoryConfig{, name=" + this.name + ", location=" + this.location + ", storeLocations=" + (this.storeLocations == null ? "null" : this.storeLocations.toString()) + ", storeStrategy=" + this.storeStrategy + ", groups=" + this.groups + ", env=" + this.env + ", authenticationAgent=" + this.authenticationAgent + ", tags=" + (this.tags == null ? "[]" : Arrays.toString(this.tags)) + '}';
    }
}

