/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.boot.NBootRepositoryLocation;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public class NBootRepositoryLocationList {
    private final List<NBootRepositoryLocation> all = new ArrayList<NBootRepositoryLocation>();

    public NBootRepositoryLocationList(NBootRepositoryLocation[] all) {
        this.addAll(all);
    }

    public NBootRepositoryLocationList() {
    }

    public NBootRepositoryLocation[] toArray() {
        return this.all.toArray(new NBootRepositoryLocation[0]);
    }

    public boolean containsName(String name) {
        return this.indexOfName(name, 0) >= 0;
    }

    public boolean containsURL(String url) {
        return this.indexOfURL(url, 0) >= 0;
    }

    public boolean containsSelection(NBootRepositoryLocation s) {
        return this.indexOf(s, 0) >= 0;
    }

    public int indexOfName(String name, int offset) {
        String trimmedName = NBootUtils.trim(name);
        for (int i = offset; i < this.all.size(); ++i) {
            if (!trimmedName.equals(NBootUtils.trim(this.all.get(i).getName()))) continue;
            return i;
        }
        return -1;
    }

    public int indexOfNames(String[] names, int offset) {
        for (int i = offset; i < this.all.size(); ++i) {
            NBootRepositoryLocation loc = this.all.get(i);
            String trimmedLocName = NBootUtils.trim(loc.getName());
            for (String name : names) {
                String trimmedName = NBootUtils.trim(name);
                if (!trimmedName.equals(trimmedLocName)) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOfURL(String url, int offset) {
        String trimmedName = NBootUtils.trim(url);
        for (int i = offset; i < this.all.size(); ++i) {
            if (!trimmedName.equals(NBootUtils.trim(this.all.get(i).getPath()))) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(NBootRepositoryLocation other, int offset) {
        if (other == null) {
            return -1;
        }
        for (int i = offset; i < this.all.size(); ++i) {
            NBootRepositoryLocation o = this.all.get(i);
            if (!NBootUtils.trim(other.getName()).equals(NBootUtils.trim(o.getName())) || !NBootUtils.trim(other.getPath()).equals(NBootUtils.trim(o.getPath()))) continue;
            return i;
        }
        return -1;
    }

    public NBootRepositoryLocationList addAll(NBootRepositoryLocation[] all) {
        if (all != null) {
            for (NBootRepositoryLocation a : all) {
                this.add(a);
            }
        }
        return this;
    }

    public NBootRepositoryLocationList add(NBootRepositoryLocation a) {
        if (a != null) {
            String n = NBootUtils.trim(a.getName());
            if (n.isEmpty()) {
                if (this.indexOf(a, 0) < 0) {
                    this.all.add(a);
                }
            } else if (this.indexOfName(a.getName(), 0) < 0) {
                this.all.add(a);
            }
        }
        return this;
    }

    public NBootRepositoryLocation removeAt(int i) {
        return this.all.remove(i);
    }

    public NBootRepositoryLocationList clear() {
        this.all.clear();
        return this;
    }
}

