/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.boot.NBootAddRepositoryOptions;
import net.thevpc.nuts.boot.NBootRepositoryLocation;
import net.thevpc.nuts.boot.NBootRepositoryLocationList;
import net.thevpc.nuts.boot.NBootRepositorySelector;
import net.thevpc.nuts.boot.internal.util.NBootRepositoryDB;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public class NBootRepositorySelectorList {
    private final List<NBootRepositorySelector> selectors = new ArrayList<NBootRepositorySelector>();

    public NBootRepositorySelectorList() {
    }

    public NBootRepositorySelectorList(NBootRepositorySelector[] a) {
        for (NBootRepositorySelector repoDefString : a) {
            if (repoDefString == null) continue;
            this.selectors.add(repoDefString);
        }
    }

    public static NBootRepositorySelectorList of(List<String> expressions) {
        return NBootRepositorySelectorList.of(expressions, NBootRepositoryDB.of());
    }

    public static NBootRepositorySelectorList of(List<String> expressions, NBootRepositoryDB db) {
        if (expressions == null) {
            return new NBootRepositorySelectorList();
        }
        NBootRepositorySelectorList result = new NBootRepositorySelectorList();
        for (String t : expressions) {
            NBootRepositorySelectorList r;
            if (t == null || (t = t.trim()).isEmpty() || (r = NBootRepositorySelectorList.of(t, db)) == null) continue;
            result = result.merge(r);
        }
        return result;
    }

    public static NBootRepositorySelectorList of(String expression, NBootRepositoryDB db) {
        if (NBootUtils.isBlank(expression)) {
            return new NBootRepositorySelectorList();
        }
        String op = "INCLUDE";
        ArrayList<NBootRepositorySelector> all = new ArrayList<NBootRepositorySelector>();
        for (String s : NBootUtils.split(expression, ",;", true, true)) {
            if ((s = s.trim()).length() <= 0) continue;
            NBootRepositorySelector oe = NBootRepositorySelector.of(op, s, db);
            if (oe == null) {
                return null;
            }
            NBootRepositorySelector e = oe;
            op = e.getOp();
            all.add(e);
        }
        return new NBootRepositorySelectorList(all.toArray(new NBootRepositorySelector[0]));
    }

    public NBootRepositorySelectorList merge(NBootRepositorySelectorList other) {
        if (other == null || other.selectors.isEmpty()) {
            return this;
        }
        ArrayList<NBootRepositorySelector> result = new ArrayList<NBootRepositorySelector>();
        result.addAll(this.selectors);
        result.addAll(other.selectors);
        return new NBootRepositorySelectorList(result.toArray(new NBootRepositorySelector[0]));
    }

    /*
     * WARNING - void declaration
     */
    public NBootRepositoryLocation[] resolve(NBootRepositoryLocation[] available, NBootRepositoryDB db) {
        Set<String> allNames;
        NBootRepositoryLocationList current = new NBootRepositoryLocationList();
        if (available != null) {
            for (NBootRepositoryLocation entry : available) {
                NBootAddRepositoryOptions ro;
                if (entry == null) continue;
                String k = entry.getName();
                String v = entry.getFullLocation();
                if (NBootUtils.isBlank(v) && !NBootUtils.isBlank(k)) {
                    String u;
                    ro = db.getRepositoryOptionsByName(k);
                    String string = u = ro == null ? null : ro.getConfig().getLocation().getFullLocation();
                    v = u != null ? u : k;
                } else if (!NBootUtils.isBlank(v) && NBootUtils.isBlank(k)) {
                    String n;
                    ro = db.getRepositoryOptionsByLocation(k);
                    String string = n = ro == null ? null : ro.getName();
                    if (n != null) {
                        k = n;
                    }
                }
                current.add(NBootRepositoryLocation.of(k, v));
            }
        }
        ArrayList<Object> result = new ArrayList<Object>();
        HashSet<String> visited = new HashSet<String>();
        ArrayList<NBootRepositorySelector> selectorsExclude = new ArrayList<NBootRepositorySelector>();
        ArrayList<NBootRepositorySelector> selectorsInclude = new ArrayList<NBootRepositorySelector>();
        boolean exact = false;
        for (NBootRepositorySelector selector : this.selectors) {
            switch (selector.getOp()) {
                case "EXACT": {
                    exact = true;
                    selectorsInclude.add(selector);
                    break;
                }
                case "INCLUDE": {
                    selectorsInclude.add(selector);
                    break;
                }
                case "EXCLUDE": {
                    selectorsExclude.add(selector);
                }
            }
        }
        if (exact) {
            current.clear();
        }
        for (NBootRepositorySelector r : selectorsExclude) {
            allNames = this.getAllNames(r, db);
            int n = current.indexOfNames(allNames.toArray(new String[0]), 0);
            if (n < 0) continue;
            current.removeAt(n);
        }
        for (NBootRepositorySelector r : selectorsInclude) {
            void var12_22;
            allNames = this.getAllNames(r, db);
            if (this.isVisitedFlag(allNames, visited)) continue;
            visited.addAll(allNames);
            Object var12_20 = null;
            Iterator<String> iterator = allNames.iterator();
            if (iterator.hasNext()) {
                String n = iterator.next();
                NBootAddRepositoryOptions nBootAddRepositoryOptions = db.getRepositoryOptionsByName(n);
            }
            String newName = r.getName() == null ? (var12_22 == null ? null : var12_22.getName()) : r.getName();
            NBootRepositoryLocation newLocation = r.getLocation();
            if (var12_22 != null && var12_22.getConfig() != null && var12_22.getConfig().getLocation() != null) {
                if (var12_22.getConfig().getLocation().getLocationType() != null) {
                    newLocation = newLocation.setLocationType(var12_22.getConfig().getLocation().getLocationType());
                }
                if (var12_22.getConfig().getLocation().getLocationType() != null && (NBootUtils.isBlank(newLocation.getPath()) || Objects.equals(newLocation.getPath(), var12_22.getConfig().getLocation().getName()) || Objects.equals(newLocation.getPath(), var12_22.getConfig().getLocation().getLocationType()))) {
                    newLocation = newLocation.setPath(var12_22.getConfig().getLocation().getPath());
                }
            }
            result.add(NBootRepositoryLocation.of(newName, newLocation.getFullLocation()));
        }
        for (Iterator<NBootRepositorySelector> iterator : current.toArray()) {
            Set<String> allNames2;
            if (!this.acceptExisting((NBootRepositoryLocation)((Object)iterator)) || this.isVisitedFlag(allNames2 = db.findAllNamesByName(((NBootRepositoryLocation)((Object)iterator)).getName()), visited)) continue;
            visited.addAll(allNames2);
            result.add(iterator);
        }
        return result.toArray(new NBootRepositoryLocation[0]);
    }

    private Set<String> getAllNames(NBootRepositorySelector r, NBootRepositoryDB db) {
        if (!NBootUtils.isBlank(r.getName())) {
            NBootAddRepositoryOptions lo = db.getRepositoryOptionsByName(r.getName());
            if (lo == null && !NBootUtils.isBlank(r.getLocation().getTypeAndPath())) {
                lo = db.getRepositoryOptionsByName(r.getLocation().getTypeAndPath());
            }
            if (lo != null) {
                return db.findAllNamesByName(lo.getName());
            }
            return Collections.singleton(r.getName());
        }
        if (!NBootUtils.isBlank(r.getLocation().getTypeAndPath())) {
            NBootAddRepositoryOptions lo = db.getRepositoryOptionsByLocation(r.getLocation().getTypeAndPath());
            if (lo == null && !NBootUtils.isBlank(r.getName())) {
                lo = db.getRepositoryOptionsByLocation(r.getName());
            }
            if (lo == null) {
                lo = db.getRepositoryOptionsByName(r.getLocation().getTypeAndPath());
            }
            String name = lo == null ? null : lo.getName();
            return db.findAllNamesByName(name);
        }
        return Collections.emptySet();
    }

    private boolean isVisitedFlag(Set<String> allNames, Set<String> visited) {
        boolean visitedFlag = false;
        for (String allName : allNames) {
            if (!visited.contains(allName)) continue;
            visitedFlag = true;
            break;
        }
        return visitedFlag;
    }

    public boolean acceptExisting(NBootRepositoryLocation location) {
        boolean includeOthers = true;
        for (NBootRepositorySelector s : this.selectors) {
            if (s.matches(location)) {
                switch (s.getOp()) {
                    case "EXACT": 
                    case "INCLUDE": {
                        return true;
                    }
                    case "EXCLUDE": {
                        return false;
                    }
                }
            }
            if (!s.getOp().equals("EXACT")) continue;
            includeOthers = false;
        }
        return includeOthers;
    }

    public NBootRepositorySelector[] toArray() {
        return this.selectors.toArray(new NBootRepositorySelector[0]);
    }

    public String toString() {
        return this.selectors.stream().map(x -> String.valueOf(x)).collect(Collectors.joining(","));
    }
}

