/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Scanner;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.thevpc.nuts.boot.NBootArguments;
import net.thevpc.nuts.boot.NBootClassLoaderNode;
import net.thevpc.nuts.boot.NBootClassLoaderNodeBuilder;
import net.thevpc.nuts.boot.NBootDependency;
import net.thevpc.nuts.boot.NBootDescriptor;
import net.thevpc.nuts.boot.NBootException;
import net.thevpc.nuts.boot.NBootId;
import net.thevpc.nuts.boot.NBootInvalidWorkspaceException;
import net.thevpc.nuts.boot.NBootLogConfig;
import net.thevpc.nuts.boot.NBootOptionsInfo;
import net.thevpc.nuts.boot.NBootRepositoryLocation;
import net.thevpc.nuts.boot.NBootRepositorySelector;
import net.thevpc.nuts.boot.NBootRepositorySelectorList;
import net.thevpc.nuts.boot.NBootUnsatisfiedRequirementsException;
import net.thevpc.nuts.boot.NBootVersion;
import net.thevpc.nuts.boot.NBootWorkspace;
import net.thevpc.nuts.boot.NBootWorkspaceAlreadyExistsException;
import net.thevpc.nuts.boot.NBootWorkspaceFactory;
import net.thevpc.nuts.boot.NBootWorkspaceNotFoundException;
import net.thevpc.nuts.boot.core.NAnyBootAwareExceptionBase;
import net.thevpc.nuts.boot.core.NExceptionWithExitCodeBase;
import net.thevpc.nuts.boot.core.NWorkspaceBase;
import net.thevpc.nuts.boot.internal.cmdline.NBootArg;
import net.thevpc.nuts.boot.internal.cmdline.NBootCmdLine;
import net.thevpc.nuts.boot.internal.cmdline.NBootWorkspaceCmdLineFormatter;
import net.thevpc.nuts.boot.internal.cmdline.NBootWorkspaceCmdLineParser;
import net.thevpc.nuts.boot.internal.cmdline.NBootWorkspaceOptionsConfig;
import net.thevpc.nuts.boot.internal.maven.NReservedMavenUtilsBoot;
import net.thevpc.nuts.boot.internal.util.NBootBootConfigLoader;
import net.thevpc.nuts.boot.internal.util.NBootCache;
import net.thevpc.nuts.boot.internal.util.NBootClassLoader;
import net.thevpc.nuts.boot.internal.util.NBootContext;
import net.thevpc.nuts.boot.internal.util.NBootErrorInfoList;
import net.thevpc.nuts.boot.internal.util.NBootI18n;
import net.thevpc.nuts.boot.internal.util.NBootIdCache;
import net.thevpc.nuts.boot.internal.util.NBootJsonParser;
import net.thevpc.nuts.boot.internal.util.NBootLog;
import net.thevpc.nuts.boot.internal.util.NBootMsg;
import net.thevpc.nuts.boot.internal.util.NBootPath;
import net.thevpc.nuts.boot.internal.util.NBootPlatformHome;
import net.thevpc.nuts.boot.internal.util.NBootPositionTypeBoot;
import net.thevpc.nuts.boot.internal.util.NBootRepositoryDB;
import net.thevpc.nuts.boot.internal.util.NBootUtils;
import net.thevpc.nuts.boot.internal.util.NBootWorkspaceFactoryComparator;
import net.thevpc.nuts.boot.internal.util.NBootWorkspaceHelper;
import net.thevpc.nuts.boot.internal.util.NReservedErrorInfo;

public final class NBootWorkspaceImpl
implements NBootWorkspace {
    public static final boolean DEFAULT_PREVIEW = true;
    private final Instant creationTime = Instant.now();
    private NBootOptionsInfo options;
    private boolean newWorkspace = true;
    private List<String> previousRepositories = new ArrayList<String>();
    private final NBootContext bContext = new NBootContext();
    private final NBootRepositoryDB repositoryDB = new NBootRepositoryDB();
    private final Function<String, String> pathExpansionConverter = new Function<String, String>(){

        @Override
        public String apply(String from) {
            switch (from) {
                case "workspace": {
                    return NBootWorkspaceImpl.this.options.getWorkspace();
                }
                case "user.home": {
                    return System.getProperty("user.home");
                }
                case "home.apps": 
                case "home.config": 
                case "home.lib": 
                case "home.temp": 
                case "home.var": 
                case "home.cache": 
                case "home.run": 
                case "home.log": {
                    return NBootUtils.getHome(from.substring("home.".length()).toUpperCase(), NBootWorkspaceImpl.this.options);
                }
                case "apps": 
                case "config": 
                case "lib": 
                case "cache": 
                case "run": 
                case "temp": 
                case "log": 
                case "var": {
                    Map s = NBootUtils.firstNonNull(NBootWorkspaceImpl.this.options.getStoreLocations(), Collections.emptyMap());
                    String v = (String)s.get(from);
                    if (v == null) {
                        return "${" + from + "}";
                    }
                    return v;
                }
            }
            return "${" + from + "}";
        }
    };
    private int newInstanceRequirements = 0;
    private NBootOptionsInfo lastWorkspaceOptions;
    private Set<NBootRepositoryLocation> parsedBootRuntimeRepositories;
    private boolean preparedWorkspace;
    private Scanner scanner;
    Boolean runtimeLoaded;
    NBootId runtimeLoadedId;
    NBootArguments unparsedOptions;
    NWorkspaceBase loadedWorkspace;
    Runnable exceptionRunnable;

    public NBootWorkspaceImpl(NBootArguments userOptionsUnparsed0) {
        this.bContext.runWith(() -> {
            NBootArguments userOptionsUnparsed = userOptionsUnparsed0;
            if (userOptionsUnparsed == null) {
                userOptionsUnparsed = new NBootArguments();
            }
            NBootOptionsInfo userOptions = new NBootOptionsInfo();
            try {
                this.unparsedOptions = userOptionsUnparsed;
                userOptions.setStdin(userOptionsUnparsed.getIn());
                userOptions.setStdout(userOptionsUnparsed.getOut());
                userOptions.setStderr(userOptionsUnparsed.getErr());
                userOptions.setCreationTime(userOptionsUnparsed.getStartTime());
                InputStream in = userOptions.getStdin();
                this.scanner = new Scanner(in == null ? System.in : in);
                NBootContext.context().log = new NBootLog(userOptions);
                ArrayList<String> aargs = new ArrayList<String>();
                if (!userOptionsUnparsed.isSkipInherited()) {
                    aargs.addAll(Arrays.asList(NBootCmdLine.parseDefault(NBootUtils.trim(System.getProperty("nuts.boot.args")))));
                    aargs.addAll(Arrays.asList(NBootCmdLine.parseDefault(NBootUtils.trim(System.getProperty("nuts.args")))));
                }
                if (userOptionsUnparsed.getOptionArgs() != null) {
                    for (String appArg : userOptionsUnparsed.getOptionArgs()) {
                        if (appArg == null) continue;
                        aargs.add(appArg);
                    }
                }
                NBootWorkspaceCmdLineParser.parseNutsArguments(aargs.toArray(new String[0]), userOptions);
                if (NBootUtils.firstNonNull(userOptions.getSkipErrors(), false).booleanValue()) {
                    StringBuilder errorMessage = new StringBuilder();
                    if (userOptions.getErrors() != null) {
                        for (String s : userOptions.getErrors()) {
                            errorMessage.append(s).append("\n");
                        }
                    }
                    errorMessage.append(NBootI18n.of("Try 'nuts --help' for more information."));
                    NBootContext.log().warn(NBootMsg.ofC(NBootI18n.of("Skipped Error : %s"), errorMessage));
                }
                if (userOptionsUnparsed.getAppArgs() != null) {
                    userOptions.getApplicationArguments().addAll(Arrays.asList(userOptionsUnparsed.getAppArgs()));
                }
                this.options = userOptions.copy();
                NBootContext.context().connectionTimout = this.options.getCustomOptions().stream().map(x -> NBootArg.of(x)).filter(x -> Objects.equals(x.getOptionName(), "---connection-timeout")).map(x -> x.getIntValue()).filter(x -> x != null).findFirst().orElse(null);
                this.postInit();
            }
            catch (Exception e) {
                NBootErrorInfoList li = new NBootErrorInfoList();
                li.add(new NReservedErrorInfo(null, null, null, NBootUtils.getErrorMessage(e), e));
                NBootOptionsInfo currOptions = this.options == null ? userOptions : this.options;
                this.logError(new URL[0], li, currOptions);
                throw new NBootException(NBootMsg.ofC(NBootI18n.of("unable to initialize boot %s#%s : %s"), "net.thevpc.nuts:nuts", currOptions.getApiVersion(), e));
            }
        });
    }

    public NBootWorkspaceImpl(NBootOptionsInfo options0) {
        this.bContext.runWith(() -> {
            NBootOptionsInfo options = options0;
            if (options == null) {
                options = new NBootOptionsInfo();
            }
            NBootContext.context().log = new NBootLog(options);
            this.options = options;
            this.postInit();
        });
    }

    @Override
    public NBootArguments getBootArguments() {
        return this.unparsedOptions;
    }

    @Override
    public NBootOptionsInfo getOptions() {
        return this.options;
    }

    private void postInit() {
        this.bContext.runWith(() -> {
            if (this.options == null) {
                this.options = new NBootOptionsInfo();
            }
            if (this.options.getCreationTime() == null) {
                this.options.setCreationTime(this.creationTime);
            }
            NBootContext.log().setOptions(this.options);
        });
    }

    private static void revalidateLocations(NBootOptionsInfo bootOptions, String workspaceName, boolean immediateLocation, String isolationLevel) {
        if (NBootUtils.isBlank(bootOptions.getName())) {
            bootOptions.setName(workspaceName);
        }
        boolean system = NBootUtils.firstNonNull(bootOptions.getSystem(), false);
        if (NBootUtils.sameEnum(isolationLevel, "SANDBOX") || NBootUtils.sameEnum(isolationLevel, "MEMORY")) {
            bootOptions.setStoreStrategy("STANDALONE");
            bootOptions.setRepositoryStoreStrategy("EXPLODED");
            system = false;
        } else {
            if (bootOptions.getStoreStrategy() == null) {
                bootOptions.setStoreStrategy(immediateLocation ? "EXPLODED" : "STANDALONE");
            }
            if (bootOptions.getRepositoryStoreStrategy() == null) {
                bootOptions.setRepositoryStoreStrategy("EXPLODED");
            }
        }
        Map<String, String> storeLocations = NBootPlatformHome.of(bootOptions.getStoreLayout(), system).buildLocations(bootOptions.getStoreStrategy(), bootOptions.getStoreLocations(), bootOptions.getHomeLocations(), bootOptions.getWorkspace());
        if (new HashSet<String>(storeLocations.values()).size() != storeLocations.size()) {
            LinkedHashMap<String, List> conflicts = new LinkedHashMap<String, List>();
            for (Map.Entry<String, String> e : storeLocations.entrySet()) {
                conflicts.computeIfAbsent(e.getValue(), k -> new ArrayList()).add(e.getKey());
            }
            StringBuilder error = new StringBuilder();
            error.append(NBootI18n.of("invalid store locations. Two or more stores point to the same location:"));
            ArrayList<String> errorParams = new ArrayList<String>();
            for (Map.Entry e : conflicts.entrySet()) {
                List ev = (List)e.getValue();
                if (ev.size() <= 1) continue;
                String ek = (String)e.getKey();
                error.append("\n");
                error.append("all of (").append(ev.stream().map(x -> "%s").collect(Collectors.joining(","))).append(") point to %s");
                errorParams.addAll(ev);
                errorParams.add(ek);
            }
            throw new NBootException(NBootMsg.ofC(error.toString(), errorParams.toArray()));
        }
        bootOptions.setStoreLocations(storeLocations);
    }

    private static String getApiDigestOrInternal() {
        return ApiDigestHolder.apiDigest == null ? "<internal>" : ApiDigestHolder.apiDigest;
    }

    public boolean hasUnsatisfiedRequirements() {
        this.prepareWorkspace();
        return this.newInstanceRequirements != 0;
    }

    public void runNewProcess() {
        int result;
        String[] processCmdLine = this.createProcessCmdLine();
        try {
            NBootContext.log().log(Level.FINE, "START", NBootMsg.ofC("start new process : %s", new NBootCmdLine(processCmdLine)));
            result = new ProcessBuilder(processCmdLine).inheritIO().start().waitFor();
        }
        catch (IOException | InterruptedException ex) {
            throw new NBootException(NBootMsg.ofPlain(NBootI18n.of("failed to run new nuts process")), (Throwable)ex);
        }
        if (result != 0) {
            throw new NBootException(NBootMsg.ofC(NBootI18n.of("failed to exec new process. returned %s"), result));
        }
    }

    public Set<NBootRepositoryLocation> resolveBootRuntimeRepositories() {
        return this.bContext.callWith(() -> {
            Set rr;
            if (this.parsedBootRuntimeRepositories != null) {
                return this.parsedBootRuntimeRepositories;
            }
            NBootLog log = NBootContext.log();
            List<String> initRepositories = this.options.getBootRepositories();
            List<String> repositories = this.options.getRepositories();
            log.log(Level.FINE, "START", NBootMsg.ofC(NBootI18n.of("resolving boot repositories to load nuts-runtime from options : selection is %s and init is %s"), repositories == null ? "[]" : repositories.toString(), initRepositories == null ? "[]" : initRepositories));
            NBootRepositorySelector[] available = NBootRepositorySelectorList.of(this.previousRepositories, this.repositoryDB).toArray();
            if (available.length == 0) {
                ArrayList<NBootRepositorySelector> drs = new ArrayList<NBootRepositorySelector>();
                ArrayList<String> tags = new ArrayList<String>();
                tags.add("main");
                if (this.options.getPreviewRepo() != null) {
                    if (this.options.getPreviewRepo().booleanValue()) {
                        tags.add("preview");
                    }
                } else {
                    tags.add("preview");
                }
                for (String s : this.repositoryDB.findByAnyTag(tags.toArray(new String[0]))) {
                    if ("maven".equals(s)) {
                        for (String customOption : this.options.getCustomOptions()) {
                            boolean m2;
                            NBootArg a = new NBootArg(customOption);
                            if (!"---m2".equals(a.key())) continue;
                            if (!a.isActive()) break;
                            boolean bl = a.isEnabled() ? NBootUtils.parseBoolean(a.getValue(), true, true) : (m2 = NBootUtils.parseBoolean(a.getValue(), true, false) == false);
                            if (!m2) continue;
                        }
                    }
                    drs.add(new NBootRepositorySelector("INCLUDE", NBootRepositoryLocation.of(s, this.repositoryDB)));
                }
                available = drs.toArray(new NBootRepositorySelector[0]);
            }
            NBootRepositorySelectorList bootRepositoriesSelector = NBootRepositorySelectorList.of(repositories, this.repositoryDB);
            NBootRepositoryLocation[] result = bootRepositoriesSelector.resolve((NBootRepositoryLocation[])Arrays.stream(available).map(x -> NBootRepositoryLocation.of(x.getName(), x.getUrl())).toArray(NBootRepositoryLocation[]::new), this.repositoryDB);
            result = (NBootRepositoryLocation[])Arrays.stream(result).map(r -> {
                if (NBootUtils.isBlank(r.getLocationType()) || NBootUtils.isBlank(r.getName())) {
                    boolean fileExists = false;
                    if (r.getPath() != null) {
                        NBootPath r1 = new NBootPath(r.getPath()).toAbsolute();
                        if (!r.getPath().equals(r1.getPath())) {
                            r = r.setPath(r1.getPath());
                        }
                        NBootPath r2 = r1.resolve(".nuts-repository");
                        NBootJsonParser parser = null;
                        try {
                            byte[] bytes = r2.readAllBytes();
                            if (bytes != null) {
                                Object o;
                                fileExists = true;
                                parser = new NBootJsonParser(new InputStreamReader(new ByteArrayInputStream(bytes)));
                                Map<String, Object> jsonObject = parser.parseObject();
                                if (NBootUtils.isBlank(r.getLocationType()) && (o = jsonObject.get("repositoryType")) instanceof String && !NBootUtils.isBlank((String)o)) {
                                    r = r.setLocationType(String.valueOf(o));
                                }
                                if (NBootUtils.isBlank(r.getName()) && (o = jsonObject.get("repositoryName")) instanceof String && !NBootUtils.isBlank((String)o)) {
                                    r = r.setName(String.valueOf(o));
                                }
                                if (NBootUtils.isBlank(r.getName())) {
                                    r = r.setName(r.getName());
                                }
                            }
                        }
                        catch (Exception e) {
                            log.log(Level.CONFIG, "ALERT", NBootMsg.ofC(NBootI18n.of("unable to load %s"), r2));
                        }
                    }
                    if (fileExists && NBootUtils.isBlank(r.getLocationType())) {
                        r = r.setLocationType("nuts");
                    }
                }
                return r;
            }).toArray(NBootRepositoryLocation[]::new);
            this.parsedBootRuntimeRepositories = rr = (Set)Arrays.stream(result).collect(Collectors.toCollection(LinkedHashSet::new));
            log.log(Level.FINE, "START", NBootMsg.ofC(NBootI18n.of("resolved boot repositories to load nuts-runtime as %s"), this.parsedBootRuntimeRepositories));
            return rr;
        });
    }

    public String[] createProcessCmdLine() {
        return this.bContext.callWith(() -> {
            this.prepareWorkspace();
            NBootLog log = NBootContext.log();
            log.log(Level.FINE, "START", NBootMsg.ofC(NBootI18n.of("running version %s.  %s"), this.options.getApiVersion(), this.getRequirementsHelpString(true)));
            String defaultWorkspaceLibFolder = this.options.getStoreType("LIB") + "/" + "id";
            ArrayList<NBootRepositoryLocation> repos = new ArrayList<NBootRepositoryLocation>();
            repos.add(NBootRepositoryLocation.of("nuts@" + defaultWorkspaceLibFolder));
            Set<NBootRepositoryLocation> bootRepositories = this.resolveBootRuntimeRepositories();
            repos.addAll(bootRepositories);
            NBootErrorInfoList errorList = new NBootErrorInfoList();
            File file = NReservedMavenUtilsBoot.resolveOrDownloadJar(NBootId.ofApi(this.options.getApiVersion()), repos.toArray(new NBootRepositoryLocation[0]), NBootRepositoryLocation.of("nuts@" + this.options.getStoreType("LIB") + File.separator + "id"), false, this.options.getExpireTime(), errorList);
            if (file == null) {
                errorList.insert(0, new NReservedErrorInfo(null, null, null, NBootMsg.ofC(NBootI18n.of("unable to load nuts %s"), this.options.getApiVersion()).toString(), null));
                this.logError(null, errorList, this.options);
                throw new NBootException(NBootMsg.ofC(NBootI18n.of("unable to load %s#%s"), "net.thevpc.nuts:nuts", this.options.getApiVersion()));
            }
            ArrayList<String> cmd = new ArrayList<String>();
            String jc = this.options.getJavaCommand();
            if (jc == null || jc.trim().isEmpty()) {
                jc = NBootUtils.resolveJavaCommand(null);
            }
            cmd.add(jc);
            boolean showCommand = false;
            for (String c : NBootCmdLine.parseDefault(this.options.getJavaOptions())) {
                if (c.isEmpty()) continue;
                if (c.equals("--show-command")) {
                    showCommand = true;
                    continue;
                }
                cmd.add(c);
            }
            if (this.options.getJavaOptions() == null) {
                Collections.addAll(cmd, NBootCmdLine.parseDefault(this.options.getJavaOptions()));
            }
            cmd.add("-jar");
            cmd.add(file.getPath());
            cmd.addAll(this.asCmdLine(this.options, new NBootWorkspaceOptionsConfig().setCompact(true).setApiVersion(this.options.getApiVersion())).toStringList());
            if (showCommand) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < cmd.size(); ++i) {
                    String s = (String)cmd.get(i);
                    if (i > 0) {
                        sb.append(" ");
                    }
                    sb.append(s);
                }
                log.log(Level.FINE, "START", NBootMsg.ofC(NBootI18n.of("[exec] %s"), sb));
            }
            return cmd.toArray(new String[0]);
        });
    }

    private NBootCmdLine asCmdLine(NBootOptionsInfo cc, NBootWorkspaceOptionsConfig conf0) {
        return this.bContext.callWith(() -> {
            NBootWorkspaceOptionsConfig conf = conf0;
            if (conf == null) {
                conf = new NBootWorkspaceOptionsConfig();
            }
            NBootWorkspaceCmdLineFormatter a = new NBootWorkspaceCmdLineFormatter(conf, cc);
            return a.toCmdLine();
        });
    }

    private NBootIdCache getFallbackCache(NBootId baseId, boolean lastWorkspace, boolean copyTemp) {
        return this.bContext.callWith(() -> {
            NBootCache cache = NBootContext.cache();
            NBootIdCache old = cache.fallbackIdMap.get(baseId);
            if (old != null) {
                return old;
            }
            NBootIdCache fid = new NBootIdCache();
            fid.baseId = baseId;
            cache.fallbackIdMap.put(fid.baseId, fid);
            String s = (lastWorkspace ? this.lastWorkspaceOptions : this.options).getStoreLocations().get("LIB") + "/id/" + NBootUtils.resolveIdPath(baseId.getShortId());
            Path ss = Paths.get(s, new String[0]);
            NBootId bestId = null;
            NBootVersion bestVersion = null;
            Path bestPath = null;
            if (Files.isDirectory(ss, new LinkOption[0])) {
                try (Stream<Path> stream2 = Files.list(ss);){
                    for (Path path : stream2.collect(Collectors.toList())) {
                        NBootVersion version = NBootVersion.of(path.getFileName().toString());
                        if (version == null || baseId.equals(NBootId.RUNTIME_ID) && !version.toString().startsWith("0.8.7.") || !Files.isDirectory(path, new LinkOption[0])) continue;
                        NBootId rId = baseId.copy().setVersion(version.getValue());
                        Path jar = ss.resolve(version.toString()).resolve(NBootUtils.resolveFileName(rId, "jar"));
                        if (!Files.isRegularFile(jar, new LinkOption[0]) || bestVersion != null && bestVersion.compareTo(version) >= 0) continue;
                        bestVersion = version;
                        bestPath = jar;
                        bestId = rId;
                    }
                }
                catch (Exception stream2) {
                    // empty catch block
                }
            }
            if (bestVersion != null) {
                Path descNutsPath = bestPath.resolveSibling(NBootUtils.resolveFileName(bestId, "nuts"));
                Set<NBootId> dependencies = NReservedMavenUtilsBoot.loadDependenciesFromNutsUrl(descNutsPath.toString());
                if (dependencies != null) {
                    fid.deps = dependencies.stream().filter(x -> NBootUtils.isAcceptDependency(x.toDependency(), this.options)).collect(Collectors.toSet());
                    fid.depsData = fid.deps.stream().map(x -> {
                        try {
                            return this.getFallbackCache((NBootId)x, lastWorkspace, copyTemp);
                        }
                        catch (RuntimeException e) {
                            if (!x.toDependency().isOptional()) {
                                throw e;
                            }
                            return null;
                        }
                    }).filter(Objects::nonNull).collect(Collectors.toList());
                }
                fid.id = bestId;
                if (copyTemp) {
                    Path temp = null;
                    try {
                        temp = Files.createTempFile("old-", bestPath.getFileName().toString(), new FileAttribute[0]);
                        Files.copy(bestPath, temp, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        throw new NBootException(NBootMsg.ofC(NBootI18n.of("error storing %s"), "nuts-runtime.jar"), (Throwable)e);
                    }
                    fid.jar = temp.toString();
                    fid.expected = bestPath.toString();
                    fid.temp = true;
                } else {
                    fid.jar = bestPath.toString();
                }
            }
            return fid;
        });
    }

    private boolean isRuntimeLoaded() {
        if (this.runtimeLoaded == null) {
            this.runtimeLoaded = false;
            try {
                Class<?> c = Class.forName("net.thevpc.nuts.runtime.standalone.workspace.DefaultNWorkspace");
                String runtimeVersionString = (String)c.getField("RUNTIME_VERSION_STRING").get(null);
                this.runtimeLoadedId = NBootId.of(runtimeVersionString);
                this.runtimeLoaded = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.runtimeLoaded;
    }

    private boolean prepareWorkspace() {
        return this.bContext.callWith(() -> {
            boolean resetHardFlag = NBootUtils.firstNonNull(this.options.getResetHard(), false);
            boolean dryFlag = NBootUtils.firstNonNull(this.options.getDry(), false);
            boolean resetFlag = NBootUtils.firstNonNull(this.options.getReset(), false);
            NBootLog log = NBootContext.log();
            if (resetHardFlag) {
                log.log(this.isAskConfirm(this.getOptions()) ? Level.OFF : Level.WARNING, "ALERT", NBootMsg.ofPlain(NBootI18n.of("reset hard all workspaces")));
                long countDeleted = 0L;
                if (!dryFlag) {
                    countDeleted = NBootUtils.deleteStoreLocationsHard(this.lastWorkspaceOptions, this.getOptions(), () -> this.scanner.nextLine());
                    NBootUtils.ndiUndo(null, false);
                }
                if (this.isPlainTrace()) {
                    if (countDeleted > 0L) {
                        log.warn(NBootMsg.ofC(NBootI18n.of("nuts hard reset successfully")));
                    } else {
                        log.warn(NBootMsg.ofC(NBootI18n.of("nuts hard reset did not require to delete any file. system is clean.")));
                    }
                }
                if (NBootUtils.isEmptyList(this.options.getApplicationArguments())) {
                    throw new NBootException(NBootMsg.ofPlain(""), 0);
                }
            }
            if (!this.preparedWorkspace) {
                Object runtimeId;
                this.preparedWorkspace = true;
                String isolationLevel = NBootUtils.firstNonBlank(this.options.getIsolationLevel(), "SYSTEM");
                if (log.isLoggable(Level.CONFIG)) {
                    log.log(Level.CONFIG, "START", NBootMsg.ofC(NBootI18n.of("bootstrap Nuts version %s %s digest %s..."), "0.8.7", NBootUtils.sameEnum(isolationLevel, "SYSTEM") ? "" : (NBootUtils.sameEnum(isolationLevel, "USER") ? " (user mode)" : (NBootUtils.sameEnum(isolationLevel, "CONFINED") ? " (confined mode)" : (NBootUtils.sameEnum(isolationLevel, "SANDBOX") ? " (sandbox mode)" : (NBootUtils.sameEnum(isolationLevel, "MEMORY") ? " (in-memory mode)" : " (unsupported mode " + isolationLevel + ")")))), NBootWorkspaceImpl.getApiDigestOrInternal()));
                    log.log(Level.CONFIG, "START", NBootMsg.ofPlain("boot-class-path:"));
                    for (String s : NBootUtils.split(System.getProperty("java.class.path"), File.pathSeparator, true, true)) {
                        log.log(Level.CONFIG, "START", NBootMsg.ofC("                  %s", s));
                    }
                    ClassLoader thisClassClassLoader = this.getClass().getClassLoader();
                    log.log(Level.CONFIG, "START", NBootMsg.ofC("class-loader: %s", thisClassClassLoader));
                    for (URL url : NBootUtils.resolveClasspathURLs(thisClassClassLoader, false)) {
                        log.log(Level.CONFIG, "START", NBootMsg.ofC("                 %s", url));
                    }
                    ClassLoader tctxloader = Thread.currentThread().getContextClassLoader();
                    if (tctxloader != null && tctxloader != thisClassClassLoader) {
                        log.log(Level.CONFIG, "START", NBootMsg.ofC("thread-class-loader: %s", tctxloader));
                        for (URL url : NBootUtils.resolveClasspathURLs(tctxloader, false)) {
                            log.log(Level.CONFIG, "START", NBootMsg.ofC("                 %s", url));
                        }
                    }
                    ClassLoader contextClassLoader = this.getContextClassLoader();
                    log.log(Level.CONFIG, "START", NBootMsg.ofC("ctx-class-loader: %s", contextClassLoader));
                    if (contextClassLoader != null && contextClassLoader != thisClassClassLoader) {
                        for (URL url : NBootUtils.resolveClasspathURLs(contextClassLoader, false)) {
                            log.log(Level.CONFIG, "START", NBootMsg.ofC("                 %s", url));
                        }
                    }
                    log.log(Level.CONFIG, "START", NBootMsg.ofPlain("system-properties:"));
                    LinkedHashMap<Object, Object> m = new LinkedHashMap<Object, Object>(System.getProperties());
                    int max = m.keySet().stream().mapToInt(String::length).max().getAsInt();
                    for (String k : new TreeSet(m.keySet())) {
                        log.log(Level.CONFIG, "START", NBootMsg.ofC("    %s = %s", NBootUtils.formatAlign(k, max, NBootPositionTypeBoot.FIRST), NBootUtils.formatStringLiteral((String)m.get(k))));
                    }
                }
                String workspaceName = null;
                NBootOptionsInfo lastConfigLoaded = null;
                String lastNutsWorkspaceJsonConfigPath = null;
                boolean immediateLocation = false;
                String _ws = this.options.getWorkspace();
                Boolean systemWorkspace = NBootUtils.firstNonNull(this.options.getSystem(), false);
                if (NBootUtils.sameEnum(isolationLevel, "SANDBOX")) {
                    this.newWorkspace = true;
                    Path t = null;
                    try {
                        t = Files.createTempDirectory("nuts-sandbox-" + Instant.now().toString().replace(':', '-'), new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        throw new NBootException(NBootMsg.ofPlain(NBootI18n.of("unable to create temporary/sandbox folder")), (Throwable)e);
                    }
                    lastNutsWorkspaceJsonConfigPath = t.toString();
                    immediateLocation = true;
                    workspaceName = t.getFileName().toString();
                    resetFlag = false;
                    if (systemWorkspace.booleanValue()) {
                        throw new NBootException(NBootMsg.ofPlain(NBootI18n.of("you cannot specify option option '--global' in sandbox mode")));
                    }
                    if (!NBootUtils.isBlank(this.options.getWorkspace())) {
                        throw new NBootException(NBootMsg.ofPlain(NBootI18n.of("you cannot specify option '--workspace' in sandbox mode")));
                    }
                    if (!NBootUtils.isBlank(this.options.getStoreStrategy()) && !NBootUtils.sameEnum(this.options.getStoreStrategy(), "STANDALONE")) {
                        throw new NBootException(NBootMsg.ofPlain(NBootI18n.of("you cannot specify option '--exploded' in sandbox mode")));
                    }
                    this.options.setWorkspace(lastNutsWorkspaceJsonConfigPath);
                } else if (NBootUtils.sameEnum(isolationLevel, "MEMORY")) {
                    this.newWorkspace = true;
                } else {
                    this.newWorkspace = true;
                    if (!NBootUtils.sameEnum(isolationLevel, "SYSTEM") && systemWorkspace.booleanValue() && NBootUtils.firstNonNull(this.options.getReset(), false).booleanValue()) {
                        throw new NBootException(NBootMsg.ofC(NBootI18n.of("invalid option 'global' in %s mode"), isolationLevel));
                    }
                    if (_ws != null && NBootUtils.isRemoteWorkspaceLocation(_ws)) {
                        workspaceName = "remote-bootstrap";
                        lastNutsWorkspaceJsonConfigPath = NBootPlatformHome.of(null, systemWorkspace).getWorkspaceLocation(NBootUtils.resolveValidWorkspaceName(workspaceName));
                        lastConfigLoaded = NBootBootConfigLoader.loadBootConfig(lastNutsWorkspaceJsonConfigPath);
                        immediateLocation = true;
                    } else {
                        NBootOptionsInfo configLoaded;
                        immediateLocation = NBootUtils.isValidWorkspaceName(_ws);
                        int maxDepth = 36;
                        for (int i = 0; i < maxDepth && (configLoaded = NBootBootConfigLoader.loadBootConfig(lastNutsWorkspaceJsonConfigPath = NBootUtils.isValidWorkspaceName(_ws) ? NBootPlatformHome.of(null, systemWorkspace).getWorkspaceLocation(NBootUtils.resolveValidWorkspaceName(_ws)) : NBootUtils.getAbsolutePath(_ws))) != null; ++i) {
                            if (NBootUtils.isBlank(configLoaded.getWorkspace())) {
                                lastConfigLoaded = configLoaded;
                                break;
                            }
                            _ws = configLoaded.getWorkspace();
                            if (i < maxDepth - 1) continue;
                            throw new NBootException(NBootMsg.ofPlain(NBootI18n.of("cyclic workspace resolution")));
                        }
                        workspaceName = NBootUtils.resolveValidWorkspaceName(this.options.getWorkspace());
                    }
                }
                this.options.setWorkspace(lastNutsWorkspaceJsonConfigPath);
                if (lastConfigLoaded != null) {
                    NBootOptionsInfo curr;
                    this.newWorkspace = false;
                    this.previousRepositories = lastConfigLoaded.getBootRepositories();
                    this.options.setWorkspace(lastNutsWorkspaceJsonConfigPath);
                    this.options.setName(lastConfigLoaded.getName());
                    this.options.setUuid(lastConfigLoaded.getUuid());
                    if (!resetFlag && !resetHardFlag) {
                        curr = this.options;
                    } else {
                        curr = this.lastWorkspaceOptions = new NBootOptionsInfo();
                        curr.setWorkspace(lastNutsWorkspaceJsonConfigPath);
                        curr.setName(lastConfigLoaded.getName());
                        curr.setUuid(lastConfigLoaded.getUuid());
                    }
                    curr.setBootRepositories(lastConfigLoaded.getBootRepositories());
                    curr.setJavaCommand(lastConfigLoaded.getJavaCommand());
                    curr.setJavaOptions(lastConfigLoaded.getJavaOptions());
                    curr.setExtensionsSet(NBootUtils.nonNullSet(lastConfigLoaded.getExtensionsSet()));
                    curr.setStoreStrategy(lastConfigLoaded.getStoreStrategy());
                    curr.setRepositoryStoreStrategy(lastConfigLoaded.getRepositoryStoreStrategy());
                    curr.setStoreLayout(lastConfigLoaded.getStoreLayout());
                    curr.setStoreLocations(NBootUtils.nonNullMap(lastConfigLoaded.getStoreLocations()));
                    curr.setHomeLocations(NBootUtils.nonNullMap(lastConfigLoaded.getHomeLocations()));
                } else {
                    this.newWorkspace = false;
                    this.previousRepositories = new ArrayList<String>();
                }
                NBootWorkspaceImpl.revalidateLocations(this.options, workspaceName, immediateLocation, isolationLevel);
                long countDeleted = 0L;
                if (resetHardFlag) {
                    log.log(this.isAskConfirm(this.getOptions()) ? Level.OFF : Level.WARNING, "ALERT", NBootMsg.ofPlain(NBootI18n.of("reset hard all workspaces")));
                    if (this.lastWorkspaceOptions != null) {
                        NBootWorkspaceImpl.revalidateLocations(this.lastWorkspaceOptions, workspaceName, immediateLocation, isolationLevel);
                    }
                    if (!dryFlag) {
                        countDeleted = NBootUtils.deleteStoreLocationsHard(this.lastWorkspaceOptions, this.getOptions(), () -> this.scanner.nextLine());
                        NBootUtils.ndiUndo(null, false);
                    }
                    this.newWorkspace = true;
                    this.previousRepositories = new ArrayList<String>();
                } else if (resetFlag) {
                    boolean sandboxOrInMemory;
                    boolean bl = sandboxOrInMemory = NBootUtils.sameEnum(isolationLevel, "SANDBOX") || NBootUtils.sameEnum(isolationLevel, "MEMORY");
                    if (!sandboxOrInMemory) {
                        log.log(this.isAskConfirm(this.getOptions()) ? Level.OFF : Level.WARNING, "ALERT", NBootMsg.ofPlain(NBootI18n.of("reset workspace")));
                        if (!dryFlag) {
                            if (this.lastWorkspaceOptions != null) {
                                NBootWorkspaceImpl.revalidateLocations(this.lastWorkspaceOptions, workspaceName, immediateLocation, isolationLevel);
                                this.getFallbackCache(NBootId.RUNTIME_ID, true, true);
                                countDeleted = NBootUtils.deleteStoreLocations(this.lastWorkspaceOptions, this.getOptions(), true, NBootPlatformHome.storeTypes(), () -> this.scanner.nextLine());
                            } else {
                                this.getFallbackCache(NBootId.RUNTIME_ID, false, true);
                                countDeleted = NBootUtils.deleteStoreLocations(this.options, this.getOptions(), true, NBootPlatformHome.storeTypes(), () -> this.scanner.nextLine());
                            }
                            NBootUtils.ndiUndo(workspaceName, true);
                        }
                    }
                    this.newWorkspace = true;
                    this.previousRepositories = lastConfigLoaded == null ? null : lastConfigLoaded.getRepositories();
                } else if (NBootUtils.firstNonNull(this.options.getRecover(), false).booleanValue()) {
                    log.log(this.isAskConfirm(this.getOptions()) ? Level.OFF : Level.WARNING, "ALERT", NBootMsg.ofPlain(NBootI18n.of("recover workspace.")));
                    if (!dryFlag) {
                        ArrayList<Object> folders = new ArrayList<Object>();
                        folders.add("CACHE");
                        folders.add("TEMP");
                        String p = NBootUtils.getStoreLocationPath(this.options, "LIB");
                        if (p != null) {
                            folders.add(Paths.get(p, new String[0]).resolve("id/net/thevpc/nuts/nuts"));
                            folders.add(Paths.get(p, new String[0]).resolve("id/net/thevpc/nuts/nuts-runtime"));
                        }
                        countDeleted = NBootUtils.deleteStoreLocations(this.options, this.getOptions(), false, folders.toArray(), () -> this.scanner.nextLine());
                    }
                    List<String> list = this.previousRepositories = lastConfigLoaded == null ? null : lastConfigLoaded.getRepositories();
                }
                if (this.options.getExtensionsSet() == null) {
                    if (this.lastWorkspaceOptions != null && !resetFlag && !resetHardFlag) {
                        this.options.setExtensionsSet(NBootUtils.firstNonNull(this.lastWorkspaceOptions.getExtensionsSet(), Collections.emptySet()));
                    } else {
                        this.options.setExtensionsSet(Collections.emptySet());
                    }
                }
                if (this.options.getHomeLocations() == null) {
                    if (this.lastWorkspaceOptions != null && !resetFlag && !resetHardFlag) {
                        this.options.setHomeLocations(NBootUtils.firstNonNull(this.lastWorkspaceOptions.getHomeLocations(), Collections.emptyMap()));
                    } else {
                        this.options.setHomeLocations(Collections.emptyMap());
                    }
                }
                if (this.options.getStoreLayout() == null) {
                    if (this.lastWorkspaceOptions != null && !resetFlag && !resetHardFlag) {
                        this.options.setStoreLayout(NBootUtils.firstNonNull(this.lastWorkspaceOptions.getStoreLayout(), NBootPlatformHome.currentOsFamily()));
                    } else {
                        this.options.setHomeLocations(Collections.emptyMap());
                    }
                }
                if (NBootUtils.isEmptyList(this.options.getApplicationArguments()) && NBootUtils.firstNonNull(this.options.getSkipBoot(), true).booleanValue() && resetHardFlag) {
                    if (this.isPlainTrace()) {
                        if (countDeleted > 0L) {
                            log.warn(NBootMsg.ofC(NBootI18n.of("nuts hard reset successfully")));
                        } else {
                            log.warn(NBootMsg.ofC(NBootI18n.of("nuts hard reset did not require to delete any file. system is clean.")));
                        }
                    }
                    throw new NBootException(NBootMsg.ofPlain(""), 0);
                }
                if (NBootUtils.isEmptyList(this.options.getApplicationArguments()) && NBootUtils.firstNonNull(this.options.getSkipBoot(), false).booleanValue() && (NBootUtils.firstNonNull(this.options.getRecover(), false).booleanValue() || resetFlag)) {
                    if (this.isPlainTrace()) {
                        if (countDeleted > 0L) {
                            log.warn(NBootMsg.ofC(NBootI18n.of("workspace erased : %s"), this.options.getWorkspace()));
                        } else {
                            log.warn(NBootMsg.ofC(NBootI18n.of("workspace is not erased because it does not exist : %s"), this.options.getWorkspace()));
                        }
                    }
                    throw new NBootException(NBootMsg.ofPlain(""), 0);
                }
                if (NBootUtils.firstNonNull(this.options.getInherited(), false).booleanValue()) {
                    this.options.setApiVersion("0.8.7");
                } else {
                    NBootVersion nutsVersion = NBootVersion.of(this.options.getApiVersion());
                    if (nutsVersion.isLatestVersion() || nutsVersion.isReleaseVersion()) {
                        NBootId s = NReservedMavenUtilsBoot.resolveLatestMavenId(NBootId.ofApi(""), null, this.resolveBootRuntimeRepositories(), this.options);
                        if (s == null) {
                            throw new NBootException(NBootMsg.ofPlain(NBootI18n.of("unable to load latest nuts version")));
                        }
                        this.options.setApiVersion(s.getVersion());
                    }
                    if (nutsVersion.isBlank()) {
                        this.options.setApiVersion("0.8.7");
                    }
                }
                NBootId bootApiId = NBootId.ofApi(this.options.getApiVersion());
                Path nutsApiConfigBootPath = Paths.get(this.options.getStoreType("CONF") + File.separator + "id", new String[0]).resolve(NBootUtils.resolveIdPath(bootApiId)).resolve("nuts-api-boot-config.json");
                boolean loadedApiConfig = false;
                if (this.isLoadFromCache() && NBootUtils.isFileAccessible(nutsApiConfigBootPath, this.options.getExpireTime())) {
                    try {
                        Map<String, Object> obj = NBootJsonParser.parse(nutsApiConfigBootPath);
                        if (!obj.isEmpty()) {
                            log.log(Level.CONFIG, "READ", NBootMsg.ofC(NBootI18n.of("loaded %s file : %s"), nutsApiConfigBootPath.getFileName(), nutsApiConfigBootPath.toString()));
                            loadedApiConfig = true;
                            if (this.options.getRuntimeId() == null) {
                                runtimeId = (String)obj.get("runtimeId");
                                if (NBootUtils.isBlank((String)runtimeId)) {
                                    log.log(Level.CONFIG, "FAIL", NBootMsg.ofC(NBootI18n.of("%s does not contain %s"), nutsApiConfigBootPath, "runtime-id"));
                                }
                                this.options.setRuntimeId((String)runtimeId);
                            }
                            if (this.options.getJavaCommand() == null) {
                                this.options.setJavaCommand((String)obj.get("javaCommand"));
                            }
                            if (this.options.getJavaOptions() == null) {
                                this.options.setJavaOptions((String)obj.get("javaOptions"));
                            }
                        }
                    }
                    catch (UncheckedIOException e) {
                        log.log(Level.CONFIG, "READ", NBootMsg.ofC(NBootI18n.of("unable to read %s : %s"), nutsApiConfigBootPath, e));
                    }
                }
                if (!loadedApiConfig || this.options.getRuntimeId() == null || this.options.getRuntimeBootDescriptor() == null || this.options.getExtensionBootDescriptors() == null) {
                    NBootId runtimeIdObject;
                    NBootVersion apiVersion = NBootVersion.of(this.options.getApiVersion());
                    if (this.isRuntimeLoaded() && (apiVersion.isBlank() || "0.8.7".equals(apiVersion.toString())) && this.options.getRuntimeId() == null) {
                        this.options.setRuntimeId(this.runtimeLoadedId == null ? null : this.runtimeLoadedId.toString());
                        this.options.setRuntimeBootDescriptor(null);
                    }
                    if (this.options.getRuntimeId() == null) {
                        runtimeId = null;
                        if (!(resetFlag || resetHardFlag || NBootUtils.firstNonNull(this.options.getRecover(), false).booleanValue())) {
                            runtimeId = NReservedMavenUtilsBoot.resolveLatestMavenId(NBootId.of("net.thevpc.nuts:nuts-runtime"), rtVersion -> rtVersion.getValue().startsWith(apiVersion + "."), Collections.singletonList(NBootRepositoryLocation.of("nuts@" + this.options.getStoreType("LIB") + File.separatorChar + "id")), this.options);
                        }
                        if (runtimeId == null) {
                            runtimeId = NReservedMavenUtilsBoot.resolveLatestMavenId(NBootId.of("net.thevpc.nuts:nuts-runtime"), rtVersion -> rtVersion.getValue().startsWith(apiVersion + "."), this.resolveBootRuntimeRepositories(), this.options);
                        }
                        if (runtimeId == null) {
                            runtimeId = this.getFallbackCache((NBootId)NBootId.RUNTIME_ID, (boolean)false, (boolean)false).id;
                        }
                        if (runtimeId == null) {
                            log.log(Level.FINEST, "FAIL", NBootMsg.ofPlain(NBootI18n.of("unable to resolve latest runtime-id version (is connection ok?)")));
                        }
                        this.options.setRuntimeId(runtimeId == null ? null : ((NBootId)runtimeId).toString());
                        this.options.setRuntimeBootDescriptor(null);
                    }
                    if (this.options.getRuntimeId() == null) {
                        this.options.setRuntimeId(this.resolveDefaultRuntimeId(this.options.getApiVersion()));
                        log.log(Level.CONFIG, "READ", NBootMsg.ofC(NBootI18n.of("consider default runtime-id : %s"), this.options.getRuntimeId()));
                    }
                    if (NBootUtils.isBlank((runtimeIdObject = NBootId.of(this.options.getRuntimeId())).getVersion())) {
                        this.options.setRuntimeId(this.resolveDefaultRuntimeId(this.options.getApiVersion()));
                    }
                    if (this.options.getRuntimeBootDescriptor() == null && !this.isRuntimeLoaded()) {
                        Set<NBootId> loadedDeps = null;
                        String rid = this.options.getRuntimeId();
                        Path nutsRuntimeCacheConfigPath = Paths.get(this.options.getStoreType("CONF") + File.separator + "id", new String[0]).resolve(NBootUtils.resolveIdPath(bootApiId)).resolve("nuts-runtime-boot-config.json");
                        try {
                            boolean cacheLoaded = false;
                            if (!NBootUtils.firstNonNull(this.options.getRecover(), false).booleanValue() && !resetFlag && !resetHardFlag && NBootUtils.isFileAccessible(nutsRuntimeCacheConfigPath, this.options.getExpireTime())) {
                                try {
                                    Map<String, Object> obj = NBootJsonParser.parse(nutsRuntimeCacheConfigPath);
                                    log.log(Level.CONFIG, "READ", NBootMsg.ofC(NBootI18n.of("loaded %s file : %s"), nutsRuntimeCacheConfigPath.getFileName(), nutsRuntimeCacheConfigPath.toString()));
                                    loadedDeps = NBootId.ofSet((String)obj.get("dependencies"));
                                    if (loadedDeps == null) {
                                        loadedDeps = new LinkedHashSet<NBootId>();
                                    }
                                }
                                catch (Exception ex) {
                                    log.log(Level.FINEST, "FAIL", NBootMsg.ofC(NBootI18n.of("unable to load %s file : %s : %s"), nutsRuntimeCacheConfigPath.getFileName(), nutsRuntimeCacheConfigPath.toString(), ex.toString()));
                                }
                                cacheLoaded = true;
                            }
                            if (!cacheLoaded || loadedDeps == null) {
                                loadedDeps = NReservedMavenUtilsBoot.loadDependenciesFromId(NBootId.of(this.options.getRuntimeId()), this.resolveBootRuntimeRepositories());
                                log.log(Level.CONFIG, "SUCCESS", NBootMsg.ofC(NBootI18n.of("detect runtime dependencies : %s"), loadedDeps));
                            }
                        }
                        catch (Exception ex) {
                            log.log(Level.FINEST, "FAIL", NBootMsg.ofC(NBootI18n.of("unable to load %s file : %s"), nutsRuntimeCacheConfigPath.getFileName(), ex.toString()));
                        }
                        if (loadedDeps == null) {
                            NBootIdCache r = this.getFallbackCache(NBootId.RUNTIME_ID, false, false);
                            loadedDeps = r.deps;
                        }
                        if (loadedDeps == null) {
                            throw new NBootException(NBootMsg.ofC(NBootI18n.of("unable to load dependencies for %s"), rid));
                        }
                        this.options.setRuntimeBootDescriptor(new NBootDescriptor().setId(this.options.getRuntimeId()).setDependencies(loadedDeps.stream().map(NBootId::toDependency).collect(Collectors.toList())));
                        Set<NBootRepositoryLocation> bootRepositories = this.resolveBootRuntimeRepositories();
                        if (log.isLoggable(Level.CONFIG)) {
                            if (bootRepositories.isEmpty()) {
                                log.log(Level.CONFIG, "FAIL", NBootMsg.ofPlain(NBootI18n.of("workspace bootRepositories could not be resolved")));
                            } else if (bootRepositories.size() == 1) {
                                log.log(Level.CONFIG, "NOTICE", NBootMsg.ofC(NBootI18n.of("workspace bootRepositories resolved to : %s"), bootRepositories.toArray()[0]));
                            } else {
                                log.log(Level.CONFIG, "NOTICE", NBootMsg.ofPlain(NBootI18n.of("workspace bootRepositories resolved to : ")));
                                for (NBootRepositoryLocation repository : bootRepositories) {
                                    log.log(Level.CONFIG, "NOTICE", NBootMsg.ofC("    %s", repository));
                                }
                            }
                        }
                        this.options.setBootRepositories(bootRepositories.stream().map(NBootRepositoryLocation::toString).collect(Collectors.toList()));
                    }
                    if (this.options.getExtensionBootDescriptors() == null) {
                        LinkedHashSet<String> excludedExtensions = new LinkedHashSet<String>();
                        if (this.options.getExcludedExtensions() != null) {
                            for (String excludedExtensionGroup : this.options.getExcludedExtensions()) {
                                for (String excludedExtension : NBootUtils.split(excludedExtensionGroup, ";,", true, true)) {
                                    excludedExtensions.add(NBootId.of(excludedExtension).getShortName());
                                }
                            }
                        }
                        if (this.options.getExtensionsSet() != null) {
                            ArrayList<NBootDescriptor> all = new ArrayList<NBootDescriptor>();
                            for (String extension : this.options.getExtensionsSet()) {
                                NBootId eid = NBootId.of(extension);
                                if (excludedExtensions.contains(eid.getShortName()) || excludedExtensions.contains(eid.getArtifactId())) continue;
                                Path extensionFile = Paths.get(this.options.getStoreType("CONF") + File.separator + "id", new String[0]).resolve(NBootUtils.resolveIdPath(bootApiId)).resolve("nuts-extension-boot-config.json");
                                Set<NBootId> loadedDeps = null;
                                if (this.isLoadFromCache() && NBootUtils.isFileAccessible(extensionFile, this.options.getExpireTime())) {
                                    try {
                                        Properties obj = NBootUtils.loadURLProperties(extensionFile);
                                        log.log(Level.CONFIG, "READ", NBootMsg.ofC(NBootI18n.of("loaded %s file : %s"), extensionFile.getFileName(), extensionFile.toString()));
                                        List<NBootId> loadedDeps0 = NBootId.ofList((String)obj.get("dependencies"));
                                        loadedDeps = loadedDeps0 == null ? new LinkedHashSet<NBootId>() : new LinkedHashSet<NBootId>(loadedDeps0);
                                    }
                                    catch (Exception ex) {
                                        log.log(Level.CONFIG, "FAIL", NBootMsg.ofC(NBootI18n.of("unable to load %s file : %s : %s"), extensionFile.getFileName(), extensionFile.toString(), ex.toString()));
                                    }
                                }
                                if (loadedDeps == null) {
                                    loadedDeps = NReservedMavenUtilsBoot.loadDependenciesFromId(eid, this.resolveBootRuntimeRepositories());
                                }
                                if (loadedDeps == null) {
                                    throw new NBootException(NBootMsg.ofC(NBootI18n.of("unable to load dependencies for %s"), eid));
                                }
                                all.add(new NBootDescriptor().setId(NBootId.of(extension)).setDependencies(loadedDeps.stream().map(NBootId::toDependency).collect(Collectors.toList())));
                            }
                            this.options.setExtensionBootDescriptors(all);
                        } else {
                            this.options.setExtensionBootDescriptors(new ArrayList<NBootDescriptor>());
                        }
                    }
                }
                this.newInstanceRequirements = this.checkRequirements(true);
                if (this.newInstanceRequirements == 0) {
                    this.options.setJavaCommand(null);
                    this.options.setJavaOptions(null);
                }
                return true;
            }
            return false;
        });
    }

    private boolean isAskConfirm(NBootOptionsInfo o) {
        return NBootUtils.sameEnum(NBootUtils.enumName(NBootUtils.firstNonNull(o.getConfirm(), "ASK")), "ASK");
    }

    private boolean isPlainTrace() {
        return NBootUtils.firstNonNull(this.options.getTrace(), true) != false && NBootUtils.firstNonNull(this.options.getBot(), false) == false && (NBootUtils.sameEnum(this.options.getOutputFormat(), "PLAIN") || NBootUtils.isBlank(this.options.getOutputFormat()));
    }

    private boolean isLoadFromCache() {
        return NBootUtils.firstNonNull(this.options.getRecover(), false) == false && NBootUtils.firstNonNull(this.options.getReset(), false) == false;
    }

    @Override
    public NWorkspaceBase getWorkspace() {
        return this.bContext.callWith(() -> {
            if (this.loadedWorkspace != null) {
                return this.loadedWorkspace;
            }
            if (this.exceptionRunnable != null) {
                this.exceptionRunnable.run();
                return this.loadedWorkspace;
            }
            this.prepareWorkspace();
            if (this.hasUnsatisfiedRequirements()) {
                throw new NBootUnsatisfiedRequirementsException(NBootMsg.ofC(NBootI18n.of("unable to open a distinct version : %s from nuts#%s"), this.getRequirementsHelpString(true), "0.8.7"));
            }
            NBootLog log = NBootContext.log();
            if (NBootUtils.isEmptyList(this.options.getApplicationArguments()) && NBootUtils.firstNonNull(this.options.getSkipBoot(), false).booleanValue() && (NBootUtils.firstNonNull(this.options.getRecover(), false).booleanValue() || NBootUtils.firstNonNull(this.options.getReset(), false).booleanValue())) {
                if (this.isPlainTrace()) {
                    log.warn(NBootMsg.ofC(NBootI18n.of("workspace erased : %s"), this.options.getWorkspace()));
                }
                throw new NBootException(null, 0);
            }
            URL[] bootClassWorldURLs = null;
            NWorkspaceBase wsInstance = null;
            NBootErrorInfoList errorList = new NBootErrorInfoList();
            String isolationLevel = NBootUtils.firstNonNull(this.options.getIsolationLevel(), "");
            try {
                boolean sandboxOrInMemory;
                boolean bl = sandboxOrInMemory = NBootUtils.sameEnum(isolationLevel, "SANDBOX") || NBootUtils.sameEnum(isolationLevel, "MEMORY");
                if (!sandboxOrInMemory) {
                    Path configFile = Paths.get(this.options.getWorkspace(), new String[0]).resolve("nuts-workspace.json");
                    if (NBootUtils.sameEnum(this.options.getOpenMode(), "OPEN_OR_ERROR")) {
                        if (!Files.isRegularFile(configFile, new LinkOption[0])) {
                            throw new NBootWorkspaceNotFoundException(this.options.getWorkspace());
                        }
                    } else if (NBootUtils.sameEnum(this.options.getOpenMode(), "CREATE_OR_ERROR") && Files.exists(configFile, new LinkOption[0])) {
                        throw new NBootWorkspaceAlreadyExistsException(this.options.getWorkspace());
                    }
                }
                if (NBootUtils.isBlank(this.options.getApiVersion()) || NBootUtils.isBlank(this.options.getRuntimeId()) || !this.isRuntimeLoaded() && this.options.getRuntimeBootDescriptor() == null || this.options.getExtensionBootDescriptors() == null) {
                    throw new NBootException(NBootMsg.ofPlain(NBootI18n.of("invalid workspace state")));
                }
                boolean recover = NBootUtils.firstNonNull(this.options.getRecover(), false) != false || NBootUtils.firstNonNull(this.options.getReset(), false) != false;
                ArrayList<NBootClassLoaderNode> deps = new ArrayList<NBootClassLoaderNode>();
                String workspaceBootLibFolder = this.options.getStoreType("LIB") + File.separator + "id";
                NBootRepositoryLocation[] repositories = this.options.getBootRepositories() == null ? new NBootRepositoryLocation[]{} : (NBootRepositoryLocation[])this.options.getBootRepositories().stream().flatMap(x -> NBootUtils.split(x, "\n;", true, true).stream().map(NBootRepositoryLocation::of)).toArray(NBootRepositoryLocation[]::new);
                NBootRepositoryLocation workspaceBootLibFolderRepo = NBootRepositoryLocation.of("nuts@" + workspaceBootLibFolder);
                this.options.setRuntimeBootDependencyNode(this.isRuntimeLoaded() ? null : this.createClassLoaderNode(this.options.getRuntimeBootDescriptor(), repositories, workspaceBootLibFolderRepo, recover, errorList, true));
                if (this.options.getExtensionBootDescriptors() != null) {
                    for (NBootDescriptor nutsBootDescriptor : this.options.getExtensionBootDescriptors()) {
                        deps.add(this.createClassLoaderNode(nutsBootDescriptor, repositories, workspaceBootLibFolderRepo, recover, errorList, false));
                    }
                }
                this.options.setExtensionBootDependencyNodes(deps);
                deps.add(0, this.options.getRuntimeBootDependencyNode());
                bootClassWorldURLs = NBootUtils.resolveClassWorldURLs(deps.toArray(new NBootClassLoaderNode[0]), this.getContextClassLoader());
                NBootClassLoader workspaceClassLoader = new NBootClassLoader(deps.toArray(new NBootClassLoaderNode[0]), this.getContextClassLoader());
                this.options.setClassWorldLoader(workspaceClassLoader);
                if (log.isLoggable(Level.CONFIG)) {
                    if (bootClassWorldURLs.length == 0) {
                        log.log(Level.CONFIG, "SUCCESS", NBootMsg.ofPlain(NBootI18n.of("empty nuts class world. All dependencies are already loaded in classpath, most likely")));
                    } else if (bootClassWorldURLs.length == 1) {
                        log.log(Level.CONFIG, "SUCCESS", NBootMsg.ofC(NBootI18n.of("resolve nuts class world to : %s %s"), NBootUtils.getURLDigest(bootClassWorldURLs[0]), bootClassWorldURLs[0]));
                    } else {
                        log.log(Level.CONFIG, "SUCCESS", NBootMsg.ofPlain(NBootI18n.of("resolve nuts class world to : ")));
                        for (URL uRL : bootClassWorldURLs) {
                            log.log(Level.CONFIG, "SUCCESS", NBootMsg.ofC("    %s : %s", NBootUtils.getURLDigest(uRL), uRL));
                        }
                    }
                }
                this.options.setClassWorldURLs(Arrays.asList(bootClassWorldURLs));
                log.log(Level.CONFIG, "NOTICE", NBootMsg.ofPlain(NBootI18n.of("search for NutsBootWorkspaceFactory service implementations")));
                ServiceLoader<NBootWorkspaceFactory> serviceLoader = ServiceLoader.load(NBootWorkspaceFactory.class, workspaceClassLoader);
                ArrayList<NBootWorkspaceFactory> factories = new ArrayList<NBootWorkspaceFactory>(5);
                for (NBootWorkspaceFactory nBootWorkspaceFactory : serviceLoader) {
                    factories.add(nBootWorkspaceFactory);
                }
                factories.sort(new NBootWorkspaceFactoryComparator(this.options));
                if (log.isLoggable(Level.CONFIG)) {
                    switch (factories.size()) {
                        case 0: {
                            log.log(Level.CONFIG, "SUCCESS", NBootMsg.ofPlain(NBootI18n.of("unable to detect NutsBootWorkspaceFactory service implementations")));
                            break;
                        }
                        case 1: {
                            log.log(Level.CONFIG, "SUCCESS", NBootMsg.ofC(NBootI18n.of("detect NutsBootWorkspaceFactory service implementation : %s"), ((NBootWorkspaceFactory)factories.get(0)).getClass().getName()));
                            break;
                        }
                        default: {
                            log.log(Level.CONFIG, "SUCCESS", NBootMsg.ofPlain(NBootI18n.of("detect NutsBootWorkspaceFactory service implementations are :")));
                            for (NBootWorkspaceFactory nBootWorkspaceFactory : factories) {
                                log.log(Level.CONFIG, "SUCCESS", NBootMsg.ofC("    %s", nBootWorkspaceFactory.getClass().getName()));
                            }
                        }
                    }
                }
                ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
                Iterator i$ = factories.iterator();
                while (i$.hasNext()) {
                    NBootWorkspaceFactory a;
                    NBootWorkspaceFactory factoryInstance = a = (NBootWorkspaceFactory)i$.next();
                    try {
                        if (log.isLoggable(Level.CONFIG)) {
                            log.log(Level.CONFIG, "NOTICE", NBootMsg.ofC(NBootI18n.of("create workspace using %s"), factoryInstance.getClass().getName()));
                        }
                        this.options.setBootWorkspaceFactory(factoryInstance);
                        wsInstance = a.createWorkspace(this.options);
                    }
                    catch (Exception | UnsatisfiedLinkError ex) {
                        arrayList.add(ex);
                        log.error(NBootMsg.ofC(NBootI18n.of("unable to create workspace using factory %s"), a), ex);
                        break;
                    }
                    if (wsInstance == null) continue;
                    break;
                }
                if (wsInstance == null) {
                    log.error(NBootMsg.ofC(NBootI18n.of("unable to load Workspace \"%s\" from ClassPath :"), this.options.getName()));
                    for (URL url : bootClassWorldURLs) {
                        log.error(NBootMsg.ofC("\t %s", NBootUtils.formatURL(url)));
                    }
                    if (arrayList.isEmpty()) {
                        log.error(NBootMsg.ofC(NBootI18n.of("current classpath does not any Nuts Workspace implementation at %s"), this.options.getWorkspace()));
                    }
                    for (Throwable exception : arrayList) {
                        log.error(NBootMsg.ofC("%s", exception), exception);
                    }
                    log.error(NBootMsg.ofC(NBootI18n.of("unable to load Workspace Component from ClassPath : %s"), Arrays.asList(bootClassWorldURLs)));
                    throw new NBootInvalidWorkspaceException(this.options.getWorkspace(), NBootMsg.ofC(NBootI18n.of("unable to load Workspace Component from ClassPath : %s%n  caused by:%n\t%s"), Arrays.asList(bootClassWorldURLs), arrayList.stream().map(Throwable::toString).collect(Collectors.joining("\n\t"))));
                }
            }
            catch (AbstractMethodError | UnsatisfiedLinkError ex) {
                URL[] finalBootClassWorldURLs = bootClassWorldURLs;
                NBootMsg errorMessage = NBootMsg.ofC(NBootI18n.of("unable to boot nuts workspace because the installed binaries are incompatible with the current nuts bootstrap version %s\nusing '-N' command line flag should fix the problem"), "0.8.7");
                errorList.insert(0, new NReservedErrorInfo(null, null, null, errorMessage + ": " + ex, ex));
                this.exceptionRunnable = () -> {
                    this.logError(finalBootClassWorldURLs, errorList, this.options);
                    throw new NBootException(errorMessage, (Throwable)ex);
                };
                this.exceptionRunnable.run();
            }
            catch (Throwable ex) {
                NBootMsg message = NBootMsg.ofPlain(NBootI18n.of("unable to bootstrap nuts workspace"));
                if (ex instanceof NBootException) {
                    errorList.insert(0, new NReservedErrorInfo(null, null, null, ex.getMessage(), ex));
                } else {
                    errorList.insert(0, new NReservedErrorInfo(null, null, null, message + " : " + ex, ex));
                }
                URL[] finalBootClassWorldURLs1 = bootClassWorldURLs;
                this.exceptionRunnable = () -> {
                    this.logError(finalBootClassWorldURLs1, errorList, this.options);
                    if (ex instanceof NBootException) {
                        throw (NBootException)ex;
                    }
                    throw new NBootException(message, ex);
                };
                this.exceptionRunnable.run();
            }
            this.loadedWorkspace = wsInstance;
            return this.loadedWorkspace;
        });
    }

    private ClassLoader getContextClassLoader() {
        ClassLoader classLoader;
        Supplier<ClassLoader> classLoaderSupplier = this.options.getClassLoaderSupplier();
        if (classLoaderSupplier != null && (classLoader = classLoaderSupplier.get()) != null) {
            return classLoader;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public NBootWorkspace runWorkspace() {
        return this.bContext.callWith(() -> {
            try {
                if (NBootUtils.firstNonNull(this.options.getCommandHelp(), false).booleanValue()) {
                    NBootWorkspaceHelper.runCommandHelp(this.options);
                } else if (NBootUtils.firstNonNull(this.options.getCommandVersion(), false).booleanValue()) {
                    NBootWorkspaceHelper.runCommandVersion(() -> NBootWorkspaceImpl.getApiDigestOrInternal(), this.options);
                } else {
                    if (this.hasUnsatisfiedRequirements()) {
                        this.runNewProcess();
                        return this;
                    }
                    NWorkspaceBase ws = this.getWorkspace();
                    ws.runBootCommand();
                }
            }
            catch (Exception ex) {
                throw this.doLogException(ex);
            }
            return this;
        });
    }

    private RuntimeException doLogException(Exception ex) {
        return this.bContext.callWith(() -> {
            int c;
            NExceptionWithExitCodeBase ec = NBootUtils.findThrowable(ex, NExceptionWithExitCodeBase.class, null);
            int n = c = ec == null ? 254 : ec.getExitCode();
            if (c != 0) {
                NAnyBootAwareExceptionBase u = NBootUtils.findThrowable(ex, NAnyBootAwareExceptionBase.class, null);
                if (u != null) {
                    try {
                        u.processThrowable(this.options);
                    }
                    catch (Exception any) {
                        NBootUtils.processThrowable(ex, true, NBootUtils.resolveShowStackTrace(this.options), NBootUtils.resolveGui(this.options));
                    }
                } else {
                    NBootUtils.processThrowable(ex, true, NBootUtils.resolveShowStackTrace(this.options), NBootUtils.resolveGui(this.options));
                }
            }
            if (ec instanceof RuntimeException) {
                return (RuntimeException)((Object)ec);
            }
            return new RuntimeException(ex);
        });
    }

    private void fallbackInstallActionUnavailable(String message) {
        NBootContext.log().error(NBootMsg.ofPlain(message));
    }

    private void logError(URL[] bootClassWorldURLs, NBootErrorInfoList ths, NBootOptionsInfo options0) {
        this.bContext.runWith(() -> {
            String apiDigestOrInternal;
            NBootOptionsInfo options = options0;
            if (options == null) {
                options = this.options;
            }
            if (options == null) {
                options = new NBootOptionsInfo();
            }
            boolean showStackTrace = NBootUtils.resolveShowStackTrace(options);
            boolean showGui = NBootUtils.resolveGui(options);
            String workspace = options.getWorkspace();
            Map<String, String> rbc_locations = options.getStoreLocations();
            if (rbc_locations == null) {
                rbc_locations = new HashMap<String, String>();
            }
            if ("<internal>".equals(apiDigestOrInternal = NBootWorkspaceImpl.getApiDigestOrInternal())) {
                apiDigestOrInternal = null;
            }
            NBootLog log = NBootContext.log();
            log.setOptions(options);
            if (!showStackTrace) {
                log.error(NBootMsg.ofC(NBootI18n.of("unable to bootstrap nuts %s %s"), "0.8.7", NBootUtils.isBlank(apiDigestOrInternal) ? "" : "(digest " + apiDigestOrInternal + ")"));
                for (NReservedErrorInfo e : ths.list()) {
                    log.error(NBootMsg.ofC("%s", e.toString()));
                }
                return;
            }
            log.error(NBootMsg.ofC("unable to bootstrap nuts %s %s", "0.8.7", NBootUtils.isBlank(apiDigestOrInternal) ? "" : "(digest " + apiDigestOrInternal + ")"));
            if (!ths.list().isEmpty()) {
                log.error(NBootMsg.ofC("%s", ths.list().get(0)));
            }
            log.error(NBootMsg.ofPlain(NBootI18n.of("here after current environment info:")));
            log.error(NBootMsg.ofC("  nuts-boot-version                : %s", "0.8.7"));
            log.error(NBootMsg.ofC("  nuts-boot-api-version            : %s", NBootUtils.desc(options.getApiVersion())));
            log.error(NBootMsg.ofC("  nuts-boot-runtime                : %s", NBootUtils.desc(options.getRuntimeId())));
            log.error(NBootMsg.ofC("  nuts-boot-repositories           : %s", NBootUtils.desc(options.getBootRepositories())));
            log.error(NBootMsg.ofC("  workspace-location               : %s", NBootUtils.firstNonNull(workspace, "<default-location>")));
            log.error(NBootMsg.ofC("  nuts-store-bin                   : %s", NBootUtils.desc(rbc_locations.get("BIN"))));
            log.error(NBootMsg.ofC("  nuts-store-conf                  : %s", NBootUtils.desc(rbc_locations.get("CONF"))));
            log.error(NBootMsg.ofC("  nuts-store-var                   : %s", NBootUtils.desc(rbc_locations.get("VAR"))));
            log.error(NBootMsg.ofC("  nuts-store-log                   : %s", NBootUtils.desc(rbc_locations.get("LOG"))));
            log.error(NBootMsg.ofC("  nuts-store-temp                  : %s", NBootUtils.desc(rbc_locations.get("TEMP"))));
            log.error(NBootMsg.ofC("  nuts-store-cache                 : %s", NBootUtils.desc(rbc_locations.get("CACHE"))));
            log.error(NBootMsg.ofC("  nuts-store-run                   : %s", NBootUtils.desc(rbc_locations.get("RUN"))));
            log.error(NBootMsg.ofC("  nuts-store-lib                   : %s", NBootUtils.desc(rbc_locations.get("LIB"))));
            log.error(NBootMsg.ofC("  nuts-store-strategy              : %s", NBootUtils.desc(options.getStoreStrategy())));
            log.error(NBootMsg.ofC("  nuts-store-layout                : %s", NBootUtils.desc(options.getStoreLayout())));
            log.error(NBootMsg.ofC("  nuts-boot-args                   : %s", this.asCmdLine(options, null)));
            log.error(NBootMsg.ofC("  nuts-app-args                    : %s", NBootUtils.nonNullStrList(options.getApplicationArguments())));
            log.error(NBootMsg.ofC("  option-read-only                 : %s", NBootUtils.firstNonNull(options.getReadOnly(), false)));
            log.error(NBootMsg.ofC("  option-trace                     : %s", NBootUtils.firstNonNull(options.getTrace(), false)));
            log.error(NBootMsg.ofC("  option-progress                  : %s", NBootUtils.desc(options.getProgressOptions())));
            log.error(NBootMsg.ofC("  option-open-mode                 : %s", NBootUtils.desc(NBootUtils.firstNonNull(options.getOpenMode(), "OPEN_OR_CREATE"))));
            NBootClassLoaderNode rtn = options.getRuntimeBootDependencyNode();
            String rtHash = "";
            if (rtn != null) {
                rtHash = NBootUtils.getURLDigest(rtn.getURL());
            }
            log.error(NBootMsg.ofC("  nuts-runtime-digest              : %s", NBootUtils.desc(rtHash)));
            if (bootClassWorldURLs == null || bootClassWorldURLs.length == 0) {
                log.error(NBootMsg.ofC("  nuts-runtime-classpath           : %s", "<undefined>"));
            } else {
                log.error(NBootMsg.ofC("  nuts-runtime-hash                : %s", "<undefined>"));
                for (int i = 0; i < bootClassWorldURLs.length; ++i) {
                    URL bootClassWorldURL = bootClassWorldURLs[i];
                    if (i == 0) {
                        log.error(NBootMsg.ofC("  nuts-runtime-classpath           : %s", NBootUtils.formatURL(bootClassWorldURL)));
                        continue;
                    }
                    log.error(NBootMsg.ofC("                                     %s", NBootUtils.formatURL(bootClassWorldURL)));
                }
            }
            log.error(NBootMsg.ofC("  java-version                     : %s", System.getProperty("java.version")));
            log.error(NBootMsg.ofC("  java-executable                  : %s", NBootUtils.desc(NBootUtils.resolveJavaCommand(null))));
            log.error(NBootMsg.ofC("  java-class-path                  : %s", System.getProperty("java.class.path")));
            log.error(NBootMsg.ofC("  java-library-path                : %s", System.getProperty("java.library.path")));
            log.error(NBootMsg.ofC("  os-name                          : %s", System.getProperty("os.name")));
            log.error(NBootMsg.ofC("  os-arch                          : %s", System.getProperty("os.arch")));
            log.error(NBootMsg.ofC("  os-version                       : %s", System.getProperty("os.version")));
            log.error(NBootMsg.ofC("  user-name                        : %s", System.getProperty("user.name")));
            log.error(NBootMsg.ofC("  user-home                        : %s", System.getProperty("user.home")));
            log.error(NBootMsg.ofC("  user-dir                         : %s", System.getProperty("user.dir")));
            log.error(NBootMsg.ofPlain(""));
            NBootLogConfig logConfig = options.getLogConfig();
            if (logConfig == null || logConfig.getLogTermLevel() == null || logConfig.getLogFileLevel() != null && logConfig.getLogFileLevel().intValue() > Level.FINEST.intValue()) {
                log.error(NBootMsg.ofPlain(NBootI18n.of("If the problem persists you may want to get more debug info by adding '--verbose' arguments.")));
            }
            if (!NBootUtils.firstNonNull(options.getReset(), false).booleanValue() && !NBootUtils.firstNonNull(options.getRecover(), false).booleanValue() && options.getExpireTime() == null) {
                log.error(NBootMsg.ofPlain(NBootI18n.of("You may also enable recover mode to ignore existing cache info with '--recover' and '--expire' arguments.")));
                log.error(NBootMsg.ofPlain(NBootI18n.of("Here is the proper command : ")));
                log.error(NBootMsg.ofPlain("  java -jar nuts.jar --verbose --recover --expire [...]"));
            } else if (!NBootUtils.firstNonNull(options.getReset(), false).booleanValue() && NBootUtils.firstNonNull(options.getRecover(), false).booleanValue() && options.getExpireTime() == null) {
                log.error(NBootMsg.ofPlain(NBootI18n.of("You may also enable full reset mode to ignore existing configuration with '--reset' argument.")));
                log.error(NBootMsg.ofPlain(NBootI18n.of("ATTENTION: this will delete all your nuts configuration. Use it at your own risk.")));
                log.error(NBootMsg.ofPlain(NBootI18n.of("Here is the proper command : ")));
                log.error(NBootMsg.ofPlain("  java -jar nuts.jar --verbose --reset [...]"));
            }
            if (!ths.list().isEmpty()) {
                log.error(NBootMsg.ofPlain(NBootI18n.of("error stack trace is:")));
                for (NReservedErrorInfo th : ths.list()) {
                    StringBuilder msg = new StringBuilder();
                    ArrayList<Object> msgParams = new ArrayList<Object>();
                    msg.append("[error]");
                    if (th.getNutsId() != null) {
                        msg.append(" <id>=%s");
                        msgParams.add(th.getNutsId());
                    }
                    if (th.getRepository() != null) {
                        msg.append(" <repo>=%s");
                        msgParams.add(th.getRepository());
                    }
                    if (th.getUrl() != null) {
                        msg.append(" <url>=%s");
                        msgParams.add(th.getUrl());
                    }
                    if (th.getThrowable() != null) {
                        msg.append(" <error>=%s");
                        msgParams.add(th.getThrowable().toString());
                    } else {
                        msg.append(" <error>=%s");
                        msgParams.add(NBootI18n.of("unexpected error"));
                    }
                    log.error(NBootMsg.ofC(msg.toString(), msgParams.toArray()));
                    log.error(NBootMsg.ofPlain(th.toString()), th.getThrowable());
                }
            } else {
                log.error(NBootMsg.ofPlain(NBootI18n.of("no stack trace is available.")));
            }
            log.error(NBootMsg.ofPlain(NBootI18n.of("now exiting nuts, Bye!")));
        });
    }

    private int checkRequirements(boolean unsatisfiedOnly) {
        int req = 0;
        if (!(NBootUtils.isBlank(this.options.getApiVersion()) || unsatisfiedOnly && this.options.getApiVersion().equals("0.8.7"))) {
            ++req;
        }
        if (!unsatisfiedOnly || !NBootUtils.isActualJavaCommand(this.options.getJavaCommand())) {
            req += 2;
        }
        if (!unsatisfiedOnly || !NBootUtils.isActualJavaOptions(this.options.getJavaOptions())) {
            req += 4;
        }
        return req;
    }

    public String getRequirementsHelpString(boolean unsatisfiedOnly) {
        int req = unsatisfiedOnly ? this.newInstanceRequirements : this.checkRequirements(false);
        StringBuilder sb = new StringBuilder();
        if ((req & 1) != 0) {
            sb.append("nuts version ").append(NBootId.ofApi(this.options.getApiVersion()));
        }
        if ((req & 2) != 0) {
            if (sb.length() > 0) {
                sb.append(" and ");
            }
            sb.append("java command ").append(this.options.getJavaCommand());
        }
        if ((req & 4) != 0) {
            if (sb.length() > 0) {
                sb.append(" and ");
            }
            sb.append("java options ").append(this.options.getJavaOptions());
        }
        if (sb.length() > 0) {
            sb.insert(0, "required ");
            return sb.toString();
        }
        return null;
    }

    private NBootClassLoaderNode createClassLoaderNode(NBootDescriptor descr, NBootRepositoryLocation[] repositories, NBootRepositoryLocation workspaceBootLibFolder, boolean recover, NBootErrorInfoList errorList, boolean runtimeDep) throws MalformedURLException {
        return this.bContext.callWith(() -> {
            NBootId id = descr.getId();
            List<NBootDependency> deps = descr.getDependencies();
            NBootClassLoaderNodeBuilder rt = new NBootClassLoaderNodeBuilder();
            String name = runtimeDep ? "runtime" : "extension " + id.toString();
            File file = NReservedMavenUtilsBoot.getBootCacheJar(NBootId.of(this.options.getRuntimeId()), repositories, workspaceBootLibFolder, !recover, name, this.options.getExpireTime(), errorList, this.options, this.pathExpansionConverter);
            rt.setId(id.toString());
            rt.setUrl(file.toURI().toURL());
            rt.setIncludedInClasspath(NBootUtils.isLoadedClassPath(rt.getURL(), this.getContextClassLoader()));
            NBootLog log = NBootContext.log();
            if (log.isLoggable(Level.CONFIG)) {
                String rtHash = "";
                if (this.options.getRuntimeId() != null && (rtHash = NBootUtils.getFileOrDirectoryDigest(file.toPath())) == null) {
                    rtHash = "";
                }
                log.log(Level.CONFIG, "NOTICE", NBootMsg.ofC(NBootI18n.of("detect %s version %s - digest %s from %s"), name, id.toString(), rtHash, file));
            }
            for (NBootDependency s : deps) {
                NBootClassLoaderNodeBuilder x = new NBootClassLoaderNodeBuilder();
                if (!NBootUtils.isAcceptDependency(s, this.options)) continue;
                x.setId(s.toString()).setUrl(NReservedMavenUtilsBoot.getBootCacheJar(s.toId(), repositories, workspaceBootLibFolder, !recover, name + " dependency", this.options.getExpireTime(), errorList, this.options, this.pathExpansionConverter).toURI().toURL());
                x.setIncludedInClasspath(NBootUtils.isLoadedClassPath(x.getURL(), this.getContextClassLoader()));
                rt.addDependency(x.build());
            }
            return rt.build();
        });
    }

    private String resolveDefaultRuntimeId(String sApiVersion) {
        int q = sApiVersion.indexOf(45);
        if (q > 0) {
            return NBootId.ofRuntime(sApiVersion.substring(0, q) + ".0" + sApiVersion.substring(q)).toString();
        }
        return NBootId.ofRuntime(sApiVersion + ".0").toString();
    }

    private static final class ApiDigestHolder {
        static final String apiDigest = NBootUtils.resolveNutsIdDigest();

        private ApiDigestHolder() {
        }
    }
}

