/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot.internal.cmdline;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.boot.NBootException;
import net.thevpc.nuts.boot.internal.cmdline.NBootArg;
import net.thevpc.nuts.boot.internal.util.NBootMsg;
import net.thevpc.nuts.boot.internal.util.NBootQuoteTypeBoot;
import net.thevpc.nuts.boot.internal.util.NBootSimpleCharQueue;
import net.thevpc.nuts.boot.internal.util.NBootSupportMode;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public class NBootCmdLine {
    private static final int ARG_TYPE_DEFAULT = 0;
    private static final int ARG_TYPE_ENTRY = 1;
    private static final int ARG_TYPE_FLAG = 2;
    protected LinkedList<String> args = new LinkedList();
    protected List<NBootArg> lookahead = new ArrayList<NBootArg>();
    protected boolean expandSimpleOptions = true;
    protected boolean expandArgumentsFile = true;
    protected Set<String> specialSimpleOptions = new HashSet<String>();
    protected String commandName;
    private int wordIndex = 0;
    private char eq = (char)61;

    public NBootCmdLine() {
    }

    public NBootCmdLine(String[] args) {
        this.setArguments(args);
    }

    public NBootCmdLine(List<String> args) {
        this.setArguments(args);
    }

    public NBootCmdLine unregisterSpecialSimpleOption(String option) {
        this.specialSimpleOptions.remove(option);
        return this;
    }

    public String[] getSpecialSimpleOptions() {
        return this.specialSimpleOptions.toArray(new String[0]);
    }

    public NBootCmdLine registerSpecialSimpleOption(String option) {
        if (option.length() > 2) {
            char c0 = option.charAt(0);
            char c1 = option.charAt(1);
            char c2 = option.charAt(2);
            if ((c0 == '-' || c0 == '+') && NBootArg.isSimpleKey(c1) && NBootArg.isSimpleKey(c2)) {
                this.specialSimpleOptions.add(option);
                return this;
            }
        }
        this.throwError(NBootMsg.ofC("invalid special option %s", option));
        return this;
    }

    public boolean isSpecialSimpleOption(String option) {
        if (option == null) {
            return false;
        }
        NBootArg a = new NBootArg(option);
        String p = a.getOptionPrefix();
        if (p == null || p.length() != 1) {
            return false;
        }
        String o = a.getKey();
        if (o == null) {
            return false;
        }
        for (String registered : this.specialSimpleOptions) {
            if (!registered.equals(o)) continue;
            return true;
        }
        return false;
    }

    public int getWordIndex() {
        return this.wordIndex;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public NBootCmdLine setCommandName(String commandName) {
        this.commandName = commandName;
        return this;
    }

    public boolean isExpandSimpleOptions() {
        return this.expandSimpleOptions;
    }

    public NBootCmdLine setExpandSimpleOptions(boolean expand) {
        this.expandSimpleOptions = expand;
        return this;
    }

    public NBootCmdLine throwUnexpectedArgument(NBootMsg errorMessage) {
        if (!this.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            ArrayList<NBootMsg> ep = new ArrayList<NBootMsg>();
            sb.append("unexpected argument %s");
            ep.add(this.highlightText(String.valueOf(this.peek())));
            if (errorMessage != null) {
                sb.append(", %s");
                ep.add(errorMessage);
            }
            this.throwError(NBootMsg.ofC(sb.toString(), ep.toArray()));
        }
        return this;
    }

    public NBootCmdLine throwMissingArgument() {
        if (this.isEmpty()) {
            this.throwError(NBootMsg.ofPlain("missing argument"));
        }
        return this;
    }

    public NBootCmdLine throwMissingArgument(String argumentName) {
        if (!NBootUtils.isBlank(argumentName)) {
            if (this.isEmpty()) {
                this.throwError(NBootMsg.ofC("missing argument %s", argumentName));
            }
            return this;
        }
        this.throwMissingArgument();
        return this;
    }

    public NBootCmdLine throwMissingArgument(NBootMsg errorMessage) {
        if (this.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            ArrayList<NBootMsg> ep = new ArrayList<NBootMsg>();
            sb.append("missing argument");
            if (errorMessage != null) {
                sb.append(", %s");
                ep.add(errorMessage);
            }
            this.throwError(NBootMsg.ofC(sb.toString(), ep.toArray()));
        }
        return this;
    }

    public NBootCmdLine throwUnexpectedArgument() {
        return this.throwUnexpectedArgument(null);
    }

    public NBootCmdLine pushBack(NBootArg arg) {
        NBootUtils.requireNonNull(arg, "argument");
        this.lookahead.add(0, arg);
        return this;
    }

    public NBootArg next() {
        return this.next(this.expandSimpleOptions);
    }

    public String nextString() {
        NBootArg a = this.next();
        return a == null ? null : a.toString();
    }

    public NBootArg nextOption(String option) {
        if (!new NBootArg(option).isOption()) {
            return (NBootArg)this.errorOptionalCformat("%s is not an option", option);
        }
        return this.next(option, true);
    }

    public boolean isNextOption() {
        NBootArg a = this.peek();
        if (a != null) {
            return a.isOption();
        }
        return false;
    }

    public boolean isNextNonOption() {
        NBootArg a = this.peek();
        if (a != null) {
            return a.isNonOption();
        }
        return false;
    }

    public NBootArg peek() {
        return this.get(0);
    }

    public boolean hasNext() {
        return !this.lookahead.isEmpty() || !this.args.isEmpty();
    }

    public boolean hasNextOption() {
        return this.hasNext() && this.peek().isOption();
    }

    public boolean hasNextNonOption() {
        return this.hasNext() && this.peek().isNonOption();
    }

    public NBootArg nextFlag(String ... names) {
        return this.next(2, names);
    }

    public NBootArg nextEntry(String ... names) {
        return this.next(1, names);
    }

    public NBootArg nextEntry() {
        return this.nextEntry(new String[0]);
    }

    public NBootArg nextFlag() {
        return this.nextFlag(new String[0]);
    }

    public NBootArg next(String ... names) {
        return this.next(0, names);
    }

    private NBootArg next(int expectedValue, String ... names) {
        if (names.length == 0 && this.hasNext()) {
            NBootArg peeked = this.peek();
            String string = peeked.getKey();
            names = string != null ? new String[]{string} : new String[]{};
        }
        block5: for (String nameSeq : names) {
            String pks;
            String[] nameSeqArray = NBootUtils.split(nameSeq, " ").toArray(new String[0]);
            if (nameSeqArray.length == 0 || !this.isPrefixed(nameSeqArray)) continue;
            String name = nameSeqArray[nameSeqArray.length - 1];
            NBootArg p = this.get(nameSeqArray.length - 1);
            if (p == null || (pks = p.getKey()) == null || !pks.equals(name)) continue;
            switch (expectedValue) {
                case 0: {
                    this.skip(nameSeqArray.length);
                    return p;
                }
                case 1: {
                    this.skip(nameSeqArray.length);
                    if (p.isKeyValue()) {
                        return p;
                    }
                    NBootArg r2 = this.peek();
                    if (r2 != null && !r2.isOption()) {
                        this.skip();
                        return this.createArgument(NBootUtils.firstNonNull(p == null ? null : p.toString(), "") + this.eq + NBootUtils.firstNonNull(r2, ""));
                    }
                    return p;
                }
                case 2: {
                    this.skip(nameSeqArray.length);
                    if (p.isNegated()) {
                        if (p.isKeyValue()) {
                            boolean x = NBootUtils.firstNonNull(p.getBooleanValue(), false);
                            if (pks == null) continue block5;
                            return this.createArgument(pks + this.eq + !x);
                        }
                        if (pks == null) continue block5;
                        return this.createArgument(pks + this.eq + false);
                    }
                    if (p.isKeyValue()) {
                        return p;
                    }
                    if (pks == null) continue block5;
                    return this.createArgument(pks + this.eq + true);
                }
                default: {
                    return (NBootArg)this.errorOptionalCformat("unsupported %s", this.highlightText(String.valueOf(expectedValue)));
                }
            }
        }
        return (NBootArg)this.emptyOptionalCformat("missing argument", new Object[0]);
    }

    private <T> T emptyOptionalCformat(String str, Object ... args) {
        ArrayList<Object> a = new ArrayList<Object>();
        if (!NBootUtils.isBlank(this.getCommandName())) {
            a.add(this.getCommandName());
            a.addAll(Arrays.asList(args));
            throw new IllegalArgumentException(NBootMsg.ofC("%s : " + str, a.toArray()).toString());
        }
        a.addAll(Arrays.asList(args));
        throw new NBootException(NBootMsg.ofC(str, a.toArray()));
    }

    private <T> T errorOptionalCformat(String str, Object ... args) {
        if (!NBootUtils.isBlank(this.getCommandName())) {
            throw new NBootException(NBootMsg.ofC("%s : %s ", this.getCommandName(), NBootMsg.ofC(str, args)));
        }
        throw new NBootException(NBootMsg.ofC(str, args));
    }

    public NBootArg nextNonOption(String name) {
        return this.next(name, true);
    }

    public NBootArg nextNonOption() {
        if (this.hasNext() && !this.isNextOption()) {
            return this.next();
        }
        return null;
    }

    public int skipAll() {
        int count = 0;
        while (this.hasNext()) {
            count += this.skip(1);
        }
        return count;
    }

    public int skip() {
        return this.skip(1);
    }

    public int skip(int count) {
        if (count < 0) {
            count = 0;
        }
        for (int initialCount = count; initialCount > 0 && this.hasNext() && this.next() != null; --initialCount) {
            ++this.wordIndex;
        }
        return count;
    }

    public boolean accept(String ... values) {
        return this.accept(0, values);
    }

    public boolean accept(int index, String ... values) {
        for (int i = 0; i < values.length; ++i) {
            NBootArg argument = this.get(index + i);
            if (argument == null) {
                return false;
            }
            if (Objects.equals(argument.getKey(), values[i])) continue;
            return false;
        }
        return true;
    }

    public NBootArg find(String name) {
        int index = this.indexOf(name);
        if (index >= 0) {
            return this.get(index);
        }
        return null;
    }

    public NBootArg get(int index) {
        if (index < 0) {
            return null;
        }
        if (index < this.lookahead.size()) {
            return this.lookahead.get(index);
        }
        while (!this.args.isEmpty() && index >= this.lookahead.size() && this.ensureNext(this.isExpandSimpleOptions(), this.expandArgumentsFile, true)) {
        }
        if (index < this.lookahead.size()) {
            return this.lookahead.get(index);
        }
        return (NBootArg)this.emptyOptionalCformat("missing argument", new Object[0]);
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public int indexOf(String name) {
        for (int i = 0; i < this.length(); ++i) {
            NBootArg g = this.get(i);
            if (g == null || !Objects.equals(g.getKey(), name)) continue;
            return i;
        }
        return -1;
    }

    public int length() {
        return this.lookahead.size() + this.args.size();
    }

    public boolean isEmpty() {
        return !this.hasNext();
    }

    public String[] toStringArray() {
        return this.toStringList().toArray(new String[0]);
    }

    public List<String> toStringList() {
        ArrayList<String> all = new ArrayList<String>(this.length());
        for (NBootArg nutsArgument : this.lookahead) {
            all.add(nutsArgument.toString());
        }
        all.addAll(this.args);
        return all;
    }

    public NBootArg[] toArgumentArray() {
        ArrayList<NBootArg> aa = new ArrayList<NBootArg>();
        while (this.hasNext()) {
            aa.add(this.next());
        }
        this.lookahead.addAll(aa);
        return aa.toArray(new NBootArg[0]);
    }

    public boolean isOption(int index) {
        NBootArg a = this.get(index);
        if (a != null) {
            return a.isOption();
        }
        return false;
    }

    public boolean isNonOption(int index) {
        NBootArg a = this.get(index);
        if (a != null) {
            return a.isNonOption();
        }
        return false;
    }

    public NBootCmdLine setArguments(List<String> arguments) {
        if (arguments == null) {
            return this.setArguments(new String[0]);
        }
        return this.setArguments(arguments.toArray(new String[0]));
    }

    public NBootCmdLine setArguments(String[] arguments) {
        this.lookahead.clear();
        this.args.clear();
        if (arguments != null) {
            Collections.addAll(this.args, arguments);
        }
        return this;
    }

    public void throwError(NBootMsg message) {
        if (NBootUtils.isBlank(this.commandName)) {
            throw new NBootException(message);
        }
        throw new NBootException(NBootMsg.ofC("%s : %s", this.commandName, message));
    }

    private boolean isPrefixed(String[] nameSeqArray) {
        for (int i = 0; i < nameSeqArray.length - 1; ++i) {
            NBootArg x = this.get(i);
            if (x != null && Objects.equals(x.toString(), nameSeqArray[i])) continue;
            return false;
        }
        return true;
    }

    public NBootArg next(String name, boolean forceNonOption) {
        if (!(!this.hasNext() || forceNonOption && this.isNextOption())) {
            NBootArg r = this.peek();
            this.skip();
            if (r == null) {
                return (NBootArg)this.emptyOptionalCformat("expected argument", new Object[0]);
            }
            return r;
        }
        if (!(!this.hasNext() || forceNonOption && this.isNextOption())) {
            return (NBootArg)this.emptyOptionalCformat("unexpected option %s", this.highlightText(String.valueOf(this.peek())));
        }
        return (NBootArg)this.emptyOptionalCformat("missing argument %s", this.highlightText(String.valueOf(name == null ? "value" : name)));
    }

    public NBootArg next(boolean expandSimpleOptions) {
        if (this.ensureNext(expandSimpleOptions, this.expandArgumentsFile, false)) {
            if (!this.lookahead.isEmpty()) {
                return this.lookahead.remove(0);
            }
            String v = this.args.removeFirst();
            return this.createArgument(v);
        }
        return null;
    }

    public String toString() {
        return this.toStringList().stream().map(x -> NBootUtils.formatStringLiteral(x, NBootQuoteTypeBoot.DOUBLE, NBootSupportMode.PREFERRED)).collect(Collectors.joining(" "));
    }

    private String createExpandedSimpleOption(char start, boolean negate, char val) {
        char[] cArray;
        if (negate) {
            char[] cArray2 = new char[3];
            cArray2[0] = start;
            cArray2[1] = 33;
            cArray = cArray2;
            cArray2[2] = val;
        } else {
            char[] cArray3 = new char[2];
            cArray3[0] = start;
            cArray = cArray3;
            cArray3[1] = val;
        }
        return new String(cArray);
    }

    private String createExpandedSimpleOption(char start, boolean negate, String val) {
        StringBuilder sb = new StringBuilder();
        sb.append(start);
        if (negate) {
            sb.append('!');
        }
        sb.append(val);
        return sb.toString();
    }

    private List<String> loadArgs(Path path, Path currentDir, Set<String> visited) {
        if (!path.isAbsolute()) {
            path = currentDir.resolve(path);
        }
        if (Files.isRegularFile(path = path.toAbsolutePath().normalize(), new LinkOption[0])) {
            if (visited.contains(path.toString())) {
                return Collections.emptyList();
            }
            visited.add(path.toString());
            ArrayList<String> all = new ArrayList<String>();
            ArrayList<String> subArgs = new ArrayList<String>();
            try (BufferedReader br = new BufferedReader(Files.newBufferedReader(path));){
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (NBootUtils.isBlank(line) || line.trim().startsWith("#")) continue;
                    subArgs.addAll(Arrays.asList(NBootCmdLine.parseDefault(line)));
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            for (String arg : subArgs) {
                if (arg.length() > 3 && arg.startsWith("--@")) {
                    Path nPath = Paths.get(arg.substring(3), new String[0]);
                    Path parent = path.getParent();
                    if (parent == null) {
                        parent = currentDir;
                    }
                    all.addAll(this.loadArgs(nPath, parent, visited));
                    continue;
                }
                all.add(arg);
            }
            return all;
        }
        if (Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException(NBootMsg.ofC("argument file does not exist %s", path).toString());
        }
        throw new IllegalArgumentException(NBootMsg.ofC("argument file is not a valid regular file %s", path).toString());
    }

    private boolean ensureNext(boolean expandSimpleOptions, boolean expandArgumentsFile, boolean ignoreExistingExpanded) {
        if (!ignoreExistingExpanded && !this.lookahead.isEmpty()) {
            return true;
        }
        if (!this.args.isEmpty()) {
            String arg = this.args.removeFirst();
            if (expandArgumentsFile && arg.length() > 3 && arg.startsWith("--@")) {
                Path nPath = Paths.get(arg.substring(3), new String[0]);
                this.args.addAll(0, this.loadArgs(nPath, Paths.get(System.getProperty("user.dir"), new String[0]), new HashSet<String>()));
                if (this.args.isEmpty()) {
                    return false;
                }
                arg = this.args.removeFirst();
            }
            if (expandSimpleOptions && arg.length() > 2 && !this.isSpecialSimpleOption(arg) && (arg.charAt(0) == '-' && arg.charAt(1) != '-' || arg.charAt(0) == '+' && arg.charAt(1) != '+') && (arg.charAt(1) != '/' || arg.charAt(2) == '/')) {
                NBootSimpleCharQueue vv = new NBootSimpleCharQueue(arg.toCharArray());
                char start = vv.read();
                char negChar = '\u0000';
                boolean negate = false;
                if (vv.peek() == '!' || vv.peek() == '~') {
                    negChar = vv.read();
                    negate = true;
                }
                while (vv.hasNext()) {
                    char c = vv.read();
                    StringBuilder cc = new StringBuilder();
                    cc.append(start);
                    if (negate) {
                        cc.append(negChar);
                    }
                    cc.append(c);
                    if (NBootArg.isSimpleKey(c)) {
                        while (vv.hasNext() && vv.peek() != this.eq && !NBootArg.isSimpleKey(vv.peek())) {
                            cc.append(vv.read());
                        }
                        if (vv.hasNext() && vv.peek() == this.eq) {
                            while (vv.hasNext()) {
                                cc.append(vv.read());
                            }
                            this.lookahead.add(this.createArgument(cc.toString()));
                            continue;
                        }
                        this.lookahead.add(this.createArgument(cc.toString()));
                        continue;
                    }
                    while (vv.hasNext()) {
                        cc.append(vv.read());
                    }
                    this.lookahead.add(this.createArgument(cc.toString()));
                }
            } else {
                this.lookahead.add(this.createArgument(arg));
            }
            return true;
        }
        return false;
    }

    private NBootArg createArgument(String v) {
        return new NBootArg(v, this.eq);
    }

    public NBootCmdLine copy() {
        NBootCmdLine c = new NBootCmdLine(this.toStringArray());
        c.eq = this.eq;
        c.commandName = this.commandName;
        return c;
    }

    private NBootMsg highlightText(String text) {
        return NBootMsg.ofC(text);
    }

    private boolean isPunctuation(char c) {
        switch (Character.getType(c)) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: {
                return true;
            }
        }
        return false;
    }

    public Iterator<NBootArg> iterator() {
        return Arrays.asList(this.toArgumentArray()).iterator();
    }

    public static String[] parseDefault(String commandLineString) {
        if (commandLineString == null) {
            return new String[0];
        }
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean START = false;
        boolean IN_WORD = true;
        int IN_QUOTED_WORD = 2;
        int IN_DBQUOTED_WORD = 3;
        int status = 0;
        char[] charArray = commandLineString.toCharArray();
        block30: for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            switch (status) {
                case 0: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            continue block30;
                        }
                        case '\n': 
                        case '\r': {
                            continue block30;
                        }
                        case '\'': {
                            status = 2;
                            continue block30;
                        }
                        case '\"': {
                            status = 3;
                            continue block30;
                        }
                        case '\\': {
                            status = 1;
                            sb.append(charArray[++i]);
                            continue block30;
                        }
                    }
                    sb.append(c);
                    status = 1;
                    continue block30;
                }
                case 1: {
                    switch (c) {
                        case ' ': {
                            args.add(sb.toString());
                            sb.delete(0, sb.length());
                            status = 0;
                            continue block30;
                        }
                        case '\"': 
                        case '\'': {
                            throw new NBootException(NBootMsg.ofC("illegal char %s", Character.valueOf(c)));
                        }
                        case '\\': {
                            if (++i >= charArray.length) {
                                throw new NBootException(NBootMsg.ofC("encountered end of string while expecting escaped character %s", Character.valueOf(c)));
                            }
                            sb.append(charArray[i]);
                            continue block30;
                        }
                    }
                    sb.append(c);
                    continue block30;
                }
                case 2: {
                    switch (c) {
                        case '\'': {
                            args.add(sb.toString());
                            sb.delete(0, sb.length());
                            status = 0;
                            continue block30;
                        }
                    }
                    sb.append(c);
                    continue block30;
                }
                case 3: {
                    switch (c) {
                        case '\"': {
                            args.add(sb.toString());
                            sb.delete(0, sb.length());
                            status = 0;
                            continue block30;
                        }
                        case '\\': {
                            i = NBootCmdLine.readEscapedArg(charArray, i + 1, sb);
                            continue block30;
                        }
                    }
                    sb.append(c);
                }
            }
        }
        switch (status) {
            case 0: {
                break;
            }
            case 1: {
                args.add(sb.toString());
                sb.delete(0, sb.length());
                break;
            }
            case 2: {
                throw new NBootException(NBootMsg.ofPlain("expected quote"));
            }
        }
        return args.toArray(new String[0]);
    }

    private static int readEscapedArg(char[] charArray, int i, StringBuilder sb) {
        char c = charArray[i];
        switch (c) {
            case ' ': 
            case '\"': 
            case '$': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case ';': 
            case '<': 
            case '>': 
            case '\\': 
            case '|': 
            case '~': {
                sb.append(c);
                break;
            }
            default: {
                sb.append('\\').append(c);
            }
        }
        return i;
    }

    public NBootCmdLine add(String argument) {
        if (argument != null) {
            this.args.add(argument);
        }
        return this;
    }

    public NBootCmdLine addAll(List<String> arguments) {
        if (arguments != null) {
            for (String argument : arguments) {
                this.add(argument);
            }
        }
        return this;
    }

    public boolean isBlank() {
        return this.isEmpty();
    }

    public NBootCmdLine pushBack(NBootArg ... args) {
        if (args != null) {
            this.lookahead.addAll(0, Arrays.stream(args).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return this;
    }

    public NBootCmdLine pushBack(String ... args) {
        if (args != null) {
            this.lookahead.addAll(0, Arrays.stream(args).map(x -> new NBootArg(x == null ? "" : x)).collect(Collectors.toList()));
        }
        return this;
    }

    public NBootCmdLine append(String ... args) {
        if (args != null) {
            this.args.addAll(Arrays.stream(args).map(x -> x == null ? "" : x).collect(Collectors.toList()));
        }
        return this;
    }
}

