/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot.internal.maven;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.thevpc.nuts.boot.NBootDependency;
import net.thevpc.nuts.boot.NBootEnvCondition;
import net.thevpc.nuts.boot.NBootException;
import net.thevpc.nuts.boot.NBootId;
import net.thevpc.nuts.boot.NBootInvalidWorkspaceException;
import net.thevpc.nuts.boot.NBootOptionsInfo;
import net.thevpc.nuts.boot.NBootRepositoryLocation;
import net.thevpc.nuts.boot.NBootVersion;
import net.thevpc.nuts.boot.NBootWorkspaceImpl;
import net.thevpc.nuts.boot.internal.maven.NMavenSettingsBoot;
import net.thevpc.nuts.boot.internal.maven.NMavenSettingsLoaderBoot;
import net.thevpc.nuts.boot.internal.util.NBootCache;
import net.thevpc.nuts.boot.internal.util.NBootContext;
import net.thevpc.nuts.boot.internal.util.NBootErrorInfoList;
import net.thevpc.nuts.boot.internal.util.NBootIdCache;
import net.thevpc.nuts.boot.internal.util.NBootJsonParser;
import net.thevpc.nuts.boot.internal.util.NBootLog;
import net.thevpc.nuts.boot.internal.util.NBootMsg;
import net.thevpc.nuts.boot.internal.util.NBootPath;
import net.thevpc.nuts.boot.internal.util.NBootUtils;
import net.thevpc.nuts.boot.internal.util.NReservedErrorInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NReservedMavenUtilsBoot {
    public static final Pattern JAR_POM_PATH = Pattern.compile("META-INF/maven/(?<g>[a-zA-Z0-9_.-]+)/(?<a>[a-zA-Z0-9_-]+)/pom.xml");
    public static final Pattern JAR_NUTS_JSON_POM_PATH = Pattern.compile("META-INF/nuts/(?<g>[a-zA-Z0-9_.-]+)/(?<a>[a-zA-Z0-9_-]+)/nuts.json");
    public static final Pattern NUTS_OS_ARCH_DEPS_PATTERN = Pattern.compile("^nuts([.](?<os>[a-zA-Z0-9-_]+)-os)?([.](?<arch>[a-zA-Z0-9-_]+)-arch)?-dependencies$");
    public static final Pattern PATTERN_TARGET_CLASSES = Pattern.compile("(?<src>.*)[/\\\\]+target[/\\\\]+classes[/\\\\]*");

    public static NBootId[] resolveJarIds(URL url) {
        File file = NBootUtils.toFile(url);
        if (file != null) {
            if (file.isDirectory()) {
                String src;
                Matcher m = PATTERN_TARGET_CLASSES.matcher(file.getPath().replace('/', File.separatorChar));
                if (m.find() && new File(src = m.group("src"), "pom.xml").exists()) {
                    Map<String, String> map = NReservedMavenUtilsBoot.resolvePomTagValues(new String[]{"groupId", "artifactId", "version"}, new File(src, "pom.xml"));
                    String groupId = map.get("groupId");
                    String artifactId = map.get("artifactId");
                    String version = map.get("version");
                    if (groupId != null && artifactId != null && version != null) {
                        return new NBootId[]{NBootId.of(groupId, artifactId, version)};
                    }
                }
                return new NBootId[0];
            }
            if (file.isFile()) {
                ArrayList<NBootId> all = new ArrayList<NBootId>();
                String fileName = file.getName().toLowerCase();
                if (fileName.endsWith(".jar") || fileName.endsWith(".zip")) {
                    try (ZipFile zf = new ZipFile(file);){
                        Enumeration<? extends ZipEntry> zipEntries = zf.entries();
                        while (zipEntries.hasMoreElements()) {
                            InputStream is;
                            String artifactId;
                            String groupId;
                            ZipEntry entry = zipEntries.nextElement();
                            String currPath = entry.getName();
                            Matcher m = JAR_POM_PATH.matcher(currPath);
                            if (m.find()) {
                                groupId = m.group("g");
                                artifactId = m.group("a");
                                is = zf.getInputStream(entry);
                                try {
                                    Map<String, String> map = NReservedMavenUtilsBoot.resolvePomTagValues(new String[]{"groupId", "artifactId", "version"}, is);
                                    if (map.containsKey("version")) {
                                        String version = map.get("version");
                                        all.add(NBootId.of(groupId, artifactId, version));
                                    }
                                }
                                finally {
                                    if (is != null) {
                                        is.close();
                                    }
                                }
                            }
                            if (!(m = JAR_NUTS_JSON_POM_PATH.matcher(currPath)).find()) continue;
                            groupId = m.group("g");
                            artifactId = m.group("a");
                            is = zf.getInputStream(entry);
                            try (InputStreamReader r = new InputStreamReader(is);){
                                Map map;
                                Object v;
                                Object p = new NBootJsonParser(r).parse();
                                if (!(p instanceof Map) || !((v = (map = (Map)p).get("version")) instanceof String)) continue;
                                all.add(NBootId.of(groupId, artifactId, (String)v));
                            }
                            finally {
                                if (is == null) continue;
                                is.close();
                            }
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return all.toArray(new NBootId[0]);
            }
        }
        return new NBootId[0];
    }

    public static String getFileName(NBootId id, String ext) {
        return id.getArtifactId() + "-" + id.getVersion() + "." + ext;
    }

    public static String toMavenPath(NBootId nutsId) {
        return NBootUtils.resolveIdPath(nutsId);
    }

    public static String resolveMavenFullPath(NBootRepositoryLocation repo, NBootId nutsId, String ext) {
        String jarPath = NReservedMavenUtilsBoot.toMavenPath(nutsId) + "/" + NReservedMavenUtilsBoot.getFileName(nutsId, ext);
        String mvnUrl = repo.getPath();
        String sep = "/";
        if (!NBootUtils.isURL(mvnUrl)) {
            sep = File.separator;
        }
        if (!mvnUrl.endsWith("/") && !mvnUrl.endsWith(sep)) {
            mvnUrl = mvnUrl + sep;
        }
        return mvnUrl + jarPath;
    }

    public static String getPathFile(NBootId id, String name) {
        return NReservedMavenUtilsBoot.toMavenPath(id) + "/" + name;
    }

    public static File resolveOrDownloadJar(NBootId nutsId, NBootRepositoryLocation[] repositories, NBootRepositoryLocation cacheFolder, boolean includeDesc, Instant expire, NBootErrorInfoList errors) {
        File cachedJarFile = new File(NReservedMavenUtilsBoot.resolveMavenFullPath(cacheFolder, nutsId, "jar"));
        if (cachedJarFile.isFile() && NBootUtils.isFileAccessible(cachedJarFile.toPath(), expire)) {
            return cachedJarFile;
        }
        NBootLog log = NBootContext.log();
        for (NBootRepositoryLocation r : repositories) {
            String path;
            log.with().level(Level.FINE).verbCache().log(NBootMsg.ofC("checking %s from %s", nutsId, r));
            if (includeDesc) {
                path = NReservedMavenUtilsBoot.resolveMavenFullPath(r, nutsId, "pom");
                File cachedPomFile = new File(NReservedMavenUtilsBoot.resolveMavenFullPath(cacheFolder, nutsId, "pom"));
                try {
                    NBootUtils.copy(path, cachedPomFile);
                }
                catch (Exception ex) {
                    errors.add(new NReservedErrorInfo(nutsId, r.toString(), path, "unable to load descriptor", ex));
                    log.with().level(Level.SEVERE).verbFail().log(NBootMsg.ofC("unable to load descriptor %s from %s.", nutsId, r));
                    continue;
                }
            }
            path = NReservedMavenUtilsBoot.resolveMavenFullPath(r, nutsId, "jar");
            try {
                NBootUtils.copy(path, cachedJarFile);
                log.with().level(Level.CONFIG).verbCache().log(NBootMsg.ofC("cache jar file %s", cachedJarFile.getPath()));
                errors.removeErrorsFor(nutsId);
                return cachedJarFile;
            }
            catch (Exception ex) {
                errors.add(new NReservedErrorInfo(nutsId, r.toString(), path, "unable to load binaries", ex));
                log.with().level(Level.SEVERE).verbFail().log(NBootMsg.ofC("unable to load binaries %s from %s.", nutsId, r));
            }
        }
        return null;
    }

    public static Set<NBootId> loadDependenciesFromId(NBootId rid, Collection<NBootRepositoryLocation> repos) {
        String pomPath = NBootUtils.resolveFilePath(rid, "pom");
        String nutsPath = NBootUtils.resolveFilePath(rid, "nuts");
        Set<NBootId> deps = null;
        for (NBootRepositoryLocation baseUrl : repos) {
            String loc = baseUrl.getPath();
            Set<String> urls = NReservedMavenUtilsBoot.expandRepoUrls(baseUrl);
            for (String url : urls) {
                if (url == null || (deps = NReservedMavenUtilsBoot.loadDependenciesFromPomUrl(url + "/" + pomPath)) == null) continue;
                return deps;
            }
            if (loc == null) continue;
            if (loc.startsWith("htmlfs:")) {
                loc = loc.substring("htmlfs:".length());
            }
            if ((deps = NReservedMavenUtilsBoot.loadDependenciesFromPomUrl(loc + "/" + pomPath)) == null && (deps = NReservedMavenUtilsBoot.loadDependenciesFromNutsUrl(loc + "/" + nutsPath)) == null) continue;
            break;
        }
        return deps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<NBootId> loadDependenciesFromNutsUrl(String url) {
        InputStream inputStream = NBootUtils.resolveInputStream(url);
        Map<String, Object> descNuts = null;
        if (inputStream != null) {
            try {
                NBootJsonParser parser = null;
                parser = new NBootJsonParser(new InputStreamReader(inputStream));
                descNuts = parser.parseObject();
                List dependencies = (List)descNuts.get("dependencies");
                if (dependencies == null) {
                    LinkedHashSet<NBootId> linkedHashSet = new LinkedHashSet<NBootId>();
                    return linkedHashSet;
                }
                Set<NBootId> set = dependencies.stream().map(x -> NBootId.of(x)).collect(Collectors.toSet());
                return set;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<NBootId> loadDependenciesFromPomUrl(String url) {
        LinkedHashSet<NBootId> depsSet = new LinkedHashSet<NBootId>();
        InputStream xml = NBootUtils.resolveInputStream(url);
        if (xml != null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = null;
                doc = builder.parse(xml);
                Element c = doc.getDocumentElement();
                HashMap<String, String> osMap = new HashMap<String, String>();
                HashMap<String, String> archMap = new HashMap<String, String>();
                for (int i = 0; i < c.getChildNodes().getLength(); ++i) {
                    Element c3;
                    int j;
                    Element c2;
                    if (c.getChildNodes().item(i) instanceof Element && c.getChildNodes().item(i).getNodeName().equals("dependencies")) {
                        c2 = (Element)c.getChildNodes().item(i);
                        for (j = 0; j < c2.getChildNodes().getLength(); ++j) {
                            if (!(c2.getChildNodes().item(j) instanceof Element) || !c2.getChildNodes().item(j).getNodeName().equals("dependency")) continue;
                            c3 = (Element)c2.getChildNodes().item(j);
                            String groupId = null;
                            String artifactId = null;
                            String version = null;
                            String scope = null;
                            String optional = null;
                            block31: for (int k = 0; k < c3.getChildNodes().getLength(); ++k) {
                                if (!(c3.getChildNodes().item(k) instanceof Element)) continue;
                                Element c4 = (Element)c3.getChildNodes().item(k);
                                switch (c4.getNodeName()) {
                                    case "groupId": {
                                        groupId = c4.getTextContent().trim();
                                        continue block31;
                                    }
                                    case "artifactId": {
                                        artifactId = c4.getTextContent().trim();
                                        continue block31;
                                    }
                                    case "version": {
                                        version = c4.getTextContent().trim();
                                        continue block31;
                                    }
                                    case "scope": {
                                        scope = c4.getTextContent().trim();
                                        continue block31;
                                    }
                                    case "optional": {
                                        optional = c4.getTextContent().trim();
                                    }
                                }
                            }
                            if (NBootUtils.isBlank(groupId)) {
                                throw new NBootException(NBootMsg.ofPlain("unexpected empty groupId"));
                            }
                            if (groupId.contains("$")) {
                                throw new NBootException(NBootMsg.ofC("unexpected maven variable in groupId=%s", groupId));
                            }
                            if (NBootUtils.isBlank(artifactId)) {
                                throw new NBootException(NBootMsg.ofPlain("unexpected empty artifactId"));
                            }
                            if (artifactId.contains("$")) {
                                throw new NBootException(NBootMsg.ofC("unexpected maven variable in artifactId=%s", artifactId));
                            }
                            if (NBootUtils.isBlank(version)) {
                                throw new NBootException(NBootMsg.ofPlain("unexpected empty artifactId"));
                            }
                            if (version.contains("$")) {
                                throw new NBootException(NBootMsg.ofC("unexpected maven variable in artifactId=%s", version));
                            }
                            if (NBootUtils.isBlank(scope) || scope.equals("compile")) {
                                boolean optionalBool = NBootUtils.parseBooleanOr(optional, false);
                                depsSet.add(NBootId.of(groupId, artifactId, version).setProperty("optional", optionalBool ? Boolean.TRUE.toString() : null).setCondition(new NBootEnvCondition().setOs(Arrays.asList((String)osMap.get(groupId + ":" + artifactId))).setArch(Arrays.asList((String)archMap.get(groupId + ":" + artifactId)))));
                                continue;
                            }
                            if (!version.contains("$")) continue;
                            throw new NBootException(NBootMsg.ofC("unexpected maven variable in artifactId=%s", version));
                        }
                        continue;
                    }
                    if (!(c.getChildNodes().item(i) instanceof Element) || !c.getChildNodes().item(i).getNodeName().equals("properties")) continue;
                    c2 = (Element)c.getChildNodes().item(i);
                    for (j = 0; j < c2.getChildNodes().getLength(); ++j) {
                        String nodeName;
                        if (!(c2.getChildNodes().item(j) instanceof Element)) continue;
                        c3 = (Element)c2.getChildNodes().item(j);
                        switch (nodeName = c3.getNodeName()) {
                            default: 
                        }
                        Matcher m = NUTS_OS_ARCH_DEPS_PATTERN.matcher(nodeName);
                        if (!m.find()) continue;
                        String os = m.group("os");
                        String arch = m.group("arch");
                        String txt = c3.getTextContent().trim();
                        for (String a : txt.trim().split("[;,\n\t]")) {
                            if ((a = a.trim()).startsWith("#")) continue;
                            if (!NBootUtils.isBlank(os)) {
                                osMap.put(a, os);
                            }
                            if (NBootUtils.isBlank(arch)) continue;
                            archMap.put(a, arch);
                        }
                    }
                }
                ArrayList<NBootId> ok = new ArrayList<NBootId>();
                for (NBootId idep : depsSet) {
                    NBootDependency dep = idep.toDependency();
                    String arch = (String)archMap.get(idep.getShortName());
                    String os = (String)osMap.get(idep.getShortName());
                    boolean replace = false;
                    if ((arch != null || os != null) && (dep.getCondition().getOs().isEmpty() && os != null || dep.getCondition().getArch().isEmpty() && arch != null)) {
                        replace = true;
                    }
                    if (replace) {
                        ok.add(dep.setCondition(dep.getCondition().builder().setArch(arch != null ? Arrays.asList(arch) : dep.getCondition().getArch()).setOs(arch != null ? Arrays.asList(arch) : dep.getCondition().getArch()).build()).toId());
                        continue;
                    }
                    ok.add(idep);
                }
                depsSet.clear();
                depsSet.addAll(ok);
            }
            catch (Exception ex) {
                NBootContext.log().with().level(Level.FINE).verbFail().error(ex).log(NBootMsg.ofC("unable to loadDependenciesAndRepositoriesFromPomUrl %s", url));
            }
            finally {
                try {
                    xml.close();
                }
                catch (IOException iOException) {}
            }
            return depsSet;
        }
        return null;
    }

    static List<NBootVersion> detectVersionsFromMetaData(String mavenMetadata) {
        ArrayList<NBootVersion> all = new ArrayList<NBootVersion>();
        NBootLog log = NBootContext.log();
        try {
            String urlType = "";
            if (mavenMetadata.startsWith("dotfilefs:")) {
                urlType = "dotfilefs";
                mavenMetadata = mavenMetadata.substring("dotfilefs:".length());
            }
            URL runtimeMetadata = NBootUtils.urlOf(mavenMetadata);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream is = null;
            try {
                is = NBootUtils.preloadStream(NBootUtils.openStream(runtimeMetadata));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (is != null) {
                log.with().level(Level.FINEST).verbSuccess().log(NBootMsg.ofC("parsing %s", mavenMetadata));
                Document doc = builder.parse(is);
                Element c = doc.getDocumentElement();
                for (int i = 0; i < c.getChildNodes().getLength(); ++i) {
                    if (!(c.getChildNodes().item(i) instanceof Element) || !c.getChildNodes().item(i).getNodeName().equals("versioning")) continue;
                    Element c2 = (Element)c.getChildNodes().item(i);
                    for (int j = 0; j < c2.getChildNodes().getLength(); ++j) {
                        if (!(c2.getChildNodes().item(j) instanceof Element) || !c2.getChildNodes().item(j).getNodeName().equals("versions")) continue;
                        Element c3 = (Element)c2.getChildNodes().item(j);
                        for (int k = 0; k < c3.getChildNodes().getLength(); ++k) {
                            Element c4;
                            NBootVersion p;
                            if (!(c3.getChildNodes().item(k) instanceof Element) || !c3.getChildNodes().item(k).getNodeName().equals("version") || (p = NBootVersion.of((c4 = (Element)c3.getChildNodes().item(k)).getTextContent())).isBlank()) continue;
                            all.add(p);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            log.with().level(Level.FINE).verbFail().error(ex).log(NBootMsg.ofC("unable to parse %s", mavenMetadata));
        }
        return all;
    }

    static VersionAndPath resolveLatestMavenId(NBootId zId, String path, Predicate<NBootVersion> filter, NBootRepositoryLocation repoUrl2, boolean stopFirst, NBootOptionsInfo options, boolean local, boolean remote) {
        String descType = "MAVEN";
        if ("nuts".equalsIgnoreCase(repoUrl2.getLocationType())) {
            descType = "NUTS";
        }
        Set<String> urls = NReservedMavenUtilsBoot.expandRepoUrls(repoUrl2);
        boolean found = false;
        NBootVersion bestVersion = null;
        String bestPath = null;
        NBootLog log = NBootContext.log();
        block0: for (String repoUrl : urls) {
            boolean remoteURL;
            String basePath;
            if (!repoUrl.contains("://")) {
                File[] children;
                FilenameFilter filenameFilter;
                if (!local) continue;
                File mavenNutsCoreFolder = new File(repoUrl, path.replace("/", File.separator));
                FilenameFilter filenameFilter2 = filenameFilter = descType.equals("NUTS") ? (dir, name) -> name.endsWith(".nuts") : (dir, name) -> name.endsWith(".pom");
                if (!mavenNutsCoreFolder.isDirectory() || (children = mavenNutsCoreFolder.listFiles()) == null) continue;
                for (File file : children) {
                    Path jarPath;
                    String[] goodChildren;
                    if (!file.isDirectory() || (goodChildren = file.list(filenameFilter)) == null || goodChildren.length <= 0) continue;
                    NBootVersion p = NBootVersion.of(file.getName());
                    if (filter != null && !filter.test(p)) continue;
                    found = true;
                    if (bestVersion != null && bestVersion.compareTo(p) >= 0 || !Files.isRegularFile(jarPath = file.toPath().resolve(NReservedMavenUtilsBoot.getFileName(NBootId.of(zId.getGroupId(), zId.getArtifactId(), p.getValue()), "jar")), new LinkOption[0])) continue;
                    bestVersion = p;
                    bestPath = "local location : " + jarPath;
                    if (log != null) {
                        log.with().level(Level.FINEST).verbSuccess().log(NBootMsg.ofC("%s#%s found in %s as %s", zId, bestVersion, repoUrl2, bestPath));
                    }
                    if (stopFirst) continue block0;
                }
                continue;
            }
            boolean htmlfs = repoUrl.startsWith("htmlfs:");
            if (htmlfs) {
                repoUrl = repoUrl.substring("htmlfs:".length());
            }
            if (!repoUrl.endsWith("/")) {
                repoUrl = repoUrl + "/";
            }
            if (!(basePath = repoUrl + path).endsWith("/")) {
                basePath = basePath + "/";
            }
            if ((!(remoteURL = new NBootPath(basePath).isRemote()) || !remote) && (remoteURL || !local)) continue;
            if (htmlfs) {
                for (NBootVersion p : NReservedMavenUtilsBoot.detectVersionsFromHtmlfsTomcatDirectoryListing(basePath)) {
                    if (filter != null && !filter.test(p)) continue;
                    found = true;
                    if (bestVersion != null && bestVersion.compareTo(p) >= 0) continue;
                    bestVersion = p;
                    bestPath = "remote file " + basePath;
                    if (log != null) {
                        log.with().level(Level.FINEST).verbSuccess().log(NBootMsg.ofC("%s#%s found in %s as %s", zId, bestVersion, repoUrl2, bestPath));
                    }
                    if (!stopFirst) continue;
                    continue block0;
                }
                continue;
            }
            String mavenMetadata = basePath + "maven-metadata.xml";
            for (NBootVersion p : NReservedMavenUtilsBoot.detectVersionsFromMetaData(mavenMetadata)) {
                if (filter != null && !filter.test(p)) continue;
                found = true;
                if (bestVersion != null && bestVersion.compareTo(p) >= 0) continue;
                bestVersion = p;
                bestPath = "remote file " + mavenMetadata;
                if (log != null) {
                    log.with().level(Level.FINEST).verbSuccess().log(NBootMsg.ofC("%s#%s found in %s as %s", zId, bestVersion, repoUrl2, bestPath));
                }
                if (!stopFirst) continue;
                continue block0;
            }
        }
        return new VersionAndPath(bestVersion, bestPath);
    }

    public static NBootId resolveLatestMavenId(NBootId zId, Predicate<NBootVersion> filter, Collection<NBootRepositoryLocation> bootRepositories, NBootOptionsInfo options) {
        VersionAndPath r;
        NBootLog log = NBootContext.log();
        if (log.isLoggable(Level.FINEST)) {
            switch (bootRepositories.size()) {
                case 0: {
                    log.with().level(Level.FINEST).verbStart().log(NBootMsg.ofC("search for %s nuts there are no repositories to look into.", zId));
                    break;
                }
                case 1: {
                    log.with().level(Level.FINEST).verbStart().log(NBootMsg.ofC("search for %s in: %s", zId, bootRepositories.toArray()[0]));
                    break;
                }
                default: {
                    log.with().level(Level.FINEST).verbStart().log(NBootMsg.ofC("search for %s in: ", zId));
                    for (NBootRepositoryLocation repoUrl : bootRepositories) {
                        log.with().level(Level.FINEST).verbStart().log(NBootMsg.ofC("    %s", repoUrl));
                    }
                }
            }
        }
        String path = NBootUtils.resolveIdPath(zId.getShortId());
        NBootVersion bestVersion = null;
        String bestPath = null;
        boolean stopOnFirstValidRepo = false;
        String fetchStrategy = NBootUtils.firstNonNull(options.getFetchStrategy(), "ONLINE");
        boolean offline = true;
        boolean online = true;
        boolean stopFast = true;
        switch (fetchStrategy) {
            case "OFFLINE": {
                offline = true;
                online = false;
                stopFast = true;
                break;
            }
            case "REMOTE": {
                offline = false;
                online = true;
                stopFast = true;
                break;
            }
            case "ONLINE": {
                offline = true;
                online = true;
                stopFast = true;
                break;
            }
            case "ANYWHERE": {
                offline = true;
                online = true;
                stopFast = false;
            }
        }
        if (offline) {
            for (NBootRepositoryLocation repoUrl2 : bootRepositories) {
                r = NReservedMavenUtilsBoot.resolveLatestMavenId(zId, path, filter, repoUrl2, false, options, true, false);
                if (r.version == null || bestVersion != null && bestVersion.compareTo(r.version) >= 0) continue;
                bestVersion = r.version;
                bestPath = r.path;
                if (!stopOnFirstValidRepo) continue;
                break;
            }
        }
        if (online && (bestVersion == null || !stopFast)) {
            for (NBootRepositoryLocation repoUrl2 : bootRepositories) {
                r = NReservedMavenUtilsBoot.resolveLatestMavenId(zId, path, filter, repoUrl2, false, options, false, true);
                if (r.version == null || bestVersion != null && bestVersion.compareTo(r.version) >= 0) continue;
                bestVersion = r.version;
                bestPath = r.path;
                if (!stopOnFirstValidRepo) continue;
                break;
            }
        }
        if (bestVersion == null) {
            return null;
        }
        NBootId iid = NBootId.of(zId.getGroupId(), zId.getArtifactId(), bestVersion.getValue());
        log.with().level(Level.FINEST).verbSuccess().log(NBootMsg.ofC("resolve %s from %s", iid, bestPath));
        return iid;
    }

    private static List<NBootVersion> detectVersionsFromHtmlfsTomcatDirectoryListing(String basePath) {
        ArrayList<NBootVersion> all = new ArrayList<NBootVersion>();
        try (InputStream in = NBootUtils.openStream(NBootUtils.urlOf(basePath));){
            List<String> p = new HtmlfsTomcatDirectoryListParser().parse(in);
            if (p != null) {
                for (String s : p) {
                    String n;
                    NBootVersion v;
                    int a;
                    if (!s.endsWith("/") || (a = (s = s.substring(0, s.length() - 1)).lastIndexOf(47)) < 0 || (v = NBootVersion.of(n = s.substring(a + 1))).isBlank()) continue;
                    all.add(v);
                }
            }
        }
        catch (IOException | UncheckedIOException exception) {
            // empty catch block
        }
        return all;
    }

    public static File getBootCacheJar(NBootId vid, NBootRepositoryLocation[] repositories, NBootRepositoryLocation cacheFolder, boolean useCache, String name, Instant expire, NBootErrorInfoList errorList, NBootOptionsInfo bOptions, Function<String, String> pathExpansionConverter) {
        File f = NReservedMavenUtilsBoot.getBootCacheFile(vid, NReservedMavenUtilsBoot.getFileName(vid, "jar"), repositories, cacheFolder, useCache, expire, errorList, bOptions, pathExpansionConverter);
        if (f == null) {
            throw new NBootInvalidWorkspaceException(bOptions.getWorkspace(), NBootMsg.ofC("unable to load %s %s from repositories %s", name, vid, Arrays.asList(repositories)));
        }
        return f;
    }

    static File getBootCacheFile(NBootId vid, String fileName, NBootRepositoryLocation[] repositories, NBootRepositoryLocation cacheFolder, boolean useCache, Instant expire, NBootErrorInfoList errorList, NBootOptionsInfo bOptions, Function<String, String> pathExpansionConverter) {
        Object f;
        String path = NReservedMavenUtilsBoot.getPathFile(vid, fileName);
        if (useCache && cacheFolder != null && NBootUtils.isFileAccessible(((File)(f = new File(cacheFolder.getPath(), path.replace('/', File.separatorChar)))).toPath(), expire)) {
            return f;
        }
        for (NBootRepositoryLocation repository : repositories) {
            if (useCache && cacheFolder != null && cacheFolder.equals(repository)) {
                return null;
            }
            File file = NReservedMavenUtilsBoot.getBootCacheFile(vid, path, repository, cacheFolder, useCache, expire, errorList, bOptions, pathExpansionConverter);
            if (file == null) continue;
            return file;
        }
        NBootCache cache = NBootContext.cache();
        NBootIdCache e = cache.fallbackIdMap.get(vid);
        if (e != null && e.jar != null) {
            return new File(e.jar);
        }
        e = cache.fallbackIdMap.get(vid.getShortId());
        if (e != null && e.jar != null) {
            return new File(e.jar);
        }
        return null;
    }

    private static File getBootCacheFile(NBootId nutsId, String path, NBootRepositoryLocation repository0, NBootRepositoryLocation cacheFolder, boolean useCache, Instant expire, NBootErrorInfoList errorList, NBootOptionsInfo bOptions, Function<String, String> pathExpansionConverter) {
        boolean cacheLocalFiles = true;
        NBootLog log = NBootContext.log();
        for (String repository : NReservedMavenUtilsBoot.expandRepoUrls(repository0)) {
            File file;
            if (repository.startsWith("htmlfs:")) {
                repository = repository.substring("htmlfs:".length());
            }
            repository = NBootUtils.expandPath(repository, bOptions.getWorkspace(), pathExpansionConverter);
            File repositoryFolder = null;
            if (NBootUtils.isURL(repository)) {
                try {
                    repositoryFolder = NBootUtils.toFile(NBootUtils.urlOf(repository));
                }
                catch (Exception ex) {
                    log.with().level(Level.FINE).verbFail().error(ex).log(NBootMsg.ofC("unable to convert url to file : %s", repository));
                }
            } else {
                repositoryFolder = new File(repository);
            }
            if (repositoryFolder == null) {
                if (cacheFolder == null) {
                    return null;
                }
                File ok = null;
                File to = new File(cacheFolder.getPath(), path);
                String urlPath = repository;
                if (!urlPath.endsWith("/")) {
                    urlPath = urlPath + "/";
                }
                urlPath = urlPath + path;
                try {
                    NBootUtils.copy(urlPath, to);
                    errorList.removeErrorsFor(nutsId);
                    ok = to;
                }
                catch (UncheckedIOException ex) {
                    errorList.add(new NReservedErrorInfo(nutsId, repository, urlPath, "unable to load", ex));
                }
                return ok;
            }
            repository = repositoryFolder.getPath();
            File repoFolder = NBootUtils.createFile(NBootUtils.getHome("CONF", bOptions), repository);
            File ff = null;
            if (repoFolder.isDirectory()) {
                file = new File(repoFolder, path.replace('/', File.separatorChar));
                if (file.isFile()) {
                    ff = file;
                } else {
                    log.with().level(Level.CONFIG).verbFail().log(NBootMsg.ofC("file not found %s", file));
                }
            } else {
                file = new File(repoFolder, path.replace('/', File.separatorChar));
                log.with().level(Level.CONFIG).verbFail().log(NBootMsg.ofC("file not found %s ; repository is not a valid folder : %s", file, repoFolder));
            }
            if (ff == null) continue;
            if (cacheFolder != null && cacheLocalFiles) {
                File to = new File(cacheFolder.getPath(), path);
                String toc = NBootUtils.getAbsolutePath(to.getPath());
                String ffc = NBootUtils.getAbsolutePath(ff.getPath());
                if (ffc.equals(toc)) {
                    return ff;
                }
                try {
                    if (to.getParentFile() != null) {
                        to.getParentFile().mkdirs();
                    }
                    String ext = "config";
                    if (ff.getName().endsWith(".jar")) {
                        ext = "jar";
                    }
                    if (to.isFile()) {
                        NBootUtils.copy(ff, to);
                        log.with().level(Level.CONFIG).verbCache().log(NBootMsg.ofC("recover cached %s file %s to %s", ext, ff, to));
                    } else {
                        NBootUtils.copy(ff, to);
                        log.with().level(Level.CONFIG).verbCache().log(NBootMsg.ofC("cache %s file %s to %s", ext, ff, to));
                    }
                    return to;
                }
                catch (UncheckedIOException ex) {
                    errorList.add(new NReservedErrorInfo(nutsId, repository, ff.getPath(), "unable to cache", ex));
                    log.with().level(Level.CONFIG).verbFail().log(NBootMsg.ofC("error caching file %s to %s : %s", ff, to, ex.toString()));
                    return ff;
                }
            }
            return ff;
        }
        return null;
    }

    public static boolean isMavenSettingsRepo(NBootRepositoryLocation loc) {
        return !(!"maven".equals(loc.getName()) && !"maven".equals(loc.getLocationType()) || !NBootUtils.isBlank(loc.getPath()) && !"maven".equals(loc.getPath()));
    }

    private static Set<String> expandRepoUrls(final NBootRepositoryLocation repoUrl2) {
        Function<String, Object> mappingFunction = new Function<String, Object>(){

            @Override
            public Object apply(String repo) {
                LinkedHashSet<String> urls = new LinkedHashSet<String>();
                if (NReservedMavenUtilsBoot.isMavenSettingsRepo(repoUrl2)) {
                    Map<String, String> p = repoUrl2.getProperties();
                    Boolean local = null;
                    Boolean central = null;
                    Boolean other = null;
                    for (String s : p.keySet()) {
                        switch (NBootUtils.trim(s).toLowerCase()) {
                            case "local": {
                                local = NBootUtils.parseBoolean(p.get(s), true, local);
                                break;
                            }
                            case "no-local": {
                                local = NBootUtils.parseBoolean(p.get(s), true, local == false) == false;
                                break;
                            }
                            case "local-only": 
                            case "localonly": {
                                boolean localOnly = NBootUtils.parseBoolean(p.get(s), true, false);
                                if (!localOnly) break;
                                local = true;
                                central = false;
                                other = false;
                                break;
                            }
                            case "central": {
                                central = NBootUtils.parseBoolean(p.get(s), true, central);
                                break;
                            }
                            case "no-central": {
                                central = NBootUtils.parseBoolean(p.get(s), true, central == false) == false;
                                break;
                            }
                            case "central-only": 
                            case "centralonly": {
                                boolean centralOnly = NBootUtils.parseBoolean(p.get(s), true, false);
                                if (!centralOnly) break;
                                local = false;
                                central = true;
                                other = false;
                                break;
                            }
                            case "other": {
                                other = NBootUtils.parseBoolean(p.get(s), true, other);
                                break;
                            }
                            case "no-other": {
                                other = NBootUtils.parseBoolean(p.get(s), true, other == false) == false;
                                break;
                            }
                            case "other-only": 
                            case "otheronly": {
                                boolean otherOnly = NBootUtils.parseBoolean(p.get(s), true, false);
                                if (!otherOnly) break;
                                local = false;
                                central = false;
                                other = true;
                                break;
                            }
                        }
                    }
                    if (local == null) {
                        local = true;
                    }
                    if (central == null) {
                        central = true;
                    }
                    if (other == null) {
                        other = true;
                    }
                    urls.addAll(NReservedMavenUtilsBoot.loadMavenSettingsUrls(local, central, other));
                } else {
                    urls.add(repoUrl2.getPath());
                }
                return urls;
            }
        };
        return (Set)NBootContext.cache().get(NMavenSettingsBoot.class.getName() + "::expandRepoUrls::" + repoUrl2, mappingFunction);
    }

    private static Set<String> loadMavenSettingsUrls(boolean local, boolean central, boolean other) {
        NMavenSettingsBoot mavenSettings = (NMavenSettingsBoot)NBootContext.cache().get(NMavenSettingsBoot.class.getName(), x -> new NMavenSettingsLoaderBoot().loadSettingsRepos());
        LinkedHashSet<String> urls = new LinkedHashSet<String>();
        if (local) {
            urls.add(mavenSettings.getLocalRepository());
        }
        if (central) {
            urls.add(mavenSettings.getRemoteRepository());
        }
        if (other) {
            for (NBootRepositoryLocation activeRepository : mavenSettings.getActiveRepositories()) {
                urls.add(activeRepository.getPath());
            }
        }
        return urls;
    }

    public static String resolveNutsApiVersionFromClassPath(NBootContext bContext) {
        return NReservedMavenUtilsBoot.resolveNutsApiPomPattern("version", bContext);
    }

    public static String resolveNutsApiPomPattern(String propName, NBootContext bContext) {
        String propValue = null;
        try {
            URL resource = NBootWorkspaceImpl.class.getResource("/META-INF/maven/net.thevpc.nuts/nuts/pom.properties");
            if (resource != null) {
                switch (propName) {
                    case "groupId": 
                    case "artifactId": 
                    case "version": {
                        propValue = NBootUtils.loadURLProperties(resource, null, false).getProperty(propName);
                    }
                }
            }
        }
        catch (Exception resource) {
            // empty catch block
        }
        if (!NBootUtils.isBlank(propValue)) {
            return propValue;
        }
        URL pomXml = NBootWorkspaceImpl.class.getResource("/META-INF/maven/net.thevpc.nuts/nuts/pom.xml");
        if (pomXml != null) {
            try (InputStream is2 = NBootUtils.openStream(pomXml);){
                propValue = NReservedMavenUtilsBoot.resolvePomTagValues(new String[]{propName}, is2).get(propName);
            }
            catch (Exception is2) {
                // empty catch block
            }
        }
        if (!NBootUtils.isBlank(propValue)) {
            return propValue;
        }
        String cp = System.getProperty("java.class.path");
        for (String p : cp.split(File.pathSeparator)) {
            String src;
            Matcher m;
            File f = new File(p);
            if (!f.isDirectory() || !(m = Pattern.compile("(?<src>.*)[/\\\\]+target[/\\\\]+classes[/\\\\]*").matcher(f.getPath().replace('/', File.separatorChar))).find() || !new File(src = m.group("src"), "pom.xml").exists() || !new File(src, "src/main/java/net/thevpc/nuts/Nuts.java".replace('/', File.separatorChar)).exists()) continue;
            propValue = NReservedMavenUtilsBoot.resolvePomTagValues(new String[]{propName}, new File(src, "pom.xml")).get(propName);
        }
        if (!NBootUtils.isBlank(propValue)) {
            return propValue;
        }
        try {
            URL resource = NBootWorkspaceImpl.class.getResource("/META-INF/nuts/net.thevpc.nuts/nuts/nuts.properties");
            if (resource != null) {
                block18 : switch (propName) {
                    case "groupId": 
                    case "artifactId": 
                    case "version": {
                        String id = NBootUtils.loadURLProperties(resource, null, false).getProperty("id");
                        if (NBootUtils.isBlank(id)) break;
                        NBootId nId = NBootId.of(id);
                        switch (propName) {
                            case "groupId": {
                                propValue = nId.getGroupId();
                                break block18;
                            }
                            case "artifactId": {
                                propValue = nId.getArtifactId();
                                break block18;
                            }
                            case "version": {
                                propValue = nId.getVersion().toString();
                            }
                        }
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!NBootUtils.isBlank(propValue)) {
            return propValue;
        }
        return null;
    }

    public static Map<String, String> resolvePomTagValues(String[] propNames, File file) {
        if (file != null && file.isFile()) {
            Map<String, String> map;
            block9: {
                InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);
                try {
                    map = NReservedMavenUtilsBoot.resolvePomTagValues(propNames, is);
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                is.close();
            }
            return map;
        }
        return new HashMap<String, String>();
    }

    public static Map<String, String> resolvePomTagValues(String[] propNames, InputStream is) {
        int i;
        String propValue = null;
        StringBuilder sb = new StringBuilder("<(?<name>");
        for (i = 0; i < propNames.length; ++i) {
            if (i > 0) {
                sb.append("|");
            }
            sb.append(propNames[i].replace(".", "[.]"));
        }
        sb.append(")>");
        sb.append("(?<value>[^<]*)");
        sb.append("</(?<name2>");
        for (i = 0; i < propNames.length; ++i) {
            if (i > 0) {
                sb.append("|");
            }
            sb.append(propNames[i].replace(".", "[.]"));
        }
        sb.append(")>");
        Pattern pattern = Pattern.compile(sb.toString());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            NBootUtils.copy(is, bos, false, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Matcher m = pattern.matcher(bos.toString());
        while (m.find()) {
            String n = m.group("name").trim();
            String n2 = m.group("name2").trim();
            propValue = m.group("value").trim();
            if (map.containsKey(n)) continue;
            map.put(n, propValue);
        }
        return map;
    }

    private static class VersionAndPath {
        NBootVersion version;
        String path;

        public VersionAndPath(NBootVersion version, String path) {
            this.version = version;
            this.path = path;
        }
    }

    private static class HtmlfsTomcatDirectoryListParser {
        private HtmlfsTomcatDirectoryListParser() {
        }

        public List<String> parse(InputStream html) {
            try {
                String line;
                ArrayList<String> found = new ArrayList<String>();
                BufferedReader br = new BufferedReader(new InputStreamReader(html));
                SimpleTomcatDirectoryListParserState s = SimpleTomcatDirectoryListParserState.EXPECT_DOCTYPE;
                block8: while ((line = br.readLine()) != null) {
                    line = line.trim();
                    switch (s.ordinal()) {
                        case 0: {
                            if (line.isEmpty()) break;
                            if (line.toLowerCase().startsWith("<!DOCTYPE html".toLowerCase())) {
                                s = SimpleTomcatDirectoryListParserState.EXPECT_BODY;
                                break;
                            }
                            if (line.toLowerCase().startsWith("<html>".toLowerCase()) || line.toLowerCase().startsWith("<html ".toLowerCase())) {
                                s = SimpleTomcatDirectoryListParserState.EXPECT_BODY;
                                break;
                            }
                            return null;
                        }
                        case 1: {
                            if (line.isEmpty() || !line.toLowerCase().startsWith("<body>".toLowerCase()) && !line.toLowerCase().startsWith("<body ".toLowerCase())) break;
                            s = SimpleTomcatDirectoryListParserState.EXPECT_PRE;
                            break;
                        }
                        case 2: {
                            int i1;
                            int i0;
                            if (line.isEmpty()) break;
                            String lowLine = line;
                            if (lowLine.toLowerCase().startsWith("<pre>".toLowerCase()) || lowLine.toLowerCase().startsWith("<pre ".toLowerCase())) {
                                if (lowLine.toLowerCase().startsWith("<pre>") && lowLine.toLowerCase().matches("<pre>name[ ]+last modified[ ]+size</pre>(<hr/>)?")) break;
                                if (lowLine.toLowerCase().startsWith("<pre>") && lowLine.toLowerCase().matches("<pre>[ ]*<a href=.*")) {
                                    if (!(lowLine = lowLine.substring("<pre>".length()).trim()).toLowerCase().startsWith("<a href=\"")) continue block8;
                                    i0 = "<a href=\"".length();
                                    i1 = lowLine.indexOf(34, i0);
                                    if (i1 > 0) {
                                        found.add(lowLine.substring(i0, i1));
                                        s = SimpleTomcatDirectoryListParserState.EXPECT_HREF;
                                        break;
                                    }
                                    return null;
                                }
                                if (!lowLine.toLowerCase().startsWith("<pre ")) continue block8;
                                s = SimpleTomcatDirectoryListParserState.EXPECT_HREF;
                                break;
                            }
                            if (!lowLine.toLowerCase().matches("<td .*<strong>last modified</strong>.*</td>")) continue block8;
                            s = SimpleTomcatDirectoryListParserState.EXPECT_HREF;
                            break;
                        }
                        case 3: {
                            int i1;
                            int i0;
                            if (line.isEmpty()) break;
                            String lowLine = line;
                            if (lowLine.toLowerCase().startsWith("</pre>".toLowerCase())) {
                                return found;
                            }
                            if (lowLine.toLowerCase().startsWith("</html>".toLowerCase())) {
                                return found;
                            }
                            if (!lowLine.toLowerCase().startsWith("<a href=\"") || (i1 = lowLine.indexOf(34, i0 = "<a href=\"".length())) <= 0) break;
                            found.add(lowLine.substring(i0, i1));
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    private static enum SimpleTomcatDirectoryListParserState {
        EXPECT_DOCTYPE,
        EXPECT_BODY,
        EXPECT_PRE,
        EXPECT_HREF;

    }
}

