/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot.internal.util;

import java.io.File;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import net.thevpc.nuts.boot.NBootHomeLocation;
import net.thevpc.nuts.boot.NBootOptionsInfo;
import net.thevpc.nuts.boot.internal.compat.NReservedBootConfigLoaderOld;
import net.thevpc.nuts.boot.internal.util.NBootContext;
import net.thevpc.nuts.boot.internal.util.NBootJsonParser;
import net.thevpc.nuts.boot.internal.util.NBootLog;
import net.thevpc.nuts.boot.internal.util.NBootMsg;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public final class NBootBootConfigLoader {
    public static NBootOptionsInfo loadBootConfig(String workspaceLocation) {
        File bootFile = new File(workspaceLocation, "nuts-workspace.json");
        NBootLog log = NBootContext.log();
        try {
            if (bootFile.isFile()) {
                log.with().level(Level.CONFIG).verbRead().log(NBootMsg.ofC("load boot file : %s", bootFile.getPath()));
                String json = NBootUtils.readStringFromFile(bootFile).trim();
                if (json.length() > 0) {
                    return NBootBootConfigLoader.loadBootConfigJSON(json);
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                log.with().level(Level.CONFIG).verbNotice().log(NBootMsg.ofC("previous Workspace config not found at %s", bootFile.getPath()));
            }
        }
        catch (Exception ex) {
            log.with().level(Level.CONFIG).verbFail().error(ex).log(NBootMsg.ofC("unable to load nuts version file %s", bootFile));
        }
        return null;
    }

    private static NBootOptionsInfo loadBootConfigJSON(String json) {
        int buildNumber;
        NBootJsonParser parser = new NBootJsonParser(new StringReader(json));
        Map<String, Object> jsonObject = parser.parseObject();
        NBootOptionsInfo c = new NBootOptionsInfo();
        String configVersion = (String)jsonObject.get("configVersion");
        if (NBootUtils.isBlank(configVersion)) {
            configVersion = (String)jsonObject.get("createApiVersion");
        }
        if (NBootUtils.isBlank(configVersion)) {
            configVersion = "";
        }
        NBootLog log = NBootContext.log();
        if (NBootUtils.isBlank(configVersion)) {
            configVersion = "0.8.7";
            log.with().level(Level.FINEST).verbFail().log(NBootMsg.ofC("unable to detect config version. Fallback to %s", configVersion));
        }
        if ((buildNumber = NBootBootConfigLoader.getApiVersionOrdinalNumber(configVersion)) <= 501) {
            log.with().level(Level.CONFIG).verbRead().log(NBootMsg.ofC("detect config version %s ( considered as 0.5.1, very old config, ignored)", configVersion));
        } else if (buildNumber <= 505) {
            log.with().level(Level.CONFIG).verbRead().log(NBootMsg.ofC("detect config version %s ( compatible with 0.5.2 config file )", configVersion));
            NReservedBootConfigLoaderOld.loadConfigVersion502(c, jsonObject, log);
        } else if (buildNumber <= 506) {
            log.with().level(Level.CONFIG).verbRead().log(NBootMsg.ofC("detect config version %s ( compatible with 0.5.6 config file )", configVersion));
            NReservedBootConfigLoaderOld.loadConfigVersion506(c, jsonObject, log);
        } else {
            log.with().level(Level.CONFIG).verbRead().log(NBootMsg.ofC("detect config version %s ( compatible with 0.5.7 config file )", configVersion));
            NReservedBootConfigLoaderOld.loadConfigVersion507(c, jsonObject, log);
        }
        return c;
    }

    private static int getApiVersionOrdinalNumber(String s) {
        try {
            int a = 0;
            for (String part : s.split("\\.")) {
                a = a * 100 + NBootUtils.firstNonNull(NBootUtils.parseInt(part), 0);
            }
            return a;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public static Map<NBootHomeLocation, String> asNutsHomeLocationMap(Map<Object, String> m) {
        LinkedHashMap<NBootHomeLocation, String> a = new LinkedHashMap<NBootHomeLocation, String>();
        if (m != null) {
            for (Map.Entry<Object, String> e : m.entrySet()) {
                Object k = e.getKey();
                NBootHomeLocation kk = k instanceof NBootHomeLocation ? (NBootHomeLocation)k : (k == null ? NBootHomeLocation.of(null, null) : NBootUtils.firstNonNull(NBootHomeLocation.parse((String)k), NBootHomeLocation.of(null, null)));
                a.put(kk, e.getValue());
            }
        }
        return a;
    }

    public static Map<String, String> asNutsStoreLocationMap(Map<Object, String> m) {
        LinkedHashMap<String, String> a = new LinkedHashMap<String, String>();
        if (m != null) {
            for (Map.Entry<Object, String> e : m.entrySet()) {
                Object k = e.getKey();
                String kk = NBootUtils.enumId((String)k);
                if (kk == null) continue;
                a.put(kk, e.getValue());
            }
        }
        return a;
    }
}

