/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot.internal.util;

import java.time.Instant;
import java.util.Objects;
import net.thevpc.nuts.boot.internal.util.NBootDuration;

public class NBootClock {
    private final long timeMillis;
    private final long nanos;

    public static NBootClock now() {
        return new NBootClock(System.currentTimeMillis(), System.nanoTime());
    }

    public NBootClock(long timeMillis, long nanos) {
        this.timeMillis = timeMillis;
        this.nanos = nanos;
    }

    public NBootDuration minus(NBootClock o) {
        return NBootDuration.ofNanos(this.nanos - o.nanos);
    }

    public Instant getInstant() {
        return Instant.ofEpochMilli(this.timeMillis);
    }

    public long getTimeMillis() {
        return this.timeMillis;
    }

    public long getTimeNanos() {
        return this.nanos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NBootClock nClock = (NBootClock)o;
        return this.timeMillis == nClock.timeMillis && this.nanos == nClock.nanos;
    }

    public int hashCode() {
        return Objects.hash(this.timeMillis, this.nanos);
    }

    public String toString() {
        return "NutsClock{timeMillis=" + this.timeMillis + ", timeNanos=" + this.nanos + '}';
    }
}

