/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot.internal.util;

import java.util.concurrent.Callable;
import net.thevpc.nuts.boot.NBootException;
import net.thevpc.nuts.boot.internal.util.NBootCache;
import net.thevpc.nuts.boot.internal.util.NBootLog;
import net.thevpc.nuts.boot.internal.util.NBootMsg;

public class NBootContext {
    public static InheritableThreadLocal<NBootContext> curr = new InheritableThreadLocal();
    public NBootLog log;
    public Integer connectionTimout;
    private NBootCache cache = new NBootCache();

    public static NBootLog log() {
        return NBootContext.context().log;
    }

    public static NBootCache cache() {
        return NBootContext.context().cache;
    }

    public static NBootContext context() {
        return (NBootContext)curr.get();
    }

    public void runWith(Runnable r) {
        NBootContext old = (NBootContext)curr.get();
        if (old == this) {
            r.run();
            return;
        }
        try {
            curr.set(this);
            r.run();
        }
        finally {
            curr.set(old);
        }
    }

    public <T> T callWith(Callable<T> r) {
        NBootContext old = (NBootContext)curr.get();
        if (old == this) {
            try {
                return r.call();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new NBootException(NBootMsg.ofC("unable to call %s : error =%s", r, e), (Throwable)e);
            }
        }
        curr.set(this);
        try {
            T e = r.call();
            return e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NBootException(NBootMsg.ofC("unable to call %s : error =%s", r, e), (Throwable)e);
        }
        finally {
            curr.set(old);
        }
    }
}

