/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot.internal.util;

import java.io.Serializable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;

public class NBootDuration
implements Serializable {
    private long nanos;
    private long micros;
    private long milliSeconds;
    private long seconds;
    private long minutes;
    private long hours;
    private long days;
    private long weeks;
    private long months;
    private long years;
    private final ChronoUnit smallestUnit;
    private final ChronoUnit largestUnit;
    private final long timeMillis;
    private final int timeNanos;

    public NBootDuration(long years, long months, long weeks, long days, long hours, long minutes, long seconds, long milliSeconds, long micros, long nanos, ChronoUnit smallestUnit, ChronoUnit largestUnit) {
        this.nanos = nanos;
        this.micros = micros;
        this.milliSeconds = milliSeconds;
        this.seconds = seconds;
        this.minutes = minutes;
        this.hours = hours;
        this.days = days;
        this.weeks = weeks;
        this.months = months;
        this.years = years;
        this.timeMillis = this.rebuildTimeMillis();
        this.timeNanos = this.rebuildTimeNanos();
        this.smallestUnit = smallestUnit == null ? this.detectSmallestUnit() : NBootDuration.normalize(smallestUnit);
        ChronoUnit chronoUnit = largestUnit = largestUnit == null ? this.detectLargestUnit() : NBootDuration.normalize(largestUnit);
        if (largestUnit.ordinal() < this.smallestUnit.ordinal()) {
            largestUnit = this.smallestUnit;
        }
        this.largestUnit = largestUnit;
        this.applyUnits();
    }

    public NBootDuration(long[] values, ChronoUnit smallestUnit, ChronoUnit largestUnit) {
        this.nanos = values[ChronoUnit.NANOS.ordinal()];
        this.micros = values[ChronoUnit.MICROS.ordinal()];
        this.milliSeconds = values[ChronoUnit.MILLIS.ordinal()];
        this.seconds = values[ChronoUnit.SECONDS.ordinal()];
        this.minutes = values[ChronoUnit.MINUTES.ordinal()];
        this.hours = values[ChronoUnit.HOURS.ordinal()];
        this.days = values[ChronoUnit.DAYS.ordinal()];
        this.weeks = values[ChronoUnit.WEEKS.ordinal()];
        this.months = values[ChronoUnit.MONTHS.ordinal()];
        this.years = values[ChronoUnit.YEARS.ordinal()];
        this.timeMillis = this.rebuildTimeMillis();
        this.timeNanos = this.rebuildTimeNanos();
        this.smallestUnit = smallestUnit == null ? this.detectSmallestUnit() : NBootDuration.normalize(smallestUnit);
        ChronoUnit chronoUnit = largestUnit = largestUnit == null ? this.detectLargestUnit() : NBootDuration.normalize(largestUnit);
        if (largestUnit.ordinal() < this.smallestUnit.ordinal()) {
            largestUnit = this.smallestUnit;
        }
        this.largestUnit = largestUnit;
        this.applyUnits();
    }

    private int rebuildTimeNanos() {
        return (int)(this.nanos + this.micros * 1000L);
    }

    private long rebuildTimeMillis() {
        return this.milliSeconds + this.seconds * 1000L + this.minutes * 1000L * 60L + this.hours * 1000L * 60L * 60L + this.days * 1000L * 60L * 60L * 24L + this.weeks * 1000L * 60L * 60L * 24L * 7L + this.months * 1000L * 60L * 60L * 24L * 30L + this.years * 1000L * 60L * 60L * 24L * 365L;
    }

    public NBootDuration(long timeMillis, int timeNanos) {
        this.timeMillis = timeMillis;
        this.timeNanos = timeNanos;
        this.nanos = (int)((long)timeNanos % 1000L);
        this.micros = (int)((long)timeNanos / 1000L);
        this.milliSeconds = (int)(timeMillis % 1000L);
        this.seconds = (int)(timeMillis / 1000L % 60L);
        this.minutes = (int)(timeMillis / 60000L % 60L);
        this.hours = (int)(timeMillis / 3600000L % 24L);
        long dd = timeMillis / 3600000L / 24L;
        this.years = dd / 365L;
        this.months = (dd %= 365L) / 30L;
        this.weeks = (dd %= 30L) / 7L;
        this.days = dd %= 7L;
        this.smallestUnit = this.detectSmallestUnit();
        this.largestUnit = this.detectLargestUnit();
    }

    public NBootDuration(long timeMillis, int timeNanos, ChronoUnit smallestUnit, ChronoUnit largestUnit) {
        this.timeMillis = timeMillis;
        this.timeNanos = timeNanos;
        if (smallestUnit != null && largestUnit != null) {
            this.smallestUnit = NBootDuration.normalize(smallestUnit);
            if ((largestUnit = NBootDuration.normalize(largestUnit)).ordinal() < this.smallestUnit.ordinal()) {
                largestUnit = this.smallestUnit;
            }
            this.largestUnit = largestUnit;
            int largestUnitOrdinal = this.largestUnit.ordinal();
            int smallestUnitOrdinal = this.smallestUnit.ordinal();
            if (smallestUnitOrdinal <= ChronoUnit.NANOS.ordinal()) {
                if (largestUnitOrdinal > ChronoUnit.NANOS.ordinal()) {
                    this.nanos = (int)((long)timeNanos % 1000L);
                } else {
                    this.nanos = (long)timeNanos + timeMillis * 1000000L;
                    return;
                }
            }
            if (smallestUnitOrdinal <= ChronoUnit.MICROS.ordinal()) {
                if (largestUnitOrdinal > ChronoUnit.MICROS.ordinal()) {
                    this.micros = (int)((long)timeNanos / 1000L);
                } else {
                    this.micros = (long)((int)((long)timeNanos / 1000L)) + timeMillis * 1000L;
                    return;
                }
            }
            if (smallestUnitOrdinal <= ChronoUnit.MILLIS.ordinal()) {
                if (largestUnitOrdinal > ChronoUnit.MILLIS.ordinal()) {
                    this.milliSeconds = (int)(timeMillis % 1000L);
                } else {
                    this.milliSeconds = timeMillis;
                    return;
                }
            }
            if (smallestUnitOrdinal <= ChronoUnit.SECONDS.ordinal()) {
                if (largestUnitOrdinal > ChronoUnit.SECONDS.ordinal()) {
                    this.seconds = (int)(timeMillis / 1000L % 60L);
                } else {
                    this.seconds = timeMillis / 1000L;
                    return;
                }
            }
            if (smallestUnitOrdinal <= ChronoUnit.MINUTES.ordinal()) {
                if (largestUnitOrdinal > ChronoUnit.MINUTES.ordinal()) {
                    this.minutes = (int)(timeMillis / 60000L % 60L);
                } else {
                    this.minutes = timeMillis / 60000L;
                    return;
                }
            }
            if (smallestUnitOrdinal <= ChronoUnit.HOURS.ordinal()) {
                if (largestUnitOrdinal > ChronoUnit.HOURS.ordinal()) {
                    this.hours = (int)(timeMillis / 3600000L % 24L);
                } else {
                    this.hours = (int)(timeMillis / 3600000L);
                    return;
                }
            }
            long dd = timeMillis / 3600000L / 24L;
            if (largestUnitOrdinal >= ChronoUnit.YEARS.ordinal()) {
                if (smallestUnitOrdinal <= ChronoUnit.YEARS.ordinal()) {
                    this.years = dd / 365L;
                }
                dd %= 365L;
            }
            if (largestUnitOrdinal >= ChronoUnit.MONTHS.ordinal()) {
                if (smallestUnitOrdinal <= ChronoUnit.MONTHS.ordinal()) {
                    this.months = dd / 30L;
                }
                dd %= 30L;
            }
            if (largestUnitOrdinal >= ChronoUnit.WEEKS.ordinal()) {
                if (smallestUnitOrdinal <= ChronoUnit.WEEKS.ordinal()) {
                    this.weeks = dd / 7L;
                }
                dd %= 7L;
            }
            if (smallestUnitOrdinal <= ChronoUnit.DAYS.ordinal()) {
                this.days = dd;
            }
        } else {
            this.nanos = (int)((long)timeNanos % 1000L);
            this.micros = (int)((long)timeNanos / 1000L);
            this.milliSeconds = (int)(timeMillis % 1000L);
            this.seconds = (int)(timeMillis / 1000L % 60L);
            this.minutes = (int)(timeMillis / 60000L % 60L);
            this.hours = (int)(timeMillis / 3600000L % 24L);
            long dd = timeMillis / 3600000L / 24L;
            this.years = dd / 365L;
            this.months = (dd %= 365L) / 30L;
            this.weeks = (dd %= 30L) / 7L;
            this.days = dd %= 7L;
            this.smallestUnit = smallestUnit == null ? this.detectSmallestUnit() : NBootDuration.normalize(smallestUnit);
            ChronoUnit chronoUnit = largestUnit = largestUnit == null ? this.detectLargestUnit() : NBootDuration.normalize(largestUnit);
            if (largestUnit.ordinal() < this.smallestUnit.ordinal()) {
                largestUnit = this.smallestUnit;
            }
            this.largestUnit = largestUnit;
            this.applyUnits();
        }
    }

    private void applyUnits() {
        int uo = this.smallestUnit.ordinal();
        if (uo > ChronoUnit.NANOS.ordinal()) {
            this.nanos = 0L;
        }
        if (uo > ChronoUnit.MICROS.ordinal()) {
            this.micros = 0L;
        }
        if (uo > ChronoUnit.MILLIS.ordinal()) {
            this.milliSeconds = 0L;
        }
        if (uo > ChronoUnit.SECONDS.ordinal()) {
            this.seconds = 0L;
        }
        if (uo > ChronoUnit.MINUTES.ordinal()) {
            this.minutes = 0L;
        }
        if (uo > ChronoUnit.HOURS.ordinal()) {
            this.hours = 0L;
        }
        if (uo > ChronoUnit.DAYS.ordinal()) {
            this.days = 0L;
        }
        if (uo > ChronoUnit.WEEKS.ordinal()) {
            this.weeks = 0L;
        }
        if (uo > ChronoUnit.MONTHS.ordinal()) {
            this.months = 0L;
        }
        if (uo > ChronoUnit.MONTHS.ordinal()) {
            this.months = 0L;
        }
        if (uo > ChronoUnit.YEARS.ordinal()) {
            this.years = 0L;
        }
        switch (this.largestUnit) {
            case YEARS: {
                break;
            }
            case MONTHS: {
                this.months += 12L * this.years;
                this.years = 0L;
                break;
            }
            case WEEKS: {
                this.weeks += 4L * this.months + 52L * this.years;
                this.years = 0L;
                this.months = 0L;
                break;
            }
            case DAYS: {
                this.days += 7L * this.weeks + 30L * this.months + 365L * this.years;
                this.years = 0L;
                this.months = 0L;
                this.weeks = 0L;
                break;
            }
            case HOURS: {
                this.hours += (7L * this.weeks + 30L * this.months + 365L * this.years + this.days) * 24L;
                this.years = 0L;
                this.months = 0L;
                this.weeks = 0L;
                this.days = 0L;
                break;
            }
            case MINUTES: {
                this.minutes += ((7L * this.weeks + 30L * this.months + 365L * this.years + this.days) * 24L + this.hours) * 60L;
                this.years = 0L;
                this.months = 0L;
                this.weeks = 0L;
                this.days = 0L;
                this.hours = 0L;
                break;
            }
            case SECONDS: {
                this.seconds += (((7L * this.weeks + 30L * this.months + 365L * this.years + this.days) * 24L + this.hours) * 60L + this.minutes) * 60L;
                this.years = 0L;
                this.months = 0L;
                this.weeks = 0L;
                this.days = 0L;
                this.hours = 0L;
                this.minutes = 0L;
                break;
            }
            case MILLIS: {
                this.milliSeconds += ((((7L * this.weeks + 30L * this.months + 365L * this.years + this.days) * 24L + this.hours) * 60L + this.minutes) * 60L + this.seconds) * 1000L;
                this.years = 0L;
                this.months = 0L;
                this.weeks = 0L;
                this.days = 0L;
                this.hours = 0L;
                this.minutes = 0L;
                this.seconds = 0L;
                break;
            }
            case MICROS: {
                this.micros += (((((7L * this.weeks + 30L * this.months + 365L * this.years + this.days) * 24L + this.hours) * 60L + this.minutes) * 60L + this.seconds) * 1000L + this.milliSeconds) * 1000L;
                this.years = 0L;
                this.months = 0L;
                this.weeks = 0L;
                this.days = 0L;
                this.hours = 0L;
                this.minutes = 0L;
                this.seconds = 0L;
                this.milliSeconds = 0L;
                break;
            }
            case NANOS: {
                this.nanos += ((((((7L * this.weeks + 30L * this.months + 365L * this.years + this.days) * 24L + this.hours) * 60L + this.minutes) * 60L + this.seconds) * 1000L + this.milliSeconds) * 1000L + this.micros) * 1000L;
                this.years = 0L;
                this.months = 0L;
                this.weeks = 0L;
                this.days = 0L;
                this.hours = 0L;
                this.minutes = 0L;
                this.seconds = 0L;
                this.milliSeconds = 0L;
                this.micros = 0L;
            }
        }
    }

    private ChronoUnit detectSmallestUnit() {
        if ((this.nanos | this.micros | this.milliSeconds | this.seconds | this.minutes | this.hours | this.days | this.weeks | this.months | this.years) == 0L) {
            return ChronoUnit.NANOS;
        }
        return this.nanos != 0L ? ChronoUnit.NANOS : (this.micros != 0L ? ChronoUnit.MICROS : (this.milliSeconds != 0L ? ChronoUnit.MILLIS : (this.seconds != 0L ? ChronoUnit.SECONDS : (this.minutes != 0L ? ChronoUnit.MINUTES : (this.hours != 0L ? ChronoUnit.HOURS : (this.days != 0L ? ChronoUnit.DAYS : (this.weeks != 0L ? ChronoUnit.WEEKS : (this.months != 0L ? ChronoUnit.MONTHS : (this.years != 0L ? ChronoUnit.YEARS : NBootDuration.normalize(ChronoUnit.FOREVER))))))))));
    }

    private ChronoUnit detectLargestUnit() {
        if ((this.nanos | this.micros | this.milliSeconds | this.seconds | this.minutes | this.hours | this.days | this.weeks | this.months | this.years) == 0L) {
            return ChronoUnit.NANOS;
        }
        return this.years != 0L ? ChronoUnit.YEARS : (this.months != 0L ? ChronoUnit.MONTHS : (this.weeks != 0L ? ChronoUnit.WEEKS : (this.days != 0L ? ChronoUnit.DAYS : (this.hours != 0L ? ChronoUnit.HOURS : (this.minutes != 0L ? ChronoUnit.MINUTES : (this.seconds != 0L ? ChronoUnit.SECONDS : (this.milliSeconds != 0L ? ChronoUnit.MILLIS : (this.micros != 0L ? ChronoUnit.MICROS : (this.nanos != 0L ? ChronoUnit.NANOS : NBootDuration.normalize(ChronoUnit.FOREVER))))))))));
    }

    static ChronoUnit normalize(ChronoUnit smallestUnit) {
        switch (smallestUnit) {
            case YEARS: 
            case WEEKS: 
            case DAYS: 
            case HOURS: 
            case MINUTES: 
            case SECONDS: 
            case MILLIS: 
            case MICROS: 
            case NANOS: {
                return smallestUnit;
            }
            case HALF_DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        return ChronoUnit.YEARS;
    }

    public static NBootDuration ofNanos(long durationNanos) {
        long ms = durationNanos / 1000000L;
        int ns = (int)(durationNanos % 1000000L);
        return new NBootDuration(ms, ns);
    }

    public static NBootDuration ofNanos(long durationNanos, ChronoUnit smallestUnit, ChronoUnit largestUnit) {
        long ms = durationNanos / 1000000L;
        int ns = (int)(durationNanos % 1000000L);
        return new NBootDuration(ms, ns, smallestUnit, largestUnit);
    }

    public static NBootDuration ofNanosOnly(long durationNanos) {
        return NBootDuration.ofUnitOnly(durationNanos, ChronoUnit.MILLIS);
    }

    public static NBootDuration ofMillisOnly(long durationMillis) {
        return NBootDuration.ofUnitOnly(durationMillis, ChronoUnit.MILLIS);
    }

    public static NBootDuration ofSecondsOnly(long durationSeconds) {
        return NBootDuration.ofUnitOnly(durationSeconds, ChronoUnit.SECONDS);
    }

    public static NBootDuration ofMinutesOnly(long durationMinutes) {
        return NBootDuration.ofUnitOnly(durationMinutes, ChronoUnit.MINUTES);
    }

    public static NBootDuration ofHoursOnly(long durationHours) {
        return NBootDuration.ofUnitOnly(durationHours, ChronoUnit.HOURS);
    }

    public static NBootDuration ofDaysOnly(long durationDays) {
        return NBootDuration.ofUnitOnly(durationDays, ChronoUnit.DAYS);
    }

    public static NBootDuration ofWeeksOnly(long durationWeeks) {
        return NBootDuration.ofUnitOnly(durationWeeks, ChronoUnit.WEEKS);
    }

    public static NBootDuration ofMonthOnly(long durationMonths) {
        return NBootDuration.ofUnitOnly(durationMonths, ChronoUnit.MONTHS);
    }

    public static NBootDuration ofYearsOnly(long durationYears) {
        return NBootDuration.ofUnitOnly(durationYears, ChronoUnit.YEARS);
    }

    public static NBootDuration ofSeconds(long durationSeconds) {
        return NBootDuration.ofUnit(durationSeconds, ChronoUnit.SECONDS);
    }

    public static NBootDuration ofMinutes(long durationMinutes) {
        return NBootDuration.ofUnit(durationMinutes, ChronoUnit.MINUTES);
    }

    public static NBootDuration ofHours(long durationHours) {
        return NBootDuration.ofUnit(durationHours, ChronoUnit.HOURS);
    }

    public static NBootDuration ofDays(long durationDays) {
        return NBootDuration.ofUnit(durationDays, ChronoUnit.DAYS);
    }

    public static NBootDuration ofWeeks(long durationWeeks) {
        return NBootDuration.ofUnit(durationWeeks, ChronoUnit.WEEKS);
    }

    public static NBootDuration ofMonth(long durationMonths) {
        return NBootDuration.ofUnit(durationMonths, ChronoUnit.MONTHS);
    }

    public static NBootDuration ofYears(long durationYears) {
        return NBootDuration.ofUnit(durationYears, ChronoUnit.YEARS);
    }

    public static NBootDuration ofUnitOnly(long durationInUnit, ChronoUnit unit) {
        long[] values = new long[ChronoUnit.values().length];
        values[unit.ordinal()] = durationInUnit;
        return new NBootDuration(values, null, null);
    }

    public static NBootDuration ofUnit(long durationInUnit, ChronoUnit unit) {
        return NBootDuration.ofUnitOnly(durationInUnit, unit).normalize();
    }

    public static NBootDuration ofMillis(long durationMillis) {
        return new NBootDuration(durationMillis, 0);
    }

    public static NBootDuration ofMillis(long durationMillis, ChronoUnit smallestUnit, ChronoUnit largestUnit) {
        return new NBootDuration(durationMillis, 0, smallestUnit, largestUnit);
    }

    public static NBootDuration ofDuration(Duration duration) {
        return NBootDuration.ofSecondsAndNanos(duration.getSeconds(), duration.getNano());
    }

    public static NBootDuration ofMillisAndNanos(long durationMillis, int nanos) {
        return new NBootDuration(durationMillis, nanos);
    }

    public static NBootDuration of(long[] values, ChronoUnit smallestUnit, ChronoUnit largestUnit) {
        return new NBootDuration(values, smallestUnit, largestUnit);
    }

    public static NBootDuration of(long[] values) {
        return NBootDuration.of(values, null, null);
    }

    public static NBootDuration ofSecondsAndNanos(long durationSeconds, long nanos) {
        long millis = durationSeconds * 1000L + nanos / 1000000L;
        int ns = (int)(nanos % 1000000L);
        return NBootDuration.ofMillisAndNanos(millis, ns);
    }

    public long getNanos() {
        return this.nanos;
    }

    public ChronoUnit firstNonZeroUp(ChronoUnit unit) {
        ChronoUnit[] values = ChronoUnit.values();
        for (int o = unit.ordinal(); o < values.length; ++o) {
            if (this.get(values[o]) == 0L) continue;
            return values[o];
        }
        return null;
    }

    public ChronoUnit firstNonZeroDown(ChronoUnit unit) {
        ChronoUnit[] values = ChronoUnit.values();
        for (int o = unit.ordinal(); o > 0; --o) {
            if (this.get(values[o]) == 0L) continue;
            return values[o];
        }
        return null;
    }

    public boolean isZeroDown(ChronoUnit unit) {
        switch (unit) {
            case YEARS: 
            case CENTURIES: 
            case ERAS: 
            case FOREVER: 
            case MILLENNIA: 
            case DECADES: {
                return (this.years | this.months | this.weeks | this.days | this.hours | this.minutes | this.seconds | this.milliSeconds | this.micros | this.nanos) == 0L;
            }
            case MONTHS: {
                return (this.months | this.weeks | this.days | this.hours | this.minutes | this.seconds | this.milliSeconds | this.micros | this.nanos) == 0L;
            }
            case WEEKS: {
                return (this.weeks | this.days | this.hours | this.minutes | this.seconds | this.milliSeconds | this.micros | this.nanos) == 0L;
            }
            case DAYS: {
                return (this.days | this.hours | this.minutes | this.seconds | this.milliSeconds | this.micros | this.nanos) == 0L;
            }
            case HOURS: {
                return (this.hours | this.minutes | this.seconds | this.milliSeconds | this.micros | this.nanos) == 0L;
            }
            case MINUTES: {
                return (this.minutes | this.seconds | this.milliSeconds | this.micros | this.nanos) == 0L;
            }
            case SECONDS: {
                return (this.seconds | this.milliSeconds | this.micros | this.nanos) == 0L;
            }
            case MILLIS: {
                return (this.milliSeconds | this.micros | this.nanos) == 0L;
            }
            case MICROS: {
                return (this.micros | this.nanos) == 0L;
            }
            case NANOS: {
                return this.nanos == 0L;
            }
        }
        return false;
    }

    public boolean isZeroUp(ChronoUnit unit) {
        switch (unit) {
            case YEARS: 
            case CENTURIES: 
            case ERAS: 
            case FOREVER: 
            case MILLENNIA: 
            case DECADES: {
                return this.years == 0L;
            }
            case MONTHS: {
                return (this.years | this.months) == 0L;
            }
            case WEEKS: {
                return (this.years | this.months | this.weeks) == 0L;
            }
            case DAYS: {
                return (this.years | this.months | this.weeks | this.days) == 0L;
            }
            case HOURS: {
                return (this.years | this.months | this.weeks | this.days | this.hours) == 0L;
            }
            case MINUTES: {
                return (this.years | this.months | this.weeks | this.days | this.hours | this.minutes) == 0L;
            }
            case SECONDS: {
                return (this.years | this.months | this.weeks | this.days | this.hours | this.minutes | this.seconds) == 0L;
            }
            case MILLIS: {
                return (this.years | this.months | this.weeks | this.days | this.hours | this.minutes | this.seconds | this.milliSeconds) == 0L;
            }
            case MICROS: {
                return (this.years | this.months | this.weeks | this.days | this.hours | this.minutes | this.seconds | this.milliSeconds | this.micros) == 0L;
            }
            case NANOS: {
                return (this.years | this.months | this.weeks | this.days | this.hours | this.minutes | this.seconds | this.milliSeconds | this.micros | this.nanos) == 0L;
            }
        }
        return false;
    }

    public long getAs(ChronoUnit unit) {
        switch (unit) {
            case YEARS: {
                return this.getTimeAsYears();
            }
            case MONTHS: {
                return this.getTimeAsMonths();
            }
            case WEEKS: {
                return this.getTimeAsWeeks();
            }
            case DAYS: {
                return this.getTimeAsDays();
            }
            case HOURS: {
                return this.getTimeAsHours();
            }
            case MINUTES: {
                return this.getTimeAsMinutes();
            }
            case SECONDS: {
                return this.getTimeAsSeconds();
            }
            case MILLIS: {
                return this.getTimeAsMillis();
            }
            case MICROS: {
                return this.getTimeAsMicros();
            }
            case NANOS: {
                return this.getTimeAsNanos();
            }
        }
        return 0L;
    }

    public long get(ChronoUnit unit) {
        switch (unit) {
            case YEARS: {
                return this.years;
            }
            case MONTHS: {
                return this.months;
            }
            case WEEKS: {
                return this.weeks;
            }
            case DAYS: {
                return this.days;
            }
            case HOURS: {
                return this.hours;
            }
            case MINUTES: {
                return this.minutes;
            }
            case SECONDS: {
                return this.seconds;
            }
            case MILLIS: {
                return this.milliSeconds;
            }
            case MICROS: {
                return this.micros;
            }
            case NANOS: {
                return this.nanos;
            }
        }
        return 0L;
    }

    public long getMicros() {
        return this.micros;
    }

    public long getMilliSeconds() {
        return this.milliSeconds;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public long getMinutes() {
        return this.minutes;
    }

    public long getHours() {
        return this.hours;
    }

    public long getDays() {
        return this.days;
    }

    public long getYears() {
        return this.years;
    }

    public long getMonths() {
        return this.months;
    }

    public long getWeeks() {
        return this.weeks;
    }

    public ChronoUnit getLargestUnit() {
        return this.largestUnit;
    }

    public ChronoUnit getSmallestUnit() {
        return this.smallestUnit;
    }

    public long getTimeAsYears() {
        return this.timeMillis / 1000L / 3600L / 24L / 365L;
    }

    public long getTimeAsMonths() {
        return this.timeMillis / 1000L / 3600L / 24L / 30L;
    }

    public long getTimeAsWeeks() {
        return this.timeMillis / 1000L / 3600L / 24L / 7L;
    }

    public long getTimeAsDays() {
        return this.timeMillis / 1000L / 3600L / 24L;
    }

    public long getTimeAsHours() {
        return this.timeMillis / 1000L / 3600L;
    }

    public long getTimeAsMinutes() {
        return this.timeMillis / 1000L / 60L;
    }

    public long getTimeAsSeconds() {
        return this.timeMillis / 1000L;
    }

    public double getTimeAsDoubleSeconds() {
        return (double)this.timeMillis / 1000.0 + (double)this.timeNanos / 1.0E9;
    }

    public long getTimeAsMillis() {
        return this.timeMillis;
    }

    public long getTimeAsMicros() {
        return this.timeMillis * 1000L + (long)(this.timeNanos / 1000);
    }

    public long getTimeAsNanos() {
        return this.timeMillis * 1000000L + (long)this.timeNanos;
    }

    public long getTimeMillis() {
        return this.timeMillis;
    }

    public int getTimeNanos() {
        return this.timeNanos;
    }

    public Duration toDuration() {
        return Duration.ofNanos((long)this.timeNanos + 1000000L * this.timeMillis);
    }

    public NBootDuration withSmallestUnit(ChronoUnit smallestUnit) {
        NBootDuration d = new NBootDuration(this.toUnitsArray(), smallestUnit, this.largestUnit);
        if (this.timeMillis != d.timeMillis || this.timeNanos != d.timeNanos) {
            throw new IllegalArgumentException("unexpected");
        }
        return d;
    }

    public NBootDuration withLargestUnit(ChronoUnit largestUnit) {
        NBootDuration d = new NBootDuration(this.toUnitsArray(), this.smallestUnit, largestUnit);
        if (this.timeMillis != d.timeMillis || this.timeNanos != d.timeNanos) {
            throw new IllegalArgumentException("unexpected");
        }
        return d;
    }

    public NBootDuration withUnits(ChronoUnit smallestUnit, ChronoUnit largestUnit) {
        NBootDuration d = new NBootDuration(this.toUnitsArray(), smallestUnit, largestUnit);
        if (this.timeMillis != d.timeMillis || this.timeNanos != d.timeNanos) {
            throw new IllegalArgumentException("unexpected");
        }
        return d;
    }

    private boolean normalizeNegativeUnit(long[] values, ChronoUnit curr, ChronoUnit next, long multiplier) {
        if (values[curr.ordinal()] < 0L) {
            if (values[curr.ordinal()] > 0L) {
                long requiredMicros = -values[next.ordinal()] / multiplier;
                if (requiredMicros * multiplier < -values[next.ordinal()]) {
                    ++requiredMicros;
                }
                if ((requiredMicros = Math.min(requiredMicros, values[next.ordinal()])) > 0L) {
                    int n = curr.ordinal();
                    values[n] = values[n] + requiredMicros * multiplier;
                    int n2 = next.ordinal();
                    values[n2] = values[n2] - requiredMicros;
                }
                return values[curr.ordinal()] < 0L;
            }
            return true;
        }
        return false;
    }

    public NBootDuration neg() {
        long[] a = this.toUnitsArray();
        for (int i = 0; i < a.length; ++i) {
            a[i] = -a[i];
        }
        return NBootDuration.of(a, this.smallestUnit, this.largestUnit);
    }

    public NBootDuration add(NBootDuration other) {
        long[] a = this.toUnitsArray();
        long[] b = other.toUnitsArray();
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            a[n] = a[n] + b[i];
        }
        return NBootDuration.of(a, this.smallestUnit.compareTo(other.getSmallestUnit()) < 0 ? this.smallestUnit : other.smallestUnit, this.largestUnit.compareTo(other.getSmallestUnit()) > 0 ? this.largestUnit : other.smallestUnit);
    }

    public NBootDuration mul(double other) {
        double ms = (double)this.timeMillis * other;
        long msL = (long)((double)this.timeMillis * other);
        long ns = (long)((double)this.timeNanos * other + (ms - (double)msL) * 1000000.0);
        return NBootDuration.ofMillisAndNanos(msL, (int)ns).withUnits(this.smallestUnit, this.largestUnit);
    }

    public NBootDuration mul(long other) {
        long[] a = this.toUnitsArray();
        int i = 0;
        while (i < a.length) {
            int n = i++;
            a[n] = a[n] * other;
        }
        return NBootDuration.of(a, this.smallestUnit, this.largestUnit);
    }

    public NBootDuration subtract(NBootDuration other) {
        long[] a = this.toUnitsArray();
        long[] b = other.toUnitsArray();
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            a[n] = a[n] - b[i];
        }
        return NBootDuration.of(a, this.smallestUnit.compareTo(other.getSmallestUnit()) < 0 ? this.smallestUnit : other.smallestUnit, this.largestUnit.compareTo(other.getSmallestUnit()) > 0 ? this.largestUnit : other.smallestUnit);
    }

    public NBootDuration normalize() {
        long n;
        long[] values = this.toUnitsArray();
        if (!(this.normalizeNegativeUnit(values, ChronoUnit.NANOS, ChronoUnit.MICROS, 1000L) && this.normalizeNegativeUnit(values, ChronoUnit.NANOS, ChronoUnit.MILLIS, 1000000L) && this.normalizeNegativeUnit(values, ChronoUnit.NANOS, ChronoUnit.SECONDS, 1000000000L) && this.normalizeNegativeUnit(values, ChronoUnit.NANOS, ChronoUnit.MINUTES, 60000000000L) && this.normalizeNegativeUnit(values, ChronoUnit.NANOS, ChronoUnit.HOURS, 360000000000L) && this.normalizeNegativeUnit(values, ChronoUnit.NANOS, ChronoUnit.DAYS, 8640000000000L) && this.normalizeNegativeUnit(values, ChronoUnit.NANOS, ChronoUnit.WEEKS, 60480000000000L) && this.normalizeNegativeUnit(values, ChronoUnit.NANOS, ChronoUnit.MONTHS, 259200000000000L) && !this.normalizeNegativeUnit(values, ChronoUnit.NANOS, ChronoUnit.YEARS, 3153600000000000L))) {
            // empty if block
        }
        if (!(this.normalizeNegativeUnit(values, ChronoUnit.MICROS, ChronoUnit.MILLIS, 1000L) && this.normalizeNegativeUnit(values, ChronoUnit.MICROS, ChronoUnit.SECONDS, 1000000L) && this.normalizeNegativeUnit(values, ChronoUnit.MICROS, ChronoUnit.MINUTES, 60000000L) && this.normalizeNegativeUnit(values, ChronoUnit.MICROS, ChronoUnit.HOURS, 360000000L) && this.normalizeNegativeUnit(values, ChronoUnit.MICROS, ChronoUnit.DAYS, 8640000000L) && this.normalizeNegativeUnit(values, ChronoUnit.MICROS, ChronoUnit.WEEKS, 60480000000L) && this.normalizeNegativeUnit(values, ChronoUnit.MICROS, ChronoUnit.MONTHS, 259200000000L) && !this.normalizeNegativeUnit(values, ChronoUnit.MICROS, ChronoUnit.YEARS, 3153600000000L))) {
            // empty if block
        }
        if (!(this.normalizeNegativeUnit(values, ChronoUnit.MILLIS, ChronoUnit.SECONDS, 1000L) && this.normalizeNegativeUnit(values, ChronoUnit.MILLIS, ChronoUnit.MINUTES, 60000L) && this.normalizeNegativeUnit(values, ChronoUnit.MILLIS, ChronoUnit.HOURS, 360000L) && this.normalizeNegativeUnit(values, ChronoUnit.MILLIS, ChronoUnit.DAYS, 8640000L) && this.normalizeNegativeUnit(values, ChronoUnit.MILLIS, ChronoUnit.WEEKS, 60480000L) && this.normalizeNegativeUnit(values, ChronoUnit.MILLIS, ChronoUnit.MONTHS, 259200000L) && !this.normalizeNegativeUnit(values, ChronoUnit.MILLIS, ChronoUnit.YEARS, 3153600000L))) {
            // empty if block
        }
        if (!(this.normalizeNegativeUnit(values, ChronoUnit.SECONDS, ChronoUnit.MINUTES, 60L) && this.normalizeNegativeUnit(values, ChronoUnit.SECONDS, ChronoUnit.HOURS, 360L) && this.normalizeNegativeUnit(values, ChronoUnit.MILLIS, ChronoUnit.DAYS, 8640L) && this.normalizeNegativeUnit(values, ChronoUnit.SECONDS, ChronoUnit.WEEKS, 60480L) && this.normalizeNegativeUnit(values, ChronoUnit.SECONDS, ChronoUnit.MONTHS, 259200L) && !this.normalizeNegativeUnit(values, ChronoUnit.SECONDS, ChronoUnit.YEARS, 3153600L))) {
            // empty if block
        }
        if (!(this.normalizeNegativeUnit(values, ChronoUnit.MINUTES, ChronoUnit.HOURS, 60L) && this.normalizeNegativeUnit(values, ChronoUnit.MINUTES, ChronoUnit.DAYS, 1440L) && this.normalizeNegativeUnit(values, ChronoUnit.MINUTES, ChronoUnit.WEEKS, 10080L) && this.normalizeNegativeUnit(values, ChronoUnit.MINUTES, ChronoUnit.MONTHS, 43200L) && !this.normalizeNegativeUnit(values, ChronoUnit.MINUTES, ChronoUnit.YEARS, 525600L))) {
            // empty if block
        }
        if (!this.normalizeNegativeUnit(values, ChronoUnit.HOURS, ChronoUnit.DAYS, 24L) || !this.normalizeNegativeUnit(values, ChronoUnit.HOURS, ChronoUnit.WEEKS, 168L) || !this.normalizeNegativeUnit(values, ChronoUnit.HOURS, ChronoUnit.MONTHS, 720L) || this.normalizeNegativeUnit(values, ChronoUnit.HOURS, ChronoUnit.YEARS, 8760L)) {
            // empty if block
        }
        if (!this.normalizeNegativeUnit(values, ChronoUnit.DAYS, ChronoUnit.WEEKS, 7L) || !this.normalizeNegativeUnit(values, ChronoUnit.DAYS, ChronoUnit.MONTHS, 30L) || this.normalizeNegativeUnit(values, ChronoUnit.DAYS, ChronoUnit.YEARS, 365L)) {
            // empty if block
        }
        if (values[ChronoUnit.NANOS.ordinal()] < 1000L) {
            long requiredMicros;
            if (values[ChronoUnit.MICROS.ordinal()] > 0L) {
                requiredMicros = -values[ChronoUnit.MICROS.ordinal()] / 1000L;
                if (requiredMicros * 1000L < -values[ChronoUnit.MICROS.ordinal()]) {
                    ++requiredMicros;
                }
                if ((requiredMicros = Math.min(requiredMicros, values[ChronoUnit.MICROS.ordinal()])) > 0L) {
                    int n2 = ChronoUnit.NANOS.ordinal();
                    values[n2] = values[n2] + requiredMicros * 1000L;
                    int n3 = ChronoUnit.NANOS.ordinal();
                    values[n3] = values[n3] - requiredMicros;
                }
            }
            if (values[ChronoUnit.NANOS.ordinal()] < 1000L && values[ChronoUnit.MILLIS.ordinal()] > 0L) {
                requiredMicros = -values[ChronoUnit.MICROS.ordinal()] / 1000L;
                if (requiredMicros * 1000L < -values[ChronoUnit.MICROS.ordinal()]) {
                    ++requiredMicros;
                }
                if ((requiredMicros = Math.min(requiredMicros, values[ChronoUnit.MICROS.ordinal()])) > 0L) {
                    int n4 = ChronoUnit.NANOS.ordinal();
                    values[n4] = values[n4] + requiredMicros * 1000L;
                    int n5 = ChronoUnit.NANOS.ordinal();
                    values[n5] = values[n5] - requiredMicros;
                }
            }
        }
        if (values[ChronoUnit.NANOS.ordinal()] >= 1000L) {
            n = values[ChronoUnit.NANOS.ordinal()];
            values[ChronoUnit.NANOS.ordinal()] = n % 1000L;
            int n6 = ChronoUnit.MICROS.ordinal();
            values[n6] = values[n6] + n / 1000L;
        }
        if (values[ChronoUnit.MICROS.ordinal()] >= 1000L) {
            n = values[ChronoUnit.MICROS.ordinal()];
            values[ChronoUnit.MICROS.ordinal()] = n % 1000L;
            int n7 = ChronoUnit.MILLIS.ordinal();
            values[n7] = values[n7] + n / 1000L;
        }
        if (values[ChronoUnit.SECONDS.ordinal()] >= 60L) {
            n = values[ChronoUnit.SECONDS.ordinal()];
            values[ChronoUnit.SECONDS.ordinal()] = n % 60L;
            int n8 = ChronoUnit.MINUTES.ordinal();
            values[n8] = values[n8] + n / 60L;
        }
        if (values[ChronoUnit.MINUTES.ordinal()] >= 60L) {
            n = values[ChronoUnit.MINUTES.ordinal()];
            values[ChronoUnit.MINUTES.ordinal()] = n % 60L;
            int n9 = ChronoUnit.HOURS.ordinal();
            values[n9] = values[n9] + n / 60L;
        }
        if (values[ChronoUnit.MONTHS.ordinal()] >= 12L || values[ChronoUnit.WEEKS.ordinal()] >= 4L || values[ChronoUnit.DAYS.ordinal()] >= 30L) {
            long dd = values[ChronoUnit.YEARS.ordinal()] * 365L + values[ChronoUnit.MONTHS.ordinal()] * 30L + values[ChronoUnit.MONTHS.ordinal()] * 30L;
            values[ChronoUnit.YEARS.ordinal()] = dd / 365L;
            values[ChronoUnit.MONTHS.ordinal()] = (dd %= 365L) / 30L;
            values[ChronoUnit.WEEKS.ordinal()] = (dd %= 30L) / 7L;
            values[ChronoUnit.DAYS.ordinal()] = dd %= 7L;
        }
        NBootDuration d = new NBootDuration(values, this.smallestUnit, this.largestUnit);
        if (this.timeMillis != d.timeMillis || this.timeNanos != d.timeNanos) {
            throw new IllegalArgumentException("unexpected");
        }
        return d;
    }

    public boolean isZero() {
        return (this.timeMillis | (long)this.timeNanos) == 0L;
    }

    public long[] toUnitsArray() {
        long[] arr = new long[ChronoUnit.values().length];
        arr[ChronoUnit.NANOS.ordinal()] = this.nanos;
        arr[ChronoUnit.MICROS.ordinal()] = this.micros;
        arr[ChronoUnit.MILLIS.ordinal()] = this.milliSeconds;
        arr[ChronoUnit.SECONDS.ordinal()] = this.seconds;
        arr[ChronoUnit.MINUTES.ordinal()] = this.minutes;
        arr[ChronoUnit.HOURS.ordinal()] = this.hours;
        arr[ChronoUnit.DAYS.ordinal()] = this.days;
        arr[ChronoUnit.WEEKS.ordinal()] = this.weeks;
        arr[ChronoUnit.MONTHS.ordinal()] = this.months;
        arr[ChronoUnit.YEARS.ordinal()] = this.years;
        return arr;
    }
}

