/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot.internal.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.thevpc.nuts.boot.NBootAddRepositoryOptions;
import net.thevpc.nuts.boot.NBootRepositoryConfig;
import net.thevpc.nuts.boot.NBootRepositoryLocation;
import net.thevpc.nuts.boot.internal.util.NBootPlatformHome;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public class NBootRepositoryDB {
    private final Map<String, NBootAddRepositoryOptions> defaultRepositoriesByName = new LinkedHashMap<String, NBootAddRepositoryOptions>();
    private final Map<String, NBootAddRepositoryOptions> defaultRepositoriesByLocation = new LinkedHashMap<String, NBootAddRepositoryOptions>();
    private final Map<String, String> aliasToBase = new LinkedHashMap<String, String>();
    private final Map<String, Set<String>> baseToAliases = new LinkedHashMap<String, Set<String>>();
    private static final NBootRepositoryDB instance = new NBootRepositoryDB();

    public static NBootRepositoryDB of() {
        return instance;
    }

    public NBootRepositoryDB() {
        this.reg(new String[]{"local"}, "system", 2000, "nuts@" + NBootUtils.getNativePath(NBootPlatformHome.SYSTEM.getWorkspaceStore("LIB", "default-workspace") + "/" + "id"), new String[0]);
        this.reg(new String[]{"main"}, "maven", 1000, "maven@", new String[0]);
        this.reg(new String[]{"main"}, "maven-central", 10000, "maven@https://repo.maven.apache.org/maven2", new String[0]);
        this.reg(new String[0], "jcenter", 10000, "maven@https://jcenter.bintray.com", new String[0]);
        this.reg(new String[0], "jboss", 10000, "maven@https://repository.jboss.org/nexus/content/repositories/releases", new String[0]);
        this.reg(new String[0], "clojars", 10000, "maven@https://repo.clojars.org", new String[0]);
        this.reg(new String[0], "atlassian", 10000, "maven@https://packages.atlassian.com/maven/public", new String[0]);
        this.reg(new String[0], "atlassian-snapshot", 10000, "maven@https://packages.atlassian.com/maven/public-snapshot", new String[0]);
        this.reg(new String[0], "oracle", 10000, "maven@https://maven.oracle.com", new String[0]);
        this.reg(new String[0], "google", 10000, "maven@https://maven.google.com", new String[0]);
        this.reg(new String[0], "spring", 10000, "maven@https://repo.spring.io/release", "spring-framework");
        this.reg(new String[0], "maven-thevpc-git", 10000, "maven@https://raw.githubusercontent.com/thevpc/vpc-public-maven/master", "vpc-public-maven");
        this.reg(new String[0], "nuts-public", 10000, "maven@dotfilefs:https://raw.githubusercontent.com/thevpc/nuts-public/master", "vpc-public-nuts", "nuts-thevpc-git");
        this.reg(new String[]{"preview"}, "thevpc", 10000, "maven@htmlfs:https://maven.thevpc.net", "dev");
        this.reg(new String[]{"preview"}, "nuts-preview", 10000, "maven@dotfilefs:https://raw.githubusercontent.com/thevpc/nuts-preview/master", "preview");
        this.reg(new String[]{"preview"}, "thevpc-goodies", 10000, "nuts@htmlfs:https://maven-goodies.thevpc.net", "goodies");
    }

    public Set<String> findByAnyTag(String ... tags) {
        LinkedHashSet<String> ok = new LinkedHashSet<String>();
        for (Map.Entry<String, NBootAddRepositoryOptions> e : this.defaultRepositoriesByName.entrySet()) {
            boolean found;
            String[] u = e.getValue().getConfig().getTags();
            boolean bl = found = tags.length == 0;
            if (!found && u != null) {
                for (String u0 : u) {
                    for (String t : tags) {
                        if (t.equals(u0)) {
                            found = true;
                        }
                        if (found) break;
                    }
                    if (found) break;
                }
            }
            if (!found) continue;
            ok.add(e.getKey());
        }
        return ok;
    }

    public Set<String> findAllNamesByName(String name) {
        if (name == null || name.isEmpty()) {
            return Collections.emptySet();
        }
        Set<String> a = this.baseToAliases.get(name);
        if (a != null) {
            return Collections.unmodifiableSet(a);
        }
        String base = this.aliasToBase.get(name);
        if (base != null && (a = this.baseToAliases.get(base)) != null) {
            return Collections.unmodifiableSet(a);
        }
        return Collections.singleton(name);
    }

    public NBootAddRepositoryOptions getRepositoryOptionsByName(String name) {
        NBootAddRepositoryOptions o = this.defaultRepositoriesByName.get(name);
        if (o == null) {
            String base = this.aliasToBase.get(name);
            o = this.defaultRepositoriesByName.get(base);
        }
        if (o != null) {
            return o.copy();
        }
        return null;
    }

    public NBootAddRepositoryOptions getRepositoryOptionsByLocation(String location) {
        NBootAddRepositoryOptions o = this.defaultRepositoriesByLocation.get(location);
        if (o != null) {
            return o.copy();
        }
        return null;
    }

    private void reg(String[] tags, String name, int order, String url, String ... names) {
        NBootRepositoryLocation location = NBootRepositoryLocation.of(url);
        NBootUtils.requireNonBlank(location.getLocationType(), "locationType");
        NBootAddRepositoryOptions options = new NBootAddRepositoryOptions().setName(name).setEnabled(true).setCreate(true).setFailSafe(false).setOrder(order).setConfig(new NBootRepositoryConfig().setLocation(location).setTags(tags == null ? new String[]{} : tags));
        this.defaultRepositoriesByName.put(name, options);
        this.defaultRepositoriesByLocation.put(url, options);
        LinkedHashSet<String> all = new LinkedHashSet<String>();
        all.add(name);
        for (String other : names) {
            this.aliasToBase.put(other, name);
            all.add(other);
        }
        this.baseToAliases.put(name, all);
    }
}

