/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot.internal.util;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import net.thevpc.nuts.boot.NBootException;
import net.thevpc.nuts.boot.internal.util.NBootMsg;
import net.thevpc.nuts.boot.internal.util.NBootQuoteTypeBoot;
import net.thevpc.nuts.boot.internal.util.NBootSupportMode;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public class NBootStringMapFormat {
    public static NBootStringMapFormat URL_FORMAT = NBootStringMapFormat.of("=", "&", "\\", true);
    public static NBootStringMapFormat COMMA_FORMAT = NBootStringMapFormat.of("=", ",", "\\", true);
    public static NBootStringMapFormat DEFAULT = URL_FORMAT;
    private final String equalsChars;
    private final String separatorChars;
    private String escapeChars;
    private final boolean sort;

    public static NBootStringMapFormat of(String equalsChars, String separatorChars, String escapeChars, boolean sort) {
        return new NBootStringMapFormat(equalsChars, separatorChars, escapeChars, sort);
    }

    public NBootStringMapFormat copy(String equalsChars, String separatorChars, String escapeChars, Boolean sort) {
        return new NBootStringMapFormat(equalsChars == null ? this.equalsChars : equalsChars, separatorChars == null ? this.separatorChars : separatorChars, escapeChars == null ? this.escapeChars : escapeChars, sort == null ? this.sort : sort);
    }

    public NBootStringMapFormat(String equalsChars, String separatorChars, String escapeChars, boolean sort) {
        this.sort = sort;
        if (equalsChars != null) {
            for (char c : equalsChars.toCharArray()) {
                if (!NBootStringMapFormat.isWhitespace(c)) continue;
                throw new IllegalArgumentException("eq chars could not include whitespaces");
            }
        }
        if (escapeChars != null) {
            for (char c : escapeChars.toCharArray()) {
                if (!NBootStringMapFormat.isWhitespace(c)) continue;
                throw new IllegalArgumentException("eq chars could not include whitespaces");
            }
        }
        if (separatorChars != null) {
            for (char c : separatorChars.toCharArray()) {
                if (!NBootStringMapFormat.isWhitespace(c)) continue;
                throw new IllegalArgumentException("eq chars could not include whitespaces");
            }
        }
        this.equalsChars = equalsChars == null ? "" : equalsChars;
        this.separatorChars = separatorChars == null ? "" : separatorChars;
        this.escapeChars = escapeChars == null ? "" : escapeChars;
    }

    private static Token readToken(PushbackReader reader, TokenConfig conf) throws IOException {
        String escapedTokens = conf.getEscapeChars();
        String eqChars = conf.getEqChars();
        String sepChars = conf.getSepChars();
        StringBuilder value = new StringBuilder();
        StringBuilder image = new StringBuilder();
        int r = reader.read();
        if (r == -1) {
            return null;
        }
        char r1 = (char)r;
        if (NBootStringMapFormat.isWhitespace(r1)) {
            do {
                if ((r = reader.read()) != -1) continue;
                return null;
            } while (NBootStringMapFormat.isWhitespace((char)r));
            r1 = (char)r;
        } else {
            if (eqChars.indexOf(r1) >= 0) {
                return new Token(TokenType.EQ, String.valueOf(r1));
            }
            if (sepChars.indexOf(r1) >= 0) {
                return new Token(TokenType.SEP, String.valueOf(r1));
            }
        }
        if (r == 34 || r == 39) {
            char cr = (char)r;
            image.append(cr);
            block14: while (true) {
                if ((r = reader.read()) == -1) {
                    throw new RuntimeException("Expected " + cr);
                }
                image.append(cr);
                if (r == cr) {
                    return new Token(cr == '\"' ? TokenType.SIMPLE_QUOTED : TokenType.DOUBLE_QUOTED, value.toString());
                }
                if (r == 92) {
                    r = reader.read();
                    if (r == -1) {
                        throw new RuntimeException("Expected " + cr);
                    }
                    image.append((char)r);
                    switch ((char)r) {
                        case 'n': {
                            value.append('\n');
                            continue block14;
                        }
                        case 'r': {
                            value.append('\r');
                            continue block14;
                        }
                        case 'f': {
                            value.append('\f');
                            continue block14;
                        }
                        case 't': {
                            value.append('\t');
                            continue block14;
                        }
                    }
                    value.append('\\');
                    value.append((char)r);
                    continue;
                }
                value.append((char)r);
            }
        }
        reader.unread(r);
        block15: while ((r = reader.read()) >= 0) {
            char cr = (char)r;
            if (escapedTokens.indexOf(cr) >= 0) {
                image.append(cr);
                r = reader.read();
                if (r == -1) {
                    value.append(cr);
                    return new Token(TokenType.WORD, value.toString(), image.toString());
                }
                cr = (char)r;
                image.append(cr);
                if (escapedTokens.indexOf(cr) >= 0 || NBootStringMapFormat.isWhitespace(cr) || eqChars.indexOf(cr) >= 0 || sepChars.indexOf(cr) >= 0) {
                    value.append(cr);
                    continue;
                }
                switch ((char)r) {
                    case ' ': {
                        value.append(' ');
                        continue block15;
                    }
                    case 'n': {
                        value.append('\n');
                        continue block15;
                    }
                    case 'r': {
                        value.append('\r');
                        continue block15;
                    }
                    case 'f': {
                        value.append('\f');
                        continue block15;
                    }
                    case 't': {
                        value.append('\t');
                        continue block15;
                    }
                }
                value.append(cr);
                value.append((char)r);
                continue;
            }
            if (NBootStringMapFormat.isWhitespace(cr) || eqChars.indexOf(cr) >= 0 || sepChars.indexOf(cr) >= 0) {
                reader.unread(cr);
                return new Token(TokenType.WORD, value.toString(), image.toString());
            }
            value.append(cr);
            image.append(cr);
        }
        return new Token(TokenType.WORD, value.toString(), image.toString());
    }

    public Map<String, String> parse(String text) {
        Map<String, List<String>> d = this.parseDuplicates(text);
        HashMap<String, String> r = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> e : d.entrySet()) {
            r.put(e.getKey(), e.getValue().get(e.getValue().size() - 1));
        }
        return r;
    }

    public Map<String, List<String>> parseDuplicates(String text) {
        LinkedHashMap<String, List<String>> m = new LinkedHashMap<String, List<String>>();
        if (NBootUtils.isBlank(text)) {
            return m;
        }
        PushbackReader reader = new PushbackReader(new StringReader(text));
        TokenConfig conf = new TokenConfig().setSepChars(this.separatorChars).setEqChars(this.equalsChars).setEscapeChars(this.escapeChars);
        ArrayList<Token> tokens = new ArrayList<Token>();
        while (true) {
            Token r = null;
            try {
                r = NBootStringMapFormat.readToken(reader, conf);
            }
            catch (IOException e) {
                throw new NBootException(NBootMsg.ofPlain("failed to read token"));
            }
            if (r == null) break;
            tokens.add(r);
        }
        if (NBootStringMapFormat.skipSeparator(tokens, conf)) {
            m.computeIfAbsent(null, v -> new ArrayList()).add(null);
        }
        while (true) {
            NBootStringMapFormat.skipSeparator(tokens, conf);
            Map.Entry<String, String> u = NBootStringMapFormat.readEntry(tokens, conf);
            if (u == null) break;
            m.computeIfAbsent(u.getKey(), v -> new ArrayList()).add(u.getValue());
        }
        return m;
    }

    private static boolean skipSeparator(List<Token> tokens, TokenConfig conf) {
        if (!tokens.isEmpty() && tokens.get((int)0).type == TokenType.SEP) {
            tokens.remove(0);
            return true;
        }
        return false;
    }

    private static Map.Entry<String, String> readEntry(List<Token> tokens, TokenConfig conf) {
        if (!tokens.isEmpty()) {
            if (tokens.get((int)0).type.isAnyWord()) {
                String k = tokens.remove((int)0).value;
                if (!tokens.isEmpty()) {
                    if (tokens.get((int)0).type == TokenType.EQ) {
                        tokens.remove(0);
                        if (!tokens.isEmpty()) {
                            if (tokens.get((int)0).type.isAnyWord()) {
                                Token v = tokens.remove(0);
                                return new AbstractMap.SimpleEntry<String, String>(k, v.value);
                            }
                            return new AbstractMap.SimpleEntry<String, Object>(k, null);
                        }
                        return new AbstractMap.SimpleEntry<String, Object>(k, null);
                    }
                    if (tokens.get((int)0).type == TokenType.SEP) {
                        tokens.remove(0);
                        return new AbstractMap.SimpleEntry<String, Object>(k, null);
                    }
                    if (conf.getEqChars().isEmpty() && tokens.get((int)0).type.isAnyWord()) {
                        String v = tokens.remove((int)0).value;
                        return new AbstractMap.SimpleEntry<String, String>(k, v);
                    }
                    return new AbstractMap.SimpleEntry<String, Object>(k, null);
                }
                return new AbstractMap.SimpleEntry<String, Object>(k, null);
            }
            if (tokens.get((int)0).type == TokenType.SEP) {
                tokens.remove(0);
                return new AbstractMap.SimpleEntry<Object, Object>(null, null);
            }
            if (tokens.get((int)0).type == TokenType.EQ) {
                tokens.remove(0);
                if (!tokens.isEmpty()) {
                    if (tokens.get((int)0).type.isAnyWord()) {
                        Token v = tokens.remove(0);
                        return new AbstractMap.SimpleEntry<Object, String>(null, v.value);
                    }
                    return new AbstractMap.SimpleEntry<Object, Object>(null, null);
                }
                return new AbstractMap.SimpleEntry<Object, Object>(null, null);
            }
            return new AbstractMap.SimpleEntry<Object, Object>(null, null);
        }
        return null;
    }

    private static boolean isWhitespace(char c) {
        if (c <= ' ') {
            return true;
        }
        return Character.isWhitespace(c);
    }

    public String format(Map<String, String> map) {
        if (map != null) {
            HashMap<String, List<String>> map2 = new HashMap<String, List<String>>();
            for (Map.Entry<String, String> e : map.entrySet()) {
                map2.put(e.getKey(), Arrays.asList(e.getValue()));
            }
            return this.formatDuplicates(map2);
        }
        return "";
    }

    public String formatDuplicates(Map<String, List<String>> map) {
        StringBuilder sb = new StringBuilder();
        if (map != null) {
            if (this.sort) {
                map = new TreeMap<String, List<String>>(map);
            }
            String escapedChars = this.separatorChars + this.equalsChars + this.escapeChars;
            Set<String> sortedKeys = map.keySet();
            for (String k : sortedKeys) {
                List<String> strings = map.get(k);
                for (String v : strings) {
                    if (v != null) {
                        if (sb.length() > 0) {
                            sb.append(this.separatorChars);
                        }
                        if (v.isEmpty()) {
                            sb.append(NBootUtils.formatStringLiteral(k, NBootQuoteTypeBoot.SIMPLE, NBootSupportMode.PREFERRED, escapedChars));
                            continue;
                        }
                        sb.append(NBootUtils.formatStringLiteral(k, NBootQuoteTypeBoot.SIMPLE, NBootSupportMode.PREFERRED, escapedChars)).append(this.equalsChars).append(NBootUtils.formatStringLiteral(v, NBootQuoteTypeBoot.SIMPLE, NBootSupportMode.PREFERRED, escapedChars));
                        continue;
                    }
                    if (sb.length() > 0) {
                        sb.append(this.separatorChars);
                    }
                    sb.append(NBootUtils.formatStringLiteral(k, NBootQuoteTypeBoot.SIMPLE, NBootSupportMode.PREFERRED, escapedChars));
                }
            }
        }
        return NBootUtils.trimToNull(sb.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NBootStringMapFormat that = (NBootStringMapFormat)o;
        return this.sort == that.sort && Objects.equals(this.equalsChars, that.equalsChars) && Objects.equals(this.separatorChars, that.separatorChars) && Objects.equals(this.escapeChars, that.escapeChars);
    }

    public int hashCode() {
        return Objects.hash(this.equalsChars, this.separatorChars, this.escapeChars, this.sort);
    }

    public String getEqualsChars() {
        return this.equalsChars;
    }

    public String getSeparatorChars() {
        return this.separatorChars;
    }

    public String getEscapeChars() {
        return this.escapeChars;
    }

    public boolean isSort() {
        return this.sort;
    }

    private static class TokenConfig {
        String eqChars;
        String sepChars;
        String escapeChars;

        private TokenConfig() {
        }

        public String getEqChars() {
            return this.eqChars;
        }

        public TokenConfig setEqChars(String eqChars) {
            this.eqChars = eqChars;
            return this;
        }

        public String getSepChars() {
            return this.sepChars;
        }

        public TokenConfig setSepChars(String sepChars) {
            this.sepChars = sepChars;
            return this;
        }

        public String getEscapeChars() {
            return this.escapeChars;
        }

        public TokenConfig setEscapeChars(String escapeChars) {
            this.escapeChars = escapeChars;
            return this;
        }
    }

    private static class Token {
        TokenType type;
        String value;
        String image;

        public Token(TokenType type, String value) {
            this(type, value, value);
        }

        public Token(TokenType type, String value, String image) {
            this.type = type;
            this.value = value;
            this.image = image;
        }
    }

    private static enum TokenType {
        DOUBLE_QUOTED,
        SIMPLE_QUOTED,
        WORD,
        EQ,
        SEP;


        boolean isAnyWord() {
            return this == DOUBLE_QUOTED || this == SIMPLE_QUOTED || this == WORD;
        }
    }
}

