/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot.internal.util;

import net.thevpc.nuts.boot.internal.util.NBootQuoteTypeBoot;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public class NBootToken {
    public static final int TT_EOF = -1;
    public static final int TT_EOL = 10;
    public static final int TT_INT = -4;
    public static final int TT_LONG = -5;
    public static final int TT_BIG_INT = -6;
    public static final int TT_FLOAT = -7;
    public static final int TT_DOUBLE = -8;
    public static final int TT_BIG_DECIMAL = -9;
    public static final int TT_WORD = -3;
    public static final int TT_NOTHING = -30;
    public static final int TT_STRING_LITERAL = -10;
    public static final int TT_SPACE = -11;
    public static final int TT_DOLLAR = -64;
    public static final int TT_DOLLAR_BRACE = -65;
    public static final int TT_VAR = -66;
    public static final int TT_DEFAULT = Integer.MIN_VALUE;
    public int ttype;
    public int lineno;
    public String sval;
    public String image;
    public String ttypeString;
    public Number nval;

    public static NBootToken of(int ttype, String sval, Number nval, int lineno, String image, String ttypeString) {
        return new NBootToken(ttype, sval, nval, lineno, image, ttypeString);
    }

    public NBootToken(int ttype, String sval, Number nval, int lineno, String image, String ttypeString) {
        this.ttype = ttype;
        this.sval = sval;
        this.nval = nval;
        this.lineno = lineno;
        this.image = image;
        this.ttypeString = ttypeString;
    }

    public static String typeString(int ttype) {
        switch (ttype) {
            case -1: {
                return "EOF";
            }
            case 10: {
                return "EOL";
            }
            case -4: {
                return "INT";
            }
            case -5: {
                return "LONG";
            }
            case -6: {
                return "BIG_INT";
            }
            case -7: {
                return "FLOAT";
            }
            case -8: {
                return "DOUBLE";
            }
            case -9: {
                return "BIG_DECIMAL";
            }
            case -3: {
                return "WORD";
            }
            case -30: {
                return "NOTHING";
            }
            case -10: {
                return "STRING_LITERAL";
            }
            case -11: {
                return "SPACE";
            }
            case -64: {
                return "TT_DOLLAR";
            }
            case -65: {
                return "TT_DOLLAR_BRACE";
            }
            case -66: {
                return "TT_VAR";
            }
            case 9: {
                return "'\\t'";
            }
            case 12: {
                return "'\\f'";
            }
        }
        if (ttype >= 32) {
            return "'" + (char)ttype + "'";
        }
        return String.valueOf(ttype);
    }

    public String toString() {
        return "NBootToken{ttype=" + NBootToken.typeString(this.ttype) + ", lineno=" + this.lineno + ", sval=" + (this.sval == null ? "null" : NBootUtils.formatStringLiteral(this.sval, NBootQuoteTypeBoot.SIMPLE)) + ", nval=" + this.nval + '}';
    }
}

