/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.boot.NBootClassLoaderNode;

public class NBootClassLoaderNodeBuilder {
    private String id;
    private URL url;
    private boolean enabled;
    private boolean includedInClasspath;
    private List<NBootClassLoaderNode> dependencies = new ArrayList<NBootClassLoaderNode>();

    public NBootClassLoaderNodeBuilder copyFrom(NBootClassLoaderNode o) {
        if (o != null) {
            this.id = o.getId();
            this.enabled = o.isEnabled();
            this.includedInClasspath = o.isIncludedInClasspath();
            this.url = o.getURL();
            this.dependencies.clear();
            if (o.getDependencies() != null) {
                for (NBootClassLoaderNode dependency : o.getDependencies()) {
                    this.addDependency(dependency);
                }
            }
        }
        return this;
    }

    public NBootClassLoaderNodeBuilder copyFrom(NBootClassLoaderNodeBuilder o) {
        if (o != null) {
            this.id = o.getId();
            this.enabled = o.isEnabled();
            this.includedInClasspath = o.isIncludedInClasspath();
            this.url = o.getURL();
            this.dependencies.clear();
            if (o.getDependencies() != null) {
                for (NBootClassLoaderNode dependency : o.getDependencies()) {
                    this.addDependency(dependency);
                }
            }
        }
        return this;
    }

    public boolean isIncludedInClasspath() {
        return this.includedInClasspath;
    }

    public NBootClassLoaderNodeBuilder setIncludedInClasspath(boolean includedInClasspath) {
        this.includedInClasspath = includedInClasspath;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public NBootClassLoaderNodeBuilder setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public NBootClassLoaderNodeBuilder setId(String id) {
        this.id = id;
        return this;
    }

    public URL getURL() {
        return this.url;
    }

    public NBootClassLoaderNodeBuilder setUrl(URL url) {
        this.url = url;
        return this;
    }

    public List<NBootClassLoaderNode> getDependencies() {
        return this.dependencies;
    }

    public NBootClassLoaderNodeBuilder setDependencies(List<NBootClassLoaderNode> dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public NBootClassLoaderNodeBuilder addDependency(NBootClassLoaderNode other) {
        this.dependencies.add(other);
        return this;
    }

    public NBootClassLoaderNode build() {
        return new NBootClassLoaderNode(this.id, this.url, this.enabled, this.includedInClasspath, this.dependencies.toArray(new NBootClassLoaderNode[0]));
    }
}

