/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.thevpc.nuts.boot.NBootDependency;
import net.thevpc.nuts.boot.NBootDescriptorProperty;
import net.thevpc.nuts.boot.NBootEnvCondition;
import net.thevpc.nuts.boot.NBootId;
import net.thevpc.nuts.boot.NBootProperties;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public class NBootDescriptor {
    private static final long serialVersionUID = 1L;
    private NBootId id;
    private List<NBootId> parents = new ArrayList<NBootId>();
    private String packaging;
    private String name;
    private String description;
    private NBootEnvCondition condition;
    private List<NBootDependency> dependencies = new ArrayList<NBootDependency>();
    private List<NBootDependency> standardDependencies = new ArrayList<NBootDependency>();
    private List<NBootDescriptorProperty> properties = new ArrayList<NBootDescriptorProperty>();
    private transient NBootProperties _propertiesBuilder = new NBootProperties();

    public NBootDescriptor() {
        this.condition = new NBootEnvCondition();
    }

    public NBootDescriptor(NBootDescriptor other) {
        this.condition = new NBootEnvCondition();
        this.copyFrom(other);
    }

    public NBootId getId() {
        return this.id;
    }

    public NBootDescriptor setId(NBootId id) {
        this.id = id;
        return this;
    }

    public NBootDescriptor setId(String id) {
        this.id = NBootId.of(id);
        return this;
    }

    public List<NBootId> getParents() {
        return this.parents;
    }

    public NBootDescriptor setParents(List<NBootId> parents) {
        this.parents = NBootUtils.uniqueNonBlankList(parents, x -> x.isBlank());
        return this;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public NBootDescriptor setPackaging(String packaging) {
        this.packaging = NBootUtils.trim(packaging);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public NBootDescriptor setName(String name) {
        this.name = NBootUtils.trim(name);
        return this;
    }

    public NBootEnvCondition getCondition() {
        return this.condition;
    }

    public NBootDescriptor setCondition(NBootEnvCondition condition) {
        this.condition.clear().copyFrom(condition);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public NBootDescriptor setDescription(String description) {
        this.description = NBootUtils.trim(description);
        return this;
    }

    public List<NBootDependency> getStandardDependencies() {
        return this.standardDependencies;
    }

    public NBootDescriptor setStandardDependencies(List<NBootDependency> dependencies) {
        this.standardDependencies = NBootUtils.uniqueNonBlankList(dependencies, x -> x.isBlank());
        return this;
    }

    public List<NBootDependency> getDependencies() {
        return this.dependencies;
    }

    public NBootDescriptor setDependencies(List<NBootDependency> dependencies) {
        this.dependencies = NBootUtils.uniqueNonBlankList(dependencies, x -> x.isBlank());
        return this;
    }

    public List<NBootDescriptorProperty> getProperties() {
        return this.properties;
    }

    public NBootDescriptor setProperties(List<NBootDescriptorProperty> properties) {
        this._rebuildPropertiesBuilder();
        this._propertiesBuilder.clear();
        if (properties != null && properties.size() != 0) {
            this._propertiesBuilder.addAll(properties);
        }
        this._updateProperties();
        return this;
    }

    public NBootDescriptor setProperty(String name, String value) {
        NBootDescriptorProperty pp = new NBootDescriptorProperty().setName(name).setValue(value);
        this._rebuildPropertiesBuilder();
        if (value == null) {
            this._propertiesBuilder.remove(pp);
        } else {
            this.properties.add(pp);
        }
        this._updateProperties();
        return this;
    }

    public NBootDescriptor copyFrom(NBootDescriptor other) {
        if (other != null) {
            this.setId(other.getId());
            this.setPackaging(other.getPackaging());
            this.setParents(other.getParents());
            this.setDescription(other.getDescription());
            this.setName(other.getName());
            this.setCondition(other.getCondition());
            this.setDependencies(other.getDependencies());
            this.setStandardDependencies(other.getStandardDependencies());
            this.setProperties(other.getProperties());
        } else {
            this.clear();
        }
        return this;
    }

    public NBootDescriptor clear() {
        this.setId((NBootId)null);
        this.setPackaging(null);
        this.setParents(null);
        this.setDescription(null);
        this.setName(null);
        this.setCondition(null);
        this.setDependencies(null);
        this.setStandardDependencies(null);
        this.setProperties(null);
        return this;
    }

    public NBootDescriptor removeDependency(NBootDependency dependency) {
        if (this.dependencies != null) {
            this.dependencies.remove(dependency);
        }
        return this;
    }

    public NBootDescriptor addDependency(NBootDependency dependency) {
        if (dependency == null) {
            throw new NullPointerException();
        }
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<NBootDependency>();
        }
        this.dependencies.add(dependency);
        return this;
    }

    public NBootDescriptor addDependencies(List<NBootDependency> dependencies) {
        NBootUtils.addUniqueNonBlankList(this.dependencies, dependencies, x -> x.isBlank());
        return this;
    }

    public NBootDescriptor removeStandardDependency(NBootDependency dependency) {
        if (this.standardDependencies != null) {
            this.standardDependencies.remove(dependency);
        }
        return this;
    }

    public NBootDescriptor addStandardDependency(NBootDependency dependency) {
        this.standardDependencies.add(dependency);
        return this;
    }

    public NBootDescriptor addStandardDependencies(List<NBootDependency> dependencies) {
        NBootUtils.addUniqueNonBlankList(this.standardDependencies, dependencies, x -> x.isBlank());
        return this;
    }

    public NBootDescriptor addProperty(NBootDescriptorProperty property) {
        this._rebuildPropertiesBuilder();
        this._propertiesBuilder.add(property);
        this._updateProperties();
        return this;
    }

    public NBootDescriptor removeProperties(NBootDescriptorProperty property) {
        this._rebuildPropertiesBuilder();
        this._propertiesBuilder.remove(property);
        this._updateProperties();
        return this;
    }

    public NBootDescriptor addProperties(List<NBootDescriptorProperty> properties) {
        if (properties != null && properties.size() != 0) {
            this._rebuildPropertiesBuilder();
            this._propertiesBuilder.addAll(properties);
            this._updateProperties();
        }
        return this;
    }

    public NBootDescriptor replaceProperty(Predicate<NBootDescriptorProperty> filter, Function<NBootDescriptorProperty, NBootDescriptorProperty> converter) {
        if (converter == null) {
            return this;
        }
        NBootProperties p = new NBootProperties();
        boolean someUpdate = false;
        for (NBootDescriptorProperty entry : this.getProperties()) {
            if (filter != null && !filter.test(entry)) continue;
            NBootDescriptorProperty v = converter.apply(entry);
            if (v != null) {
                if (!Objects.equals(v, entry)) {
                    someUpdate = true;
                }
                p.add(v);
                continue;
            }
            someUpdate = true;
        }
        if (someUpdate) {
            this.setProperties(p.toList());
        }
        return this;
    }

    public NBootDescriptor replaceDependency(Predicate<NBootDependency> filter, UnaryOperator<NBootDependency> converter) {
        if (converter == null) {
            return this;
        }
        ArrayList<NBootDependency> dependenciesList = new ArrayList<NBootDependency>();
        for (NBootDependency d : this.getDependencies()) {
            if (filter == null || filter.test(d)) {
                if ((d = (NBootDependency)converter.apply(d)) == null) continue;
                dependenciesList.add(d);
                continue;
            }
            dependenciesList.add(d);
        }
        this.dependencies = dependenciesList;
        return this;
    }

    public NBootDescriptor removeDependency(Predicate<NBootDependency> dependency) {
        if (dependency == null) {
            return this;
        }
        Iterator<NBootDependency> it = this.dependencies.iterator();
        while (it.hasNext()) {
            NBootDependency d = it.next();
            if (!dependency.test(d)) continue;
            it.remove();
        }
        return this;
    }

    public NBootDescriptorProperty getProperty(String name) {
        return Arrays.stream(this._propertiesBuilder.toArray()).filter(x -> x.getName().equals(name)).findFirst().orElse(null);
    }

    private void _rebuildPropertiesBuilder() {
        if (this._propertiesBuilder == null) {
            this._propertiesBuilder = new NBootProperties();
            this._propertiesBuilder.addAll(this.properties);
        }
    }

    private void _updateProperties() {
        this.properties.clear();
        this.properties.addAll(Arrays.asList(this._propertiesBuilder.toArray()));
    }

    public int hashCode() {
        return Objects.hash(this.id, this.packaging, this.name, this.description, this.condition, this.dependencies, this.standardDependencies, this.properties, this.parents);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NBootDescriptor that = (NBootDescriptor)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.parents, that.parents) && Objects.equals(this.packaging, that.packaging) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.condition, that.condition) && Objects.equals(this.dependencies, that.dependencies) && Objects.equals(this.standardDependencies, that.standardDependencies) && Objects.equals(this.properties, that.properties);
    }

    public NBootDescriptor copy() {
        return new NBootDescriptor(this);
    }

    public boolean isBlank() {
        if (this.id != null && !this.id.isBlank()) {
            return false;
        }
        if (!NBootUtils.isBlank(this.packaging)) {
            return false;
        }
        if (this.parents != null) {
            for (NBootId parent : this.parents) {
                if (parent == null || parent.isBlank()) continue;
                return false;
            }
        }
        if (!NBootUtils.isBlank(this.description)) {
            return false;
        }
        if (!NBootUtils.isBlank(this.name)) {
            return false;
        }
        if (this.condition != null && !this.condition.isBlank()) {
            return false;
        }
        if (this.dependencies != null) {
            for (NBootDependency d : this.dependencies) {
                if (d == null || d.isBlank()) continue;
                return false;
            }
        }
        if (this.standardDependencies != null) {
            for (NBootDependency d : this.standardDependencies) {
                if (d == null || d.isBlank()) continue;
                return false;
            }
        }
        if (this.properties != null && this.properties.size() > 0) {
            for (NBootDescriptorProperty property : this.properties) {
                if (property == null || property.isBlank()) continue;
                return false;
            }
        }
        return true;
    }
}

