/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot;

import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import net.thevpc.nuts.boot.NBootClassLoaderNode;
import net.thevpc.nuts.boot.NBootDescriptor;
import net.thevpc.nuts.boot.NBootHomeLocation;
import net.thevpc.nuts.boot.NBootLogConfig;
import net.thevpc.nuts.boot.NBootWorkspaceFactory;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public final class NBootOptionsInfo {
    private static final long serialVersionUID = 1L;
    private NBootClassLoaderNode runtimeBootDependencyNode;
    private List<NBootDescriptor> extensionBootDescriptors;
    private List<NBootClassLoaderNode> extensionBootDependencyNodes;
    private NBootWorkspaceFactory bootWorkspaceFactory;
    private List<URL> classWorldURLs;
    private ClassLoader classWorldLoader;
    private String uuid;
    private Set<String> extensionsSet;
    private NBootDescriptor runtimeBootDescriptor;
    private List<String> outputFormatOptions;
    private List<String> customOptions;
    private String apiVersion;
    private String runtimeId;
    private String javaCommand;
    private String javaOptions;
    private String workspace;
    private String outLinePrefix;
    private String errLinePrefix;
    private String name;
    private Boolean installCompanions;
    private Boolean skipWelcome;
    private Boolean skipBoot;
    private Boolean system;
    private Boolean gui;
    private List<String> excludedExtensions;
    private List<String> repositories;
    private List<String> bootRepositories;
    private String userName;
    private Boolean sharedInstance;
    private char[] credentials;
    private String terminalMode;
    private Boolean readOnly;
    private Boolean trace;
    private String progressOptions;
    private String dependencySolver;
    private NBootLogConfig logConfig;
    private String confirm;
    private String outputFormat;
    private List<String> applicationArguments;
    private String openMode;
    private Instant creationTime;
    private Boolean dry;
    private Boolean showStacktrace;
    private Supplier<ClassLoader> classLoaderSupplier;
    private List<String> executorOptions;
    private Boolean recover;
    private Boolean reset;
    private Boolean resetHard;
    private Boolean commandVersion;
    private Boolean commandHelp;
    private String debug;
    private Boolean inherited;
    private String executionType;
    private String runAs;
    private String archetype;
    private Boolean switchWorkspace;
    private Map<String, String> storeLocations;
    private Map<NBootHomeLocation, String> homeLocations;
    private String storeLayout;
    private String storeStrategy;
    private String repositoryStoreStrategy;
    private String fetchStrategy;
    private Boolean cached;
    private Boolean indexed;
    private Boolean transitive;
    private Boolean bot;
    private Boolean previewRepo;
    private InputStream stdin;
    private PrintStream stdout;
    private PrintStream stderr;
    private ExecutorService executorService;
    private Instant expireTime;
    private List<String> errors;
    private Boolean skipErrors;
    private String locale;
    private String theme;
    private Boolean initLaunchers;
    private Boolean initScripts;
    private Boolean initPlatforms;
    private Boolean initJava;
    private String isolationLevel;
    private String desktopLauncher;
    private String menuLauncher;
    private String userLauncher;

    public String getDesktopLauncher() {
        return this.desktopLauncher;
    }

    public String getMenuLauncher() {
        return this.menuLauncher;
    }

    public String getUserLauncher() {
        return this.userLauncher;
    }

    public NBootOptionsInfo setInitLaunchers(Boolean initLaunchers) {
        this.initLaunchers = initLaunchers;
        return this;
    }

    public NBootOptionsInfo setInitScripts(Boolean initScripts) {
        this.initScripts = initScripts;
        return this;
    }

    public NBootOptionsInfo setInitPlatforms(Boolean initPlatforms) {
        this.initPlatforms = initPlatforms;
        return this;
    }

    public NBootOptionsInfo setInitJava(Boolean initJava) {
        this.initJava = initJava;
        return this;
    }

    public NBootOptionsInfo setIsolationLevel(String isolationLevel) {
        this.isolationLevel = isolationLevel;
        return this;
    }

    public NBootOptionsInfo setDesktopLauncher(String desktopLauncher) {
        this.desktopLauncher = desktopLauncher;
        return this;
    }

    public NBootOptionsInfo setMenuLauncher(String menuLauncher) {
        this.menuLauncher = menuLauncher;
        return this;
    }

    public NBootOptionsInfo setUserLauncher(String userLauncher) {
        this.userLauncher = userLauncher;
        return this;
    }

    public NBootOptionsInfo copy() {
        return new NBootOptionsInfo().copyFrom(this);
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public NBootOptionsInfo setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public List<String> getApplicationArguments() {
        return this.applicationArguments;
    }

    public NBootOptionsInfo setApplicationArguments(List<String> applicationArguments) {
        this.applicationArguments = applicationArguments;
        return this;
    }

    public String getArchetype() {
        return this.archetype;
    }

    public NBootOptionsInfo setArchetype(String archetype) {
        this.archetype = archetype;
        return this;
    }

    public Supplier<ClassLoader> getClassLoaderSupplier() {
        return this.classLoaderSupplier;
    }

    public NBootOptionsInfo setClassLoaderSupplier(Supplier<ClassLoader> provider) {
        this.classLoaderSupplier = provider;
        return this;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public NBootOptionsInfo setConfirm(String confirm) {
        this.confirm = confirm;
        return this;
    }

    public Boolean getDry() {
        return this.dry;
    }

    public Boolean getShowStacktrace() {
        return this.showStacktrace;
    }

    public NBootOptionsInfo setDry(Boolean dry) {
        this.dry = dry;
        return this;
    }

    public NBootOptionsInfo setShowStacktrace(Boolean showStacktrace) {
        this.showStacktrace = showStacktrace;
        return this;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public NBootOptionsInfo setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public List<String> getExcludedExtensions() {
        return this.excludedExtensions;
    }

    public NBootOptionsInfo setExcludedExtensions(List<String> excludedExtensions) {
        this.excludedExtensions = excludedExtensions;
        return this;
    }

    public String getExecutionType() {
        return this.executionType;
    }

    public NBootOptionsInfo setExecutionType(String executionType) {
        this.executionType = executionType;
        return this;
    }

    public String getRunAs() {
        return this.runAs;
    }

    public NBootOptionsInfo setRunAs(String runAs) {
        this.runAs = runAs;
        return this;
    }

    public List<String> getExecutorOptions() {
        return this.executorOptions;
    }

    public NBootOptionsInfo setExecutorOptions(List<String> executorOptions) {
        this.executorOptions = executorOptions;
        return this;
    }

    public String getHomeLocation(NBootHomeLocation location) {
        return this.homeLocations == null ? null : this.homeLocations.get(location);
    }

    public Map<NBootHomeLocation, String> getHomeLocations() {
        return this.homeLocations;
    }

    public NBootOptionsInfo setHomeLocations(Map<NBootHomeLocation, String> homeLocations) {
        if (homeLocations != null) {
            if (this.homeLocations == null) {
                this.homeLocations = new HashMap<NBootHomeLocation, String>();
            }
            this.homeLocations.putAll(homeLocations);
        } else {
            this.homeLocations = null;
        }
        return this;
    }

    public String getJavaCommand() {
        return this.javaCommand;
    }

    public NBootOptionsInfo setJavaCommand(String javaCommand) {
        this.javaCommand = javaCommand;
        return this;
    }

    public String getJavaOptions() {
        return this.javaOptions;
    }

    public NBootOptionsInfo setJavaOptions(String javaOptions) {
        this.javaOptions = javaOptions;
        return this;
    }

    public NBootLogConfig getLogConfig() {
        return this.logConfig;
    }

    public NBootOptionsInfo setLogConfig(NBootLogConfig logConfig) {
        this.logConfig = logConfig == null ? null : logConfig.copy();
        return this;
    }

    public String getName() {
        return this.name;
    }

    public NBootOptionsInfo setName(String workspaceName) {
        this.name = workspaceName;
        return this;
    }

    public String getOpenMode() {
        return this.openMode;
    }

    public NBootOptionsInfo setOpenMode(String openMode) {
        this.openMode = openMode;
        return this;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public NBootOptionsInfo setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
        return this;
    }

    public List<String> getOutputFormatOptions() {
        return this.outputFormatOptions;
    }

    public NBootOptionsInfo setOutputFormatOptions(List<String> options) {
        if (options != null) {
            if (this.outputFormatOptions == null) {
                this.outputFormatOptions = new ArrayList<String>();
            }
            this.outputFormatOptions.clear();
            return this.addOutputFormatOptions(NBootUtils.nonNullList(options).toArray(new String[0]));
        }
        this.outputFormatOptions = null;
        return this;
    }

    public NBootOptionsInfo setOutputFormatOptions(String ... options) {
        if (this.outputFormatOptions == null) {
            this.outputFormatOptions = new ArrayList<String>();
        }
        this.outputFormatOptions.clear();
        return this.addOutputFormatOptions(options);
    }

    public char[] getCredentials() {
        return this.credentials;
    }

    public NBootOptionsInfo setCredentials(char[] credentials) {
        this.credentials = credentials;
        return this;
    }

    public String getRepositoryStoreStrategy() {
        return this.repositoryStoreStrategy;
    }

    public NBootOptionsInfo setRepositoryStoreStrategy(String repositoryStoreStrategy) {
        this.repositoryStoreStrategy = repositoryStoreStrategy;
        return this;
    }

    public String getRuntimeId() {
        return this.runtimeId;
    }

    public NBootOptionsInfo setRuntimeId(String runtimeId) {
        this.runtimeId = runtimeId;
        return this;
    }

    public String getStoreType(String folder) {
        return this.storeLocations == null ? null : this.storeLocations.get(NBootUtils.enumId(folder));
    }

    public String getStoreLayout() {
        return this.storeLayout;
    }

    public NBootOptionsInfo setStoreLayout(String storeLayout) {
        this.storeLayout = storeLayout;
        return this;
    }

    public String getStoreStrategy() {
        return this.storeStrategy;
    }

    public NBootOptionsInfo setStoreStrategy(String storeStrategy) {
        this.storeStrategy = storeStrategy;
        return this;
    }

    public Map<String, String> getStoreLocations() {
        return this.storeLocations;
    }

    public NBootOptionsInfo setStoreLocations(Map<String, String> storeLocations) {
        if (storeLocations != null) {
            if (this.storeLocations == null) {
                this.storeLocations = new HashMap<String, String>();
            }
            this.storeLocations.clear();
            this.storeLocations.putAll(NBootUtils.nonNullMap(storeLocations));
        } else {
            this.storeLocations = null;
        }
        return this;
    }

    public String getTerminalMode() {
        return this.terminalMode;
    }

    public NBootOptionsInfo setTerminalMode(String terminalMode) {
        this.terminalMode = terminalMode;
        return this;
    }

    public List<String> getRepositories() {
        return this.repositories;
    }

    public List<String> getBootRepositories() {
        return this.bootRepositories;
    }

    public NBootOptionsInfo setRepositories(List<String> repositories) {
        this.repositories = repositories;
        return this;
    }

    public NBootOptionsInfo setBootRepositories(List<String> bootRepositories) {
        this.bootRepositories = bootRepositories;
        return this;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public NBootOptionsInfo setWorkspace(String workspace) {
        this.workspace = workspace;
        return this;
    }

    public String getDebug() {
        return this.debug;
    }

    public NBootOptionsInfo setDebug(String debug) {
        this.debug = debug;
        return this;
    }

    public Boolean getSystem() {
        return this.system;
    }

    public NBootOptionsInfo setSystem(Boolean system) {
        this.system = system;
        return this;
    }

    public Boolean getGui() {
        return this.gui;
    }

    public NBootOptionsInfo setGui(Boolean gui) {
        this.gui = gui;
        return this;
    }

    public Boolean getInherited() {
        return this.inherited;
    }

    public NBootOptionsInfo setInherited(Boolean inherited) {
        this.inherited = inherited;
        return this;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public NBootOptionsInfo setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public Boolean getRecover() {
        return this.recover;
    }

    public NBootOptionsInfo setRecover(Boolean recover) {
        this.recover = recover;
        return this;
    }

    public Boolean getResetHard() {
        return this.resetHard;
    }

    public void setResetHard(Boolean resetHard) {
        this.resetHard = resetHard;
    }

    public Boolean getReset() {
        return this.reset;
    }

    public NBootOptionsInfo setReset(Boolean reset) {
        this.reset = reset;
        return this;
    }

    public Boolean getCommandVersion() {
        return this.commandVersion;
    }

    public NBootOptionsInfo setCommandVersion(Boolean version) {
        this.commandVersion = version;
        return this;
    }

    public Boolean getCommandHelp() {
        return this.commandHelp;
    }

    public NBootOptionsInfo setCommandHelp(Boolean help) {
        this.commandHelp = help;
        return this;
    }

    public Boolean getInstallCompanions() {
        return this.installCompanions;
    }

    public NBootOptionsInfo setInstallCompanions(Boolean skipInstallCompanions) {
        this.installCompanions = skipInstallCompanions;
        return this;
    }

    public Boolean getSkipWelcome() {
        return this.skipWelcome;
    }

    public NBootOptionsInfo setSkipWelcome(Boolean skipWelcome) {
        this.skipWelcome = skipWelcome;
        return this;
    }

    public String getOutLinePrefix() {
        return this.outLinePrefix;
    }

    public NBootOptionsInfo setOutLinePrefix(String outLinePrefix) {
        this.outLinePrefix = outLinePrefix;
        return this;
    }

    public String getErrLinePrefix() {
        return this.errLinePrefix;
    }

    public NBootOptionsInfo setErrLinePrefix(String errLinePrefix) {
        this.errLinePrefix = errLinePrefix;
        return this;
    }

    public Boolean getSkipBoot() {
        return this.skipBoot;
    }

    public NBootOptionsInfo setSkipBoot(Boolean skipBoot) {
        this.skipBoot = skipBoot;
        return this;
    }

    public Boolean getTrace() {
        return this.trace;
    }

    public NBootOptionsInfo setTrace(Boolean trace) {
        this.trace = trace;
        return this;
    }

    public String getProgressOptions() {
        return this.progressOptions;
    }

    public NBootOptionsInfo setProgressOptions(String progressOptions) {
        this.progressOptions = progressOptions;
        return this;
    }

    public Boolean getCached() {
        return this.cached;
    }

    public NBootOptionsInfo setCached(Boolean cached) {
        this.cached = cached;
        return this;
    }

    public Boolean getIndexed() {
        return this.indexed;
    }

    public NBootOptionsInfo setIndexed(Boolean indexed) {
        this.indexed = indexed;
        return this;
    }

    public Boolean getTransitive() {
        return this.transitive;
    }

    public NBootOptionsInfo setTransitive(Boolean transitive) {
        this.transitive = transitive;
        return this;
    }

    public Boolean getBot() {
        return this.bot;
    }

    public NBootOptionsInfo setBot(Boolean bot) {
        this.bot = bot;
        return this;
    }

    public Boolean getPreviewRepo() {
        return this.previewRepo;
    }

    public NBootOptionsInfo setPreviewRepo(Boolean bot) {
        this.previewRepo = bot;
        return this;
    }

    public String getFetchStrategy() {
        return this.fetchStrategy;
    }

    public NBootOptionsInfo setFetchStrategy(String fetchStrategy) {
        this.fetchStrategy = fetchStrategy;
        return this;
    }

    public InputStream getStdin() {
        return this.stdin;
    }

    public NBootOptionsInfo setStdin(InputStream stdin) {
        this.stdin = stdin;
        return this;
    }

    public PrintStream getStdout() {
        return this.stdout;
    }

    public NBootOptionsInfo setStdout(PrintStream stdout) {
        this.stdout = stdout;
        return this;
    }

    public PrintStream getStderr() {
        return this.stderr;
    }

    public NBootOptionsInfo setStderr(PrintStream stderr) {
        this.stderr = stderr;
        return this;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public NBootOptionsInfo setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public Instant getExpireTime() {
        return this.expireTime;
    }

    public NBootOptionsInfo setExpireTime(Instant expireTime) {
        this.expireTime = expireTime;
        return this;
    }

    public Boolean getSkipErrors() {
        return this.skipErrors;
    }

    public NBootOptionsInfo setSkipErrors(Boolean value) {
        this.skipErrors = value;
        return this;
    }

    public Boolean getSwitchWorkspace() {
        return this.switchWorkspace;
    }

    public NBootOptionsInfo setSwitchWorkspace(Boolean switchWorkspace) {
        this.switchWorkspace = switchWorkspace;
        return this;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public NBootOptionsInfo setErrors(List<String> errors) {
        this.errors = errors;
        return this;
    }

    public List<String> getCustomOptions() {
        return this.customOptions;
    }

    public NBootOptionsInfo setCustomOptions(List<String> properties) {
        this.customOptions = properties;
        return this;
    }

    public String getLocale() {
        return this.locale;
    }

    public NBootOptionsInfo setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    public String getTheme() {
        return this.theme;
    }

    public NBootOptionsInfo setTheme(String theme) {
        this.theme = theme;
        return this;
    }

    public NBootOptionsInfo copyFrom(NBootOptionsInfo other) {
        if (other == null) {
            return this;
        }
        this.setApiVersion(other.getApiVersion());
        this.setRuntimeId(other.getRuntimeId());
        this.setJavaCommand(other.getJavaCommand());
        this.setJavaOptions(other.getJavaOptions());
        this.setWorkspace(other.getWorkspace());
        this.setName(other.getName());
        this.setInstallCompanions(other.getInstallCompanions());
        this.setSkipWelcome(other.getSkipWelcome());
        this.setSkipBoot(other.getSkipBoot());
        this.setSystem(other.getSystem());
        this.setGui(other.getGui());
        this.setUserName(other.getUserName());
        this.setCredentials(other.getCredentials());
        this.setTerminalMode(other.getTerminalMode());
        this.setReadOnly(other.getReadOnly());
        this.setTrace(other.getTrace());
        this.setProgressOptions(other.getProgressOptions());
        this.setLogConfig(other.getLogConfig());
        this.setConfirm(other.getConfirm());
        this.setConfirm(other.getConfirm());
        this.setOutputFormat(other.getOutputFormat());
        this.setOutputFormatOptions(other.getOutputFormatOptions());
        this.setOpenMode(other.getOpenMode());
        this.setCreationTime(other.getCreationTime());
        this.setDry(other.getDry());
        this.setShowStacktrace(other.getShowStacktrace());
        this.setClassLoaderSupplier(other.getClassLoaderSupplier());
        this.setExecutorOptions(other.getExecutorOptions());
        this.setRecover(other.getRecover());
        this.setReset(other.getReset());
        this.setResetHard(other.getResetHard());
        this.setCommandVersion(other.getCommandVersion());
        this.setCommandHelp(other.getCommandHelp());
        this.setDebug(other.getDebug());
        this.setInherited(other.getInherited());
        this.setExecutionType(other.getExecutionType());
        this.setRunAs(other.getRunAs());
        this.setArchetype(other.getArchetype());
        this.setStoreStrategy(other.getStoreStrategy());
        this.setHomeLocations(other.getHomeLocations());
        this.setStoreLocations(other.getStoreLocations());
        this.setStoreLayout(other.getStoreLayout());
        this.setStoreStrategy(other.getStoreStrategy());
        this.setRepositoryStoreStrategy(other.getRepositoryStoreStrategy());
        this.setFetchStrategy(other.getFetchStrategy());
        this.setCached(other.getCached());
        this.setIndexed(other.getIndexed());
        this.setTransitive(other.getTransitive());
        this.setBot(other.getBot());
        this.setStdin(other.getStdin());
        this.setStdout(other.getStdout());
        this.setStderr(other.getStderr());
        this.setExecutorService(other.getExecutorService());
        this.setExcludedExtensions(other.getExcludedExtensions());
        this.setRepositories(other.getRepositories());
        this.setBootRepositories(other.getBootRepositories());
        this.setApplicationArguments(other.getApplicationArguments());
        this.setCustomOptions(other.getCustomOptions());
        this.setExpireTime(other.getExpireTime());
        this.setErrors(other.getErrors());
        this.setSkipErrors(other.getSkipErrors());
        this.setSwitchWorkspace(other.getSwitchWorkspace());
        this.setLocale(other.getLocale());
        this.setTheme(other.getTheme());
        this.setDependencySolver(other.getDependencySolver());
        this.setIsolationLevel(other.getIsolationLevel());
        this.setInitLaunchers(other.getInitLaunchers());
        this.setInitJava(other.getInitJava());
        this.setInitScripts(other.getInitScripts());
        this.setInitPlatforms(other.getInitPlatforms());
        this.setDesktopLauncher(other.getDesktopLauncher());
        this.setMenuLauncher(other.getMenuLauncher());
        this.setUserLauncher(other.getUserLauncher());
        this.setSharedInstance(other.getSharedInstance());
        this.setPreviewRepo(other.getPreviewRepo());
        this.setRuntimeBootDependencyNode(other.getRuntimeBootDependencyNode());
        this.setExtensionBootDescriptors(other.getExtensionBootDescriptors());
        this.setExtensionBootDependencyNodes(other.getExtensionBootDependencyNodes());
        this.setBootWorkspaceFactory(other.getBootWorkspaceFactory());
        this.setClassWorldURLs(other.getClassWorldURLs());
        this.setClassWorldLoader(other.getClassWorldLoader());
        this.setUuid(other.getUuid());
        this.setExtensionsSet(other.getExtensionsSet());
        this.setRuntimeBootDescriptor(other.getRuntimeBootDescriptor());
        return this;
    }

    public NBootOptionsInfo setAllPresent(NBootOptionsInfo o) {
        if (o != null) {
            if (o.getApiVersion() != null) {
                this.setApiVersion(o.getApiVersion());
            }
            if (o.getRuntimeId() != null) {
                this.setRuntimeId(o.getRuntimeId());
            }
            if (o.getJavaCommand() != null) {
                this.setJavaCommand(o.getJavaCommand());
            }
            if (o.getJavaOptions() != null) {
                this.setJavaOptions(o.getJavaOptions());
            }
            if (o.getWorkspace() != null) {
                this.setWorkspace(o.getWorkspace());
            }
            if (o.getName() != null) {
                this.setName(o.getName());
            }
            if (o.getInstallCompanions() != null) {
                this.setInstallCompanions(o.getInstallCompanions());
            }
            if (o.getSkipWelcome() != null) {
                this.setSkipWelcome(o.getSkipWelcome());
            }
            if (o.getSkipBoot() != null) {
                this.setSkipBoot(o.getSkipBoot());
            }
            if (o.getSystem() != null) {
                this.setSystem(o.getSystem());
            }
            if (o.getGui() != null) {
                this.setGui(o.getGui());
            }
            if (o.getUserName() != null) {
                this.setUserName(o.getUserName());
            }
            if (o.getCredentials() != null) {
                this.setCredentials(o.getCredentials());
            }
            if (o.getTerminalMode() != null) {
                this.setTerminalMode(o.getTerminalMode());
            }
            if (o.getReadOnly() != null) {
                this.setReadOnly(o.getReadOnly());
            }
            if (o.getTrace() != null) {
                this.setTrace(o.getTrace());
            }
            if (o.getProgressOptions() != null) {
                this.setProgressOptions(o.getProgressOptions());
            }
            if (o.getLogConfig() != null) {
                this.setLogConfig(o.getLogConfig());
            }
            if (o.getConfirm() != null) {
                this.setConfirm(o.getConfirm());
            }
            if (o.getConfirm() != null) {
                this.setConfirm(o.getConfirm());
            }
            if (o.getOutputFormat() != null) {
                this.setOutputFormat(o.getOutputFormat());
            }
            if (o.getOutputFormatOptions() != null) {
                this.setOutputFormatOptions(o.getOutputFormatOptions());
            }
            if (o.getOpenMode() != null) {
                this.setOpenMode(o.getOpenMode());
            }
            if (o.getCreationTime() != null) {
                this.setCreationTime(o.getCreationTime());
            }
            if (o.getDry() != null) {
                this.setDry(o.getDry());
            }
            if (o.getShowStacktrace() != null) {
                this.setShowStacktrace(o.getShowStacktrace());
            }
            if (o.getClassLoaderSupplier() != null) {
                this.setClassLoaderSupplier(o.getClassLoaderSupplier());
            }
            if (o.getExecutorOptions() != null) {
                this.setExecutorOptions(o.getExecutorOptions());
            }
            if (o.getRecover() != null) {
                this.setRecover(o.getRecover());
            }
            if (o.getReset() != null) {
                this.setReset(o.getReset());
            }
            if (o.getResetHard() != null) {
                this.setResetHard(o.getResetHard());
            }
            if (o.getCommandVersion() != null) {
                this.setCommandVersion(o.getCommandVersion());
            }
            if (o.getCommandHelp() != null) {
                this.setCommandHelp(o.getCommandHelp());
            }
            if (o.getDebug() != null) {
                this.setDebug(o.getDebug());
            }
            if (o.getInherited() != null) {
                this.setInherited(o.getInherited());
            }
            if (o.getExecutionType() != null) {
                this.setExecutionType(o.getExecutionType());
            }
            if (o.getRunAs() != null) {
                this.setRunAs(o.getRunAs());
            }
            if (o.getArchetype() != null) {
                this.setArchetype(o.getArchetype());
            }
            if (o.getStoreStrategy() != null) {
                this.setStoreStrategy(o.getStoreStrategy());
            }
            if (o.getHomeLocations() != null) {
                this.setHomeLocations(o.getHomeLocations());
            }
            if (o.getStoreLocations() != null) {
                this.setStoreLocations(o.getStoreLocations());
            }
            if (o.getStoreLayout() != null) {
                this.setStoreLayout(o.getStoreLayout());
            }
            if (o.getStoreStrategy() != null) {
                this.setStoreStrategy(o.getStoreStrategy());
            }
            if (o.getRepositoryStoreStrategy() != null) {
                this.setRepositoryStoreStrategy(o.getRepositoryStoreStrategy());
            }
            if (o.getFetchStrategy() != null) {
                this.setFetchStrategy(o.getFetchStrategy());
            }
            if (o.getCached() != null) {
                this.setCached(o.getCached());
            }
            if (o.getIndexed() != null) {
                this.setIndexed(o.getIndexed());
            }
            if (o.getTransitive() != null) {
                this.setTransitive(o.getTransitive());
            }
            if (o.getBot() != null) {
                this.setBot(o.getBot());
            }
            if (o.getStdin() != null) {
                this.setStdin(o.getStdin());
            }
            if (o.getStdout() != null) {
                this.setStdout(o.getStdout());
            }
            if (o.getStderr() != null) {
                this.setStderr(o.getStderr());
            }
            if (o.getExecutorService() != null) {
                this.setExecutorService(o.getExecutorService());
            }
            if (o.getExcludedExtensions() != null) {
                this.setExcludedExtensions(o.getExcludedExtensions());
            }
            if (o.getRepositories() != null) {
                this.setRepositories(o.getRepositories());
            }
            if (o.getBootRepositories() != null) {
                this.setBootRepositories(o.getBootRepositories());
            }
            if (o.getApplicationArguments() != null) {
                this.setApplicationArguments(o.getApplicationArguments());
            }
            if (o.getCustomOptions() != null) {
                this.setCustomOptions(o.getCustomOptions());
            }
            if (o.getExpireTime() != null) {
                this.setExpireTime(o.getExpireTime());
            }
            if (o.getErrors() != null) {
                this.setErrors(o.getErrors());
            }
            if (o.getSkipErrors() != null) {
                this.setSkipErrors(o.getSkipErrors());
            }
            if (o.getSwitchWorkspace() != null) {
                this.setSwitchWorkspace(o.getSwitchWorkspace());
            }
            if (o.getLocale() != null) {
                this.setLocale(o.getLocale());
            }
            if (o.getTheme() != null) {
                this.setTheme(o.getTheme());
            }
            if (o.getDependencySolver() != null) {
                this.setDependencySolver(o.getDependencySolver());
            }
            if (o.getIsolationLevel() != null) {
                this.setIsolationLevel(o.getIsolationLevel());
            }
            if (o.getInitLaunchers() != null) {
                this.setInitLaunchers(o.getInitLaunchers());
            }
            if (o.getInitJava() != null) {
                this.setInitJava(o.getInitJava());
            }
            if (o.getInitScripts() != null) {
                this.setInitScripts(o.getInitScripts());
            }
            if (o.getInitLaunchers() != null) {
                this.setInitLaunchers(o.getInitLaunchers());
            }
            if (o.getDesktopLauncher() != null) {
                this.setDesktopLauncher(o.getDesktopLauncher());
            }
            if (o.getMenuLauncher() != null) {
                this.setMenuLauncher(o.getMenuLauncher());
            }
            if (o.getUserLauncher() != null) {
                this.setUserLauncher(o.getUserLauncher());
            }
            if (o.getPreviewRepo() != null) {
                this.setPreviewRepo(o.getPreviewRepo());
            }
            if (o.getSharedInstance() != null) {
                this.setSharedInstance(o.getSharedInstance());
            }
            if (o.getRuntimeBootDependencyNode() != null) {
                this.setRuntimeBootDependencyNode(o.getRuntimeBootDependencyNode());
            }
            if (o.getExtensionBootDescriptors() != null) {
                this.setExtensionBootDescriptors(o.getExtensionBootDescriptors());
            }
            if (o.getExtensionBootDependencyNodes() != null) {
                this.setExtensionBootDependencyNodes(o.getExtensionBootDependencyNodes());
            }
            if (o.getBootWorkspaceFactory() != null) {
                this.setBootWorkspaceFactory(o.getBootWorkspaceFactory());
            }
            if (o.getClassWorldURLs() != null) {
                this.setClassWorldURLs(o.getClassWorldURLs());
            }
            if (o.getClassWorldLoader() != null) {
                this.setClassWorldLoader(o.getClassWorldLoader());
            }
            if (o.getUuid() != null) {
                this.setUuid(o.getUuid());
            }
            if (o.getExtensionsSet() != null) {
                this.setExtensionsSet(o.getExtensionsSet());
            }
            if (o.getRuntimeBootDescriptor() != null) {
                this.setRuntimeBootDescriptor(o.getRuntimeBootDescriptor());
            }
        }
        return this;
    }

    public Boolean getSharedInstance() {
        return this.sharedInstance;
    }

    public NBootOptionsInfo setSharedInstance(Boolean sharedInstance) {
        this.sharedInstance = sharedInstance;
        return this;
    }

    public NBootOptionsInfo setUserName(String username) {
        this.userName = username;
        return this;
    }

    public NBootOptionsInfo setStoreLocation(String location, String value) {
        if (NBootUtils.isBlank(value)) {
            if (this.storeLocations != null) {
                this.storeLocations.remove(location);
            }
        } else {
            if (this.storeLocations == null) {
                this.storeLocations = new HashMap<String, String>();
            }
            this.storeLocations.put(location, value);
        }
        return this;
    }

    public NBootOptionsInfo setHomeLocation(NBootHomeLocation location, String value) {
        if (NBootUtils.isBlank(value)) {
            if (this.homeLocations != null) {
                this.homeLocations.remove(location);
            }
        } else {
            if (this.homeLocations == null) {
                this.homeLocations = new HashMap<NBootHomeLocation, String>();
            }
            this.homeLocations.put(location, value);
        }
        return this;
    }

    public NBootOptionsInfo addOutputFormatOptions(String ... options) {
        if (options != null) {
            for (String option : options) {
                if (option == null || (option = NBootUtils.trim(option)).isEmpty()) continue;
                if (this.outputFormatOptions == null) {
                    this.outputFormatOptions = new ArrayList<String>();
                }
                this.outputFormatOptions.add(option);
            }
        }
        return this;
    }

    public String getDependencySolver() {
        return this.dependencySolver;
    }

    public NBootOptionsInfo setDependencySolver(String dependencySolver) {
        this.dependencySolver = dependencySolver;
        return this;
    }

    public String getIsolationLevel() {
        return this.isolationLevel;
    }

    public Boolean getInitLaunchers() {
        return this.initLaunchers;
    }

    public Boolean getInitScripts() {
        return this.initScripts;
    }

    public Boolean getInitPlatforms() {
        return this.initPlatforms;
    }

    public Boolean getInitJava() {
        return this.initJava;
    }

    public NBootOptionsInfo unsetRuntimeOptions() {
        this.setCommandHelp(null);
        this.setCommandVersion(null);
        this.setOpenMode(null);
        this.setExecutionType(null);
        this.setRunAs(null);
        this.setReset(null);
        this.setResetHard(null);
        this.setRecover(null);
        this.setDry(null);
        this.setShowStacktrace(null);
        this.setExecutorOptions(null);
        this.setApplicationArguments(null);
        return this;
    }

    public NBootOptionsInfo unsetCreationOptions() {
        this.setName(null);
        this.setArchetype(null);
        this.setStoreLayout(null);
        this.setStoreStrategy(null);
        this.setRepositoryStoreStrategy(null);
        this.setStoreLocations(null);
        this.setHomeLocations(null);
        this.setSwitchWorkspace(null);
        return this;
    }

    public NBootOptionsInfo unsetExportedOptions() {
        this.setJavaCommand(null);
        this.setJavaOptions(null);
        this.setWorkspace(null);
        this.setUserName(null);
        this.setCredentials(null);
        this.setApiVersion(null);
        this.setRuntimeId(null);
        this.setTerminalMode(null);
        this.setLogConfig(null);
        this.setExcludedExtensions(null);
        this.setRepositories(null);
        this.setSystem(null);
        this.setGui(null);
        this.setReadOnly(null);
        this.setTrace(null);
        this.setProgressOptions(null);
        this.setDependencySolver(null);
        this.setDebug(null);
        this.setInstallCompanions(null);
        this.setSkipWelcome(null);
        this.setSkipBoot(null);
        this.setOutLinePrefix(null);
        this.setErrLinePrefix(null);
        this.setCached(null);
        this.setIndexed(null);
        this.setTransitive(null);
        this.setBot(null);
        this.setFetchStrategy(null);
        this.setConfirm(null);
        this.setOutputFormat(null);
        this.setOutputFormatOptions((List<String>)null);
        this.setExpireTime(null);
        this.setTheme(null);
        this.setLocale(null);
        this.setInitLaunchers(null);
        this.setInitPlatforms(null);
        this.setInitScripts(null);
        this.setInitJava(null);
        this.setDesktopLauncher(null);
        this.setMenuLauncher(null);
        this.setUserLauncher(null);
        return this;
    }

    public NBootClassLoaderNode getRuntimeBootDependencyNode() {
        return this.runtimeBootDependencyNode;
    }

    public NBootOptionsInfo setRuntimeBootDependencyNode(NBootClassLoaderNode runtimeBootDependencyNode) {
        this.runtimeBootDependencyNode = runtimeBootDependencyNode;
        return this;
    }

    public List<NBootDescriptor> getExtensionBootDescriptors() {
        return this.extensionBootDescriptors;
    }

    public NBootOptionsInfo setExtensionBootDescriptors(List<NBootDescriptor> extensionBootDescriptors) {
        this.extensionBootDescriptors = NBootUtils.nonNullList(extensionBootDescriptors);
        return this;
    }

    public List<NBootClassLoaderNode> getExtensionBootDependencyNodes() {
        return this.extensionBootDependencyNodes;
    }

    public NBootOptionsInfo setExtensionBootDependencyNodes(List<NBootClassLoaderNode> extensionBootDependencyNodes) {
        this.extensionBootDependencyNodes = NBootUtils.nonNullList(extensionBootDependencyNodes);
        return this;
    }

    public NBootWorkspaceFactory getBootWorkspaceFactory() {
        return this.bootWorkspaceFactory;
    }

    public NBootOptionsInfo setBootWorkspaceFactory(NBootWorkspaceFactory bootWorkspaceFactory) {
        this.bootWorkspaceFactory = bootWorkspaceFactory;
        return this;
    }

    public List<URL> getClassWorldURLs() {
        return this.classWorldURLs;
    }

    public NBootOptionsInfo setClassWorldURLs(List<URL> classWorldURLs) {
        this.classWorldURLs = NBootUtils.nonNullList(classWorldURLs);
        return this;
    }

    public ClassLoader getClassWorldLoader() {
        return this.classWorldLoader;
    }

    public NBootOptionsInfo setClassWorldLoader(ClassLoader classWorldLoader) {
        this.classWorldLoader = classWorldLoader;
        return this;
    }

    public String getUuid() {
        return this.uuid;
    }

    public NBootOptionsInfo setUuid(String uuid) {
        this.uuid = NBootUtils.trimToNull(uuid);
        return this;
    }

    public Set<String> getExtensionsSet() {
        return this.extensionsSet;
    }

    public NBootOptionsInfo setExtensionsSet(Set<String> extensionsSet) {
        this.extensionsSet = NBootUtils.nonNullSet(extensionsSet);
        return this;
    }

    public NBootDescriptor getRuntimeBootDescriptor() {
        return this.runtimeBootDescriptor;
    }

    public NBootOptionsInfo setRuntimeBootDescriptor(NBootDescriptor runtimeBootDescriptor) {
        this.runtimeBootDescriptor = runtimeBootDescriptor;
        return this;
    }

    public NBootOptionsInfo resetOptions() {
        this.outputFormatOptions = null;
        this.customOptions = null;
        this.apiVersion = null;
        this.runtimeId = null;
        this.javaCommand = null;
        this.javaOptions = null;
        this.workspace = null;
        this.outLinePrefix = null;
        this.errLinePrefix = null;
        this.name = null;
        this.installCompanions = null;
        this.skipWelcome = null;
        this.skipBoot = null;
        this.system = null;
        this.gui = null;
        this.excludedExtensions = null;
        this.repositories = null;
        this.userName = null;
        this.sharedInstance = null;
        this.credentials = null;
        this.terminalMode = null;
        this.readOnly = null;
        this.trace = null;
        this.progressOptions = null;
        this.dependencySolver = null;
        this.logConfig = null;
        this.confirm = null;
        this.outputFormat = null;
        this.applicationArguments = null;
        this.openMode = null;
        this.creationTime = null;
        this.dry = null;
        this.showStacktrace = null;
        this.classLoaderSupplier = null;
        this.executorOptions = null;
        this.recover = null;
        this.reset = null;
        this.resetHard = null;
        this.commandHelp = null;
        this.debug = null;
        this.inherited = null;
        this.executionType = null;
        this.runAs = null;
        this.archetype = null;
        this.switchWorkspace = null;
        this.storeLocations = null;
        this.homeLocations = null;
        this.storeLayout = null;
        this.storeStrategy = null;
        this.repositoryStoreStrategy = null;
        this.bootRepositories = null;
        this.fetchStrategy = null;
        this.cached = null;
        this.indexed = null;
        this.transitive = null;
        this.bot = null;
        this.previewRepo = null;
        this.stdin = null;
        this.stdout = null;
        this.stderr = null;
        this.executorService = null;
        this.expireTime = null;
        this.skipErrors = null;
        this.locale = null;
        this.theme = null;
        this.initLaunchers = null;
        this.initScripts = null;
        this.initPlatforms = null;
        this.initJava = null;
        this.isolationLevel = null;
        this.desktopLauncher = null;
        this.menuLauncher = null;
        this.userLauncher = null;
        return this;
    }
}

