/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot;

import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import net.thevpc.nuts.boot.NBootException;
import net.thevpc.nuts.boot.internal.util.NBootMsg;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public class NBootVersion {
    private static Pattern VERSION_PART_PATTERN = Pattern.compile("([0-9a-zA-Z_.-])+");
    public static Pattern PATTERN = Pattern.compile("[A-Za-z0-9._*,()\\[\\] ${}+-]+");
    public static NBootVersion BLANK = new NBootVersion("");
    private static final long serialVersionUID = 1L;
    protected String expression;
    private VersionParts parts;

    public NBootVersion(String expression) {
        this.expression = NBootUtils.trim(expression);
    }

    public static String incVersion(String oldVersion, int level, long count) {
        return NBootVersion.incVersion(oldVersion, level, BigInteger.valueOf(count));
    }

    public static String incVersion(String oldVersion, int level, BigInteger count) {
        VersionParts parts;
        int digitCount;
        if (count == null) {
            count = BigInteger.ZERO;
        }
        if ((digitCount = (parts = NBootVersion.splitVersionParts2(oldVersion)).getDigitCount()) == 0) {
            parts.addDigit(BigInteger.ZERO, ".");
            digitCount = parts.getDigitCount();
        }
        if (level < 0) {
            for (level = digitCount + level; level < 0; ++level) {
                parts.addDigit(BigInteger.ZERO, ".");
            }
            VersionPart digit = parts.getDigit(level);
            digit.string = String.valueOf(new BigInteger(digit.string).add(count));
            return parts.toString();
        }
        for (int i = digitCount; i < level; ++i) {
            parts.addDigit(BigInteger.ZERO, ".");
        }
        VersionPart digit = parts.getDigit(level);
        digit.string = String.valueOf(new BigInteger(digit.string).add(count));
        return parts.toString();
    }

    public static int compareVersions(String v1, String v2) {
        if ((v1 = NBootUtils.trim(v1)).equals(v2 = NBootUtils.trim(v2))) {
            return 0;
        }
        if ("LATEST".equals(v1)) {
            return 1;
        }
        if ("LATEST".equals(v2)) {
            return -1;
        }
        if ("RELEASE".equals(v1)) {
            return 1;
        }
        if ("RELEASE".equals(v2)) {
            return -1;
        }
        VersionParts v1arr = NBootVersion.splitVersionParts2(v1);
        VersionParts v2arr = NBootVersion.splitVersionParts2(v2);
        return v1arr.compareTo(v2arr);
    }

    private static VersionParts splitVersionParts2(String v1) {
        v1 = NBootUtils.trim(v1);
        ArrayList<VersionPart> parts = new ArrayList<VersionPart>();
        StringBuilder last = null;
        VersionPartType partType = null;
        for (char c : v1.toCharArray()) {
            if (Character.isDigit(c)) {
                if (last == null) {
                    last = new StringBuilder();
                    last.append(c);
                    partType = VersionPartType.NUMBER;
                    continue;
                }
                if (partType == VersionPartType.NUMBER) {
                    last.append(c);
                    continue;
                }
                parts.add(new VersionPart(last.toString(), partType));
                last.delete(0, last.length());
                partType = VersionPartType.NUMBER;
                last.append(c);
                continue;
            }
            if (c == '.' || c == '-') {
                if (last != null) {
                    parts.add(new VersionPart(last.toString(), partType));
                    last = null;
                }
                parts.add(new VersionPart(String.valueOf(c), VersionPartType.SEPARATOR));
                partType = VersionPartType.SEPARATOR;
                continue;
            }
            if (last == null) {
                partType = VersionPartType.QAL;
                last = new StringBuilder();
                last.append(c);
                continue;
            }
            if (partType == VersionPartType.QAL) {
                last.append(c);
                continue;
            }
            parts.add(new VersionPart(last.toString(), partType));
            partType = VersionPartType.QAL;
            last.delete(0, last.length());
            last.append(c);
        }
        if (last != null && last.length() > 0) {
            parts.add(new VersionPart(last.toString(), partType));
        }
        return new VersionParts(parts);
    }

    private static Integer getKnownQualifierIndex(String v1) {
        switch (v1.toLowerCase()) {
            case "a": 
            case "alpha": {
                return 1;
            }
            case "b": 
            case "beta": {
                return 2;
            }
            case "m": 
            case "milestone": {
                return 3;
            }
            case "rc": 
            case "cr": {
                return 4;
            }
            case "snapshot": {
                return 5;
            }
            case "": 
            case "ga": 
            case "final": {
                return 6;
            }
            case "sp": {
                return 7;
            }
        }
        return null;
    }

    public static NBootVersion of(String value) {
        return new NBootVersion(value);
    }

    public boolean isLatestVersion() {
        String s = this.asSingleValue();
        return "LATEST".equalsIgnoreCase(s);
    }

    public boolean isReleaseVersion() {
        String s = this.asSingleValue();
        return "RELEASE".equalsIgnoreCase(s);
    }

    public boolean isSnapshotVersion() {
        String s = this.asSingleValue();
        return s != null && s.toUpperCase().endsWith("-SNAPSHOT");
    }

    public boolean isNull() {
        return this.expression == null;
    }

    public boolean isBlank() {
        return this.expression == null || this.expression.trim().isEmpty();
    }

    public String getValue() {
        return this.expression;
    }

    public int compareTo(String other) {
        return NBootVersion.compareVersions(this.expression, other);
    }

    public int compareTo(NBootVersion other) {
        return this.compareTo(other == null ? null : other.getValue());
    }

    public NBootVersion compatNewer() {
        String v = this.toExplicitSingleValueOrNullString();
        if (v == null) {
            return this;
        }
        return new NBootVersion("[" + this.expression + ",[");
    }

    public NBootVersion compatOlder() {
        String v = this.toExplicitSingleValueOrNullString();
        if (v == null) {
            return this;
        }
        return new NBootVersion("]," + v + "]");
    }

    public List<NVersionIntervalBoot> intervals() {
        return NVersionIntervalBoot.ofList(this.expression);
    }

    public String asSingleValue() {
        if (VERSION_PART_PATTERN.matcher(this.expression).matches()) {
            return this.expression;
        }
        int commas = 0;
        int seps = 0;
        String s = this.expression.trim();
        if (s.isEmpty()) {
            return null;
        }
        block5: for (char c : s.toCharArray()) {
            switch (c) {
                case '*': {
                    return null;
                }
                case ',': {
                    if (++commas > 1) {
                        return null;
                    }
                    if (seps < 2) continue block5;
                    return null;
                }
                case '(': 
                case ')': 
                case '[': 
                case ']': {
                    if (++seps <= 2) continue block5;
                    return null;
                }
                default: {
                    if (Character.isWhitespace(c) || seps < 2) continue block5;
                    return null;
                }
            }
        }
        if (seps == 0) {
            if (commas == 0) {
                if (VERSION_PART_PATTERN.matcher(this.expression).matches()) {
                    return this.expression.trim();
                }
            } else {
                String one;
                HashSet<String> all = new HashSet<String>(NBootUtils.split(s, ",", true, true));
                if (all.size() == 1 && VERSION_PART_PATTERN.matcher(one = (String)all.stream().findAny().get()).matches()) {
                    return one;
                }
            }
        } else if (seps == 2) {
            int o = s.charAt(0);
            int c = s.charAt(s.length() - 1);
            if (o == 40) {
                o = 93;
            }
            if (c == 41) {
                c = 91;
            }
            s = s.substring(1, s.length() - 1).trim();
            if (o == 91 && c == 93) {
                if (commas == 0) {
                    if (VERSION_PART_PATTERN.matcher(s).matches()) {
                        return s;
                    }
                } else {
                    String one;
                    HashSet<String> two = new HashSet<String>(NBootUtils.split(s, ",", true, false));
                    if (two.size() == 1 && VERSION_PART_PATTERN.matcher(one = (String)two.stream().findAny().get()).matches()) {
                        return one;
                    }
                }
            }
        }
        return null;
    }

    public boolean isSingleValue() {
        return this.asSingleValue() != null;
    }

    public boolean isFilter() {
        for (char c : this.expression.toCharArray()) {
            switch (c) {
                case '(': 
                case ')': 
                case '*': 
                case ',': 
                case '[': 
                case ']': {
                    return true;
                }
            }
        }
        return false;
    }

    public NBootVersion inc() {
        return this.inc(-1);
    }

    public NBootVersion inc(int index) {
        return this.inc(index, 1L);
    }

    public NBootVersion inc(int index, long amount) {
        return new NBootVersion(NBootVersion.incVersion(this.getValue(), index, amount));
    }

    public NBootVersion inc(int index, BigInteger amount) {
        return new NBootVersion(NBootVersion.incVersion(this.getValue(), index, amount));
    }

    public int size() {
        VersionParts parts = this.getParts();
        return parts.size();
    }

    public int numberSize() {
        return this.getParts().getDigitCount();
    }

    public String[] split() {
        VersionParts parts = this.getParts();
        int size = parts.size();
        String[] all = new String[size];
        for (int i = 0; i < size; ++i) {
            all[i] = parts.get((int)i).string;
        }
        return all;
    }

    public String get(int index) {
        VersionParts parts = this.getParts();
        int size = parts.size();
        if (index >= 0) {
            if (index < parts.size()) {
                return parts.get((int)index).string;
            }
        } else {
            int x = size + index;
            if (x >= 0 && x < parts.size()) {
                return parts.get((int)x).string;
            }
        }
        return null;
    }

    public String getNumber(int level) {
        VersionParts parts = this.getParts();
        int size = parts.getDigitCount();
        if (level >= 0) {
            VersionPart digit = parts.getDigit(level);
            return digit == null ? null : digit.string;
        }
        int x = size + level;
        VersionPart digit = x >= 0 ? parts.getDigit(x) : null;
        return digit == null ? null : digit.string;
    }

    private String toExplicitSingleValueOrNullString() {
        if (!this.isBlank() && !this.isFilter()) {
            return this.expression;
        }
        return null;
    }

    private VersionParts getParts() {
        if (this.parts == null) {
            this.parts = NBootVersion.splitVersionParts2(this.getValue());
        }
        return this.parts;
    }

    public int hashCode() {
        return this.expression != null ? this.expression.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NBootVersion version = (NBootVersion)o;
        return this.expression != null ? this.expression.equals(version.expression) : version.expression == null;
    }

    public String toString() {
        return this.expression == null ? "" : this.expression;
    }

    private static boolean isQualifierFrom(int i, VersionParts v1) {
        VersionPart a = v1.get(i);
        if (a.type == VersionPartType.SEPARATOR && a.string.equals("-")) {
            if (i + 1 < v1.size()) {
                block4: for (int j = i + 1; j < v1.size(); ++j) {
                    a = v1.get(j);
                    switch (a.type.ordinal()) {
                        case 2: {
                            if (!a.string.equals(".")) continue block4;
                            return false;
                        }
                        case 1: {
                            return true;
                        }
                        default: {
                            return false;
                        }
                    }
                }
                return true;
            }
            return true;
        }
        return false;
    }

    private static class VersionParts {
        List<VersionPart> all;

        public VersionParts(List<VersionPart> all) {
            this.all = all;
        }

        public VersionPart get(int index) {
            return this.all.get(index);
        }

        public int size() {
            return this.all.size();
        }

        public int getDigitCount() {
            int c = 0;
            for (VersionPart s : this.all) {
                if (s.type != VersionPartType.NUMBER) continue;
                ++c;
            }
            return c;
        }

        public VersionPart getDigit(int index) {
            int c = 0;
            for (VersionPart s : this.all) {
                if (s.type != VersionPartType.NUMBER) continue;
                if (c == index) {
                    return s;
                }
                ++c;
            }
            return null;
        }

        public void insertDigit(long val, String sep) {
            if (this.all.size() == 0) {
                this.all.add(new VersionPart(String.valueOf(val), VersionPartType.NUMBER));
            } else if (this.all.get((int)0).type == VersionPartType.NUMBER) {
                if (sep == null) {
                    sep = ".";
                }
                if (!sep.equals(".") && !sep.equals("-")) {
                    throw new IllegalArgumentException("illegal separator");
                }
                this.all.add(0, new VersionPart(sep, VersionPartType.SEPARATOR));
                this.all.add(0, new VersionPart(String.valueOf(val), VersionPartType.NUMBER));
            } else {
                this.all.add(0, new VersionPart(String.valueOf(val), VersionPartType.NUMBER));
            }
        }

        public void addDigit(BigInteger val, String sep) {
            if (this.all.size() == 0) {
                this.all.add(new VersionPart(String.valueOf(val), VersionPartType.NUMBER));
            } else if (this.all.get((int)(this.all.size() - 1)).type == VersionPartType.NUMBER) {
                if (sep == null) {
                    sep = ".";
                }
                if (!sep.equals(".") && !sep.equals("-")) {
                    throw new IllegalArgumentException("illegal separator");
                }
                this.all.add(new VersionPart(sep, VersionPartType.SEPARATOR));
                this.all.add(new VersionPart(String.valueOf(val), VersionPartType.NUMBER));
            } else {
                this.all.add(new VersionPart(String.valueOf(val), VersionPartType.NUMBER));
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (VersionPart versionPart : this.all) {
                sb.append(versionPart.string);
            }
            return sb.toString();
        }

        public int compareTo(VersionParts v2) {
            VersionParts v1 = this;
            int i = 0;
            for (int j = 0; i < v1.size() || j < v2.size(); ++i, ++j) {
                if (i < v1.size() && j < v2.size()) {
                    VersionPart b;
                    VersionPart a = v1.get(i);
                    int r = a.compareTo(b = v2.get(i));
                    if (r == 0) continue;
                    return r;
                }
                if (i < v1.size()) {
                    if (NBootVersion.isQualifierFrom(i, v1)) {
                        return -1;
                    }
                    return 1;
                }
                if (NBootVersion.isQualifierFrom(i, v2)) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }
    }

    private static class VersionPart {
        String string;
        VersionPartType type;

        public VersionPart(String string, VersionPartType type) {
            this.string = string;
            this.type = type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.string, this.type});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VersionPart that = (VersionPart)o;
            return this.string.equalsIgnoreCase(that.string) && this.type == that.type;
        }

        public String toString() {
            String name = this.type.name().toLowerCase();
            return name + "(" + this.string + ")";
        }

        public int compareTo(VersionPart v2) {
            VersionPart v1 = this;
            if (v1.equals(v2)) {
                return 0;
            }
            if (v1.type == VersionPartType.SEPARATOR && v2.type == VersionPartType.SEPARATOR) {
                if (v1.string.equals("-")) {
                    return -1;
                }
                return 1;
            }
            if (v1.type == VersionPartType.SEPARATOR) {
                return -1;
            }
            if (v2.type == VersionPartType.SEPARATOR) {
                return 1;
            }
            if (v1.type == VersionPartType.NUMBER && v2.type == VersionPartType.NUMBER) {
                return new BigInteger(v1.string).compareTo(new BigInteger(v2.string));
            }
            if (v1.type == VersionPartType.NUMBER) {
                return 1;
            }
            if (v2.type == VersionPartType.NUMBER) {
                return -1;
            }
            Integer q1 = NBootVersion.getKnownQualifierIndex(v1.string);
            Integer q2 = NBootVersion.getKnownQualifierIndex(v2.string);
            if (q1 != null && q2 != null) {
                return q1.compareTo(q2);
            }
            if (q1 != null) {
                return -1;
            }
            if (q2 != null) {
                return 1;
            }
            return v1.string.compareToIgnoreCase(v2.string);
        }
    }

    static enum VersionPartType {
        NUMBER,
        QAL,
        SEPARATOR;

    }

    public static class NVersionIntervalBoot
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean includeLowerBound;
        private final boolean includeUpperBound;
        private final String lowerBound;
        private final String upperBound;

        static NVersionIntervalBoot of(String s) {
            List<NVersionIntervalBoot> x = NVersionIntervalBoot.ofList(s);
            if (x.isEmpty()) {
                return null;
            }
            if (x.size() > 1) {
                throw new NBootException(NBootMsg.ofC("too many intervals"));
            }
            return x.get(0);
        }

        static List<NVersionIntervalBoot> ofList(String s) {
            return new NReservedVersionIntervalParserBoot().parse(s);
        }

        public NVersionIntervalBoot(boolean inclusiveLowerBoundary, boolean inclusiveUpperBoundary, String min, String max) {
            this.includeLowerBound = inclusiveLowerBoundary;
            this.includeUpperBound = inclusiveUpperBoundary;
            this.lowerBound = NBootUtils.trimToNull(min);
            this.upperBound = NBootUtils.trimToNull(max);
        }

        public boolean acceptVersion(NBootVersion version) {
            int t;
            if (!(NBootUtils.isBlank(this.lowerBound) || this.lowerBound.equals("LATEST") || this.lowerBound.equals("RELEASE"))) {
                t = version.compareTo(this.lowerBound);
                if (this.includeLowerBound && t < 0 || !this.includeLowerBound && t <= 0) {
                    return false;
                }
            }
            if (!(NBootUtils.isBlank(this.upperBound) || this.upperBound.equals("LATEST") || this.upperBound.equals("RELEASE"))) {
                t = version.compareTo(this.upperBound);
                return !(this.includeUpperBound && t > 0 || !this.includeUpperBound && t >= 0);
            }
            return true;
        }

        public boolean isFixedValue() {
            return this.includeLowerBound && this.includeUpperBound && NBootUtils.trim(this.lowerBound).equals(NBootUtils.trim(this.upperBound)) && !"LATEST".equals(this.lowerBound) && !"RELEASE".equals(this.lowerBound);
        }

        public boolean isIncludeLowerBound() {
            return this.includeLowerBound;
        }

        public boolean isIncludeUpperBound() {
            return this.includeUpperBound;
        }

        public String getLowerBound() {
            return this.lowerBound;
        }

        public String getUpperBound() {
            return this.upperBound;
        }

        public String toString() {
            String lb;
            String ub = this.upperBound == null ? "" : this.upperBound;
            boolean sameBound = ub.equals(lb = this.lowerBound == null ? "" : this.lowerBound);
            if (sameBound && !lb.isEmpty()) {
                return (this.includeLowerBound ? "[" : "]") + lb + (this.includeUpperBound ? "]" : "[");
            }
            return (this.includeLowerBound ? "[" : "]") + lb + "," + ub + (this.includeUpperBound ? "]" : "[");
        }
    }

    public static class NReservedVersionIntervalParserBoot {
        final int NEXT = 1;
        final int NEXT_COMMA = 2;
        final int EXPECT_V1 = 3;
        final int EXPECT_V_COMMA = 4;
        final int EXPECT_V2 = 5;
        final int EXPECT_CLOSE = 6;
        int t;
        int state = 1;
        int open = -1;
        int close = -1;
        String v1 = null;
        String v2 = null;
        List<NVersionIntervalBoot> dd = new ArrayList<NVersionIntervalBoot>();

        void reset() {
            this.open = -1;
            this.close = -1;
            this.v1 = null;
            this.v2 = null;
        }

        void addNextValue(String sval) {
            if (sval.endsWith("*")) {
                String min = sval.substring(0, sval.length() - 1);
                if (min.equals("")) {
                    this.dd.add(new NVersionIntervalBoot(false, false, min, null));
                } else {
                    String max = NBootVersion.of(min).inc(-1).getValue();
                    this.dd.add(new NVersionIntervalBoot(true, false, min, max));
                }
            } else {
                this.dd.add(new NVersionIntervalBoot(true, true, sval, sval));
            }
        }

        void addNextInterval() {
            boolean inclusiveLowerBoundary = this.open == 91 && this.v1 != null;
            boolean inclusiveUpperBoundary = this.close == 93 && this.v2 != null;
            this.dd.add(new NVersionIntervalBoot(inclusiveLowerBoundary, inclusiveUpperBoundary, this.v1, this.v2));
            this.reset();
        }

        public List<NVersionIntervalBoot> parse(String version) {
            StreamTokenizer st = new StreamTokenizer(new StringReader(version));
            st.resetSyntax();
            st.whitespaceChars(0, 32);
            block37: for (int i = 33; i < 256; ++i) {
                switch ((char)i) {
                    case '(': 
                    case ')': 
                    case ',': 
                    case '[': 
                    case ']': {
                        continue block37;
                    }
                    default: {
                        st.wordChars(i, i);
                    }
                }
            }
            try {
                block38: while ((this.t = st.nextToken()) != -1) {
                    switch (this.state) {
                        case 1: {
                            switch (this.t) {
                                case -3: {
                                    this.addNextValue(st.sval);
                                    this.state = 2;
                                    continue block38;
                                }
                                case 40: 
                                case 91: 
                                case 93: {
                                    this.open = this.t;
                                    this.state = 3;
                                    continue block38;
                                }
                                case 44: {
                                    continue block38;
                                }
                            }
                            throw new NBootException(NBootMsg.ofC("unexpected  %s", Character.valueOf((char)this.t)));
                        }
                        case 2: {
                            switch (this.t) {
                                case 44: {
                                    this.state = 1;
                                    continue block38;
                                }
                            }
                            throw new NBootException(NBootMsg.ofC("unexpected ',' found %s", Character.valueOf((char)this.t)));
                        }
                        case 3: {
                            switch (this.t) {
                                case -3: {
                                    this.v1 = st.sval;
                                    this.state = 4;
                                    continue block38;
                                }
                                case 44: {
                                    this.state = 5;
                                    continue block38;
                                }
                            }
                            throw new NBootException(NBootMsg.ofC("unexpected  %s", Character.valueOf((char)this.t)));
                        }
                        case 4: {
                            switch (this.t) {
                                case 44: {
                                    this.state = 5;
                                    continue block38;
                                }
                                case 93: {
                                    this.close = this.t;
                                    this.v2 = this.v1;
                                    this.addNextInterval();
                                    this.state = 2;
                                    continue block38;
                                }
                                case 41: 
                                case 91: {
                                    this.close = this.t;
                                    this.v2 = this.v1;
                                    this.addNextInterval();
                                    this.state = 2;
                                    continue block38;
                                }
                            }
                            throw new NBootException(NBootMsg.ofC("unexpected  %s", Character.valueOf((char)this.t)));
                        }
                        case 5: {
                            switch (this.t) {
                                case -3: {
                                    this.v2 = st.sval;
                                    this.state = 6;
                                    continue block38;
                                }
                                case 41: 
                                case 91: 
                                case 93: {
                                    this.close = this.t;
                                    this.addNextInterval();
                                    this.state = 2;
                                    continue block38;
                                }
                            }
                            throw new NBootException(NBootMsg.ofC("unexpected  %s", Character.valueOf((char)this.t)));
                        }
                        case 6: {
                            switch (this.t) {
                                case 41: 
                                case 91: 
                                case 93: {
                                    this.close = this.t;
                                    this.addNextInterval();
                                    this.state = 2;
                                    continue block38;
                                }
                            }
                            throw new NBootException(NBootMsg.ofC("unexpected  %s", Character.valueOf((char)this.t)));
                        }
                    }
                    throw new NBootException(NBootMsg.ofC("unsupported state %s", this.state));
                }
                if (this.state != 2 && this.state != 1) {
                    throw new NBootException(NBootMsg.ofC("invalid state %s", this.state));
                }
            }
            catch (IOException ex) {
                throw new NBootException(NBootMsg.ofC("parse version failed: %s : ", version, ex));
            }
            return this.dd;
        }
    }
}

