/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot.internal.cmdline;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.boot.NBootHomeLocation;
import net.thevpc.nuts.boot.NBootLogConfig;
import net.thevpc.nuts.boot.NBootOptionsInfo;
import net.thevpc.nuts.boot.NBootVersion;
import net.thevpc.nuts.boot.internal.cmdline.NBootCmdLine;
import net.thevpc.nuts.boot.internal.cmdline.NBootWorkspaceOptionsConfig;
import net.thevpc.nuts.boot.internal.util.NBootPlatformHome;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public class NBootWorkspaceCmdLineFormatter {
    private static final String V080 = "0.8.0";
    private static final String V081 = "0.8.1";
    private static final String V083 = "0.8.3";
    private static final String V084 = "0.8.4";
    private static final String V085 = "0.8.5";
    private NBootWorkspaceOptionsConfig config;
    private NBootOptionsInfo options;

    public NBootWorkspaceCmdLineFormatter(NBootWorkspaceOptionsConfig config, NBootOptionsInfo options) {
        this.config = config;
        this.options = options;
    }

    private void fillOption(String longName, String shortName, List<String> values, String sep, List<String> arguments, boolean forceSingle) {
        if (values != null && values.size() > 0) {
            this.fillOption0(this.selectOptionName(longName, shortName), String.join((CharSequence)sep, values), arguments, forceSingle);
        }
    }

    private void fillOption(String longName, String shortName, String[] values, String sep, List<String> arguments, boolean forceSingle) {
        if (values != null && values.length > 0) {
            this.fillOption0(this.selectOptionName(longName, shortName), String.join((CharSequence)sep, values), arguments, forceSingle);
        }
    }

    private void fillOption(String longName, String shortName, Boolean value, boolean defaultValue, List<String> arguments, boolean forceSingle) {
        if (value != null) {
            if (defaultValue) {
                if (!value.booleanValue()) {
                    if (this.config.isShortOptions() && shortName != null) {
                        arguments.add("-!" + shortName.substring(1));
                    } else if (longName.startsWith("---")) {
                        arguments.add("---!" + longName.substring(3));
                    } else {
                        arguments.add("--!" + longName.substring(2));
                    }
                }
            } else if (value.booleanValue()) {
                arguments.add(this.selectOptionName(longName, shortName));
            }
        }
    }

    private void fillOption(String longName, String shortName, char[] value, List<String> arguments, boolean forceSingle) {
        if (value != null && new String(value).isEmpty()) {
            this.fillOption0(this.selectOptionName(longName, shortName), new String(value), arguments, forceSingle);
        }
    }

    private void fillOption(String longName, String shortName, String value, List<String> arguments, boolean forceSingle) {
        if (!NBootUtils.isBlank(value)) {
            this.fillOption0(this.selectOptionName(longName, shortName), value, arguments, forceSingle);
        }
    }

    private void fillOption(String longName, String shortName, int value, List<String> arguments, boolean forceSingle) {
        if (value > 0) {
            this.fillOption0(this.selectOptionName(longName, shortName), String.valueOf(value), arguments, forceSingle);
        }
    }

    private void fillOptionEnum(String longName, String shortName, String value, String enumType, List<String> arguments, boolean forceSingle) {
        if (this.tryFillOptionShortEnum(value, enumType, arguments, forceSingle)) {
            return;
        }
        if (value != null) {
            if (this.config.isShortOptions()) {
                if ("NOsFamily".equals(enumType)) {
                    switch (NBootUtils.enumName(value)) {
                        case "LINUX": {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("linux", "l"), arguments, forceSingle);
                            return;
                        }
                        case "WINDOWS": {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("windows", "w"), arguments, forceSingle);
                            return;
                        }
                        case "MACOS": {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("macos", "m"), arguments, forceSingle);
                            return;
                        }
                        case "UNIX": {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("unix", "u"), arguments, forceSingle);
                            return;
                        }
                        case "UNKNOWN": {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("unknown", "x"), arguments, forceSingle);
                            return;
                        }
                    }
                } else if ("NStoreStrategy".equals(enumType)) {
                    switch (NBootUtils.enumName(value)) {
                        case "EXPLODED": {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("exploded", "e"), arguments, forceSingle);
                            return;
                        }
                        case "STANDALONE": {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("standalone", "s"), arguments, forceSingle);
                            return;
                        }
                    }
                } else if ("NTerminalMode".equals(enumType)) {
                    switch (NBootUtils.enumName(value)) {
                        case "FILTERED": {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("no", "n"), arguments, forceSingle);
                            return;
                        }
                        case "INHERITED": {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("inherited", "h"), arguments, forceSingle);
                            return;
                        }
                        case "FORMATTED": {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("yes", "y"), arguments, forceSingle);
                            return;
                        }
                        case "DEFAULT": {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("default", null), arguments, forceSingle);
                            return;
                        }
                    }
                }
            }
            if ("NSupportMode".equals(enumType) && !this.isApiVersionOrAfter(V084)) {
                switch (NBootUtils.enumName(value)) {
                    case "ALWAYS": {
                        this.fillOption0(this.selectOptionName(longName, shortName), "preferred", arguments, forceSingle);
                        return;
                    }
                    case "NEVER": {
                        this.fillOption0(this.selectOptionName(longName, shortName), "unsupported", arguments, forceSingle);
                        return;
                    }
                }
            }
            this.fillOption0(this.selectOptionName(longName, shortName), value.toString().toLowerCase(), arguments, forceSingle);
        }
    }

    private boolean fillOptionEnumRunAs(String value, List<String> arguments) {
        if (value == null) {
            return false;
        }
        switch (NBootUtils.enumName(value)) {
            case "CURRENT_USER": {
                if (this.isApiVersionOrAfter(V081)) {
                    if (!this.config.isOmitDefaults()) {
                        arguments.add("--current-user");
                    }
                } else {
                    arguments.add("--user-cmd");
                }
                return true;
            }
            case "ROOT": {
                if (this.isApiVersionOrAfter(V081)) {
                    arguments.add("--as-root");
                } else {
                    arguments.add("--root-cmd");
                }
                return true;
            }
            case "SUDO": {
                if (this.isApiVersionOrAfter(V081)) {
                    arguments.add("--sudo");
                }
                return true;
            }
        }
        if (value.toUpperCase().startsWith("USER:")) {
            String user = value.substring("USER:".length());
            if (this.isApiVersionOrAfter(V081)) {
                arguments.add("--run-as=" + user);
            }
            return true;
        }
        throw new UnsupportedOperationException("unsupported RunAs : " + value);
    }

    private boolean tryFillOptionShortEnum(String value, String enumType, List<String> arguments, boolean forceSingle) {
        if (value != null && this.config.isShortOptions()) {
            if ("NOpenMode".equals(enumType)) {
                switch (NBootUtils.enumName(value)) {
                    case "OPEN_OR_ERROR": {
                        this.fillOption0(this.selectOptionName("--open-mode", "-o"), this.selectOptionVal("open-or-error", "r"), arguments, forceSingle);
                        return true;
                    }
                    case "CREATE_OR_ERROR": {
                        this.fillOption0(this.selectOptionName("--open-mode", "-o"), this.selectOptionVal("create-or-error", "w"), arguments, forceSingle);
                        return true;
                    }
                    case "OPEN_OR_CREATE": {
                        if (!this.config.isOmitDefaults()) {
                            this.fillOption0(this.selectOptionName("--open-mode", "-o"), this.selectOptionVal("open-or-create", "rw"), arguments, forceSingle);
                        }
                        return true;
                    }
                    case "OPEN_OR_NULL": {
                        this.fillOption0(this.selectOptionName("--open-mode", "-o"), this.selectOptionVal("open-or-null", "on"), arguments, forceSingle);
                        return true;
                    }
                }
            }
            if ("NExecutionType".equals(enumType)) {
                switch (NBootUtils.enumName(value)) {
                    case "SYSTEM": {
                        if (this.isApiVersionOrAfter(V081)) {
                            arguments.add("--system");
                        } else {
                            arguments.add("--user-cmd");
                        }
                        return true;
                    }
                    case "EMBEDDED": {
                        arguments.add(this.selectOptionName("--embedded", "-b"));
                        return true;
                    }
                    case "SPAWN": {
                        if (!this.config.isOmitDefaults()) {
                            arguments.add(this.selectOptionName("--spawn", "-x"));
                        }
                        return true;
                    }
                    case "OPEN": {
                        arguments.add(this.selectOptionName("--open-file", "--open-file"));
                        return true;
                    }
                }
            }
            if ("NConfirmationMode".equals(enumType)) {
                switch (NBootUtils.enumName(value)) {
                    case "YES": {
                        arguments.add(this.selectOptionName("--yes", "-y"));
                        return true;
                    }
                    case "NO": {
                        arguments.add(this.selectOptionName("-no", "-n"));
                        return true;
                    }
                    case "ASK": {
                        if (this.config.isOmitDefaults()) break;
                        arguments.add("--ask");
                        return true;
                    }
                    case "ERROR": {
                        arguments.add("--error");
                        return true;
                    }
                }
            }
            if ("NTerminalMode".equals(enumType)) {
                switch (NBootUtils.enumName(value)) {
                    case "FILTERED": {
                        if (this.isApiVersionOrAfter(V084)) {
                            arguments.add("--color=filtered");
                        } else {
                            arguments.add(this.selectOptionName("--!color", "-!c"));
                        }
                        return true;
                    }
                    case "FORMATTED": {
                        arguments.add(this.selectOptionName("--color", "-c"));
                        return true;
                    }
                    case "INHERITED": {
                        arguments.add(this.selectOptionName("--color=inherited", "-c=h"));
                        return true;
                    }
                    case "ANSI": {
                        arguments.add(this.selectOptionName("--color=ansi", "-c=a"));
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void fillOptionEnum(String value, String enumType, List<String> arguments, boolean forceSingle) {
        if (value != null) {
            if (this.tryFillOptionShortEnum(value, enumType, arguments, forceSingle)) {
                return;
            }
            arguments.add("--" + NBootUtils.enumId(value));
        }
    }

    private String selectOptionVal(String longName, String shortName) {
        if (this.config.isShortOptions()) {
            return shortName;
        }
        return longName;
    }

    private String selectOptionName(String longName, String shortName) {
        if (this.config.isShortOptions() && shortName != null) {
            return shortName;
        }
        return longName;
    }

    private void fillOption0(String name, String value, List<String> arguments, boolean forceSingle) {
        if (this.config.isSingleArgOptions() || forceSingle) {
            arguments.add(name + "=" + value);
        } else {
            arguments.add(name);
            arguments.add(value);
        }
    }

    public NBootCmdLine toCmdLine() {
        NBootLogConfig logConfig;
        ArrayList<String> arguments = new ArrayList<String>();
        this.fillOption("--java", "-j", this.options.getJavaCommand(), arguments, false);
        this.fillOption("--java-options", "-O", this.options.getJavaOptions(), arguments, false);
        String wsString = this.options.getWorkspace();
        if (NBootUtils.isBlank(wsString)) {
            wsString = "";
        } else if (wsString.contains("/") || wsString.contains("\\")) {
            wsString = new File(wsString).toPath().toAbsolutePath().normalize().toString();
        }
        this.fillOption("--workspace", "-w", wsString, arguments, false);
        this.fillOption("--user", "-u", this.options.getUserName(), arguments, false);
        this.fillOption("--password", "-p", this.options.getCredentials(), arguments, false);
        this.fillOption("--boot-version", "-V", this.options.getApiVersion(), arguments, false);
        this.fillOption("--boot-runtime", null, this.options.getRuntimeId(), arguments, false);
        String nTerminalMode = this.options.getTerminalMode();
        if (!this.isApiVersionOrAfter(V084) && NBootUtils.firstNonNull(this.options.getBot(), false).booleanValue()) {
            nTerminalMode = "FILTERED";
        }
        if (!this.config.isOmitDefaults() || !NBootUtils.sameEnum(nTerminalMode, "FORMATTED")) {
            this.fillOptionEnum("--color", "-c", nTerminalMode, "NTerminalMode", arguments, true);
        }
        if ((logConfig = this.options.getLogConfig()) != null) {
            if (logConfig.getLogTermLevel() != null && logConfig.getLogTermLevel() == logConfig.getLogFileLevel()) {
                this.fillOption("--log-" + logConfig.getLogFileLevel().toString().toLowerCase(), null, true, false, arguments, false);
            } else {
                if (logConfig.getLogTermLevel() != null) {
                    this.fillOption("--log-term-" + logConfig.getLogTermLevel().toString().toLowerCase(), null, true, false, arguments, false);
                }
                if (logConfig.getLogFileLevel() != null) {
                    this.fillOption("--log-file-" + logConfig.getLogFileLevel().toString().toLowerCase(), null, true, false, arguments, false);
                }
            }
            if (logConfig.getLogFileCount() > 0) {
                this.fillOption("--log-file-count", null, String.valueOf(logConfig.getLogFileCount()), arguments, false);
            }
            this.fillOption("--log-file-size", null, logConfig.getLogFileSize(), arguments, false);
            this.fillOption("--log-file-base", null, logConfig.getLogFileBase(), arguments, false);
            this.fillOption("--log-file-name", null, logConfig.getLogFileName(), arguments, false);
        }
        this.fillOption("--exclude-extension", "-X", this.options.getExcludedExtensions(), ";", arguments, false);
        this.fillOption("--repositories", "-r", this.options.getRepositories(), ";", arguments, false);
        if (this.isApiVersionOrAfter(V085)) {
            this.fillOption("--boot-repositories", null, this.options.getBootRepositories(), ";", arguments, false);
        }
        this.fillOption("--global", "-g", this.options.getSystem(), false, arguments, false);
        this.fillOption("--gui", null, this.options.getGui(), false, arguments, false);
        this.fillOption("--read-only", "-R", this.options.getReadOnly(), false, arguments, false);
        this.fillOption("--trace", "-t", this.options.getTrace(), true, arguments, false);
        this.fillOption("--progress", "-P", this.options.getProgressOptions(), arguments, true);
        this.fillOption("--solver", null, this.options.getDependencySolver(), arguments, false);
        if (this.isApiVersionOrAfter(V083)) {
            this.fillOption("--debug", null, this.options.getDebug(), arguments, true);
        } else {
            this.fillOption("--debug", null, this.options.getDebug() != null, false, arguments, true);
        }
        this.fillOption("--install-companions", "-k", this.options.getInstallCompanions(), false, arguments, false);
        this.fillOption("--skip-welcome", "-K", NBootUtils.firstNonNull(this.options.getSkipWelcome(), false), false, arguments, false);
        this.fillOption("--out-line-prefix", null, this.options.getOutLinePrefix(), arguments, false);
        this.fillOption("--skip-boot", "-Q", this.options.getSkipBoot(), false, arguments, false);
        this.fillOption("--cached", null, this.options.getCached(), true, arguments, false);
        this.fillOption("--indexed", null, this.options.getIndexed(), true, arguments, false);
        this.fillOption("--transitive", null, this.options.getTransitive(), true, arguments, false);
        if (this.isApiVersionOrAfter(V081)) {
            this.fillOption("--bot", "-B", this.options.getBot(), false, arguments, false);
        }
        if (this.isApiVersionOrAfter(V085)) {
            this.fillOption("--preview-repo", "-U", this.options.getPreviewRepo(), false, arguments, false);
            this.fillOption("--shared-instance", null, this.options.getSharedInstance(), false, arguments, false);
        }
        if (this.options.getFetchStrategy() != null && NBootUtils.sameEnum(this.options.getFetchStrategy(), "ONLINE")) {
            this.fillOptionEnum("--fetch", "-f", this.options.getFetchStrategy(), "NFetchStrategy", arguments, false);
        }
        this.fillOptionEnum(this.options.getConfirm(), "NConfirmationMode", arguments, false);
        this.fillOptionEnum(this.options.getOutputFormat(), "NContentType", arguments, false);
        if (this.options.getOutputFormatOptions() != null) {
            for (String string : this.options.getOutputFormatOptions()) {
                this.fillOption("--output-format-option", "-T", string, arguments, false);
            }
        }
        if (this.isApiVersionOrAfter(V080)) {
            this.fillOption("--expire", "-N", this.options.getExpireTime() == null ? null : this.options.getExpireTime().toString(), arguments, false);
            if (this.options.getOutLinePrefix() != null && Objects.equals(this.options.getOutLinePrefix(), this.options.getErrLinePrefix()) && this.options.getOutLinePrefix().length() > 0) {
                this.fillOption("--line-prefix", null, this.options.getOutLinePrefix(), arguments, false);
            } else {
                if (this.options.getOutLinePrefix() != null && this.options.getOutLinePrefix().length() > 0) {
                    this.fillOption("--out-line-prefix", null, this.options.getOutLinePrefix(), arguments, false);
                }
                if (this.options.getErrLinePrefix() != null && this.options.getErrLinePrefix().length() > 0) {
                    this.fillOption("--err-line-prefix", null, this.options.getErrLinePrefix(), arguments, false);
                }
            }
        }
        if (this.isApiVersionOrAfter(V081)) {
            this.fillOption("--theme", null, this.options.getTheme(), arguments, false);
        }
        if (this.isApiVersionOrAfter(V081)) {
            this.fillOption("--locale", "-L", this.options.getLocale(), arguments, false);
        }
        if (this.isApiVersionOrAfter(V084)) {
            this.fillOption("--init-launchers", null, this.options.getInitLaunchers(), true, arguments, false);
            this.fillOption("--init-platforms", null, this.options.getInitLaunchers(), true, arguments, false);
            this.fillOption("--init-java", null, this.options.getInitLaunchers(), true, arguments, false);
            this.fillOption("--init-scripts", null, this.options.getInitLaunchers(), true, arguments, false);
            this.fillOptionEnum("--desktop-launcher", null, this.options.getDesktopLauncher(), "NSupportMode", arguments, false);
            this.fillOptionEnum("--menu-launcher", null, this.options.getDesktopLauncher(), "NSupportMode", arguments, false);
            this.fillOptionEnum("--user-launcher", null, this.options.getDesktopLauncher(), "NSupportMode", arguments, false);
            this.fillOptionEnum("--isolation-level", null, this.options.getIsolationLevel(), "NIsolationLevel", arguments, false);
        } else if (this.isApiVersionOrAfter(V081)) {
            this.fillOption("---init-launchers", null, this.options.getInitLaunchers(), true, arguments, false);
            this.fillOption("---init-platforms", null, this.options.getInitLaunchers(), true, arguments, false);
            this.fillOption("---init-java", null, this.options.getInitLaunchers(), true, arguments, false);
            this.fillOption("---init-scripts", null, this.options.getInitLaunchers(), true, arguments, false);
            this.fillOptionEnum("---system-desktop-launcher", null, this.options.getDesktopLauncher(), "NSupportMode", arguments, false);
            this.fillOptionEnum("---system-menu-launcher", null, this.options.getDesktopLauncher(), "NSupportMode", arguments, false);
            this.fillOptionEnum("---system-custom-launcher", null, this.options.getDesktopLauncher(), "NSupportMode", arguments, false);
        }
        this.fillOption("--name", null, NBootUtils.trim(this.options.getName()), arguments, false);
        this.fillOption("--archetype", "-A", this.options.getArchetype(), arguments, false);
        this.fillOptionEnum("--store-layout", null, this.options.getStoreLayout(), "NOsFamily", arguments, false);
        this.fillOptionEnum("--store-strategy", null, this.options.getStoreStrategy(), "NStoreStrategy", arguments, false);
        this.fillOptionEnum("--repo-store-strategy", null, this.options.getRepositoryStoreStrategy(), "NStoreStrategy", arguments, false);
        Map<String, String> storeLocations = this.options.getStoreLocations();
        if (storeLocations == null) {
            storeLocations = new HashMap<String, String>();
        }
        for (String location : NBootPlatformHome.storeTypes()) {
            String s = storeLocations.get(location);
            if (NBootUtils.isBlank(s)) continue;
            this.fillOption("--" + NBootUtils.enumId(location) + "-location", null, s, arguments, false);
        }
        Map<NBootHomeLocation, String> map = this.options.getHomeLocations();
        if (map != null) {
            for (String location : NBootPlatformHome.storeTypes()) {
                String s = map.get(NBootHomeLocation.of(null, location));
                if (NBootUtils.isBlank(s)) continue;
                this.fillOption("--system-" + NBootUtils.enumId(location) + "-home", null, s, arguments, false);
            }
            for (String osFamily : NBootPlatformHome.osFamilies()) {
                for (String location : NBootPlatformHome.storeTypes()) {
                    String s = map.get(NBootHomeLocation.of(osFamily, location));
                    if (NBootUtils.isBlank(s)) continue;
                    this.fillOption("--" + NBootUtils.enumId(osFamily) + "-" + NBootUtils.enumId(location) + "-home", null, s, arguments, false);
                }
            }
        }
        if (this.isApiVersionOrAfter(V080) && this.options.getSwitchWorkspace() != null) {
            this.fillOption("--switch", null, this.options.getSwitchWorkspace(), false, arguments, false);
        }
        this.fillOption("--help", "-h", NBootUtils.firstNonNull(this.options.getCommandHelp(), false), false, arguments, false);
        this.fillOption("--version", "-v", NBootUtils.firstNonNull(this.options.getCommandVersion(), false), false, arguments, false);
        if (!(this.config.isOmitDefaults() && this.options.getOpenMode() == null || NBootUtils.sameEnum(this.options.getOpenMode(), "OPEN_OR_CREATE"))) {
            this.fillOptionEnum(this.options.getOpenMode(), "NOpenMode", arguments, false);
        }
        this.fillOptionEnum(this.options.getExecutionType(), "NExecutionType", arguments, false);
        this.fillOptionEnumRunAs(this.options.getRunAs(), arguments);
        this.fillOption("--reset", "-Z", this.options.getReset(), false, arguments, false);
        this.fillOption("--recover", "-z", this.options.getRecover(), false, arguments, false);
        this.fillOption("--dry", "-D", this.options.getDry(), false, arguments, false);
        if (this.isApiVersionOrAfter(V085)) {
            this.fillOption("--reset-hard", null, this.options.getResetHard(), false, arguments, false);
        }
        if (this.isApiVersionOrAfter(V084)) {
            this.fillOption("--stacktrace", null, this.options.getShowStacktrace(), false, arguments, false);
        }
        if (this.isApiVersionOrAfter(V081) && this.options.getCustomOptions() != null) {
            arguments.addAll(NBootUtils.nonNullStrList(this.options.getCustomOptions()));
        }
        if (!this.config.isOmitDefaults() && !NBootUtils.isEmptyList(this.options.getApplicationArguments()) || !NBootUtils.nonNullStrList(this.options.getExecutorOptions()).isEmpty()) {
            arguments.add(this.selectOptionName("--exec", "-e"));
        }
        arguments.addAll(NBootUtils.nonNullStrList(this.options.getExecutorOptions()));
        arguments.addAll(NBootUtils.nonNullStrList(this.options.getApplicationArguments()));
        return new NBootCmdLine(arguments);
    }

    private boolean isApiVersionOrAfter(String version) {
        String apiVersionStr = this.config.getApiVersion();
        if (apiVersionStr == null) {
            return true;
        }
        NBootVersion apiVersionObj = NBootVersion.of(apiVersionStr);
        return apiVersionObj.compareTo(version) >= 0;
    }
}

