/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot.internal.compat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.thevpc.nuts.boot.NBootException;
import net.thevpc.nuts.boot.NBootHomeLocation;
import net.thevpc.nuts.boot.NBootOptionsInfo;
import net.thevpc.nuts.boot.internal.util.NBootBootConfigLoader;
import net.thevpc.nuts.boot.internal.util.NBootLog;
import net.thevpc.nuts.boot.internal.util.NBootMsg;
import net.thevpc.nuts.boot.internal.util.NBootPlatformHome;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public class NReservedBootConfigLoaderOld {
    public static void loadConfigVersion507(NBootOptionsInfo config, Map<String, Object> jsonObject, NBootLog bLog) {
        bLog.with().level(Level.CONFIG).verbNotice().log(NBootMsg.ofPlain("config version compatibility : 0.5.7"));
        config.setUuid((String)jsonObject.get("uuid"));
        config.setName((String)jsonObject.get("name"));
        config.setWorkspace((String)jsonObject.get("workspace"));
        config.setJavaCommand((String)jsonObject.get("javaCommand"));
        config.setJavaOptions((String)jsonObject.get("javaOptions"));
        config.setHomeLocations(NBootBootConfigLoader.asNutsHomeLocationMap((Map)jsonObject.get("homeLocations")));
        config.setStoreLocations(NBootBootConfigLoader.asNutsStoreLocationMap((Map)jsonObject.get("storeLocations")));
        config.setStoreStrategy((String)jsonObject.get("storeLocationStrategy"));
        config.setStoreLayout((String)jsonObject.get("storeLocationLayout"));
        config.setRepositoryStoreStrategy((String)jsonObject.get("repositoryStoreLocationStrategy"));
        if (jsonObject.get("bootRepositories") == null) {
            config.setBootRepositories(null);
        } else if (jsonObject.get("bootRepositories") instanceof List) {
            config.setBootRepositories((List)jsonObject.get("bootRepositories"));
        } else if (jsonObject.get("bootRepositories") instanceof String) {
            config.setBootRepositories(new ArrayList<String>(Arrays.asList((String)jsonObject.get("bootRepositories"))));
        }
        List extensions = (List)jsonObject.get("extensions");
        if (extensions != null) {
            LinkedHashSet<String> extSet = new LinkedHashSet<String>();
            for (Map extension : extensions) {
                String eid = (String)extension.get("id");
                Boolean enabled = (Boolean)extension.get("enabled");
                if (enabled == null || !enabled.booleanValue()) continue;
                extSet.add(eid);
            }
            config.setExtensionsSet(extSet);
        } else {
            config.setExtensionsSet(new HashSet<String>());
        }
    }

    public static void loadConfigVersion506(NBootOptionsInfo config, Map<String, Object> jsonObject, NBootLog bLog) {
        bLog.with().level(Level.CONFIG).verbNotice().log(NBootMsg.ofPlain("config version compatibility : 0.5.6"));
        config.setUuid((String)jsonObject.get("uuid"));
        config.setName((String)jsonObject.get("name"));
        config.setWorkspace((String)jsonObject.get("workspace"));
        config.setApiVersion((String)jsonObject.get("apiVersion"));
        config.setRuntimeId((String)jsonObject.get("runtimeId"));
        config.setJavaCommand((String)jsonObject.get("javaCommand"));
        config.setJavaOptions((String)jsonObject.get("javaOptions"));
        config.setStoreLocations(NBootBootConfigLoader.asNutsStoreLocationMap((Map)jsonObject.get("storeLocations")));
        config.setHomeLocations(NBootBootConfigLoader.asNutsHomeLocationMap((Map)jsonObject.get("homeLocations")));
        String s = (String)jsonObject.get("storeLocationStrategy");
        if (s != null && s.length() > 0) {
            config.setStoreStrategy(s.toUpperCase());
        }
        if ((s = (String)jsonObject.get("repositoryStoreLocationStrategy")) != null && s.length() > 0) {
            config.setRepositoryStoreStrategy(s.toUpperCase());
        }
        if ((s = (String)jsonObject.get("storeLocationLayout")) != null && s.length() > 0) {
            config.setStoreLayout(s.toUpperCase());
        }
    }

    public static void loadConfigVersion502(NBootOptionsInfo config, Map<String, Object> jsonObject, NBootLog bLog) {
        bLog.with().level(Level.CONFIG).verbNotice().log(NBootMsg.ofPlain("config version compatibility : 0.5.2"));
        config.setUuid((String)jsonObject.get("uuid"));
        config.setName((String)jsonObject.get("name"));
        config.setWorkspace((String)jsonObject.get("workspace"));
        config.setApiVersion((String)jsonObject.get("bootApiVersion"));
        config.setRuntimeId((String)jsonObject.get("bootRuntime"));
        config.setJavaCommand((String)jsonObject.get("bootJavaCommand"));
        config.setJavaOptions((String)jsonObject.get("bootJavaOptions"));
        LinkedHashMap<String, String> storeLocations = new LinkedHashMap<String, String>();
        LinkedHashMap<NBootHomeLocation, String> homeLocations = new LinkedHashMap<NBootHomeLocation, String>();
        String[] stringArray = NBootPlatformHome.storeTypes();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String folder;
            String folderName502 = folder = stringArray[i];
            if (NBootUtils.sameEnum(folder, "BIN")) {
                folderName502 = "programs";
            }
            String k = folderName502.toLowerCase() + "StoreLocation";
            String v = (String)jsonObject.get(k);
            storeLocations.put(folder, v);
            k = folderName502.toLowerCase() + "SystemHome";
            v = (String)jsonObject.get(k);
            homeLocations.put(NBootHomeLocation.of(null, folder), v);
            String[] stringArray2 = NBootPlatformHome.osFamilies();
            int n2 = stringArray2.length;
            for (int j = 0; j < n2; ++j) {
                String osFamily;
                switch (osFamily = stringArray2[j]) {
                    case "MACOS": {
                        k = folderName502.toLowerCase() + "MacOsHome";
                        break;
                    }
                    case "LINUX": 
                    case "UNIX": 
                    case "WINDOWS": 
                    case "UNKNOWN": {
                        k = folderName502.toLowerCase() + NBootUtils.enumTitle(osFamily) + "Home";
                        break;
                    }
                    default: {
                        throw new NBootException(NBootMsg.ofC("unsupported os-family %s", osFamily));
                    }
                }
                v = (String)jsonObject.get(k);
                homeLocations.put(NBootHomeLocation.of(osFamily, folder), v);
            }
        }
        config.setHomeLocations(homeLocations);
        config.setStoreLocations(storeLocations);
        String s = (String)jsonObject.get("storeLocationStrategy");
        if (s != null && s.length() > 0) {
            config.setStoreStrategy(s.toUpperCase());
        }
        if ((s = (String)jsonObject.get("repositoryStoreLocationStrategy")) != null && s.length() > 0) {
            config.setRepositoryStoreStrategy(s.toUpperCase());
        }
        if ((s = (String)jsonObject.get("storeLocationLayout")) != null && s.length() > 0) {
            config.setStoreLayout(s.toUpperCase());
        }
    }
}

