/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot.internal.util;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashMap;
import net.thevpc.nuts.boot.NBootClassLoaderNode;
import net.thevpc.nuts.boot.NBootId;

public class NBootClassLoader
extends URLClassLoader {
    private final LinkedHashMap<String, NBootClassLoaderNode> nodes = new LinkedHashMap();
    private final LinkedHashMap<String, NBootClassLoaderNode> effective = new LinkedHashMap();

    public NBootClassLoader(NBootClassLoaderNode[] urls, ClassLoader parent) {
        super(new URL[0], parent);
        for (NBootClassLoaderNode url : urls) {
            if (url == null) continue;
            this.add(url);
        }
    }

    public boolean contains(NBootClassLoaderNode node, boolean deep) {
        return this.search(node, deep) != null;
    }

    public NBootClassLoaderNode search(NBootClassLoaderNode node, boolean deep) {
        NBootId ii = NBootId.of(node.getId());
        String sn = ii.getShortName();
        NBootClassLoaderNode o = this.nodes.get(sn);
        if (o != null) {
            return o;
        }
        if (deep) {
            return this.effective.get(sn);
        }
        return null;
    }

    public boolean add(NBootClassLoaderNode node) {
        NBootId ii = NBootId.of(node.getId());
        String sn = ii.getShortName();
        if (!this.nodes.containsKey(sn)) {
            this.nodes.put(sn, node);
            return this.add(node, true);
        }
        return false;
    }

    protected boolean add(NBootClassLoaderNode node, boolean deep) {
        String s = node.getId();
        NBootId ii = NBootId.of(s);
        String sn = ii.getShortName();
        if (!this.effective.containsKey(sn)) {
            this.effective.put(sn, node);
            super.addURL(node.getURL());
            if (deep) {
                for (NBootClassLoaderNode dependency : node.getDependencies()) {
                    this.add(dependency, true);
                }
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "PrivateNutsBootClassLoader{" + this.nodes.values() + '}';
    }
}

