/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot.internal.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.boot.NBootException;
import net.thevpc.nuts.boot.internal.util.NBootMsg;

public final class NBootJsonParser {
    private final StreamTokenizer st;

    public NBootJsonParser(Reader r) {
        this.st = new StreamTokenizer(r);
        this.st.ordinaryChar(47);
    }

    public static Map<String, Object> parse(Path path) {
        Map<String, Object> map;
        block8: {
            BufferedReader r = Files.newBufferedReader(path);
            try {
                map = new NBootJsonParser(r).parseObject();
                if (r == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            ((Reader)r).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            ((Reader)r).close();
        }
        return map;
    }

    public Map<String, Object> parseObject() {
        return (Map)this.parse();
    }

    public List<Object> parseArray() {
        return (List)this.parse();
    }

    public Object parse() {
        Object a = this.nextElement();
        int p = this.nextToken();
        if (p != -1) {
            throw new NBootException(NBootMsg.ofC("json syntax error :  encountered %s", this.st));
        }
        return a;
    }

    private int nextToken() {
        try {
            return this.st.nextToken();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Object nextElement() {
        int p = this.nextToken();
        switch (p) {
            case -2: {
                return this.st.nval;
            }
            case -3: {
                switch (this.st.sval) {
                    case "true": {
                        return true;
                    }
                    case "false": {
                        return false;
                    }
                    case "null": {
                        return null;
                    }
                }
                throw new NBootException(NBootMsg.ofC("json syntax error : %s", this.st.sval));
            }
            case 34: {
                return this.st.sval;
            }
            case 91: {
                this.st.pushBack();
                return this.nextArray();
            }
            case 123: {
                this.st.pushBack();
                return this.nextObject();
            }
        }
        throw new NBootException(NBootMsg.ofC("json syntax error : %s", this.str(p)));
    }

    private List<Object> nextArray() {
        ArrayList<Object> arr = new ArrayList<Object>();
        int p = this.nextToken();
        if (p != 91) {
            throw new NBootException(NBootMsg.ofC("json syntax error : %s", this.str(p)));
        }
        p = this.nextToken();
        if (p == 93) {
            return arr;
        }
        this.st.pushBack();
        arr.add(this.nextElement());
        block4: while ((p = this.nextToken()) != -1) {
            switch (p) {
                case 93: {
                    return arr;
                }
                case 44: {
                    arr.add(this.nextElement());
                    continue block4;
                }
            }
            throw new NBootException(NBootMsg.ofC("json syntax error : %s", this.str(p)));
        }
        throw new NBootException(NBootMsg.ofPlain("json syntax error : missing ]"));
    }

    private void readChar(char expected) {
        int encountered = this.nextToken();
        if (encountered != expected) {
            throw new NBootException(NBootMsg.ofC("json syntax error : expected %s  , encountered %s", this.str(expected), this.str(encountered)));
        }
    }

    private Object[] nextKeyValue() {
        Object t = this.nextElement();
        if (!(t instanceof String)) {
            throw new NBootException(NBootMsg.ofC("json syntax error : expected entry name, , encountered %s", t));
        }
        this.readChar(':');
        Object v = this.nextElement();
        return new Object[]{t, v};
    }

    private Map<String, Object> nextObject() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        int p = this.nextToken();
        if (p != 123) {
            throw new NBootException(NBootMsg.ofC("json syntax error : %s", p));
        }
        p = this.nextToken();
        if (p == 125) {
            return map;
        }
        this.st.pushBack();
        Object[] kv = this.nextKeyValue();
        map.put((String)kv[0], kv[1]);
        block4: while ((p = this.nextToken()) != -1) {
            switch (p) {
                case 125: {
                    return map;
                }
                case 44: {
                    kv = this.nextKeyValue();
                    map.put((String)kv[0], kv[1]);
                    continue block4;
                }
            }
            throw new NBootException(NBootMsg.ofC("json syntax error : %s", p));
        }
        throw new NBootException(NBootMsg.ofPlain("json syntax error : Missing }"));
    }

    private String str(int a) {
        switch (a) {
            case -1: {
                return "EOF";
            }
            case 10: {
                return "EOL";
            }
            case -2: {
                return "NUMBER";
            }
            case -3: {
                return "WORD";
            }
            case 34: {
                return "DOUBLE_QUOTES";
            }
            case 39: {
                return "SIMPLE_QUOTES";
            }
            case 13: {
                return "\\r";
            }
        }
        return "'" + (char)a + "'";
    }
}

