/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot.internal.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Scanner;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.thevpc.nuts.boot.NBootLogConfig;
import net.thevpc.nuts.boot.NBootOptionsInfo;
import net.thevpc.nuts.boot.internal.util.NBootMsg;
import net.thevpc.nuts.boot.internal.util.NBootPlatformHome;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public class NBootLog {
    public static final String INTENT_ALERT = "ALERT";
    public static final String INTENT_FAIL = "FAIL";
    public static final String INTENT_NOTICE = "NOTICE";
    public static final String INTENT_START = "START";
    public static final String INTENT_READ = "READ";
    public static final String INTENT_SUCCESS = "SUCCESS";
    public static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZoneId.systemDefault());
    private NBootOptionsInfo options;
    private final InputStream in;
    private final PrintStream out;
    private final PrintStream err;
    private Scanner inScanner;
    private PrintStream fileLogPrintStream;
    private int cachedTermLogLevel;
    private int cachedFileLogLevel;

    public NBootLog() {
        this(null);
    }

    public NBootLog(NBootOptionsInfo bootTerminal) {
        this.in = bootTerminal == null || bootTerminal.getStdin() == null ? System.in : bootTerminal.getStdin();
        this.out = bootTerminal == null || bootTerminal.getStdout() == null ? System.out : bootTerminal.getStdout();
        this.err = bootTerminal == null || bootTerminal.getStderr() == null ? System.out : bootTerminal.getStderr();
        this.cachedTermLogLevel = Level.OFF.intValue();
        this.cachedFileLogLevel = Level.OFF.intValue();
    }

    public void error(NBootMsg message, Throwable e) {
        this.log(Level.SEVERE, INTENT_FAIL, message, e);
    }

    public void warn(NBootMsg message) {
        this.log(Level.WARNING, INTENT_ALERT, message);
    }

    public void error(NBootMsg message) {
        this.log(Level.SEVERE, INTENT_FAIL, message);
    }

    public void log(Level lvl, String logVerb, NBootMsg message) {
        if (this.isLoggableTerm(lvl)) {
            this.doLogTerm(lvl, logVerb, message == null ? "" : message.toString());
        }
        if (this.isLoggableFile(lvl)) {
            this.doLogFile(lvl, logVerb, message == null ? "" : message.toString());
        }
    }

    public void log(Level level, String verb, Supplier<NBootMsg> msgSupplier, Supplier<Throwable> errorSupplier) {
        if (this.isLoggableTerm(level)) {
            this.log(level, verb, msgSupplier.get(), errorSupplier.get());
        }
    }

    public void log(LogRecord record) {
        String verb = null;
        Level level = record.getLevel();
        if (verb == null) {
            verb = level.intValue() >= Level.SEVERE.intValue() ? INTENT_FAIL : (level.intValue() >= Level.WARNING.intValue() ? INTENT_ALERT : (level.intValue() >= Level.INFO.intValue() ? INTENT_NOTICE : INTENT_NOTICE));
        }
        this.log(level, verb, NBootMsg.ofPlain(record.getMessage()), record.getThrown());
    }

    public LogOp with() {
        return new LogOp(this);
    }

    public void log(Level lvl, String logVerb, NBootMsg message, Throwable err) {
        if (this.isLoggableTerm(lvl)) {
            this.doLogTerm(lvl, logVerb, message == null ? "" : message.toString());
            if (err != null) {
                err.printStackTrace(this.err);
            }
        }
        if (this.isLoggableFile(lvl)) {
            this.doLogFile(lvl, logVerb, message == null ? "" : message.toString());
            if (err != null && this.fileLogPrintStream != null) {
                err.printStackTrace(this.fileLogPrintStream);
            }
        }
    }

    private void doLogTerm(Level lvl, String logVerb, String s) {
        this.errln("%s %-7s %-7s : %s", DEFAULT_DATE_TIME_FORMATTER.format(Instant.now()), lvl, logVerb, s);
    }

    private void doLogFile(Level lvl, String logVerb, String s) {
        if (this.fileLogPrintStream != null) {
            this.fileLogPrintStream.printf("%s %-7s %-7s : %s", DEFAULT_DATE_TIME_FORMATTER.format(Instant.now()), lvl, logVerb, s);
            this.fileLogPrintStream.println();
            this.fileLogPrintStream.flush();
        }
    }

    public boolean isLoggableTerm(Level lvl) {
        if (this.options.getBot() != null && this.options.getBot().booleanValue()) {
            return false;
        }
        if (lvl.intValue() == Level.OFF.intValue()) {
            return true;
        }
        if ((this.options == null || this.options.getLogConfig() == null) && lvl.intValue() >= Level.WARNING.intValue()) {
            return true;
        }
        return lvl.intValue() >= this.cachedTermLogLevel;
    }

    public boolean isLoggableFile(Level lvl) {
        if (this.fileLogPrintStream == null) {
            return false;
        }
        if (lvl.intValue() == Level.OFF.intValue()) {
            return true;
        }
        if (this.options == null || this.options.getLogConfig() == null) {
            return false;
        }
        return lvl.intValue() >= this.cachedFileLogLevel;
    }

    public boolean isLoggable(Level lvl) {
        return this.isLoggableTerm(lvl) || this.isLoggableFile(lvl);
    }

    public void setOptions(NBootOptionsInfo options) {
        this.options = options;
        NBootLogConfig nLogConfig = options.getLogConfig();
        if (nLogConfig != null) {
            File parentFile;
            if (nLogConfig.getLogTermLevel() != null) {
                this.cachedTermLogLevel = nLogConfig.getLogTermLevel().intValue();
            }
            if (nLogConfig.getLogFileLevel() != null) {
                this.cachedFileLogLevel = nLogConfig.getLogFileLevel().intValue();
            }
            Level level = nLogConfig.getLogFileLevel();
            String folder = nLogConfig.getLogFileBase();
            String name = nLogConfig.getLogFileName();
            int maxSize = nLogConfig.getLogFileSize();
            int count = nLogConfig.getLogFileCount();
            if (level == null) {
                level = Level.INFO;
            }
            int MEGA = 0x100000;
            if (name == null || NBootUtils.isBlank(name)) {
                name = Instant.now().toString().replace(":", "") + "-nuts-%g.log";
            }
            StringBuilder realName = new StringBuilder();
            char[] charArray = name.toCharArray();
            block12: for (int i = 0; i < charArray.length; ++i) {
                char c = charArray[i];
                switch (c) {
                    case '%': {
                        if (i + 1 < charArray.length) {
                            ++i;
                        }
                        switch (charArray[i]) {
                            case '/': {
                                realName.append(File.separatorChar);
                                continue block12;
                            }
                            case '%': {
                                realName.append('%');
                                continue block12;
                            }
                            case 'g': {
                                realName.append("boot");
                                continue block12;
                            }
                            case 't': {
                                String tempFolder = Paths.get(NBootPlatformHome.of(options.getStoreLayout()).getWorkspaceStore("TEMP", options.getWorkspace()), new String[0]).toString();
                                realName.append(tempFolder);
                                continue block12;
                            }
                            case 'u': {
                                realName.append(UUID.randomUUID());
                                continue block12;
                            }
                        }
                        realName.append('%');
                        realName.append(charArray[i]);
                        continue block12;
                    }
                    default: {
                        realName.append(c);
                    }
                }
            }
            if (folder == null || NBootUtils.isBlank(folder)) {
                String logFolder = Paths.get(NBootPlatformHome.of(options.getStoreLayout()).getWorkspaceStore("LOG", options.getWorkspace()), new String[0]).toString();
                folder = logFolder + "/" + "id" + "/net/thevpc/nuts/nuts/" + "0.8.8";
            }
            String pattern = (folder + "/" + realName).replace('/', File.separatorChar);
            if (maxSize <= 0) {
                maxSize = 5;
            }
            if (count <= 0) {
                count = 3;
            }
            if ((parentFile = new File(pattern).getParentFile()) != null) {
                parentFile.mkdirs();
            }
            boolean append = true;
            String realPath = pattern;
            long realMaxSizeInBytes = maxSize * MEGA;
            try {
                this.fileLogPrintStream = new PrintStream(new FileOutputStream(realPath, append));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    public PrintStream err() {
        return this.err;
    }

    public void err(String msg, Object ... p) {
        this.err.printf(msg, p);
        this.err.flush();
    }

    public void errln(String msg, Object ... p) {
        this.err.println(NBootMsg.ofC(msg, p));
        this.err.flush();
    }

    public void outln(String msg, Object ... p) {
        this.out.println(NBootMsg.ofC(msg, p));
        this.out.flush();
    }

    public void errln(Throwable exception) {
        exception.printStackTrace(this.err);
    }

    public String readLine() {
        if (this.inScanner == null) {
            this.inScanner = new Scanner(System.in);
        }
        return this.inScanner.nextLine();
    }

    public static class LogOp {
        private NBootLog logger;
        private Level level = Level.FINE;
        private String verb;
        private NBootMsg msg;
        private long time;
        private Supplier<NBootMsg> msgSupplier;
        private Throwable error;

        public LogOp(NBootLog logger) {
            this.logger = logger;
        }

        public LogOp verbFail() {
            this.verb = NBootLog.INTENT_FAIL;
            return this;
        }

        public LogOp verbCache() {
            this.verb = "CACHE";
            return this;
        }

        public LogOp verbNotice() {
            this.verb = NBootLog.INTENT_NOTICE;
            return this;
        }

        public LogOp verbRead() {
            this.verb = NBootLog.INTENT_READ;
            return this;
        }

        public LogOp verbAlert() {
            this.verb = NBootLog.INTENT_ALERT;
            return this;
        }

        public LogOp verbSuccess() {
            this.verb = NBootLog.INTENT_SUCCESS;
            return this;
        }

        public LogOp verbStart() {
            this.verb = NBootLog.INTENT_START;
            return this;
        }

        public LogOp level(Level level) {
            this.level = level == null ? Level.FINE : level;
            return this;
        }

        public LogOp error(Throwable error) {
            this.error = error;
            return this;
        }

        public void log(NBootMsg message) {
            this.msg = message;
            this.run();
        }

        public void log(Supplier<NBootMsg> msgSupplier) {
            this.msgSupplier = msgSupplier;
            this.run();
        }

        public LogOp time(long time) {
            this.time = time;
            return this;
        }

        private void run() {
            if (this.logger.isLoggable(this.level)) {
                NBootMsg m = this.msg;
                if (this.msgSupplier != null) {
                    m = this.msgSupplier.get();
                }
                this.logger.log(this.level, this.verb, m, this.error);
            }
        }

        public boolean isLoggable(Level level) {
            return this.logger.isLoggable(level);
        }
    }
}

