/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import net.thevpc.nuts.boot.internal.util.NBootMsgParam;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public class NBootMsg {
    public static final Object[] NO_PARAMS = new Object[0];
    private final String codeLang;
    private final Object message;
    private final Level level;
    private final String format;
    private final Object[] params;

    private static NBootMsg of(String format, Object message, Object[] params, String codeLang, Level level) {
        return new NBootMsg(format, message, params, codeLang, level);
    }

    private NBootMsg(String format, Object message, Object[] params, String codeLang, Level level) {
        NBootUtils.requireNonNull(message, "message");
        NBootUtils.requireNonNull(format, "format");
        NBootUtils.requireNonNull(params, "params");
        this.level = level;
        this.format = format;
        switch (format) {
            case "PLAIN": {
                if (params.length <= 0) break;
                throw new IllegalArgumentException("arguments are not supported for " + format);
            }
        }
        this.codeLang = NBootUtils.trimToNull(codeLang);
        this.message = message;
        this.params = params;
    }

    public static NBootMsg ofPlain(String message) {
        return NBootMsg.of("PLAIN", message, NO_PARAMS, null, null);
    }

    public static NBootMsg ofC(String message) {
        return NBootMsg.of("CFORMAT", message, NO_PARAMS, null, null);
    }

    public static NBootMsg ofC(String message, Object ... params) {
        return NBootMsg.of("CFORMAT", message, params, null, null);
    }

    public static NBootMsg ofV(String message, NBootMsgParam ... params) {
        LinkedHashMap<String, NBootMsgParam> vars = new LinkedHashMap<String, NBootMsgParam>();
        if (params != null) {
            for (NBootMsgParam param : params) {
                String e = param.getName();
                if (vars.containsKey(e)) {
                    throw new IllegalArgumentException("duplicate key " + e);
                }
                vars.put(e, param);
            }
        }
        return NBootMsg.ofV(message, (String s) -> {
            Supplier<?> ss;
            NBootMsgParam p = (NBootMsgParam)vars.get(s);
            if (p != null && (ss = p.getValue()) != null) {
                return ss.get();
            }
            return null;
        });
    }

    public static NBootMsg ofV(String message, Map<String, ?> vars) {
        return NBootMsg.of("VFORMAT", message, new Object[]{vars}, null, null);
    }

    public static NBootMsg ofV(String message, Function<String, ?> vars) {
        return NBootMsg.of("VFORMAT", message, new Object[]{vars}, null, null);
    }

    public static NBootMsg ofC(String message, NBootMsgParam ... params) {
        if (params == null) {
            return NBootMsg.ofC(message, new Object[]{null});
        }
        Object[] paramsAsObjects = Arrays.stream(params).map(NBootMsgParam::getValue).toArray();
        return NBootMsg.ofC(message, paramsAsObjects);
    }

    public String getFormat() {
        return this.format;
    }

    public Object getMessage() {
        return this.message;
    }

    public Object[] getParams() {
        return this.params;
    }

    public String getCodeLang() {
        return this.codeLang;
    }

    public Level getLevel() {
        return this.level;
    }

    private Object _preFormatOne(Object o) {
        if (o == null) {
            return null;
        }
        return o;
    }

    private Object[] _preFormatArr(Object[] o) {
        if (o == null) {
            return o;
        }
        Object[] r = new Object[o.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = this._preFormatOne(o[i]);
        }
        return r;
    }

    public String toString() {
        try {
            switch (this.format) {
                case "CFORMAT": {
                    StringBuilder sb = new StringBuilder();
                    new Formatter(sb).format((String)this.message, this._preFormatArr(this.params));
                    return sb.toString();
                }
                case "VFORMAT": {
                    return this.formatAsV();
                }
            }
            return String.valueOf(this.message);
        }
        catch (Exception e) {
            ArrayList<List<Object>> a = new ArrayList<List<Object>>();
            if (this.params != null) {
                a.add(Arrays.asList(this.params));
            }
            return NBootMsg.ofC("[ERROR] Invalid %s message %s with params %s : %s", this.format, this.message, a, e).toString();
        }
    }

    private String formatAsV() {
        return NBootUtils.replaceDollarPlaceHolder((String)this.message, s -> {
            Object param = this.params[0];
            Function m = null;
            m = param instanceof Map ? x -> ((Map)param).get(x) : (Function)param;
            Object v = m.apply(s);
            if (v != null) {
                return String.valueOf(v);
            }
            return "${" + s + "}";
        });
    }

    public NBootMsg asSevere() {
        return this.withLevel(Level.SEVERE);
    }

    public NBootMsg asInfo() {
        return this.withLevel(Level.FINE);
    }

    public NBootMsg asConfig() {
        return this.withLevel(Level.CONFIG);
    }

    public NBootMsg asWarning() {
        return this.withLevel(Level.WARNING);
    }

    public NBootMsg asFinest() {
        return this.withLevel(Level.FINEST);
    }

    public NBootMsg asFine() {
        return this.withLevel(Level.FINE);
    }

    public NBootMsg asFiner() {
        return this.withLevel(Level.FINER);
    }

    public NBootMsg withLevel(Level level) {
        return NBootMsg.of(this.format, this.message, this.params, this.codeLang, level);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NBootMsg that = (NBootMsg)o;
        return Objects.equals(this.codeLang, that.codeLang) && Objects.equals(this.message, that.message) && this.format == that.format && Arrays.deepEquals(this.params, that.params) && Objects.equals(this.level, that.level);
    }

    public int hashCode() {
        int result = Objects.hash(this.codeLang, this.message, this.format, this.level);
        result = 31 * result + Arrays.hashCode(this.params);
        return result;
    }
}

