/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot.internal.util;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.Spliterators;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import net.thevpc.nuts.boot.NBootCancelException;
import net.thevpc.nuts.boot.NBootClassLoaderNode;
import net.thevpc.nuts.boot.NBootDependency;
import net.thevpc.nuts.boot.NBootEnvCondition;
import net.thevpc.nuts.boot.NBootException;
import net.thevpc.nuts.boot.NBootId;
import net.thevpc.nuts.boot.NBootLogConfig;
import net.thevpc.nuts.boot.NBootOptionsInfo;
import net.thevpc.nuts.boot.NBootVersion;
import net.thevpc.nuts.boot.NBootWorkspaceImpl;
import net.thevpc.nuts.boot.core.NAnyBootAwareExceptionBase;
import net.thevpc.nuts.boot.internal.cmdline.NBootArg;
import net.thevpc.nuts.boot.internal.cmdline.NBootWorkspaceCmdLineParser;
import net.thevpc.nuts.boot.internal.maven.NReservedMavenUtilsBoot;
import net.thevpc.nuts.boot.internal.util.NBootChronometer;
import net.thevpc.nuts.boot.internal.util.NBootContext;
import net.thevpc.nuts.boot.internal.util.NBootDeleteFilesContextBoot;
import net.thevpc.nuts.boot.internal.util.NBootDeleteFilesContextBootImpl;
import net.thevpc.nuts.boot.internal.util.NBootDuration;
import net.thevpc.nuts.boot.internal.util.NBootLog;
import net.thevpc.nuts.boot.internal.util.NBootMonitoredURLInputStream;
import net.thevpc.nuts.boot.internal.util.NBootMsg;
import net.thevpc.nuts.boot.internal.util.NBootPlatformHome;
import net.thevpc.nuts.boot.internal.util.NBootPositionTypeBoot;
import net.thevpc.nuts.boot.internal.util.NBootQuoteTypeBoot;
import net.thevpc.nuts.boot.internal.util.NBootStringMapFormat;
import net.thevpc.nuts.boot.internal.util.NBootSupportMode;
import net.thevpc.nuts.boot.internal.util.NBootToken;

public final class NBootUtils {
    public static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.SSSX"};
    private static final char[] BASE16_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static final URL urlOf(String any) {
        try {
            return URI.create(any).toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String enumTitle(String s) {
        if (NBootUtils.isBlank(s)) {
            return "";
        }
        char[] charArray = s.trim().toCharArray();
        charArray[0] = Character.toUpperCase(charArray[0]);
        return new String(charArray);
    }

    public static String enumId(String s) {
        if (NBootUtils.isBlank(s)) {
            return "";
        }
        char[] charArray = s.trim().toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            charArray[i] = c == '_' ? 45 : Character.toLowerCase(c);
        }
        return new String(charArray);
    }

    public static String enumName(String s) {
        if (NBootUtils.isBlank(s)) {
            return "";
        }
        char[] charArray = s.trim().toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            charArray[i] = c == '-' ? 95 : Character.toUpperCase(c);
        }
        return new String(charArray);
    }

    public static boolean sameEnum(String a, String b) {
        char[] charArray2;
        char[] charArray1 = a == null ? new char[]{} : a.trim().toCharArray();
        char[] cArray = charArray2 = b == null ? new char[]{} : b.trim().toCharArray();
        if (charArray1.length != charArray2.length) {
            return false;
        }
        for (int i = 0; i < charArray1.length; ++i) {
            char c1 = charArray1[i];
            char c2 = charArray2[i];
            if ((c1 = c1 == '-' ? (char)'_' : Character.toUpperCase(c1)) == (c2 = c2 == '-' ? (char)'_' : Character.toUpperCase(c2))) continue;
            return false;
        }
        return true;
    }

    public static Integer parseInt(String s) {
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T> T firstNonNull(T ... values) {
        if (values != null) {
            for (T value : values) {
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }

    public static boolean isValidWorkspaceName(String workspace) {
        if (NBootUtils.isBlank(workspace)) {
            return true;
        }
        String workspaceName = workspace.trim();
        return workspaceName.matches("[^/\\\\]+") && !workspaceName.equals(".") && !workspaceName.equals("..");
    }

    public static String resolveValidWorkspaceName(String workspace) {
        if (NBootUtils.isBlank(workspace)) {
            return "default-workspace";
        }
        String workspaceName = workspace.trim();
        if (workspaceName.matches("[^/\\\\]+") && !workspaceName.equals(".") && !workspaceName.equals("..")) {
            return workspaceName;
        }
        String p = null;
        try {
            p = Paths.get(workspaceName, new String[0]).toRealPath(new LinkOption[0]).getFileName().toString();
        }
        catch (IOException ex) {
            p = new File(workspaceName).getAbsoluteFile().getName();
        }
        if (p.isEmpty() || p.equals(".") || p.equals("..")) {
            return "unknown";
        }
        return p;
    }

    public static String resolveJavaCommand(String javaHome) {
        String exe;
        String string = exe = NBootUtils.sameEnum(NBootPlatformHome.currentOsFamily(), "WINDOWS") ? "java.exe" : "java";
        if ((javaHome == null || javaHome.isEmpty()) && (NBootUtils.isBlank(javaHome = System.getProperty("java.home")) || "null".equals(javaHome))) {
            return exe;
        }
        return javaHome + File.separator + "bin" + File.separator + exe;
    }

    public static boolean isActualJavaOptions(String options) {
        return true;
    }

    public static boolean isActualJavaCommand(String cmd) {
        if (cmd == null || cmd.trim().isEmpty()) {
            return true;
        }
        String javaHome = System.getProperty("java.home");
        if (NBootUtils.isBlank(javaHome) || "null".equals(javaHome)) {
            return cmd.equals("java") || cmd.equals("java.exe") || cmd.equals("javaw.exe") || cmd.equals("javaw");
        }
        String jh = javaHome.replace("\\", "/");
        if ((cmd = cmd.replace("\\", "/")).equals(jh + "/bin/java")) {
            return true;
        }
        if (cmd.equals(jh + "/bin/java.exe")) {
            return true;
        }
        if (cmd.equals(jh + "/bin/javaw")) {
            return true;
        }
        if (cmd.equals(jh + "/bin/javaw.exe")) {
            return true;
        }
        if (cmd.equals(jh + "/jre/bin/java")) {
            return true;
        }
        return cmd.equals(jh + "/jre/bin/java.exe");
    }

    public static String desc(Object s) {
        if (s == null) {
            return "<undefined>";
        }
        String ss = s instanceof Enum ? NBootUtils.enumName(((Enum)s).name()) : s.toString().trim();
        return ss.isEmpty() ? "<undefined>" : ss;
    }

    public static String coalesce(Object ... all) {
        for (Object object : all) {
            if (object == null) continue;
            return NBootUtils.desc(object);
        }
        return NBootUtils.desc(null);
    }

    public static String formatLogValue(Object unresolved, Object resolved) {
        String b;
        String a = NBootUtils.desc(unresolved);
        if (a.equals(b = NBootUtils.desc(resolved))) {
            return a;
        }
        return a + " => " + b;
    }

    public static boolean getSysBoolNutsProperty(String property, boolean defaultValue) {
        return NBootUtils.parseBooleanOr(System.getProperty("nuts." + property), defaultValue) || NBootUtils.parseBooleanOr(System.getProperty("nuts.export." + property), defaultValue);
    }

    public static boolean isInfiniteLoopThread(String className, String methodName) {
        Thread thread = Thread.currentThread();
        StackTraceElement[] elements = thread.getStackTrace();
        if (elements == null || elements.length == 0) {
            return false;
        }
        for (int i = 0; i < elements.length; ++i) {
            StackTraceElement element = elements[elements.length - (i + 1)];
            if (!className.equals(element.getClassName()) || !methodName.equals(element.getMethodName())) continue;
            return true;
        }
        return false;
    }

    public static String getHome(String storeFolder, NBootOptionsInfo bOptions) {
        return (NBootUtils.firstNonNull(bOptions.getSystem(), false) != false ? NBootPlatformHome.ofSystem(bOptions.getStoreLayout()) : NBootPlatformHome.of(bOptions.getStoreLayout())).getWorkspaceLocation(storeFolder, bOptions.getHomeLocations(), bOptions.getName());
    }

    public static String getIdShortName(String groupId, String artifactId) {
        if (NBootUtils.isBlank(groupId)) {
            return NBootUtils.trim(artifactId);
        }
        return NBootUtils.trim(groupId) + ":" + NBootUtils.trim(artifactId);
    }

    public static String getIdLongName(String groupId, String artifactId, String version, String classifier) {
        StringBuilder sb = new StringBuilder();
        if (!NBootUtils.isBlank(groupId)) {
            sb.append(groupId).append(":");
        }
        sb.append(NBootUtils.trim(artifactId));
        if (version != null && !NBootUtils.isBlank(version)) {
            sb.append("#");
            sb.append(version);
        }
        if (!NBootUtils.isBlank(classifier)) {
            sb.append("?");
            sb.append("classifier=");
            sb.append(classifier);
        }
        return sb.toString();
    }

    public static boolean isAcceptCondition(NBootEnvCondition cond) {
        String earch;
        List<String> oss = NBootUtils.uniqueNonBlankStringList(cond.getOs());
        List<String> archs = NBootUtils.uniqueNonBlankStringList(cond.getArch());
        if (!oss.isEmpty()) {
            String eos = NBootPlatformHome.currentOsFamily();
            boolean osOk = false;
            for (String e : oss) {
                NBootId ee = NBootId.of(e);
                if (!ee.getShortName().equalsIgnoreCase(eos)) continue;
                if (!NBootUtils.acceptVersion(ee.getVersion(), System.getProperty("os.version"))) break;
                osOk = true;
                break;
            }
            if (!osOk) {
                return false;
            }
        }
        if (!archs.isEmpty() && (earch = System.getProperty("os.arch")) != null) {
            boolean archOk = false;
            for (String e : archs) {
                if (e.isEmpty() || !e.equalsIgnoreCase(earch)) continue;
                archOk = true;
                break;
            }
            return archOk;
        }
        return true;
    }

    public static NBootId parseId(String nutsId) {
        if (NBootUtils.isBlank(nutsId)) {
            return new NBootId(null, null);
        }
        Matcher m = NBootId.PATTERN.matcher(nutsId);
        if (m.find()) {
            NBootId idBuilder = new NBootId();
            String group = m.group("group");
            String artifact = m.group("artifact");
            idBuilder.setArtifactId(artifact);
            idBuilder.setVersion(m.group("version"));
            if (artifact == null) {
                artifact = group;
                group = null;
            }
            idBuilder.setArtifactId(artifact);
            idBuilder.setGroupId(group);
            Map<String, String> queryMap = NBootStringMapFormat.DEFAULT.parse(m.group("query"));
            NBootEnvCondition conditionBuilder = new NBootEnvCondition();
            LinkedHashMap<String, String> idProperties = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> e : queryMap.entrySet()) {
                String key = e.getKey();
                String value = e.getValue();
                NBootUtils.setIdProperty(key, value, idBuilder, conditionBuilder, idProperties);
            }
            return idBuilder.setCondition(conditionBuilder).setProperties(idProperties);
        }
        throw new NBootException(NBootMsg.ofC("invalid id format : %s", nutsId));
    }

    private static boolean ndiAddFileLine(Path filePath, String commentLine, String goodLine, boolean force, String ensureHeader, String headerReplace) {
        boolean found = false;
        boolean updatedFile = false;
        ArrayList<String> lines = new ArrayList<String>();
        if (Files.isRegularFile(filePath, new LinkOption[0])) {
            String fileContent = null;
            try {
                fileContent = new String(Files.readAllBytes(filePath));
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            String[] fileRows = fileContent.split("\n");
            if (!(ensureHeader == null || fileRows.length != 0 && fileRows[0].trim().matches(ensureHeader))) {
                lines.add(headerReplace);
                updatedFile = true;
            }
            for (int i = 0; i < fileRows.length; ++i) {
                String row = fileRows[i];
                if (row.trim().equals("# " + commentLine)) {
                    lines.add(row);
                    found = true;
                    if (++i < fileRows.length && !fileRows[i].trim().equals(goodLine)) {
                        updatedFile = true;
                    }
                    lines.add(goodLine);
                    ++i;
                    while (i < fileRows.length) {
                        lines.add(fileRows[i]);
                        ++i;
                    }
                    continue;
                }
                lines.add(row);
            }
        }
        if (!found) {
            if (ensureHeader != null && headerReplace != null && lines.isEmpty()) {
                lines.add(headerReplace);
            }
            lines.add("# " + commentLine);
            lines.add(goodLine);
            updatedFile = true;
        }
        if (force || updatedFile) {
            try {
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                Files.write(filePath, (String.join((CharSequence)"\n", lines) + "\n").getBytes(), new OpenOption[0]);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return updatedFile;
    }

    static boolean ndiRemoveFileCommented2Lines(Path filePath, String commentLine, boolean force) {
        boolean found = false;
        boolean updatedFile = false;
        try {
            ArrayList<String> lines = new ArrayList<String>();
            if (Files.isRegularFile(filePath, new LinkOption[0])) {
                String fileContent = new String(Files.readAllBytes(filePath));
                String[] fileRows = fileContent.split("\n");
                for (int i = 0; i < fileRows.length; ++i) {
                    String row = fileRows[i];
                    if (row.trim().equals("# " + commentLine)) {
                        found = true;
                        i += 2;
                        while (i < fileRows.length) {
                            lines.add(fileRows[i]);
                            ++i;
                        }
                        continue;
                    }
                    lines.add(row);
                }
            }
            if (found) {
                updatedFile = true;
            }
            if (force || updatedFile) {
                if (!Files.exists(filePath.getParent(), new LinkOption[0])) {
                    Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                }
                Files.write(filePath, (String.join((CharSequence)"\n", lines) + "\n").getBytes(), new OpenOption[0]);
            }
            return updatedFile;
        }
        catch (IOException ex) {
            NBootContext.log().with().level(Level.WARNING).verbAlert().error(ex).log(NBootMsg.ofPlain("unable to update update " + filePath));
            return false;
        }
    }

    public static void ndiUndo(String wsName, boolean update) {
        String os = NBootPlatformHome.currentOsFamily();
        if (NBootUtils.sameEnum(os, "LINUX") || NBootUtils.sameEnum(os, "MACOS")) {
            String bashrc = NBootUtils.sameEnum(os, "LINUX") ? ".bashrc" : ".bash_profile";
            Path sysrcFile = Paths.get(System.getProperty("user.home"), new String[0]).resolve(bashrc);
            if (Files.exists(sysrcFile, new LinkOption[0])) {
                NBootUtils.ndiRemoveFileCommented2Lines(sysrcFile, "net.thevpc.app.nuts.toolbox.ndi configuration", true);
                NBootUtils.ndiRemoveFileCommented2Lines(sysrcFile, "net.thevpc.app.nuts configuration", true);
                NBootUtils.ndiRemoveFileCommented2Lines(sysrcFile, "net.thevpc.nuts configuration", true);
            }
            if (update && !Objects.equals("default-workspace", wsName)) {
                String latestDefaultVersion = null;
                try {
                    Path nbase = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".local/share/nuts/apps/default-workspace/id/net/thevpc/nuts/nuts");
                    if (Files.isDirectory(nbase, new LinkOption[0])) {
                        latestDefaultVersion = Files.list(nbase).filter(f -> Files.exists(f.resolve(".nuts-bashrc"), new LinkOption[0])).map(x -> sysrcFile.getFileName().toString()).min((o1, o2) -> NBootVersion.of(o2).compareTo(NBootVersion.of(o1))).orElse(null);
                    }
                    if (latestDefaultVersion != null) {
                        NBootUtils.ndiAddFileLine(sysrcFile, "net.thevpc.nuts configuration", "source " + nbase.resolve(latestDefaultVersion).resolve(".nuts-bashrc"), true, "#!.*", "#!/bin/sh");
                    }
                }
                catch (Exception e) {
                    NBootContext.log().with().level(Level.FINEST).verbFail().log(NBootMsg.ofC("unable to undo NDI : %s", e.toString()));
                }
            }
        }
    }

    public static String formatIdList(List<NBootId> s) {
        return s.stream().map(Object::toString).collect(Collectors.joining(","));
    }

    public static String formatIdArray(NBootId[] s) {
        return Arrays.stream(s).map(Object::toString).collect(Collectors.joining(","));
    }

    public static String formatStringIdList(List<String> s) {
        LinkedHashSet<String> allIds = new LinkedHashSet<String>();
        if (s != null) {
            for (String s1 : s) {
                if ((s1 = NBootUtils.trim(s1)).length() <= 0) continue;
                allIds.add(s1);
            }
        }
        return String.join((CharSequence)",", allIds);
    }

    public static String formatStringIdArray(String[] s) {
        LinkedHashSet<String> allIds = new LinkedHashSet<String>();
        if (s != null) {
            for (String s1 : s) {
                if ((s1 = NBootUtils.trim(s1)).length() <= 0) continue;
                allIds.add(s1);
            }
        }
        return String.join((CharSequence)",", allIds);
    }

    public static List<String> parseStringIdList(String s) {
        if (s == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> allIds = new LinkedHashSet<String>();
        StringBuilder q = null;
        boolean inBrackets = false;
        for (char c : s.toCharArray()) {
            if (q == null) {
                q = new StringBuilder();
                if (c == '[' || c == ']') {
                    inBrackets = true;
                    q.append(c);
                    continue;
                }
                if (c == ',' || Character.isWhitespace(c) || c == ';') continue;
                q.append(c);
                continue;
            }
            if (c == ',' || Character.isWhitespace(c) || c == ';') {
                if (inBrackets) {
                    q.append(c);
                    continue;
                }
                if (q.length() > 0) {
                    allIds.add(q.toString());
                }
                q = null;
                inBrackets = false;
                continue;
            }
            if (c == '[' || c == ']') {
                if (inBrackets) {
                    inBrackets = false;
                    q.append(c);
                    continue;
                }
                inBrackets = true;
                q.append(c);
                continue;
            }
            q.append(c);
        }
        if (q != null && q.length() > 0) {
            allIds.add(q.toString());
        }
        return new ArrayList<String>(allIds);
    }

    public static List<NBootId> parseIdList(String s) {
        ArrayList<NBootId> list = new ArrayList<NBootId>();
        List<String> o = NBootUtils.parseStringIdList(s);
        for (String x : o) {
            NBootId y = NBootId.of(x);
            if (y == null) {
                return null;
            }
            list.add(y);
        }
        return list;
    }

    public static Map<String, String> toMap(NBootEnvCondition condition) {
        Map<String, String> properties;
        String s;
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        if (condition.getArch() != null && !NBootUtils.isBlank(s = condition.getArch().stream().map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.joining(",")))) {
            m.put("arch", s);
        }
        if (condition.getOs() != null && !NBootUtils.isBlank(s = condition.getOs().stream().map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.joining(",")))) {
            m.put("os", s);
        }
        if (condition.getOsDist() != null && !NBootUtils.isBlank(s = condition.getOsDist().stream().map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.joining(",")))) {
            m.put("osdist", s);
        }
        if (condition.getPlatform() != null && !NBootUtils.isBlank(s = NBootUtils.formatStringIdList(condition.getPlatform()))) {
            m.put("platform", s);
        }
        if (condition.getDesktopEnvironment() != null && !NBootUtils.isBlank(s = condition.getDesktopEnvironment().stream().map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.joining(",")))) {
            m.put("desktop", s);
        }
        if (condition.getProfiles() != null && !NBootUtils.isBlank(s = condition.getProfiles().stream().map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.joining(",")))) {
            m.put("profile", s);
        }
        if (condition.getProperties() != null && !(properties = condition.getProperties()).isEmpty()) {
            m.put("cond-properties", NBootStringMapFormat.DEFAULT.format(properties));
        }
        return m;
    }

    public static boolean isBootOptional(String name, NBootOptionsInfo bOptions) {
        if (bOptions.getCustomOptions() != null) {
            for (String property : bOptions.getCustomOptions()) {
                NBootArg a = new NBootArg(property);
                if (!("boot-" + name).equals(a.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBootOptional(NBootOptionsInfo bOptions) {
        if (bOptions.getCustomOptions() != null) {
            for (String property : bOptions.getCustomOptions()) {
                NBootArg a = new NBootArg(property);
                if (!"boot-optional".equals(a.getKey())) continue;
                return NBootUtils.parseBooleanOr(a.getValue(), true);
            }
        }
        return true;
    }

    public static boolean parseBooleanOr(String any, boolean b) {
        return NBootUtils.firstNonNull(NBootUtils.parseBoolean(any), b);
    }

    public static Instant parseInstant(String s) {
        if (NBootUtils.isBlank(s)) {
            return null;
        }
        try {
            return DateTimeFormatter.ISO_INSTANT.parse((CharSequence)s, Instant::from);
        }
        catch (Exception exception) {
            for (String f : DATE_FORMATS) {
                try {
                    return new SimpleDateFormat(f).parse(s).toInstant();
                }
                catch (Exception exception2) {
                }
            }
            throw new NBootException(NBootMsg.ofC("invalid instant %s", s));
        }
    }

    public static Instant parseInstant(String s, Instant emptyValue, Instant errorValue) {
        if (NBootUtils.isBlank(s)) {
            return emptyValue;
        }
        try {
            return DateTimeFormatter.ISO_INSTANT.parse((CharSequence)s, Instant::from);
        }
        catch (Exception exception) {
            for (String f : DATE_FORMATS) {
                try {
                    return new SimpleDateFormat(f).parse(s).toInstant();
                }
                catch (Exception exception2) {
                }
            }
            return errorValue;
        }
    }

    public static Boolean parseBoolean(String any, Boolean emptyValue, Boolean errorValue) {
        if (any == null) {
            return emptyValue;
        }
        String svalue = String.valueOf(any).trim().toLowerCase();
        if (svalue.isEmpty()) {
            return emptyValue;
        }
        if (svalue.matches("true|enable|enabled|yes|always|y|on|ok|t|o")) {
            return true;
        }
        if (svalue.matches("false|disable|disabled|no|none|never|n|off|ko|f")) {
            return false;
        }
        return errorValue;
    }

    public static Boolean parseBoolean(String any) {
        return NBootUtils.parseBoolean(any, null, null);
    }

    public static String resolveNutsIdDigest() {
        return NBootUtils.resolveNutsIdDigest(NBootId.ofApi("0.8.8"), NBootUtils.resolveClasspathURLs(NBootWorkspaceImpl.class.getClassLoader(), true));
    }

    public static String resolveNutsIdDigest(NBootId id, URL[] urls) {
        return NBootUtils.getURLDigest(NBootUtils.findClassLoaderJar(id, urls));
    }

    public static boolean isAcceptDependency(NBootDependency s, NBootOptionsInfo bOptions) {
        boolean bootOptionals = NBootUtils.isBootOptional(bOptions);
        String o = s.getOptional();
        if ((NBootUtils.isBlank(o) || Boolean.parseBoolean(o)) && !bootOptionals && !NBootUtils.isBootOptional(s.getArtifactId(), bOptions)) {
            return false;
        }
        return NBootUtils.isAcceptCondition(s.getCondition());
    }

    public static boolean isDependencyDefaultScope(String s1) {
        if (NBootUtils.isBlank(s1)) {
            return true;
        }
        return NBootUtils.sameEnum(s1, "api");
    }

    public static boolean acceptVersion(String one, String other) {
        return NBootUtils.acceptVersion(NBootVersion.of(one), NBootVersion.of(other));
    }

    public static boolean acceptVersion(NBootVersion.NVersionIntervalBoot one, NBootVersion other) {
        int c;
        NBootVersion a = NBootVersion.of(one.getLowerBound());
        if (!a.isBlank()) {
            c = a.compareTo(other);
            if (one.isIncludeLowerBound() ? c > 0 : c >= 0) {
                return false;
            }
        }
        a = NBootVersion.of(one.getUpperBound());
        if (!a.isBlank()) {
            c = a.compareTo(other);
            if (one.isIncludeUpperBound()) {
                return c >= 0;
            }
            return c > 0;
        }
        return true;
    }

    public static boolean acceptVersion(NBootVersion one, NBootVersion other) {
        if (!other.isSingleValue()) {
            throw new NBootException(NBootMsg.ofC("expected single value version: %s", other));
        }
        List<NBootVersion.NVersionIntervalBoot> ii = one.intervals();
        if (ii.isEmpty()) {
            return true;
        }
        for (NBootVersion.NVersionIntervalBoot i : ii) {
            if (!NBootUtils.acceptVersion(i, other)) continue;
            return true;
        }
        return false;
    }

    public static String getIdLongName(String groupId, String artifactId, NBootVersion version, String classifier) {
        StringBuilder sb = new StringBuilder();
        if (!NBootUtils.isBlank(groupId)) {
            sb.append(groupId).append(":");
        }
        sb.append(NBootUtils.trim(artifactId));
        if (version != null && !version.isBlank()) {
            sb.append("#");
            sb.append(version);
        }
        if (!NBootUtils.isBlank(classifier)) {
            sb.append("?");
            sb.append("classifier=");
            sb.append(classifier);
        }
        return sb.toString();
    }

    public static String toDependencyExclusionListString(List<NBootId> exclusions) {
        TreeSet<String> ex = new TreeSet<String>();
        for (NBootId exclusion : exclusions) {
            ex.add(exclusion.getShortName());
        }
        return String.join((CharSequence)",", ex);
    }

    private static void setIdProperty(String key, String value, NBootId builder, NBootEnvCondition sb, Map<String, String> props) {
        if (key == null) {
            return;
        }
        switch (key) {
            case "profile": {
                sb.setProfile(NBootUtils.splitDefault(value));
                break;
            }
            case "platform": {
                sb.setPlatform(NBootUtils.parsePropertyIdList(value));
                break;
            }
            case "osdist": {
                sb.setOsDist(NBootUtils.parsePropertyIdList(value));
                break;
            }
            case "arch": {
                sb.setArch(NBootUtils.parsePropertyIdList(value));
                break;
            }
            case "os": {
                sb.setOs(NBootUtils.parsePropertyIdList(value));
                break;
            }
            case "desktop": {
                sb.setDesktopEnvironment(NBootUtils.parsePropertyIdList(value));
                break;
            }
            case "cond-properties": {
                Map<String, String> mm = NBootStringMapFormat.COMMA_FORMAT.parse(value);
                sb.setProperties(mm);
                break;
            }
            default: {
                props.put(key, value);
            }
        }
    }

    public static String getErrorMessage(Throwable ex) {
        String m = ex.getMessage();
        if (m == null || m.length() < 5) {
            m = ex.toString();
        }
        return m;
    }

    public static <T> T findThrowable(Throwable th, Class<T> type, Predicate<Throwable> filter) {
        HashSet<Throwable> visited = new HashSet<Throwable>();
        Stack<Throwable> stack = new Stack<Throwable>();
        if (th != null) {
            stack.push(th);
        }
        while (!stack.isEmpty()) {
            Throwable a = (Throwable)stack.pop();
            if (!visited.add(a)) continue;
            if (type.isAssignableFrom(th.getClass()) && (filter == null || filter.test(th))) {
                return (T)th;
            }
            Throwable c = th.getCause();
            if (c != null) {
                stack.add(c);
            }
            if (!(th instanceof InvocationTargetException) || (c = ((InvocationTargetException)th).getTargetException()) == null) continue;
            stack.add(c);
        }
        return null;
    }

    public static String[] stacktraceToArray(Throwable th) {
        try {
            String line;
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                th.printStackTrace(pw);
            }
            BufferedReader br = new BufferedReader(new StringReader(sw.toString()));
            ArrayList<String> s = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                s.add(line);
            }
            return s.toArray(new String[0]);
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    public static String stacktrace(Throwable th) {
        try {
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                th.printStackTrace(pw);
            }
            return sw.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static List<String> splitDefault(String str) {
        return NBootUtils.split(str, " ;,\n\r\t|", true, true);
    }

    public static List<String> parseAndTrimToDistinctList(String s) {
        if (s == null) {
            return new ArrayList<String>();
        }
        return NBootUtils.splitDefault(s).stream().map(String::trim).filter(x -> x.length() > 0).distinct().collect(Collectors.toList());
    }

    public static String joinAndTrimToNull(List<String> args) {
        return NBootUtils.trimToNull(String.join((CharSequence)",", args));
    }

    public static Integer parseFileSizeInBytes(String value, Integer defaultMultiplier) {
        if (NBootUtils.isBlank(value)) {
            return null;
        }
        Integer i = NBootUtils.parseInt(value = value.trim());
        if (i != null) {
            if (defaultMultiplier != null) {
                return i * defaultMultiplier;
            }
            return i;
        }
        for (String s : new String[]{"kb", "mb", "gb", "k", "m", "g"}) {
            String v;
            if (!value.toLowerCase().endsWith(s) || (i = NBootUtils.parseInt(v = value.substring(0, value.length() - s.length()).trim())) == null) continue;
            switch (s) {
                case "k": 
                case "kb": {
                    return i * 1024;
                }
                case "m": 
                case "mb": {
                    return i * 1024 * 1024;
                }
                case "g": 
                case "gb": {
                    return i * 1024 * 1024 * 1024;
                }
            }
        }
        return null;
    }

    public static int firstIndexOf(String string, char[] chars) {
        char[] value = string.toCharArray();
        for (int i = 0; i < value.length; ++i) {
            for (char aChar : chars) {
                if (value[i] != aChar) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T, V> Map<T, V> nonNullMap(Map<T, V> other) {
        if (other == null) {
            return new LinkedHashMap();
        }
        return new LinkedHashMap<T, V>(other);
    }

    public static <T> List<T> nonNullListFromArray(T[] other) {
        return NBootUtils.nonNullList(Arrays.asList(other));
    }

    public static <T> List<T> unmodifiableOrNullList(Collection<T> other) {
        if (other == null) {
            return null;
        }
        return Collections.unmodifiableList(new ArrayList<T>(other));
    }

    public static <T> Set<T> unmodifiableOrNullSet(Collection<T> other) {
        if (other == null) {
            return null;
        }
        return Collections.unmodifiableSet(new LinkedHashSet<T>(other));
    }

    public static <T, V> Map<T, V> unmodifiableOrNullMap(Map<T, V> other) {
        if (other == null) {
            return null;
        }
        return Collections.unmodifiableMap(new LinkedHashMap<T, V>(other));
    }

    public static <T> List<T> copyOrNullList(Collection<T> other) {
        if (other == null) {
            return null;
        }
        return new ArrayList<T>(other);
    }

    public static <T> List<T> nonNullList(Collection<T> other) {
        if (other == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(other);
    }

    public static <T> Set<T> nonNullSet(Collection<T> other) {
        if (other == null) {
            return new LinkedHashSet();
        }
        return new LinkedHashSet<T>(other);
    }

    public static List<String> addUniqueNonBlankList(List<String> list, String ... values) {
        LinkedHashSet<String> newList = new LinkedHashSet<String>();
        if (list != null) {
            newList.addAll(list);
        }
        boolean someUpdates = false;
        if (values != null) {
            for (String value : values) {
                if (NBootUtils.isBlank(value) || !newList.add(NBootUtils.trim(value))) continue;
                someUpdates = true;
            }
        }
        if (someUpdates) {
            list = new ArrayList<String>(newList);
        }
        return list;
    }

    public static <T> List<T> uniqueNonBlankList(Collection<T> other, Predicate<T> blakifier) {
        return NBootUtils.uniqueList(other).stream().filter(x -> x != null && !blakifier.test(x)).collect(Collectors.toList());
    }

    public static List<String> uniqueNonBlankStringList(Collection<String> other) {
        return NBootUtils.uniqueList(other).stream().filter(x -> !NBootUtils.isBlank(x)).collect(Collectors.toList());
    }

    public static <T> List<T> addUniqueNonBlankList(List<T> list, Collection<T> other, Predicate<T> blakifier) {
        if (other != null) {
            for (T t : other) {
                if (t == null || blakifier.test(t) || list.contains(t)) continue;
                list.add(t);
            }
        }
        return list;
    }

    public static <T> List<T> uniqueList(Collection<T> other) {
        if (other == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(new LinkedHashSet<T>(other));
    }

    public static <T> Set<T> set(Collection<T> other) {
        if (other == null) {
            return new LinkedHashSet();
        }
        return new LinkedHashSet<T>(other);
    }

    public static <T> List<T> unmodifiableList(Collection<T> other) {
        return other == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<T>(other));
    }

    public static <T, V> Map<T, V> unmodifiableMap(Map<T, V> other) {
        return other == null ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap<T, V>(other));
    }

    public static <T> List<T> unmodifiableUniqueList(Collection<T> other) {
        return other == null ? Collections.emptyList() : Collections.unmodifiableList(NBootUtils.uniqueList(other));
    }

    public static boolean isGraphicalDesktopEnvironment() {
        try {
            if (!GraphicsEnvironment.isHeadless()) {
                return false;
            }
            try {
                GraphicsDevice[] screenDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
                if (screenDevices == null || screenDevices.length == 0) {
                    return false;
                }
            }
            catch (HeadlessException e) {
                return false;
            }
            return true;
        }
        catch (UnsatisfiedLinkError e) {}
        finally {
            return false;
        }
    }

    public static String inputString(String message, String title, Supplier<String> in) {
        try {
            String line;
            if (title == null) {
                title = "Nuts Package Manager - 0.8.8";
            }
            if ((line = JOptionPane.showInputDialog(null, message, title, 3)) == null) {
                line = "";
            }
            return line;
        }
        catch (UnsatisfiedLinkError e) {
            NBootContext.log().with().level(Level.OFF).verbAlert().log(NBootMsg.ofC("[Graphical Environment Unsupported] %s", title));
            if (in == null) {
                return new Scanner(System.in).nextLine();
            }
            return in.get();
        }
    }

    public static void showMessage(String message, String title) {
        if (title == null) {
            title = "Nuts Package Manager";
        }
        try {
            JOptionPane.showMessageDialog(null, message);
        }
        catch (UnsatisfiedLinkError e) {
            NBootContext.log().with().level(Level.OFF).verbAlert().log(NBootMsg.ofC("[Graphical Environment Unsupported] %s", title));
        }
    }

    private static void fillBootDependencyNodes(NBootClassLoaderNode node, Set<URL> urls, Set<String> visitedIds) {
        String shortName = NBootId.of(node.getId()).getShortName();
        if (!visitedIds.contains(shortName)) {
            visitedIds.add(shortName);
            if (!node.isIncludedInClasspath()) {
                urls.add(node.getURL());
            } else {
                NBootContext.log().with().level(Level.WARNING).verbCache().log(NBootMsg.ofC("url will not be loaded (already in classloader) : %s", node.getURL()));
            }
            for (NBootClassLoaderNode dependency : node.getDependencies()) {
                NBootUtils.fillBootDependencyNodes(dependency, urls, visitedIds);
            }
        }
    }

    public static URL[] resolveClassWorldURLs(NBootClassLoaderNode[] nodes, ClassLoader contextClassLoader) {
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        HashSet<String> visitedIds = new HashSet<String>();
        for (NBootClassLoaderNode info : nodes) {
            if (info == null) continue;
            NBootUtils.fillBootDependencyNodes(info, urls, visitedIds);
        }
        return urls.toArray(new URL[0]);
    }

    public static URL findClassLoaderJar(NBootId id, URL[] urls) {
        for (URL url : urls) {
            NBootId[] nutsBootIds;
            for (NBootId i : nutsBootIds = NReservedMavenUtilsBoot.resolveJarIds(url)) {
                if (!NBootUtils.isBlank(id.getGroupId()) && !i.getGroupId().equals(id.getGroupId()) || !NBootUtils.isBlank(id.getArtifactId()) && !i.getArtifactId().equals(id.getArtifactId()) || !NBootUtils.isBlank(id.getVersion()) && !i.getVersion().equals(id.getVersion())) continue;
                return url;
            }
        }
        return null;
    }

    public static URL[] resolveClasspathURLs(ClassLoader contextClassLoader, boolean includeClassPath) {
        String classPath;
        LinkedHashSet<URL> all = new LinkedHashSet<URL>();
        if (includeClassPath && (classPath = System.getProperty("java.class.path")) != null) {
            for (String s : classPath.split(System.getProperty("path.separator"))) {
                if ((s = s.trim()).length() <= 0) continue;
                try {
                    Path pp = Paths.get(s, new String[0]);
                    if (!Files.exists(pp, new LinkOption[0])) continue;
                    all.add(pp.toUri().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        if (contextClassLoader != null) {
            if (contextClassLoader instanceof URLClassLoader) {
                all.addAll(Arrays.asList(((URLClassLoader)contextClassLoader).getURLs()));
            } else {
                try {
                    Enumeration<URL> r = contextClassLoader.getResources("META-INF/MANIFEST.MF");
                    while (r.hasMoreElements()) {
                        URL u = r.nextElement();
                        if ("jrt".equals(u.getProtocol()) || !"jar".equals(u.getProtocol()) || !u.getFile().endsWith("!/META-INF/MANIFEST.MF")) continue;
                        String jar = u.getFile().substring(0, u.getFile().length() - "!/META-INF/MANIFEST.MF".length());
                        all.add(NBootUtils.urlOf(jar));
                    }
                }
                catch (IOException | UncheckedIOException exception) {
                    // empty catch block
                }
            }
        }
        return all.toArray(new URL[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isLoadedClassPath(URL url, ClassLoader contextClassLoader) {
        NBootLog log;
        block24: {
            log = NBootContext.log();
            try {
                if (url == null) break block24;
                if (contextClassLoader == null) {
                    return false;
                }
                File file = NBootUtils.toFile(url);
                if (file == null) {
                    throw new NBootException(NBootMsg.ofC("unsupported classpath item; expected a file path: %s", url));
                }
                ZipFile zipFile = null;
                try {
                    zipFile = new ZipFile(file);
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry zipEntry = entries.nextElement();
                        String zname = zipEntry.getName();
                        if (zname.endsWith("/") || !zname.endsWith(".class") || zname.contains("$")) continue;
                        if (NBootUtils.isInfiniteLoopThread(NBootUtils.class.getName(), "isLoadedClassPath")) {
                            boolean bl = false;
                            return bl;
                        }
                        URL incp = contextClassLoader.getResource(zname);
                        String clz = zname.substring(0, zname.length() - 6).replace('/', '.');
                        if (incp != null) {
                            log.with().level(Level.FINEST).verbSuccess().log(NBootMsg.ofC("url %s is already in classpath. checked class %s successfully", url, clz));
                            boolean bl = true;
                            return bl;
                        }
                        log.with().level(Level.FINEST).verbNotice().log(NBootMsg.ofC("url %s is not in classpath. failed to check class %s", url, clz));
                        boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        log.with().level(Level.FINEST).verbFail().log(NBootMsg.ofC("url %s is not in classpath. no class found to check", url));
        return false;
    }

    public static String resolveGroupIdPath(String groupId) {
        return groupId.replace('.', '/');
    }

    public static String resolveIdPath(NBootId id) {
        StringBuilder sb = new StringBuilder();
        sb.append(NBootUtils.resolveGroupIdPath(id.getGroupId()));
        if (!NBootUtils.isBlank(id.getArtifactId())) {
            sb.append("/");
            sb.append(id.getArtifactId());
            if (!NBootUtils.isBlank(id.getVersion())) {
                sb.append("/");
                sb.append(id.getVersion());
            }
        }
        return sb.toString();
    }

    public static String resolveJarPath(NBootId id) {
        return NBootUtils.resolveFilePath(id, "jar");
    }

    public static String resolveDescPath(NBootId id) {
        return NBootUtils.resolveFilePath(id, "nuts");
    }

    public static String resolveNutsDescriptorPath(NBootId id) {
        return NBootUtils.resolveFilePath(id, "nuts");
    }

    public static String resolveFileName(NBootId id, String extension) {
        StringBuilder sb = new StringBuilder();
        sb.append(id.getArtifactId());
        if (!NBootUtils.isBlank(id.getVersion())) {
            sb.append("-").append(id.getVersion());
        }
        if (!NBootUtils.isBlank(extension)) {
            sb.append(".").append(extension);
        }
        return sb.toString();
    }

    public static String resolveFilePath(NBootId id, String extension) {
        String fileName = NBootUtils.resolveFileName(id, extension);
        return NBootUtils.resolveIdPath(id) + '/' + fileName;
    }

    public static List<String> nonNullStrList(List<String> list) {
        if (list == null) {
            return new ArrayList<String>();
        }
        return list;
    }

    public static <T> boolean isEmptyList(List<T> any) {
        return any == null || any.isEmpty();
    }

    public static long parseTimePeriod(String argPart, String optionName) {
        if (argPart == null) {
            throw new IllegalArgumentException("missing value for " + optionName);
        }
        Object[] i = NBootUtils.parseSuffixedLong(argPart);
        if (i[0] == null) {
            throw new IllegalArgumentException("expected time number for " + optionName + " : " + argPart);
        }
        long c = (Long)i[0];
        switch (String.valueOf(i[1]).toLowerCase()) {
            case "": 
            case "ms": {
                return c;
            }
            case "s": {
                return c * 1000L;
            }
            case "mn": {
                return c * 1000L * 60L;
            }
            case "h": {
                return c * 1000L * 60L * 60L;
            }
        }
        throw new IllegalArgumentException("invalid time unit for " + optionName + " : " + argPart);
    }

    private static Object[] parseSuffixedLong(String argPart) {
        if (argPart == null) {
            argPart = "";
        }
        argPart = argPart.trim();
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        char[] chars = argPart.toCharArray();
        boolean expectInt = true;
        for (int i = 0; i < chars.length; ++i) {
            if (expectInt) {
                if (Character.isDigit(chars[i])) {
                    sb1.append(chars[i]);
                    continue;
                }
                sb2.append(chars[i]);
                expectInt = false;
                continue;
            }
            sb2.append(chars[i]);
        }
        if (sb1.length() > 0) {
            try {
                long ii = Long.parseLong(sb1.toString());
                return new Object[]{ii, sb2.toString()};
            }
            catch (Exception e) {
                return new Object[]{null, sb1.toString() + sb2.toString()};
            }
        }
        return new Object[]{null, sb2.toString()};
    }

    public static String getAbsolutePath(String path) {
        return new File(path).toPath().toAbsolutePath().normalize().toString();
    }

    public static String readStringFromFile(File file) {
        try {
            return new String(Files.readAllBytes(file.toPath()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static InputStream openStream(URL url) {
        return NBootMonitoredURLInputStream.of(url);
    }

    public static byte[] loadStream(InputStream stream) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        NBootUtils.copy(stream, bos, true, true);
        return bos.toByteArray();
    }

    public static ByteArrayInputStream preloadStream(InputStream stream) {
        return new ByteArrayInputStream(NBootUtils.loadStream(stream));
    }

    public static Properties loadURLProperties(Path path) {
        Properties props = new Properties();
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                props.load(is);
            }
            catch (IOException ex) {
                return new Properties();
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties loadURLProperties(URL url, File cacheFile, boolean useCache) {
        NBootChronometer chrono = NBootChronometer.startNow();
        Properties props = new Properties();
        InputStream inputStream = null;
        File urlFile = NBootUtils.toFile(url);
        NBootLog log = NBootContext.log();
        try {
            if (useCache && cacheFile != null && cacheFile.isFile()) {
                try {
                    inputStream = new FileInputStream(cacheFile);
                    props.load(inputStream);
                    chrono.stop();
                    NBootDuration time = chrono.getDuration();
                    log.with().level(Level.CONFIG).verbSuccess().log(NBootMsg.ofC("load cached file from  %s" + (!time.isZero() ? " (time %s)" : ""), cacheFile.getPath(), chrono));
                    Properties properties = props;
                    return properties;
                }
                catch (IOException ex) {
                    log.with().level(Level.CONFIG).verbFail().log(NBootMsg.ofC("invalid cache. Ignored %s : %s", cacheFile.getPath(), ex.toString()));
                }
                finally {
                    block30: {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Exception ex) {
                                if (log == null) break block30;
                                log.with().level(Level.FINE).verbFail().error(ex).log(NBootMsg.ofPlain("unable to close stream"));
                            }
                        }
                    }
                }
            }
            inputStream = null;
            try {
                if (url == null) return props;
                String urlString = url.toString();
                inputStream = NBootUtils.openStream(url);
                if (inputStream != null) {
                    props.load(inputStream);
                    if (cacheFile != null) {
                        boolean copy = true;
                        if (urlFile != null && NBootUtils.getAbsolutePath(urlFile.getPath()).equals(NBootUtils.getAbsolutePath(cacheFile.getPath()))) {
                            copy = false;
                        }
                        if (copy) {
                            File pp = cacheFile.getParentFile();
                            if (pp != null) {
                                pp.mkdirs();
                            }
                            boolean cachedRecovered = cacheFile.isFile();
                            if (urlFile != null) {
                                NBootUtils.copy(urlFile, cacheFile);
                            } else {
                                NBootUtils.copy(url, cacheFile);
                            }
                            NBootDuration time = chrono.getDuration();
                            if (cachedRecovered) {
                                log.with().level(Level.CONFIG).verbCache().log(NBootMsg.ofC("recover cached prp file %s (from %s)" + (!time.isZero() ? " (time %s)" : ""), cacheFile.getPath(), urlString, time));
                            } else {
                                log.with().level(Level.CONFIG).verbCache().log(NBootMsg.ofC("cache prp file %s (from %s)" + (!time.isZero() ? " (time %s)" : ""), cacheFile.getPath(), urlString, time));
                            }
                            Properties properties = props;
                            return properties;
                        }
                    }
                    NBootDuration time = chrono.getDuration();
                    log.with().level(Level.CONFIG).verbSuccess().log(NBootMsg.ofC("load props file from  %s" + (!time.isZero() ? " (time %s)" : ""), urlString, time));
                    return props;
                }
                NBootDuration time = chrono.getDuration();
                log.with().level(Level.CONFIG).verbFail().log(NBootMsg.ofC("load props file from  %s" + (!time.isZero() ? " (time %s)" : ""), urlString, time));
                return props;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception e) {
            NBootDuration time = chrono.getDuration();
            log.with().level(Level.CONFIG).verbFail().log(NBootMsg.ofC("load props file from  %s" + (!time.isZero() ? " (time %s)" : ""), String.valueOf(url), time));
        }
        return props;
    }

    public static boolean isURL(String url) {
        if (url != null) {
            try {
                NBootUtils.urlOf(url);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static String getNativePath(String s) {
        return s.replace('/', File.separatorChar);
    }

    public static File toFile(String url) {
        if (NBootUtils.isBlank(url)) {
            return null;
        }
        URL u = null;
        try {
            u = NBootUtils.urlOf(url);
            return NBootUtils.toFile(u);
        }
        catch (Exception e) {
            return new File(url);
        }
    }

    public static URL toURL(String url) {
        if (NBootUtils.isBlank(url)) {
            return null;
        }
        try {
            return NBootUtils.urlOf(url);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static File toFile(URL url) {
        if (url == null) {
            return null;
        }
        if ("file".equals(url.getProtocol())) {
            try {
                return Paths.get(url.toURI()).toFile();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static long copy(InputStream from, OutputStream to, boolean closeInput, boolean closeOutput) {
        byte[] bytes = new byte[10240];
        long all = 0L;
        try {
            try {
                long l;
                block11: {
                    try {
                        int count;
                        while ((count = from.read(bytes)) > 0) {
                            to.write(bytes, 0, count);
                            all += (long)count;
                        }
                        l = all;
                        if (!closeInput) break block11;
                    }
                    catch (Throwable throwable) {
                        if (closeInput) {
                            from.close();
                        }
                        throw throwable;
                    }
                    from.close();
                }
                return l;
            }
            finally {
                if (closeOutput) {
                    to.close();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void copy(File ff, File to) {
        if (ff.equals(to)) {
            return;
        }
        if (to.getParentFile() != null) {
            to.getParentFile().mkdirs();
        }
        NBootLog log = NBootContext.log();
        if (ff == null || !ff.exists()) {
            log.with().level(Level.CONFIG).verbFail().log(NBootMsg.ofC("not found %s", ff));
            throw new UncheckedIOException(new FileNotFoundException(ff == null ? "" : ff.getPath()));
        }
        try {
            Files.copy(ff.toPath(), to.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            log.with().level(Level.CONFIG).verbFail().log(NBootMsg.ofC("error copying %s to %s : %s", ff, to, ex.toString()));
            throw new UncheckedIOException(ex);
        }
    }

    public static void copy(String path, File to) {
        if (NBootUtils.isBlank(path)) {
            throw new UncheckedIOException(new IOException("empty path " + path));
        }
        File file = NBootUtils.toFile(path);
        if (file != null) {
            NBootUtils.copy(file, to);
        } else {
            URL u = NBootUtils.toURL(path);
            if (u != null) {
                NBootUtils.copy(u, to);
            } else {
                throw new UncheckedIOException(new IOException("neither file nor URL : " + path));
            }
        }
    }

    public static void copy(URL url, File to) {
        NBootLog log = NBootContext.log();
        try {
            boolean mkdirs;
            InputStream in = NBootUtils.openStream(url);
            if (in == null) {
                throw new IOException("empty Stream " + url);
            }
            if (to.getParentFile() != null && !to.getParentFile().isDirectory() && !(mkdirs = to.getParentFile().mkdirs())) {
                log.with().level(Level.CONFIG).verbFail().log(NBootMsg.ofC("error creating folder %s", url));
            }
            ReadableByteChannel rbc = Channels.newChannel(in);
            FileOutputStream fos = new FileOutputStream(to);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        }
        catch (FileNotFoundException ex) {
            log.with().level(Level.CONFIG).verbFail().log(NBootMsg.ofC("not found %s", url));
            throw new UncheckedIOException(ex);
        }
        catch (UncheckedIOException ex) {
            log.with().level(Level.CONFIG).verbFail().log(NBootMsg.ofC("not found %s", url));
            throw ex;
        }
        catch (IOException ex) {
            log.with().level(Level.CONFIG).verbFail().log(NBootMsg.ofC("error copying %s to %s : %s", url, to, ex.toString()));
            throw new UncheckedIOException(ex);
        }
    }

    public static File createFile(String parent, String child) {
        String userHome = System.getProperty("user.home");
        if (child.startsWith("~/") || child.startsWith("~\\")) {
            child = new File(userHome, child.substring(2)).getPath();
        }
        if (child.startsWith("/") || child.startsWith("\\") || new File(child).isAbsolute()) {
            return new File(child);
        }
        if (parent != null) {
            if (parent.startsWith("~/")) {
                parent = new File(userHome, parent.substring(2)).getPath();
            }
        } else {
            parent = ".";
        }
        return new File(parent, child);
    }

    public static String expandPath(String path, String base, Function<String, String> pathExpansionConverter) {
        if (NBootUtils.isURL(path = NBootMsg.ofV(path.trim(), pathExpansionConverter).toString())) {
            return path;
        }
        if (path.startsWith("~/") || path.startsWith("~\\")) {
            path = System.getProperty("user.home") + path.substring(1);
        }
        if (base == null) {
            base = System.getProperty("user.dir");
        }
        if (new File(path).isAbsolute()) {
            return path;
        }
        return base + File.separator + path;
    }

    public static boolean isFileAccessible(Path path, Instant expireTime) {
        boolean proceed = Files.isRegularFile(path, new LinkOption[0]);
        if (proceed) {
            try {
                FileTime lastModifiedTime;
                if (expireTime != null && (lastModifiedTime = Files.getLastModifiedTime(path, new LinkOption[0])).toInstant().compareTo(expireTime) < 0) {
                    return false;
                }
            }
            catch (Exception ex0) {
                NBootContext.log().with().level(Level.FINEST).verbFail().log(NBootMsg.ofC("unable to get LastModifiedTime for file : %s", path.toString(), ex0.toString()));
            }
        }
        return proceed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getURLDigest(URL url) {
        if (url != null) {
            File ff = NBootUtils.toFile(url);
            if (ff != null) {
                return NBootUtils.getFileOrDirectoryDigest(ff.toPath());
            }
            InputStream is = null;
            try {
                is = NBootUtils.openStream(url);
                if (is != null) {
                    String string = NBootUtils.getStreamDigest(is);
                    return string;
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }

    public static String getFileOrDirectoryDigest(Path p) {
        if (Files.isDirectory(p, new LinkOption[0])) {
            return NBootUtils.getDirectoryDigest(p);
        }
        if (Files.isRegularFile(p, new LinkOption[0])) {
            String string;
            block10: {
                InputStream is = Files.newInputStream(p, new OpenOption[0]);
                try {
                    string = NBootUtils.getStreamDigest(is);
                    if (is == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        return null;
                    }
                }
                is.close();
            }
            return string;
        }
        return null;
    }

    private static String getDirectoryDigest(Path p) {
        try {
            final MessageDigest md = MessageDigest.getInstance("MD5");
            Files.walkFileTree(p, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    NBootUtils.incrementalUpdateFileDigest(new ByteArrayInputStream(dir.toString().getBytes()), md);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    NBootUtils.incrementalUpdateFileDigest(new ByteArrayInputStream(file.toString().getBytes()), md);
                    try {
                        NBootUtils.incrementalUpdateFileDigest(Files.newInputStream(file, new OpenOption[0]), md);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
            byte[] digest = md.digest();
            return NBootUtils.toHexString(digest);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getStreamDigest(InputStream is) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return NBootUtils.getStreamDigest(is, md, 2048);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getStreamDigest(InputStream is, MessageDigest md, int byteArraySize) {
        try {
            int numBytes;
            md.reset();
            byte[] bytes = new byte[byteArraySize];
            while ((numBytes = is.read(bytes)) != -1) {
                md.update(bytes, 0, numBytes);
            }
            byte[] digest = md.digest();
            return NBootUtils.toHexString(digest);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static void incrementalUpdateFileDigest(InputStream is, MessageDigest md) {
        try {
            int numBytes;
            byte[] bytes = new byte[4096];
            while ((numBytes = is.read(bytes)) != -1) {
                md.update(bytes, 0, numBytes);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static InputStream resolveInputStream(String url) {
        InputStream in;
        block11: {
            in = null;
            try {
                if (url.startsWith("http://") || url.startsWith("https://")) {
                    URL url1 = NBootUtils.urlOf(url);
                    try {
                        in = NBootUtils.openStream(url1);
                        break block11;
                    }
                    catch (Exception ex) {
                        return null;
                    }
                }
                if (url.startsWith("file:")) {
                    URL url1 = NBootUtils.urlOf(url);
                    File file = NBootUtils.toFile(url1);
                    if (file == null) {
                        try {
                            in = NBootUtils.openStream(url1);
                            break block11;
                        }
                        catch (Exception ex) {
                            return null;
                        }
                    }
                    if (file.isFile()) {
                        in = Files.newInputStream(file.toPath(), new OpenOption[0]);
                        break block11;
                    }
                    return null;
                }
                File file = new File(url);
                if (file.isFile()) {
                    in = Files.newInputStream(file.toPath(), new OpenOption[0]);
                    break block11;
                }
                return null;
            }
            catch (IOException | UncheckedIOException e) {
                NBootLog log = NBootContext.log();
                log.with().level(Level.FINE).verbFail().error(e).log(NBootMsg.ofC("unable to resolveInputStream %s", url));
            }
        }
        return in;
    }

    public static long deleteAndConfirmAll(Path[] folders, boolean force, NBootDeleteFilesContextBoot refForceAll, String header, NBootOptionsInfo bOptions, Supplier<String> readline) {
        long count = 0L;
        boolean headerWritten = false;
        if (folders != null) {
            for (Path child : folders) {
                if (!Files.exists(child, new LinkOption[0])) continue;
                if (!headerWritten) {
                    headerWritten = true;
                    if (!(force || refForceAll.isForce(true) || header == null || NBootUtils.firstNonNull(bOptions.getBot(), false).booleanValue())) {
                        NBootContext.log().with().level(Level.WARNING).verbAlert().log(NBootMsg.ofC("%s", header));
                    }
                }
                count += NBootUtils.deleteAndConfirm(child, force, refForceAll, bOptions, readline);
            }
        }
        return count;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long deleteAndConfirm(Path directory, boolean force, NBootDeleteFilesContextBoot refForceAll, NBootOptionsInfo bOptions, Supplier<String> readline) {
        String confirm = NBootUtils._confirm(bOptions);
        boolean bot = NBootUtils.firstNonNull(bOptions.getBot(), false);
        boolean gui = NBootUtils.firstNonNull(bOptions.getGui(), false);
        if (!Files.exists(directory, new LinkOption[0])) return 0L;
        NBootLog log = NBootContext.log();
        if (!force && !refForceAll.isForce(true) && refForceAll.accept(directory)) {
            String line = null;
            if (bot) {
                if (!NBootUtils.sameEnum(confirm, "YES")) throw new NBootException(NBootMsg.ofPlain("failed to delete files in --bot mode without auto confirmation"));
                line = "y";
            } else {
                switch (confirm) {
                    case "YES": {
                        line = "y";
                        break;
                    }
                    case "NO": {
                        line = "n";
                        break;
                    }
                    case "ERROR": {
                        throw new NBootException(NBootMsg.ofPlain("error response"));
                    }
                    case "ASK": {
                        if (gui) {
                            line = NBootUtils.inputString(NBootMsg.ofC("do you confirm deleting %s [y/n/c] (default 'n') ?", directory).toString(), null, readline);
                            break;
                        }
                        log.with().level(Level.OFF).verbAlert().log(NBootMsg.ofC("do you confirm deleting %s [y/n/c] (default 'n') ? : ", directory));
                        line = readline.get();
                    }
                }
            }
            if (line != null && line.equals(line.toUpperCase()) && NBootUtils.parseBoolean(line) != null) {
                refForceAll.setForce(NBootUtils.parseBoolean(line));
            } else {
                if ("c".equalsIgnoreCase(line)) {
                    throw new NBootCancelException();
                }
                if (!NBootUtils.firstNonNull(NBootUtils.parseBoolean(line), false).booleanValue()) {
                    refForceAll.ignore(directory);
                    return 0L;
                }
            }
        }
        final long[] count = new long[1];
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    count[0] = count[0] + 1L;
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    count[0] = count[0] + 1L;
                    boolean deleted = false;
                    for (int i = 0; i < 2; ++i) {
                        try {
                            Files.delete(dir);
                            deleted = true;
                            break;
                        }
                        catch (DirectoryNotEmptyException directoryNotEmptyException) {
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                        try {
                            Thread.sleep(500L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                    if (!deleted) {
                        try {
                            Files.delete(dir);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            count[0] = count[0] + 1L;
            log.with().level(Level.FINEST).verbAlert().log(NBootMsg.ofC("delete folder : %s (%s files/folders deleted)", directory, count[0]));
            return count[0];
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static String formatURL(URL url) {
        if (url == null) {
            return "<EMPTY>";
        }
        File f = NBootUtils.toFile(url);
        if (f != null) {
            return f.getPath();
        }
        return url.toString();
    }

    public static String getStoreLocationPath(NBootOptionsInfo bOptions, String storeType) {
        Map<String, String> storeLocations = bOptions.getStoreLocations();
        if (storeLocations != null) {
            return storeLocations.get(NBootUtils.enumId(storeType));
        }
        return null;
    }

    public static long deleteStoreLocations(NBootOptionsInfo lastBootOptions, NBootOptionsInfo o, boolean includeRoot, Object[] storeTypesOrPaths, Supplier<String> readline) {
        if (lastBootOptions == null) {
            return 0L;
        }
        String confirm = NBootUtils._confirm(o);
        if (NBootUtils.sameEnum(confirm, "ASK") && !NBootUtils.sameEnum(NBootUtils.enumId(NBootUtils.firstNonNull(o.getOutputFormat(), "PLAIN")), "PLAIN")) {
            throw new NBootException(NBootMsg.ofPlain("unable to switch to interactive mode for non plain text output format. You need to provide default response (-y|-n) for resetting/recovering workspace. You was asked to confirm deleting folders as part as recover/reset option."), 255);
        }
        NBootLog log = NBootContext.log();
        log.with().level(Level.FINEST).verbAlert().log(NBootMsg.ofC("delete workspace location(s) at : %s", lastBootOptions.getWorkspace()));
        boolean force = false;
        switch (confirm) {
            case "ASK": {
                break;
            }
            case "YES": {
                force = true;
                break;
            }
            case "NO": 
            case "ERROR": {
                log.with().level(Level.WARNING).verbAlert().log(NBootMsg.ofPlain("reset cancelled (applied '--no' argument)"));
                throw new NBootCancelException();
            }
        }
        ArrayList<Path> folders = new ArrayList<Path>();
        if (includeRoot) {
            folders.add(Paths.get(lastBootOptions.getWorkspace(), new String[0]));
        }
        NBootPlatformHome hh = NBootUtils.firstNonNull(o.getSystem(), false) != false ? NBootPlatformHome.ofSystem(o.getStoreLayout()) : NBootPlatformHome.of(o.getStoreLayout());
        for (Object ovalue : storeTypesOrPaths) {
            if (ovalue == null) continue;
            if (ovalue instanceof String) {
                String p = NBootUtils.getStoreLocationPath(lastBootOptions, (String)ovalue);
                if (p != null) {
                    folders.add(Paths.get(p, new String[0]));
                    continue;
                }
                folders.add(Paths.get(hh.getStore((String)ovalue), new String[0]));
                continue;
            }
            if (ovalue instanceof Path) {
                folders.add((Path)ovalue);
                continue;
            }
            if (ovalue instanceof File) {
                folders.add(((File)ovalue).toPath());
                continue;
            }
            throw new NBootException(NBootMsg.ofC("unsupported path type : %s", ovalue));
        }
        NBootOptionsInfo optionsCopy = o.copy();
        if (NBootUtils.firstNonNull(optionsCopy.getBot(), false).booleanValue() || !NBootUtils.isGraphicalDesktopEnvironment()) {
            optionsCopy.setGui(false);
        }
        return NBootUtils.deleteAndConfirmAll(folders.toArray(new Path[0]), force, "ATTENTION ! You are about to delete nuts workspace files.", optionsCopy, readline);
    }

    private static String _confirm(NBootOptionsInfo o) {
        return NBootUtils.enumName(NBootUtils.firstNonNull(o.getConfirm(), "ASK"));
    }

    public static long deleteStoreLocationsHard(NBootOptionsInfo lastBootOptions, NBootOptionsInfo bOptions, Supplier<String> readline) {
        String _ws;
        String confirm = NBootUtils._confirm(bOptions);
        if (NBootUtils.sameEnum(confirm, "ASK") && !NBootUtils.sameEnum(NBootUtils.enumName(NBootUtils.firstNonNull(bOptions.getOutputFormat(), "PLAIN")), "PLAIN")) {
            throw new NBootException(NBootMsg.ofPlain("unable to switch to interactive mode for non plain text output format. You need to provide default response (-y|-n) for resetting/recovering workspace. You was asked to confirm deleting folders as part as recover/reset option."), 255);
        }
        NBootLog log = NBootContext.log();
        log.with().level(Level.FINEST).verbAlert().log(NBootMsg.ofC("hard reset nuts to remove all workspaces and all configuration files."));
        boolean force = false;
        switch (confirm) {
            case "ASK": {
                break;
            }
            case "YES": {
                force = true;
                break;
            }
            case "NO": 
            case "ERROR": {
                log.with().level(Level.WARNING).verbAlert().log(NBootMsg.ofPlain("reset cancelled (applied '--no' argument)"));
                throw new NBootCancelException();
            }
        }
        LinkedHashSet<Path> folders = new LinkedHashSet<Path>();
        NBootPlatformHome hh = NBootUtils.firstNonNull(bOptions.getSystem(), false) != false ? NBootPlatformHome.ofSystem(bOptions.getStoreLayout()) : NBootPlatformHome.of(bOptions.getStoreLayout());
        folders.add(Paths.get(hh.getHome(), new String[0]).resolve("ws"));
        for (String storeType : NBootPlatformHome.storeTypes()) {
            folders.add(Paths.get(hh.getStore(storeType), new String[0]));
        }
        if (lastBootOptions != null) {
            folders.add(Paths.get(lastBootOptions.getWorkspace(), new String[0]));
            for (String ovalue : NBootPlatformHome.storeTypes()) {
                if (ovalue == null) continue;
                if (ovalue instanceof String) {
                    String p = NBootUtils.getStoreLocationPath(lastBootOptions, ovalue);
                    if (p == null) continue;
                    folders.add(Paths.get(p, new String[0]));
                    continue;
                }
                if (ovalue instanceof Path) {
                    folders.add((Path)((Object)ovalue));
                    continue;
                }
                if (ovalue instanceof File) {
                    folders.add(((File)((Object)ovalue)).toPath());
                    continue;
                }
                throw new NBootException(NBootMsg.ofC("unsupported path type : %s", ovalue));
            }
        }
        if (!NBootUtils.isRemoteWorkspaceLocation(_ws = bOptions.getWorkspace())) {
            Boolean systemWorkspace = NBootUtils.firstNonNull(bOptions.getSystem(), false);
            String lastNutsWorkspaceJsonConfigPath = NBootUtils.isValidWorkspaceName(_ws) ? NBootPlatformHome.of(null, systemWorkspace).getWorkspaceLocation(NBootUtils.resolveValidWorkspaceName(_ws)) : NBootUtils.getAbsolutePath(_ws);
            folders.add(Paths.get(lastNutsWorkspaceJsonConfigPath, new String[0]));
        }
        for (String ovalue : NBootPlatformHome.storeTypes()) {
            if (ovalue == null) continue;
            if (ovalue instanceof String) {
                String p = NBootUtils.getStoreLocationPath(bOptions, ovalue);
                if (p == null) continue;
                folders.add(Paths.get(p, new String[0]));
                continue;
            }
            if (ovalue instanceof Path) {
                folders.add((Path)((Object)ovalue));
                continue;
            }
            if (ovalue instanceof File) {
                folders.add(((File)((Object)ovalue)).toPath());
                continue;
            }
            throw new NBootException(NBootMsg.ofC("unsupported path type : %s", ovalue));
        }
        NBootOptionsInfo optionsCopy = bOptions.copy();
        if (NBootUtils.firstNonNull(optionsCopy.getBot(), false).booleanValue() || !NBootUtils.isGraphicalDesktopEnvironment()) {
            optionsCopy.setGui(false);
        }
        return NBootUtils.deleteAndConfirmAll((Path[])folders.stream().sorted().toArray(Path[]::new), force, "ATTENTION ! You are about to delete workspaces and all nuts configuration files.", optionsCopy, readline);
    }

    public static long deleteAndConfirmAll(Path[] folders, boolean force, String header, NBootOptionsInfo bOptions, Supplier<String> readline) {
        return NBootUtils.deleteAndConfirmAll(folders, force, new NBootDeleteFilesContextBootImpl(), header, bOptions, readline);
    }

    public static String trim(String value) {
        if (value == null) {
            return "";
        }
        return value.trim();
    }

    public static CharSequence trim(CharSequence value) {
        int st;
        int len0;
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return value.toString().trim();
        }
        int len = len0 = value.length();
        for (st = 0; st < len && value.charAt(st) <= ' '; ++st) {
        }
        while (st < len && value.charAt(len - 1) <= ' ') {
            --len;
        }
        return st > 0 || len < len0 ? value.subSequence(st, len) : value.toString();
    }

    public static CharSequence trimLeft(CharSequence value) {
        int st;
        if (value == null) {
            return "";
        }
        int len = value.length();
        if (len == 0) {
            return value.toString();
        }
        for (st = 0; st < len && value.charAt(st) <= ' '; ++st) {
        }
        if (st > 0) {
            return value.subSequence(st, len);
        }
        return value.toString();
    }

    public static CharSequence trimRight(CharSequence value) {
        int st;
        if (value == null) {
            return "";
        }
        int len = value.length();
        if (len == 0) {
            return value.toString();
        }
        for (st = len; st > 0 && value.charAt(st - 1) <= ' '; --st) {
        }
        if (st < len) {
            return value.subSequence(0, st);
        }
        return value.toString();
    }

    public static String trimToNull(String value) {
        if (value == null) {
            return null;
        }
        String t = value.trim();
        if (t.isEmpty()) {
            return null;
        }
        return t;
    }

    public static String trimToNull(CharSequence value) {
        if (value == null) {
            return null;
        }
        String t = NBootUtils.trim(value).toString();
        if (t.isEmpty()) {
            return null;
        }
        return t;
    }

    public static String firstNonNull(String ... values) {
        return NBootUtils.firstNonNull(values == null ? null : Arrays.asList(values));
    }

    public static String firstNonNull(List<String> values) {
        if (values != null) {
            for (String value : values) {
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }

    public static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static String firstNonBlank(String a, String b) {
        if (!NBootUtils.isBlank(a)) {
            return a;
        }
        if (!NBootUtils.isBlank(b)) {
            return b;
        }
        return null;
    }

    public static String firstNonBlank(String ... values) {
        return NBootUtils.firstNonBlank(values == null ? null : Arrays.asList(values));
    }

    public static String firstNonBlank(List<String> values) {
        if (values != null) {
            for (String value : values) {
                if (NBootUtils.isBlank(value)) continue;
                return value;
            }
        }
        return null;
    }

    public static String toHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = BASE16_CHARS[v >>> 4];
            hexChars[j * 2 + 1] = BASE16_CHARS[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String formatAlign(String text, int size, NBootPositionTypeBoot position) {
        int len;
        if (text == null) {
            text = "";
        }
        if ((len = text.length()) >= size) {
            return text;
        }
        switch (position) {
            case FIRST: {
                StringBuilder sb = new StringBuilder(size);
                sb.append(text);
                for (int i = len; i < size; ++i) {
                    sb.append(' ');
                }
                return sb.toString();
            }
            case LAST: {
                StringBuilder sb = new StringBuilder(size);
                for (int i = len; i < size; ++i) {
                    sb.append(' ');
                }
                sb.append(text);
                return sb.toString();
            }
            case CENTER: {
                int i;
                StringBuilder sb = new StringBuilder(size);
                int h = size / 2 + size % 2;
                for (i = len; i < h; ++i) {
                    sb.append(' ');
                }
                sb.append(text);
                h = size / 2;
                for (i = len; i < h; ++i) {
                    sb.append(' ');
                }
                return sb.toString();
            }
        }
        throw new UnsupportedOperationException();
    }

    public static String formatStringLiteral(String text) {
        return NBootUtils.formatStringLiteral(text, NBootQuoteTypeBoot.DOUBLE);
    }

    public static String formatStringLiteral(String text, NBootQuoteTypeBoot quoteType) {
        return NBootUtils.formatStringLiteral(text, quoteType, NBootSupportMode.ALWAYS);
    }

    public static String formatStringLiteral(String text, NBootQuoteTypeBoot quoteType, NBootSupportMode condition) {
        return NBootUtils.formatStringLiteral(text, quoteType, condition, "");
    }

    public static String formatStringLiteral(String text, NBootQuoteTypeBoot quoteType, NBootSupportMode condition, String escapeChars) {
        if (text == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        boolean requireQuotes = condition == NBootSupportMode.ALWAYS;
        boolean allowQuotes = condition != NBootSupportMode.NEVER;
        block14: for (char c : text.toCharArray()) {
            switch (c) {
                case ' ': {
                    if (allowQuotes) {
                        sb.append(" ");
                        requireQuotes = true;
                        continue block14;
                    }
                    sb.append("\\ ");
                    continue block14;
                }
                case '\n': {
                    sb.append("\\n");
                    if (requireQuotes || !allowQuotes) continue block14;
                    requireQuotes = true;
                    continue block14;
                }
                case '\f': {
                    sb.append("\\f");
                    if (requireQuotes || !allowQuotes) continue block14;
                    requireQuotes = true;
                    continue block14;
                }
                case '\r': {
                    sb.append("\\r");
                    if (requireQuotes || !allowQuotes) continue block14;
                    requireQuotes = true;
                    continue block14;
                }
                case '\t': {
                    sb.append("\\t");
                    if (requireQuotes || !allowQuotes) continue block14;
                    requireQuotes = true;
                    continue block14;
                }
                case '\"': {
                    if (quoteType == NBootQuoteTypeBoot.DOUBLE) {
                        sb.append("\\").append(c);
                        if (requireQuotes || !allowQuotes) continue block14;
                        requireQuotes = true;
                        continue block14;
                    }
                    sb.append(c);
                    continue block14;
                }
                case '\'': {
                    if (quoteType == NBootQuoteTypeBoot.SIMPLE) {
                        sb.append("\\").append(c);
                        if (requireQuotes || !allowQuotes) continue block14;
                        requireQuotes = true;
                        continue block14;
                    }
                    sb.append(c);
                    continue block14;
                }
                case '`': {
                    sb.append(c);
                    continue block14;
                }
                default: {
                    if (escapeChars != null && escapeChars.indexOf(c) >= 0) {
                        if (allowQuotes) {
                            sb.append(c);
                            requireQuotes = true;
                            continue block14;
                        }
                        sb.append("\\").append(c);
                        continue block14;
                    }
                    sb.append(c);
                }
            }
        }
        if (sb.length() == 0) {
            requireQuotes = true;
        }
        if (requireQuotes) {
            switch (quoteType) {
                case DOUBLE: {
                    sb.insert(0, '\"');
                    sb.append('\"');
                    break;
                }
                case SIMPLE: {
                    sb.insert(0, '\'');
                    sb.append('\'');
                }
            }
        }
        return sb.toString();
    }

    public static List<String> parsePropertyIdList(String s) {
        return NBootUtils.parseStringIdList(s);
    }

    public static List<String> parsePropertyStringList(String s) {
        return NBootUtils.parseAndTrimToDistinctList(s);
    }

    public static List<String> split(String value, String chars) {
        return NBootUtils.split(value, chars, true, false);
    }

    public static String repeat(char c, int count) {
        char[] e = new char[count];
        Arrays.fill(e, c);
        return new String(e);
    }

    public static String repeat(String str, int count) {
        if (count < 0) {
            throw new ArrayIndexOutOfBoundsException(count);
        }
        switch (count) {
            case 0: {
                return "";
            }
            case 1: {
                return str;
            }
        }
        StringBuilder sb = new StringBuilder(str.length() * count);
        for (int i = 0; i < count; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static String alignLeft(String s, int width) {
        StringBuilder sb = new StringBuilder();
        if (s != null) {
            sb.append(s);
            int x = width - sb.length();
            if (x > 0) {
                sb.append(NBootUtils.repeat(' ', x));
            }
        }
        return sb.toString();
    }

    public static String alignRight(String s, int width) {
        StringBuilder sb = new StringBuilder();
        if (s != null) {
            sb.append(s);
            int x = width - sb.length();
            if (x > 0) {
                sb.insert(0, NBootUtils.repeat(' ', x));
            }
        }
        return sb.toString();
    }

    public static List<String> split(String value, String chars, boolean trim, boolean ignoreEmpty) {
        if (value == null) {
            value = "";
        }
        StringTokenizer st = new StringTokenizer(value, chars, true);
        ArrayList<String> all = new ArrayList<String>();
        boolean wasSep = true;
        while (st.hasMoreElements()) {
            String s = st.nextToken();
            if (chars.indexOf(s.charAt(0)) >= 0) {
                if (wasSep) {
                    s = "";
                    if (!ignoreEmpty) {
                        all.add(s);
                    }
                }
                wasSep = true;
                continue;
            }
            wasSep = false;
            if (trim) {
                s = s.trim();
            }
            if (ignoreEmpty && s.isEmpty()) continue;
            all.add(s);
        }
        if (wasSep && !ignoreEmpty) {
            all.add("");
        }
        return all;
    }

    public static byte[] fromHexString(String s) {
        int len = s.length();
        if (len == 0) {
            return new byte[0];
        }
        if (s.length() % 2 == 1) {
            s = s + "0";
            ++len;
        }
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            char c1 = s.charAt(i);
            char c2 = s.charAt(i + 1);
            data[i / 2] = (byte)((Character.digit(c1, 16) << 4) + Character.digit(c2, 16));
        }
        return data;
    }

    public static String replaceDollarPlaceHolder(String text, Function<String, String> mapper) {
        if (mapper == null) {
            return "";
        }
        return NBootUtils.parseDollarPlaceHolder(text).map(t -> {
            switch (t.ttype) {
                case -65: 
                case -64: {
                    String x = (String)mapper.apply(t.sval);
                    if (x == null) {
                        throw new IllegalArgumentException("var not found " + t.sval);
                    }
                    return x;
                }
            }
            return t.sval;
        }).collect(Collectors.joining());
    }

    public static Stream<NBootToken> parseDollarPlaceHolder(final String text) {
        final String TT_DEFAULT_STR = NBootToken.typeString(Integer.MIN_VALUE);
        final String TT_DOLLAR_BRACE_STR = NBootToken.typeString(-65);
        final String TT_DOLLAR_STR = NBootToken.typeString(-64);
        return NBootUtils.iterToStream(new Iterator<NBootToken>(){
            final char[] t;
            int p;
            final int length;
            final StringBuilder sb;
            final StringBuilder n;
            final StringBuilder ni;
            final List<NBootToken> buffer;
            {
                this.t = text == null ? new char[]{} : text.toCharArray();
                this.p = 0;
                this.length = this.t.length;
                this.sb = new StringBuilder(this.length);
                this.n = new StringBuilder(this.length);
                this.ni = new StringBuilder(this.length);
                this.buffer = new ArrayList<NBootToken>(2);
            }

            private boolean ready() {
                return !this.buffer.isEmpty();
            }

            @Override
            public boolean hasNext() {
                if (this.ready()) {
                    return true;
                }
                while (this.p < this.length) {
                    this.fillOnce();
                    if (!this.ready()) continue;
                    return true;
                }
                if (this.sb.length() > 0) {
                    this.buffer.add(NBootToken.of(Integer.MIN_VALUE, this.sb.toString(), 0, 0, this.sb.toString(), TT_DEFAULT_STR));
                    this.sb.setLength(0);
                }
                return this.ready();
            }

            private void fillOnce() {
                char c = this.t[this.p];
                if (c == '$' && this.p + 1 < this.length && this.t[this.p + 1] == '{') {
                    this.p += 2;
                    this.n.setLength(0);
                    this.ni.setLength(0);
                    this.ni.append(c).append('{');
                    while (this.p < this.length) {
                        c = this.t[this.p];
                        if (c != '}') {
                            this.n.append(c);
                            this.ni.append(c);
                            ++this.p;
                            continue;
                        }
                        this.ni.append(c);
                        break;
                    }
                    if (this.sb.length() > 0) {
                        this.buffer.add(NBootToken.of(Integer.MIN_VALUE, this.sb.toString(), 0, 0, this.sb.toString(), TT_DEFAULT_STR));
                        this.sb.setLength(0);
                    }
                    this.buffer.add(NBootToken.of(-65, this.n.toString(), 0, 0, this.ni.toString(), TT_DOLLAR_BRACE_STR));
                } else if (c == '$' && this.p + 1 < this.length && NBootUtils.isValidVarStart(this.t[this.p + 1])) {
                    ++this.p;
                    this.n.setLength(0);
                    this.ni.setLength(0);
                    this.ni.append(c);
                    while (this.p < this.length) {
                        c = this.t[this.p];
                        if (NBootUtils.isValidVarPart(c)) {
                            this.n.append(c);
                            this.ni.append(c);
                            ++this.p;
                            continue;
                        }
                        --this.p;
                        break;
                    }
                    if (this.sb.length() > 0) {
                        this.buffer.add(NBootToken.of(Integer.MIN_VALUE, this.sb.toString(), 0, 0, this.sb.toString(), TT_DEFAULT_STR));
                        this.sb.setLength(0);
                    }
                    this.buffer.add(NBootToken.of(-64, this.n.toString(), 0, 0, this.ni.toString(), TT_DOLLAR_STR));
                } else {
                    this.sb.append(c);
                }
                ++this.p;
            }

            @Override
            public NBootToken next() {
                NBootUtils.requireTrue(this.ready(), "token ready");
                return this.buffer.remove(0);
            }
        });
    }

    public static boolean isValidVarPart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_';
    }

    public static boolean isValidVarStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    private static <T> Stream<T> iterToStream(Iterator<T> it) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 0), false);
    }

    public static String toStringOrEmpty(Object any) {
        if (any == null) {
            return "";
        }
        return any.toString();
    }

    public static boolean isBlank(String value) {
        return value == null || value.trim().isEmpty();
    }

    private static NBootMsg createMessage(Supplier<NBootMsg> msg) {
        NBootUtils.requireNonNull(msg, "message supplier");
        NBootMsg m = msg.get();
        NBootUtils.requireNonNull(m, "message");
        return m;
    }

    private static String createName(String name) {
        return NBootUtils.isBlank(name) ? "value" : name;
    }

    public static <T> T requireNonNull(T object, Supplier<NBootMsg> msg) {
        if (object == null) {
            throw NBootUtils.creatIllegalArgumentException(NBootUtils.createMessage(msg));
        }
        return object;
    }

    public static <T> T requireNonNull(T object, String name) {
        return NBootUtils.requireNonNull(object, () -> NBootMsg.ofC("%s should not be null", NBootUtils.createName(name)));
    }

    public static <T> T requireNonNull(T object) {
        return NBootUtils.requireNonNull(object, "value");
    }

    public static void requireNull(Object object, String name) {
        if (object != null) {
            throw NBootUtils.creatIllegalArgumentException(NBootMsg.ofC("%s must be null", NBootUtils.createName(name)));
        }
    }

    public static void requireNull(Object object, Supplier<NBootMsg> message) {
        if (object != null) {
            throw NBootUtils.creatIllegalArgumentException(NBootUtils.createMessage(message));
        }
    }

    public static String requireNonBlank(String object, String name) {
        if (NBootUtils.isBlank(object)) {
            throw NBootUtils.creatIllegalArgumentException(NBootMsg.ofC("%s should not be blank", NBootUtils.createName(name)));
        }
        return object;
    }

    public static String requireNonBlank(String object, Supplier<NBootMsg> msg) {
        if (NBootUtils.isBlank(object)) {
            throw NBootUtils.creatIllegalArgumentException(NBootUtils.createMessage(msg));
        }
        return object;
    }

    private static RuntimeException creatIllegalArgumentException(NBootMsg m) {
        throw new IllegalArgumentException(m.toString());
    }

    public static void requireNull(Object object) {
        NBootUtils.requireNull(object, (String)null);
    }

    public static boolean requireTrue(boolean value, String name) {
        return NBootUtils.requireTrue(value, () -> NBootMsg.ofC("should be %s", NBootUtils.createName(name)));
    }

    public static boolean requireTrue(boolean object, Supplier<NBootMsg> msg) {
        if (!object) {
            throw NBootUtils.creatIllegalArgumentException(NBootUtils.createMessage(msg));
        }
        return object;
    }

    public static boolean requireFalse(boolean value, String name) {
        return NBootUtils.requireFalse(value, () -> NBootMsg.ofC("should not be %s", NBootUtils.createName(name)));
    }

    public static boolean requireFalse(boolean object, Supplier<NBootMsg> msg) {
        if (!object) {
            throw NBootUtils.creatIllegalArgumentException(NBootUtils.createMessage(msg));
        }
        return object;
    }

    public static int processThrowable(Throwable ex, String[] args, NBootOptionsInfo bootOptions) {
        if (ex == null) {
            return 0;
        }
        NAnyBootAwareExceptionBase u = NBootUtils.findThrowable(ex, NAnyBootAwareExceptionBase.class, null);
        if (u != null) {
            return u.processThrowable(bootOptions);
        }
        if (bootOptions == null) {
            bootOptions = new NBootOptionsInfo();
            NBootWorkspaceCmdLineParser.parseNutsArguments(args, bootOptions);
        }
        return NBootUtils.processThrowable(ex, true, NBootUtils.resolveShowStackTrace(bootOptions), NBootUtils.resolveGui(bootOptions));
    }

    public static boolean resolveGui(NBootOptionsInfo bo) {
        if (bo == null) {
            return false;
        }
        if (bo.getBot() != null && bo.getBot().booleanValue()) {
            return false;
        }
        if (bo.getGui() != null && bo.getGui().booleanValue()) {
            return NBootUtils.isGraphicalDesktopEnvironment();
        }
        return false;
    }

    public static int processThrowable(Throwable ex, boolean showMessage, boolean showStackTrace, boolean showGui) {
        if (ex == null) {
            return 0;
        }
        NBootLog out = NBootContext.log();
        String m = NBootUtils.getErrorMessage(ex);
        if (out == null) {
            if (showMessage) {
                System.err.println(NBootMsg.ofPlain(m));
                if (showStackTrace) {
                    System.err.println(NBootMsg.ofPlain("---------------"));
                    System.err.println(NBootMsg.ofPlain(">  STACKTRACE :"));
                    System.err.println(NBootMsg.ofPlain("---------------"));
                    System.err.println(NBootMsg.ofPlain(NBootUtils.stacktrace(ex)));
                }
            }
            if (showGui) {
                StringBuilder sb = new StringBuilder();
                sb.append(m);
                if (showStackTrace && sb.length() > 0) {
                    sb.append("\n");
                    sb.append(NBootUtils.stacktrace(ex));
                }
                NBootUtils.showMessage(NBootMsg.ofPlain(sb.toString()).toString(), "Nuts Package Manager - Error");
            }
        } else {
            if (showMessage) {
                out.with().level(Level.OFF).verbFail().log(NBootMsg.ofPlain(m));
                if (showStackTrace) {
                    out.with().level(Level.OFF).verbFail().log(NBootMsg.ofPlain("---------------"));
                    out.with().level(Level.OFF).verbFail().log(NBootMsg.ofPlain(">  STACKTRACE :"));
                    out.with().level(Level.OFF).verbFail().log(NBootMsg.ofPlain("---------------"));
                    out.with().level(Level.OFF).verbFail().log(NBootMsg.ofPlain(NBootUtils.stacktrace(ex)));
                }
            }
            if (showGui) {
                StringBuilder sb = new StringBuilder();
                sb.append(m);
                if (showStackTrace && sb.length() > 0) {
                    sb.append("\n");
                    sb.append(NBootUtils.stacktrace(ex));
                }
                NBootUtils.showMessage(NBootMsg.ofPlain(sb.toString()).toString(), "Nuts Package Manager - Error");
            }
        }
        return 224;
    }

    public static int exitIfError(Throwable ex, String[] args, NBootOptionsInfo bootOptions) {
        int code = NBootUtils.processThrowable(ex, args, bootOptions);
        if (code != 0) {
            System.exit(code);
        }
        return code;
    }

    public static int exitIfError(int code) {
        if (code != 0) {
            System.exit(code);
        }
        return code;
    }

    public static boolean resolveShowStackTrace(NBootOptionsInfo bo) {
        if (bo == null) {
            return true;
        }
        if (bo.getShowStacktrace() != null) {
            return bo.getShowStacktrace();
        }
        if (bo.getBot() != null && bo.getBot().booleanValue()) {
            return false;
        }
        if (NBootUtils.getSysBoolNutsProperty("stacktrace", false)) {
            return true;
        }
        if (bo.getDebug() != null && !NBootUtils.isBlank(bo.getDebug())) {
            return true;
        }
        NBootLogConfig nLogConfig = bo.getLogConfig();
        return nLogConfig != null && nLogConfig.getLogTermLevel() != null && nLogConfig.getLogTermLevel().intValue() < Level.INFO.intValue();
    }

    public static String damerauLevenshteinClosest(double threshold, String str1, String[] dictionary) {
        if (threshold > 1.0) {
            threshold = 1.0;
        }
        if (threshold < 0.0) {
            threshold = 0.0;
        }
        double bestRelativeDistance = -1.0;
        String bestResult = null;
        if (str1 == null) {
            str1 = "";
        }
        for (String s : dictionary) {
            double u;
            if (s == null) {
                s = "";
            }
            if (!((u = NBootUtils.computeOptionSimilarity(str1, s)) >= threshold) || bestResult != null && !(u > bestRelativeDistance)) continue;
            bestResult = s;
            bestRelativeDistance = u;
        }
        return bestResult;
    }

    public static int damerauLevenshtein(String s1, String s2) {
        int i;
        int len1 = s1.length();
        int len2 = s2.length();
        int[][] dp = new int[len1 + 1][len2 + 1];
        for (i = 0; i <= len1; ++i) {
            dp[i][0] = i;
        }
        for (int j = 0; j <= len2; ++j) {
            dp[0][j] = j;
        }
        for (i = 1; i <= len1; ++i) {
            for (int j = 1; j <= len2; ++j) {
                int cost = s1.charAt(i - 1) == s2.charAt(j - 1) ? 0 : 1;
                dp[i][j] = Math.min(Math.min(dp[i - 1][j] + 1, dp[i][j - 1] + 1), dp[i - 1][j - 1] + cost);
                if (i <= 1 || j <= 1 || s1.charAt(i - 1) != s2.charAt(j - 2) || s1.charAt(i - 2) != s2.charAt(j - 1)) continue;
                dp[i][j] = Math.min(dp[i][j], dp[i - 2][j - 2] + cost);
            }
        }
        return dp[len1][len2];
    }

    public static double tokenSimilarity(String[] tokens1, String[] tokens2) {
        if (tokens1.length == 0 || tokens2.length == 0) {
            return 0.0;
        }
        double totalScore = 0.0;
        int totalComparisons = 0;
        for (String token1 : tokens1) {
            int minDistance = Integer.MAX_VALUE;
            String bestMatch = "";
            for (String token2 : tokens2) {
                int distance = NBootUtils.damerauLevenshtein(token1, token2);
                if (distance >= minDistance) continue;
                minDistance = distance;
                bestMatch = token2;
            }
            double maxLength = Math.max(token1.length(), bestMatch.length());
            double similarity = maxLength == 0.0 ? 1.0 : 1.0 - (double)minDistance / maxLength;
            totalScore += similarity;
            ++totalComparisons;
        }
        return totalComparisons == 0 ? 0.0 : totalScore / (double)totalComparisons;
    }

    public static double fuzzyJaccardSimilarity(String[] tokens1, String[] tokens2) {
        if (tokens1.length == 0 || tokens2.length == 0) {
            return 0.0;
        }
        HashSet<String> set1 = new HashSet<String>(Arrays.asList(tokens1));
        HashSet<String> set2 = new HashSet<String>(Arrays.asList(tokens2));
        double intersection = 0.0;
        double union = set1.size() + set2.size();
        for (String token1 : set1) {
            double bestMatchScore = 0.0;
            for (String token2 : set2) {
                int distance = NBootUtils.damerauLevenshtein(token1, token2);
                double maxLen = Math.max(token1.length(), token2.length());
                double d = maxLen == 0.0 ? 1.0 : 1.0 - (double)distance / maxLen;
                double similarity = d;
                if (!(similarity > bestMatchScore)) continue;
                bestMatchScore = similarity;
            }
            intersection += bestMatchScore;
        }
        return intersection / union;
    }

    public static double computeOptionSimilarity(String word1, String word2) {
        String[] tokens1 = NBootUtils.split(word1, " ;,\n\r\t|-_", true, true).toArray(new String[0]);
        String[] tokens2 = NBootUtils.split(word2, " ;,\n\r\t|-_", true, true).toArray(new String[0]);
        double tokenEditSimilarity = NBootUtils.tokenSimilarity(tokens1, tokens2);
        double fuzzyJaccardSimilarity = NBootUtils.fuzzyJaccardSimilarity(tokens1, tokens2);
        return tokenEditSimilarity * 0.6 + fuzzyJaccardSimilarity * 0.4;
    }

    public static boolean isRemoteWorkspaceLocation(String _ws) {
        return _ws != null && _ws.matches("[a-z-]+://.*");
    }
}

