/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot.internal.util;

import net.thevpc.nuts.boot.NBootId;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public class NReservedErrorInfo {
    private final NBootId nutsId;
    private final String repository;
    private final String url;
    private final String message;
    private final Throwable throwable;

    public NReservedErrorInfo(NBootId nutsId, String repository, String url, String message, Throwable throwable) {
        this.nutsId = nutsId;
        this.repository = repository;
        this.url = url;
        this.message = message;
        this.throwable = throwable;
    }

    public NBootId getNutsId() {
        return this.nutsId;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!NBootUtils.isBlank(this.getMessage())) {
            sb.append(this.getMessage());
        } else {
            sb.append("unexpected error");
        }
        if (this.getNutsId() != null) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(" for id ").append(this.getNutsId());
        }
        if (this.getUrl() != null) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(" from ").append(this.getUrl());
        }
        if (this.getRepository() != null) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(" for repository ").append(this.getRepository());
        }
        if (this.getThrowable() != null) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(": ").append(this.getThrowable().toString());
        }
        return sb.toString();
    }
}

