/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.boot.NBootId;
import net.thevpc.nuts.boot.internal.util.NBootPlatformHome;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public class NBootEnvCondition
implements Serializable {
    public static final NBootEnvCondition BLANK = new NBootEnvCondition();
    private static final long serialVersionUID = 1L;
    private List<String> arch = new ArrayList<String>();
    private List<String> os = new ArrayList<String>();
    private List<String> osDist = new ArrayList<String>();
    private List<String> platform = new ArrayList<String>();
    private List<String> desktopEnvironment = new ArrayList<String>();
    private List<String> profiles = new ArrayList<String>();
    private Map<String, String> properties = new HashMap<String, String>();

    public NBootEnvCondition() {
    }

    public NBootEnvCondition(NBootEnvCondition other) {
        this.copyFrom(other);
    }

    public NBootEnvCondition(List<String> arch, List<String> os, List<String> osDist, List<String> platform, List<String> desktopEnvironment, List<String> profile, Map<String, String> properties) {
        this.arch = arch == null ? Collections.emptyList() : Collections.unmodifiableList(arch);
        this.os = os == null ? Collections.emptyList() : Collections.unmodifiableList(os);
        this.osDist = osDist == null ? Collections.emptyList() : Collections.unmodifiableList(osDist);
        this.platform = platform == null ? Collections.emptyList() : Collections.unmodifiableList(platform);
        this.desktopEnvironment = desktopEnvironment == null ? Collections.emptyList() : Collections.unmodifiableList(desktopEnvironment);
        this.profiles = profile == null ? Collections.emptyList() : Collections.unmodifiableList(profile);
        this.properties = properties == null ? new HashMap<String, String>() : new HashMap<String, String>(properties);
    }

    public static boolean isAcceptCondition(NBootEnvCondition cond) {
        String earch;
        List<String> oss = NBootUtils.uniqueNonBlankStringList(cond.getOs());
        List<String> archs = NBootUtils.uniqueNonBlankStringList(cond.getArch());
        if (!oss.isEmpty()) {
            String eos = NBootPlatformHome.currentOsFamily();
            boolean osOk = false;
            for (String e : oss) {
                NBootId ee = NBootId.of(e);
                if (!ee.getShortName().equalsIgnoreCase(eos)) continue;
                if (!NBootUtils.acceptVersion(ee.getVersion(), System.getProperty("os.version"))) break;
                osOk = true;
                break;
            }
            if (!osOk) {
                return false;
            }
        }
        if (!archs.isEmpty() && (earch = System.getProperty("os.arch")) != null) {
            boolean archOk = false;
            for (String e : archs) {
                if (e.isEmpty() || !e.equalsIgnoreCase(earch)) continue;
                archOk = true;
                break;
            }
            return archOk;
        }
        return true;
    }

    public List<String> getArch() {
        return this.arch;
    }

    public NBootEnvCondition setArch(List<String> arch) {
        this.arch = NBootUtils.uniqueNonBlankStringList(arch);
        return this;
    }

    public List<String> getOs() {
        return this.os;
    }

    public NBootEnvCondition setOs(List<String> os) {
        this.os = NBootUtils.uniqueNonBlankStringList(os);
        return this;
    }

    public List<String> getOsDist() {
        return this.osDist;
    }

    public NBootEnvCondition setOsDist(List<String> osDist) {
        this.osDist = NBootUtils.uniqueNonBlankStringList(osDist);
        return this;
    }

    public List<String> getPlatform() {
        return this.platform;
    }

    public NBootEnvCondition setPlatform(List<String> platform) {
        this.platform = NBootUtils.uniqueNonBlankStringList(platform);
        return this;
    }

    public List<String> getDesktopEnvironment() {
        return this.desktopEnvironment;
    }

    public NBootEnvCondition setDesktopEnvironment(List<String> desktopEnvironment) {
        this.desktopEnvironment = NBootUtils.uniqueNonBlankStringList(desktopEnvironment);
        return this;
    }

    public List<String> getProfiles() {
        return this.profiles;
    }

    public NBootEnvCondition setProfile(List<String> profiles) {
        this.profiles = profiles;
        return this;
    }

    public NBootEnvCondition copyFrom(NBootEnvCondition other) {
        if (other != null) {
            this.setArch(this.mergeLists(this.getArch(), other.getArch()));
            this.setOs(this.mergeLists(this.getOs(), other.getOs()));
            this.setOsDist(this.mergeLists(this.getOsDist(), other.getOsDist()));
            this.setPlatform(this.mergeLists(this.getPlatform(), other.getPlatform()));
            this.setDesktopEnvironment(this.mergeLists(this.getDesktopEnvironment(), other.getDesktopEnvironment()));
            this.setProfile(this.mergeLists(this.getProfiles(), other.getProfiles()));
            this.setProperties(this.mergeMaps(this.getProperties(), other.getProperties()));
        }
        return this;
    }

    private Map<String, String> mergeMaps(Map<String, String> a, Map<String, String> b) {
        LinkedHashMap<String, String> n = new LinkedHashMap<String, String>();
        if (a != null) {
            n.putAll(a);
        }
        if (a != null) {
            n.putAll(b);
        }
        return n;
    }

    private List<String> mergeLists(List<String> a, List<String> b) {
        LinkedHashSet<String> n = new LinkedHashSet<String>();
        if (a != null) {
            n.addAll(a);
        }
        if (a != null) {
            n.addAll(b);
        }
        return new ArrayList<String>(n);
    }

    public NBootEnvCondition clear() {
        this.setArch(new ArrayList<String>());
        this.setOs(new ArrayList<String>());
        this.setOsDist(new ArrayList<String>());
        this.setPlatform(new ArrayList<String>());
        this.setDesktopEnvironment(new ArrayList<String>());
        this.setProfile(new ArrayList<String>());
        this.setProperties(new LinkedHashMap<String, String>());
        return this;
    }

    public NBootEnvCondition copy() {
        return this.builder();
    }

    public NBootEnvCondition build() {
        return new NBootEnvCondition(this.getArch(), this.getOs(), this.getOsDist(), this.getPlatform(), this.getDesktopEnvironment(), this.getProfiles(), this.properties);
    }

    public NBootEnvCondition builder() {
        return new NBootEnvCondition(this);
    }

    public String toString() {
        String s = String.join((CharSequence)" & ", (CharSequence[])Arrays.stream(new String[]{this.ts("arch", this.arch.toArray(new String[0])), this.ts("os", this.os.toArray(new String[0])), this.ts("osDist", this.osDist.toArray(new String[0])), this.ts("platform", this.platform.toArray(new String[0])), this.ts("desktop", this.desktopEnvironment.toArray(new String[0])), this.ts("profile", this.profiles.toArray(new String[0])), this.ts("props", this.properties)}).filter(x -> x.length() > 0).toArray(String[]::new));
        if (s.isEmpty()) {
            return "blank";
        }
        return s;
    }

    private String ts(String n, String[] vs) {
        if (vs.length == 0) {
            return "";
        }
        return n + "=" + String.join((CharSequence)",", vs[0]);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public NBootEnvCondition setProperties(Map<String, String> properties) {
        this.properties = properties == null ? null : new HashMap<String, String>(properties);
        return this;
    }

    public NBootEnvCondition addProperties(Map<String, String> properties) {
        if (properties != null) {
            for (Map.Entry<String, String> e : properties.entrySet()) {
                this.addProperty(e.getKey(), e.getValue());
            }
        }
        return this;
    }

    public NBootEnvCondition addProperty(String key, String value) {
        if ((key = NBootUtils.trimToNull(key)) != null) {
            if (this.properties == null) {
                this.properties = new HashMap<String, String>();
            }
            if (value == null) {
                this.properties.remove(key);
            } else {
                this.properties.put(key, value);
            }
        }
        return this;
    }

    public NBootEnvCondition addDesktopEnvironment(String value) {
        this.desktopEnvironment = NBootUtils.addUniqueNonBlankList(this.desktopEnvironment, value);
        return this;
    }

    public NBootEnvCondition addDesktopEnvironments(String ... values) {
        this.desktopEnvironment = NBootUtils.addUniqueNonBlankList(this.desktopEnvironment, values);
        return this;
    }

    public NBootEnvCondition addArchs(String value) {
        this.arch = NBootUtils.addUniqueNonBlankList(this.arch, value);
        return this;
    }

    public NBootEnvCondition addArchs(String ... values) {
        this.arch = NBootUtils.addUniqueNonBlankList(this.arch, values);
        return this;
    }

    public NBootEnvCondition addOs(String value) {
        this.os = NBootUtils.addUniqueNonBlankList(this.os, value);
        return this;
    }

    public NBootEnvCondition addOses(String ... values) {
        this.os = NBootUtils.addUniqueNonBlankList(this.os, values);
        return this;
    }

    public NBootEnvCondition addOsDist(String value) {
        this.osDist = NBootUtils.addUniqueNonBlankList(this.osDist, value);
        return this;
    }

    public NBootEnvCondition addOsDists(String ... values) {
        this.osDist = NBootUtils.addUniqueNonBlankList(this.osDist, values);
        return this;
    }

    public NBootEnvCondition addPlatform(String value) {
        this.platform = NBootUtils.addUniqueNonBlankList(this.platform, value);
        return this;
    }

    public NBootEnvCondition addPlatforms(String ... values) {
        this.platform = NBootUtils.addUniqueNonBlankList(this.platform, values);
        return this;
    }

    public NBootEnvCondition addProfile(String value) {
        this.profiles = NBootUtils.addUniqueNonBlankList(this.profiles, value);
        return this;
    }

    public NBootEnvCondition addProfiles(String ... values) {
        this.profiles = NBootUtils.addUniqueNonBlankList(this.profiles, values);
        return this;
    }

    private String ts(String n, Map<String, String> properties) {
        if (properties.isEmpty()) {
            return "";
        }
        return n + "={" + properties.entrySet().stream().map(x -> {
            String k = (String)x.getKey();
            String v = (String)x.getValue();
            if (v == null) {
                return k;
            }
            return k + "=" + v;
        }).collect(Collectors.joining(",")) + "}";
    }

    public boolean isBlank() {
        if (this.arch != null && !this.arch.isEmpty()) {
            return false;
        }
        if (this.os != null && !this.os.isEmpty()) {
            return false;
        }
        if (this.osDist != null && !this.osDist.isEmpty()) {
            return false;
        }
        if (this.platform != null && !this.platform.isEmpty()) {
            return false;
        }
        if (this.desktopEnvironment != null && !this.desktopEnvironment.isEmpty()) {
            return false;
        }
        if (this.profiles != null && !this.profiles.isEmpty()) {
            return false;
        }
        return this.properties == null || this.properties.isEmpty();
    }

    public Map<String, String> toMap() {
        return NBootUtils.toMap(this);
    }
}

