/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import net.thevpc.nuts.boot.NBootDependency;
import net.thevpc.nuts.boot.NBootEnvCondition;
import net.thevpc.nuts.boot.NBootVersion;
import net.thevpc.nuts.boot.internal.util.NBootStringMapFormat;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public class NBootId {
    public static NBootId API_ID = new NBootId("net.thevpc.nuts", "nuts", "");
    public static NBootId RUNTIME_ID = new NBootId("net.thevpc.nuts", "nuts-runtime", "");
    public static Pattern PATTERN = Pattern.compile("^(?<group>[a-zA-Z0-9_.${}*-]+)(:(?<artifact>[a-zA-Z0-9_.${}*-]+))?(#(?<version>[^?]+))?(\\?(?<query>.+))?$");
    public static NBootId BLANK = new NBootId(null, null, "");
    private String groupId;
    private String artifactId;
    private String classifier;
    private String version;
    private NBootEnvCondition condition = new NBootEnvCondition();
    private Map<String, String> properties = new LinkedHashMap<String, String>();

    public static NBootId ofApi(String version) {
        if (version == null || version.isEmpty()) {
            return API_ID;
        }
        return new NBootId("net.thevpc.nuts", "nuts", version);
    }

    public static NBootId ofRuntime(String version) {
        if (version == null || version.isEmpty()) {
            return RUNTIME_ID;
        }
        return new NBootId("net.thevpc.nuts", "nuts-runtime", version);
    }

    public static NBootId ofApi(NBootVersion version) {
        if (version == null || version.isBlank()) {
            return API_ID;
        }
        return NBootId.of("net.thevpc.nuts", "nuts", version.getValue());
    }

    public static List<NBootId> ofList(String value) {
        return NBootUtils.parseIdList(value);
    }

    public static Set<NBootId> ofSet(String value) {
        List<NBootId> nBootIds = NBootId.ofList(value);
        return nBootIds == null ? null : new LinkedHashSet<NBootId>(nBootIds);
    }

    public NBootId() {
        this.condition = new NBootEnvCondition();
    }

    public NBootId(NBootId id) {
        this.copyFrom(id);
    }

    public NBootId(String groupId, String artifactId) {
        this.groupId = NBootUtils.trimToNull(groupId);
        this.artifactId = NBootUtils.trimToNull(artifactId);
    }

    public static NBootId of(String groupId, String artifactId, String version) {
        return new NBootId(groupId, artifactId, version);
    }

    public NBootId(String groupId, String artifactId, String version) {
        this.groupId = NBootUtils.trimToNull(groupId);
        this.artifactId = NBootUtils.trimToNull(artifactId);
        this.version = version == null ? "" : version;
    }

    public NBootId(String groupId, String artifactId, String classifier, String version, String propertiesQuery, NBootEnvCondition condition) {
        this.groupId = NBootUtils.trimToNull(groupId);
        this.artifactId = NBootUtils.trimToNull(artifactId);
        this.classifier = NBootUtils.trimToNull(classifier);
        this.version = version == null ? "" : version;
        this.setCondition(condition);
        this.setProperties(this.properties);
    }

    public static NBootId of(String value) {
        return NBootUtils.parseId(value);
    }

    public NBootId copyFrom(NBootId id) {
        if (id == null) {
            this.clear();
        } else {
            this.setCondition(id.getCondition());
            this.setGroupId(id.getGroupId());
            this.setArtifactId(id.getArtifactId());
            this.setVersion(id.getVersion());
            this.setClassifier(id.getClassifier());
            this.setCondition(id.getCondition());
            this.setPropertiesQuery(id.getPropertiesQuery());
        }
        return this;
    }

    public NBootId clear() {
        this.setGroupId(null);
        this.setArtifactId(null);
        this.setVersion(null);
        this.setPropertiesQuery("");
        return this;
    }

    public NBootId setGroupId(String value) {
        this.groupId = NBootUtils.trimToNull(value);
        return this;
    }

    public NBootId setRepository(String value) {
        return this.setProperty("repo", NBootUtils.trimToNull(value));
    }

    public NBootId setVersion(String value) {
        this.version = value == null ? "" : value;
        return this;
    }

    public NBootId setArtifactId(String value) {
        this.artifactId = NBootUtils.trimToNull(value);
        return this;
    }

    public String getFace() {
        String s = this.getProperties().get("face");
        return NBootUtils.trimToNull(s);
    }

    public String getPackaging() {
        String s = this.getProperties().get("packaging");
        return NBootUtils.trimToNull(s);
    }

    public NBootId setFace(String value) {
        return this.setProperty("face", NBootUtils.trimToNull(value));
    }

    public NBootId setFaceContent() {
        return this.setFace("content");
    }

    public NBootId setFaceDescriptor() {
        return this.setFace("descriptor");
    }

    public String getClassifier() {
        return this.classifier;
    }

    public NBootId setClassifier(String value) {
        this.classifier = NBootUtils.trimToNull(value);
        return this;
    }

    public NBootId setPackaging(String value) {
        return this.setProperty("packaging", NBootUtils.trimToNull(value));
    }

    public NBootId setCondition(NBootEnvCondition c) {
        if (c == null) {
            this.setProperty("os", null);
            this.setProperty("osdist", null);
            this.setProperty("arch", null);
            this.setProperty("platform", null);
            this.setProperty("desktop", null);
            this.setProperty("profile", null);
            this.condition.setProperties(null);
        } else {
            this.setProperty("os", NBootUtils.joinAndTrimToNull(c.getOs()));
            this.setProperty("osdist", NBootUtils.joinAndTrimToNull(c.getOsDist()));
            this.setProperty("arch", NBootUtils.joinAndTrimToNull(c.getArch()));
            this.setProperty("platform", NBootUtils.formatStringIdList(c.getPlatform()));
            this.setProperty("desktop", NBootUtils.joinAndTrimToNull(c.getDesktopEnvironment()));
            this.setProperty("profile", NBootUtils.joinAndTrimToNull(c.getProfiles()));
            this.condition.setProperties(c.getProperties());
        }
        return this;
    }

    public NBootEnvCondition getCondition() {
        return this.condition;
    }

    public NBootId setProperty(String property, String value) {
        switch (property) {
            case "os": {
                this.condition.setOs(NBootUtils.parsePropertyIdList(value));
                break;
            }
            case "osdist": {
                this.condition.setOsDist(NBootUtils.parsePropertyIdList(value));
                break;
            }
            case "arch": {
                this.condition.setArch(NBootUtils.parsePropertyIdList(value));
                break;
            }
            case "platform": {
                this.condition.setPlatform(NBootUtils.parsePropertyIdList(value));
                break;
            }
            case "desktop": {
                this.condition.setDesktopEnvironment(NBootUtils.parsePropertyIdList(value));
                break;
            }
            case "profile": {
                this.condition.setProfile(NBootUtils.parsePropertyIdList(value));
                break;
            }
            case "cond-properties": {
                this.condition.setProperties(NBootStringMapFormat.DEFAULT.parse(value));
                break;
            }
            case "version": {
                this.setVersion(value);
                break;
            }
            default: {
                if (value == null) {
                    this.properties.remove(property);
                    break;
                }
                this.properties.put(property, value);
            }
        }
        return this;
    }

    public NBootId setProperties(Map<String, String> queryMap) {
        for (Map.Entry<String, String> e : queryMap.entrySet()) {
            this.setProperty(e.getKey(), e.getValue());
        }
        return this;
    }

    public NBootId clearProperties() {
        this.properties.clear();
        return this;
    }

    public NBootId setPropertiesQuery(String propertiesQuery) {
        this.setProperties(NBootStringMapFormat.DEFAULT.parse(propertiesQuery));
        return this;
    }

    public String getPropertiesQuery() {
        return NBootStringMapFormat.DEFAULT.format(this.getProperties());
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getRepository() {
        return NBootUtils.trimToNull(this.getProperties().get("repo"));
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getFullName() {
        return this.toString();
    }

    public String getShortName() {
        return NBootUtils.getIdShortName(this.groupId, this.artifactId);
    }

    public String getLongName() {
        return NBootUtils.getIdLongName(this.groupId, this.artifactId, this.version, this.classifier);
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (NBootUtils.isBlank(this.classifier)) {
            if (!NBootUtils.isBlank(this.groupId)) {
                sb.append(this.groupId).append(":");
            }
            sb.append(NBootUtils.trim(this.artifactId));
        } else {
            sb.append(NBootUtils.trim(this.groupId));
            sb.append(":").append(NBootUtils.trim(this.artifactId));
            sb.append(":").append(NBootUtils.trim(this.classifier));
        }
        String v = this.getVersion();
        if (!NBootUtils.isBlank(v)) {
            sb.append("#");
            sb.append(v);
        }
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.putAll(NBootUtils.toMap(this.condition));
        if (this.properties != null) {
            for (Map.Entry<String, String> e : this.properties.entrySet()) {
                if (m.containsKey(e.getKey())) continue;
                m.put(e.getKey(), e.getValue());
            }
        }
        if (!m.isEmpty()) {
            sb.append("?").append(NBootStringMapFormat.DEFAULT.format(m));
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NBootId nutsId = (NBootId)o;
        if (!Objects.equals(this.groupId, nutsId.groupId)) {
            return false;
        }
        if (!Objects.equals(this.artifactId, nutsId.artifactId)) {
            return false;
        }
        if (!Objects.equals(this.version, nutsId.version)) {
            return false;
        }
        if (!Objects.equals(this.classifier, nutsId.classifier)) {
            return false;
        }
        return Objects.equals(this.properties, nutsId.properties);
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }

    public boolean equalsShortId(NBootId other) {
        if (other == null) {
            return false;
        }
        return NBootUtils.trim(this.groupId).equals(NBootUtils.trim(other.getArtifactId())) && NBootUtils.trim(this.artifactId).equals(NBootUtils.trim(other.getGroupId()));
    }

    public boolean equalsLongId(NBootId other) {
        if (other == null) {
            return false;
        }
        return NBootUtils.trim(this.artifactId).equals(NBootUtils.trim(other.getArtifactId())) && NBootUtils.trim(this.groupId).equals(NBootUtils.trim(other.getGroupId())) && Objects.equals(this.version == null || NBootUtils.isBlank(this.version) ? null : this.version, other.getVersion() == null || NBootUtils.isBlank(other.getVersion()) ? null : other.getVersion()) && Objects.equals(this.getClassifier(), other.getClassifier());
    }

    public NBootId getShortId() {
        return new NBootId(this.groupId, this.artifactId, this.classifier, null, "", NBootEnvCondition.BLANK);
    }

    public NBootId getLongId() {
        return new NBootId(this.groupId, this.artifactId, this.classifier, this.version, "", NBootEnvCondition.BLANK);
    }

    public NBootId copy() {
        return new NBootId(this);
    }

    public NBootDependency toDependency() {
        Map<String, String> properties = this.getProperties();
        String exc = properties.get("exclusions");
        if (exc == null) {
            exc = "";
        }
        ArrayList<NBootId> a = new ArrayList<NBootId>();
        for (String s : NBootUtils.splitDefault(exc)) {
            NBootId n = NBootId.of(s);
            if (n == null) continue;
            a.add(n);
        }
        return new NBootDependency().setRepository(this.getRepository()).setArtifactId(this.getArtifactId()).setGroupId(this.getGroupId()).setClassifier(this.getClassifier()).setVersion(this.getVersion()).setScope(properties.get("scope")).setOptional(properties.get("optional")).setExclusions(a).setCondition(this.getCondition()).setProperties(properties);
    }

    public boolean isNull() {
        return false;
    }

    public boolean isBlank() {
        return this.toString().isEmpty();
    }

    public int compareTo(NBootId o2) {
        int x = NBootUtils.trim(this.getGroupId()).compareTo(NBootUtils.trim(o2.getGroupId()));
        if (x != 0) {
            return x;
        }
        x = NBootUtils.trim(this.getArtifactId()).compareTo(NBootUtils.trim(o2.getArtifactId()));
        if (x != 0) {
            return x;
        }
        x = NBootUtils.trim(this.getClassifier()).compareTo(NBootUtils.trim(o2.getClassifier()));
        if (x != 0) {
            return x;
        }
        x = NBootVersion.of(this.getVersion()).compareTo(NBootVersion.of(o2.getVersion()));
        if (x != 0) {
            return x;
        }
        return 0;
    }
}

