/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot;

import net.thevpc.nuts.boot.NBootException;
import net.thevpc.nuts.boot.NBootRepositoryLocation;
import net.thevpc.nuts.boot.internal.util.NBootMsg;
import net.thevpc.nuts.boot.internal.util.NBootRepositoryDB;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public class NBootRepositorySelector {
    private final NBootRepositoryLocation location;
    private String op;

    public static NBootRepositorySelector of(String location, NBootRepositoryDB db) {
        return NBootRepositorySelector.of(null, location, db);
    }

    public static NBootRepositorySelector of(String op, String location, NBootRepositoryDB db) {
        location = NBootUtils.trim(location);
        op = NBootRepositorySelector.parseSelectorOp(op);
        if (location.length() > 0) {
            if (location.startsWith("+")) {
                op = "INCLUDE";
                location = location.substring(1).trim();
            } else if (location.startsWith("-")) {
                op = "EXCLUDE";
                location = location.substring(1).trim();
            } else if (location.startsWith("=")) {
                op = "EXACT";
                location = location.substring(1).trim();
            }
            NBootRepositoryLocation z = NBootRepositoryLocation.of(location, db);
            if (z != null) {
                return new NBootRepositorySelector(op, z);
            }
        }
        return null;
    }

    private static String parseSelectorOp(String op) {
        if (op == null) {
            op = "INCLUDE";
        } else {
            switch (NBootUtils.enumName(op)) {
                case "INCLUDE": {
                    op = "INCLUDE";
                    break;
                }
                case "EXCLUDE": {
                    op = "EXCLUDE";
                    break;
                }
                case "EXACT": {
                    op = "EXACT";
                    break;
                }
                default: {
                    throw new NBootException(NBootMsg.ofC("invalid op %s", op));
                }
            }
        }
        return op;
    }

    public NBootRepositorySelector(String op, NBootRepositoryLocation location) {
        NBootUtils.requireNonNull(op, "operator");
        NBootUtils.requireNonNull(location, "location");
        this.op = NBootRepositorySelector.parseSelectorOp(op);
        this.location = location;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (NBootUtils.enumName(this.op)) {
            case "EXACT": {
                sb.append("=");
                break;
            }
            case "EXCLUDE": {
                sb.append("-");
                break;
            }
            case "INCLUDE": {
                sb.append("+");
            }
        }
        sb.append(this.location);
        return sb.toString();
    }

    public String getOp() {
        return this.op;
    }

    public String getName() {
        return this.location.getName();
    }

    public String getUrl() {
        return this.location.getFullLocation();
    }

    public NBootRepositoryLocation getLocation() {
        return this.location;
    }

    public boolean matches(NBootRepositoryLocation other) {
        String otherName = other.getName();
        String otherURL = other.getFullLocation();
        String name0 = this.location.getName();
        String url0 = this.location.getFullLocation();
        otherName = otherName == null ? "" : otherName.trim();
        otherURL = otherURL == null ? "" : otherURL.trim();
        String _name = name0 == null ? "" : name0.trim();
        String _url = url0 == null ? "" : url0.trim();
        String string = otherURL = otherURL == null ? otherURL : otherURL.trim();
        if (_name.length() > 0 && _name.equals(otherName)) {
            return true;
        }
        return _url.length() > 0 && _url.equals(otherURL);
    }
}

