/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot;

import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.thevpc.nuts.boot.NBootArguments;
import net.thevpc.nuts.boot.NBootException;
import net.thevpc.nuts.boot.NBootLogConfig;
import net.thevpc.nuts.boot.NBootOptionsInfo;
import net.thevpc.nuts.boot.NBootWorkspace;
import net.thevpc.nuts.boot.core.NWorkspaceBase;
import net.thevpc.nuts.boot.internal.cmdline.NBootArg;
import net.thevpc.nuts.boot.internal.cmdline.NBootCmdLine;
import net.thevpc.nuts.boot.internal.cmdline.NBootWorkspaceCmdLineParser;
import net.thevpc.nuts.boot.internal.util.NBootI18n;
import net.thevpc.nuts.boot.internal.util.NBootLog;
import net.thevpc.nuts.boot.internal.util.NBootMsg;
import net.thevpc.nuts.boot.internal.util.NBootUtils;
import net.thevpc.nuts.boot.internal.util.NBootWorkspaceHelper;

public class NBootWorkspaceNativeExec
implements NBootWorkspace {
    public static final String COMMAND_PREFIX = "native-exec";
    private final Instant creationTime = Instant.now();
    private Scanner scanner;
    private final NBootLog bLog;
    private final NBootOptionsInfo options;
    private long minTime = 5000L;
    private long waitTime = 3000L;
    private long maxCount = -1L;
    private NBootArguments unparsedOptions;

    public NBootWorkspaceNativeExec(NBootArguments unparsedOptions) {
        if (unparsedOptions == null) {
            unparsedOptions = new NBootArguments();
        }
        this.unparsedOptions = unparsedOptions;
        NBootOptionsInfo userOptions = new NBootOptionsInfo();
        userOptions.setStdin(unparsedOptions.getIn());
        userOptions.setStdout(unparsedOptions.getOut());
        userOptions.setStderr(unparsedOptions.getErr());
        userOptions.setCreationTime(unparsedOptions.getStartTime());
        InputStream in = userOptions.getStdin();
        this.scanner = new Scanner(in == null ? System.in : in);
        this.bLog = new NBootLog(userOptions);
        ArrayList<String> allArgs = new ArrayList<String>();
        if (unparsedOptions.getOptionArgs() != null) {
            allArgs.addAll(Arrays.asList(unparsedOptions.getOptionArgs()));
        }
        if (unparsedOptions.getAppArgs() != null) {
            allArgs.addAll(Arrays.asList(unparsedOptions.getAppArgs()));
        }
        this.parseArguments(allArgs.toArray(new String[0]), userOptions);
        if (NBootUtils.firstNonNull(userOptions.getSkipErrors(), false).booleanValue()) {
            StringBuilder errorMessage = new StringBuilder();
            if (userOptions.getErrors() != null) {
                for (String s : userOptions.getErrors()) {
                    errorMessage.append(s).append("\n");
                }
            }
            errorMessage.append(NBootI18n.of("Try 'nuts --help' for more information."));
            this.bLog.warn(NBootMsg.ofC(NBootI18n.of("Skipped Error : %s"), errorMessage));
        }
        this.options = userOptions.copy();
        this.postInit();
    }

    @Override
    public NBootArguments getBootArguments() {
        return this.unparsedOptions;
    }

    @Override
    public NBootOptionsInfo getOptions() {
        return this.options;
    }

    private void parseArguments(String[] bootArguments, NBootOptionsInfo userOptions) {
        NBootCmdLine cmdLine = new NBootCmdLine(bootArguments).setCommandName("nuts").setExpandSimpleOptions(true).registerSpecialSimpleOption("-version");
        while (cmdLine.hasNext()) {
            if (this.nextArgument(cmdLine, userOptions) != null) continue;
            cmdLine.skip();
        }
    }

    private List<NBootArg> nextArgument(NBootCmdLine cmdLine, NBootOptionsInfo options) {
        while (cmdLine.hasNext()) {
            NBootArg a = cmdLine.peek();
            if (a.isOption()) {
                String k;
                boolean active = a.isActive();
                switch (k = a.key()) {
                    case "--min-time": {
                        String sValue;
                        a = cmdLine.nextEntry();
                        if (active) {
                            sValue = NBootUtils.firstNonNull(a.getStringValue(), "");
                            try {
                                this.minTime = NBootUtils.parseTimePeriod(sValue, k);
                            }
                            catch (Exception ex) {
                                NBootWorkspaceHelper.addError(NBootMsg.ofC("%s", ex.getMessage()), options);
                            }
                            break;
                        }
                        return Collections.singletonList(a);
                    }
                    case "--wait-time": {
                        String sValue;
                        a = cmdLine.nextEntry();
                        if (active) {
                            sValue = NBootUtils.firstNonNull(a.getStringValue(), "");
                            try {
                                this.waitTime = NBootUtils.parseTimePeriod(sValue, k);
                            }
                            catch (Exception ex) {
                                NBootWorkspaceHelper.addError(NBootMsg.ofC("%s", ex.getMessage()), options);
                            }
                            break;
                        }
                        return Collections.singletonList(a);
                    }
                    case "--max-count": {
                        String sValue;
                        a = cmdLine.nextEntry();
                        if (active) {
                            sValue = NBootUtils.firstNonNull(a.getStringValue(), "");
                            try {
                                this.maxCount = Long.parseLong(sValue);
                            }
                            catch (Exception ex) {
                                NBootWorkspaceHelper.addError(NBootMsg.ofC("%s", ex.getMessage()), options);
                            }
                            break;
                        }
                        return Collections.singletonList(a);
                    }
                    case "--java": 
                    case "--boot-java": 
                    case "-j": {
                        String v;
                        a = cmdLine.nextEntry();
                        if (active && options != null) {
                            v = NBootUtils.firstNonNull(a.getStringValue(), "");
                            options.setJavaCommand(v);
                        }
                        return Collections.singletonList(a);
                    }
                    case "--java-home": 
                    case "--boot-java-home": {
                        String v;
                        a = cmdLine.nextEntry();
                        if (active && options != null) {
                            v = a.getStringValue();
                            options.setJavaCommand(NBootUtils.resolveJavaCommand(v));
                        }
                        return Collections.singletonList(a);
                    }
                    case "--java-options": 
                    case "--boot-java-options": 
                    case "-J": {
                        a = cmdLine.nextEntry();
                        String v = NBootUtils.firstNonNull(a.getStringValue(), "");
                        if (active && options != null) {
                            options.setJavaOptions(v);
                        }
                        return Collections.singletonList(a);
                    }
                    case "--gui": {
                        a = cmdLine.nextFlag();
                        if (active && options != null) {
                            options.setGui(a.getBooleanValue());
                        }
                        return Collections.singletonList(a);
                    }
                    case "-B": 
                    case "--bot": {
                        a = cmdLine.nextFlag();
                        if (active) {
                            if (options != null) {
                                options.setBot(a.getBooleanValue());
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "-t": 
                    case "--trace": {
                        a = cmdLine.nextFlag();
                        if (active) {
                            if (options != null) {
                                options.setTrace(a.getBooleanValue());
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "-P": 
                    case "--progress": {
                        a = cmdLine.next();
                        if (active) {
                            if (options != null) {
                                String s = a.getStringValue();
                                if (a.isNegated()) {
                                    s = NBootUtils.isBlank(s) ? "false" : "false," + s;
                                    options.setProgressOptions(s);
                                } else {
                                    options.setProgressOptions(s);
                                }
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "--dry": 
                    case "-D": {
                        a = cmdLine.nextFlag();
                        if (active && options != null) {
                            options.setDry(a.getBooleanValue());
                        }
                        return Collections.singletonList(a);
                    }
                    case "--stacktrace": {
                        a = cmdLine.nextFlag();
                        if (active && options != null) {
                            options.setShowStacktrace(a.getBooleanValue());
                        }
                        return Collections.singletonList(a);
                    }
                    case "--debug": {
                        a = cmdLine.next();
                        if (active) {
                            if (options != null) {
                                if (NBootUtils.isBlank(a.getStringValue())) {
                                    options.setDebug(String.valueOf(a.isEnabled()));
                                } else if (a.isNegated()) {
                                    options.setDebug(String.valueOf(NBootUtils.parseBoolean(a.getStringValue(), true, false) == false));
                                } else {
                                    options.setDebug(a.getStringValue());
                                }
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "--verbose": 
                    case "--log-verbose": 
                    case "--log-finest": 
                    case "--log-finer": 
                    case "--log-fine": 
                    case "--log-info": 
                    case "--log-warning": 
                    case "--log-severe": 
                    case "--log-config": 
                    case "--log-all": 
                    case "--log-off": 
                    case "--log-term-verbose": 
                    case "--log-term-finest": 
                    case "--log-term-finer": 
                    case "--log-term-fine": 
                    case "--log-term-info": 
                    case "--log-term-warning": 
                    case "--log-term-severe": 
                    case "--log-term-config": 
                    case "--log-term-all": 
                    case "--log-term-off": 
                    case "--log-file-verbose": 
                    case "--log-file-finest": 
                    case "--log-file-finer": 
                    case "--log-file-fine": 
                    case "--log-file-info": 
                    case "--log-file-warning": 
                    case "--log-file-severe": 
                    case "--log-file-config": 
                    case "--log-file-all": 
                    case "--log-file-off": 
                    case "--log-file-size": 
                    case "--log-file-name": 
                    case "--log-file-base": 
                    case "--log-file-count": {
                        if (active) {
                            NBootLogConfig logConfig = options.getLogConfig();
                            if (logConfig == null) {
                                logConfig = new NBootLogConfig();
                            }
                            NBootArg r = NBootWorkspaceCmdLineParser.parseLogLevel(logConfig, cmdLine, active);
                            options.setLogConfig(logConfig);
                            return r == null ? null : Collections.singletonList(r);
                        }
                        return Collections.singletonList(a);
                    }
                    case "--output-format-option": 
                    case "-T": {
                        if (active) {
                            if (options != null) {
                                options.addOutputFormatOptions(cmdLine.nextEntry().getStringValue());
                            }
                            return Collections.singletonList(a);
                        }
                        cmdLine.skip();
                        return Collections.singletonList(a);
                    }
                    case "-O": 
                    case "--output-format": {
                        a = cmdLine.nextEntry();
                        if (active) {
                            if (options != null) {
                                String t = NBootUtils.firstNonNull(a.getStringValue(), "");
                                int i = NBootUtils.firstIndexOf(t, new char[]{' ', ';', ':', '='});
                                if (i > 0) {
                                    options.setOutputFormat(t.substring(0, i).toUpperCase());
                                    options.addOutputFormatOptions(t.substring(i + 1).toUpperCase());
                                } else {
                                    options.setOutputFormat(t.toUpperCase());
                                    options.addOutputFormatOptions("");
                                }
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "--tson": {
                        a = cmdLine.next();
                        if (active) {
                            if (options != null) {
                                options.setOutputFormat("TSON");
                                options.addOutputFormatOptions(NBootUtils.firstNonNull(a.getStringValue(), ""));
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "--yaml": {
                        a = cmdLine.next();
                        if (active) {
                            if (options != null) {
                                options.setOutputFormat("YAML");
                                options.addOutputFormatOptions(NBootUtils.firstNonNull(a.getStringValue(), ""));
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "--json": {
                        a = cmdLine.next();
                        if (active) {
                            if (options != null) {
                                options.setOutputFormat("JSON");
                                options.addOutputFormatOptions(NBootUtils.firstNonNull(a.getStringValue(), ""));
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "--plain": {
                        a = cmdLine.next();
                        if (active) {
                            if (options != null) {
                                options.setOutputFormat("PLAIN");
                                options.addOutputFormatOptions(NBootUtils.firstNonNull(a.getStringValue(), ""));
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "--xml": {
                        a = cmdLine.next();
                        if (active) {
                            if (options != null) {
                                options.setOutputFormat("XML");
                                options.addOutputFormatOptions(NBootUtils.firstNonNull(a.getStringValue(), ""));
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "--table": {
                        a = cmdLine.next();
                        if (active) {
                            if (options != null) {
                                options.setOutputFormat("TABLE");
                                options.addOutputFormatOptions(NBootUtils.firstNonNull(a.getStringValue(), ""));
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "--tree": {
                        a = cmdLine.next();
                        if (active) {
                            if (options != null) {
                                options.setOutputFormat("TREE");
                                options.addOutputFormatOptions(NBootUtils.firstNonNull(a.getStringValue(), ""));
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "--props": {
                        a = cmdLine.next();
                        if (active) {
                            if (options != null) {
                                options.setOutputFormat("PROPS");
                                options.addOutputFormatOptions(NBootUtils.firstNonNull(a.getStringValue(), ""));
                            }
                        } else {
                            return Collections.singletonList(a);
                        }
                    }
                    case "--yes": 
                    case "-y": {
                        a = cmdLine.nextFlag();
                        if (active && a.getBooleanValue().booleanValue()) {
                            if (options != null) {
                                options.setConfirm("YES");
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "--no": 
                    case "-n": {
                        a = cmdLine.nextFlag();
                        if (active && a.getBooleanValue().booleanValue()) {
                            if (options != null) {
                                options.setConfirm("NO");
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "--error": {
                        a = cmdLine.nextFlag();
                        if (active && a.getBooleanValue().booleanValue()) {
                            if (options != null) {
                                options.setConfirm("ERROR");
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "--ask": {
                        a = cmdLine.nextFlag();
                        if (active && a.getBooleanValue().booleanValue()) {
                            if (options != null) {
                                options.setConfirm("ASK");
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "--open-file": {
                        a = cmdLine.nextFlag();
                        if (active && a.getBooleanValue().booleanValue()) {
                            if (options != null) {
                                options.setExecutionType("OPEN");
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "--external": 
                    case "--spawn": 
                    case "-x": {
                        a = cmdLine.nextFlag();
                        if (active && a.getBooleanValue().booleanValue()) {
                            if (options != null) {
                                options.setExecutionType("SPAWN");
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "--user-cmd": 
                    case "--system": {
                        a = cmdLine.nextFlag();
                        if (active && a.getBooleanValue().booleanValue()) {
                            if (options != null) {
                                options.setExecutionType("SYSTEM");
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "--root-cmd": 
                    case "--as-root": {
                        a = cmdLine.nextFlag();
                        if (active && a.getBooleanValue().booleanValue()) {
                            if (options != null) {
                                options.setRunAs("ROOT");
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "--current-user": {
                        a = cmdLine.nextFlag();
                        if (active && a.getBooleanValue().booleanValue()) {
                            if (options != null) {
                                options.setRunAs("CURRENT_USER");
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "--run-as": {
                        a = cmdLine.nextEntry();
                        if (active) {
                            if (options != null) {
                                options.setRunAs("USER:" + a.getStringValue());
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "--sudo": {
                        a = cmdLine.nextFlag();
                        if (active) {
                            if (options != null) {
                                options.setRunAs("SUDO");
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "-": {
                        List<String> applicationArguments;
                        ArrayList<Object> newArgs;
                        if (active) {
                            newArgs = new ArrayList<String>();
                            newArgs.addAll(Arrays.asList(cmdLine.toStringArray()));
                            cmdLine.skipAll();
                            if (options != null) {
                                if (a.getValue() != null) {
                                    NBootWorkspaceHelper.addError(NBootMsg.ofC(NBootI18n.of("invalid argument for workspace: %s"), a.getImage()), options);
                                }
                                applicationArguments = NBootUtils.nonNullStrList(options.getApplicationArguments());
                                applicationArguments.addAll(newArgs);
                                options.setApplicationArguments(applicationArguments);
                            }
                            return newArgs.stream().map(NBootArg::of).collect(Collectors.toList());
                        }
                        newArgs = new ArrayList<String>(Arrays.asList(cmdLine.toStringArray()));
                        cmdLine.skipAll();
                        return newArgs.stream().map(NBootArg::of).collect(Collectors.toList());
                    }
                    case "-version": 
                    case "-v": 
                    case "--version": {
                        a = cmdLine.nextFlag();
                        if (active) {
                            if (options != null) {
                                options.setCommandVersion(a.isActive());
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "--out-line-prefix": {
                        a = cmdLine.nextEntry();
                        if (active && options != null) {
                            options.setOutLinePrefix(a.getStringValue());
                        }
                    }
                    case "--err-line-prefix": {
                        a = cmdLine.nextEntry();
                        if (active) {
                            if (options != null) {
                                options.setErrLinePrefix(a.getStringValue());
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "--line-prefix": {
                        a = cmdLine.nextEntry();
                        if (active) {
                            if (options != null) {
                                options.setOutLinePrefix(a.getStringValue());
                                options.setErrLinePrefix(a.getStringValue());
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "-e": 
                    case "--exec": {
                        List<String> applicationArguments;
                        ArrayList<Object> newArgs;
                        a = cmdLine.nextFlag();
                        if (active) {
                            newArgs = new ArrayList();
                            newArgs.add(a.toString());
                            if (a.getBooleanValue().booleanValue()) {
                                while ((a = cmdLine.next()) != null) {
                                    if (a.isOption()) {
                                        if (options != null) {
                                            List<String> executorOptions = options.getExecutorOptions();
                                            if (executorOptions == null) {
                                                executorOptions = new ArrayList<String>();
                                            }
                                            executorOptions.add(NBootUtils.firstNonNull(a.getImage(), ""));
                                            newArgs.add(NBootUtils.firstNonNull(a.getImage(), ""));
                                            options.setExecutorOptions(executorOptions);
                                            continue;
                                        }
                                        newArgs.add(NBootUtils.firstNonNull(a.getImage(), ""));
                                        continue;
                                    }
                                    if (options != null) {
                                        applicationArguments = NBootUtils.nonNullStrList(options.getApplicationArguments());
                                        applicationArguments.add(NBootUtils.firstNonNull(a.toString(), ""));
                                        List<String> list = Arrays.asList(cmdLine.toStringArray());
                                        applicationArguments.addAll(list);
                                        newArgs.addAll(list);
                                        cmdLine.skipAll();
                                        options.setApplicationArguments(applicationArguments);
                                        continue;
                                    }
                                    newArgs.addAll(Arrays.asList(cmdLine.toStringArray()));
                                    cmdLine.skipAll();
                                }
                            }
                            return newArgs.stream().map(NBootArg::of).collect(Collectors.toList());
                        }
                        newArgs = new ArrayList();
                        newArgs.addAll(Arrays.asList(cmdLine.toStringArray()));
                        cmdLine.skipAll();
                        return newArgs.stream().map(NBootArg::of).collect(Collectors.toList());
                    }
                    case "-?": 
                    case "--help": 
                    case "-h": {
                        a = cmdLine.nextFlag();
                        if (active) {
                            if (options != null) {
                                options.setCommandHelp(a.getBooleanValue());
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "--skip-errors": {
                        a = cmdLine.nextFlag();
                        if (active) {
                            if (options != null) {
                                options.setSkipErrors(a.getBooleanValue());
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    case "-L": 
                    case "--locale": {
                        a = cmdLine.nextEntry();
                        if (active) {
                            if (options != null) {
                                options.setLocale(a.getStringValue());
                            }
                            return Collections.singletonList(a);
                        }
                        return Collections.singletonList(a);
                    }
                    default: {
                        if (k.startsWith("---") && k.length() > 3 && k.charAt(3) != '-') {
                            a = cmdLine.next();
                            if (options != null) {
                                List<String> customOptions = options.getCustomOptions();
                                if (customOptions == null) {
                                    customOptions = new ArrayList<String>();
                                }
                                customOptions.add(a.toString());
                                options.setCustomOptions(customOptions);
                            }
                            return Collections.singletonList(a);
                        }
                        NBootWorkspaceHelper.addError(NBootMsg.ofC(NBootI18n.of("nuts: invalid option %s"), a.getImage()), options);
                        throw new NBootException(NBootMsg.ofC(NBootI18n.of("unsupported option %s"), a));
                    }
                }
                continue;
            }
            ArrayList<String> newArgs = new ArrayList<String>();
            newArgs.addAll(Arrays.asList(cmdLine.toStringArray()));
            cmdLine.skipAll();
            if (options != null) {
                List<String> applicationArguments = NBootUtils.nonNullStrList(options.getApplicationArguments());
                applicationArguments.addAll(newArgs);
                options.setApplicationArguments(applicationArguments);
            }
            return newArgs.stream().map(NBootArg::of).collect(Collectors.toList());
        }
        if (cmdLine.isEmpty()) {
            return null;
        }
        throw new NBootException(NBootMsg.ofC(NBootI18n.of("unsupported %s"), cmdLine.peek()));
    }

    private void postInit() {
        if (this.options.getCreationTime() == null) {
            this.options.setCreationTime(this.creationTime);
        }
        if (this.options.getApplicationArguments() == null) {
            this.options.setApplicationArguments(new ArrayList<String>());
        }
        if (this.options.getErrors() == null) {
            this.options.setErrors(new ArrayList<String>());
        }
        this.bLog.setOptions(this.options);
    }

    @Override
    public NBootWorkspace runWorkspace() {
        this.runWorkspace0();
        return this;
    }

    @Override
    public NWorkspaceBase getWorkspace() {
        return new NWorkspaceBase(){

            @Override
            public void runBootCommand() {
            }
        };
    }

    public void runWorkspace0() {
        if (NBootUtils.firstNonNull(this.options.getCommandHelp(), false).booleanValue()) {
            NBootWorkspaceHelper.runCommandHelp(this.options);
            return;
        }
        if (NBootUtils.firstNonNull(this.options.getCommandVersion(), false).booleanValue()) {
            NBootWorkspaceHelper.runCommandVersion(null, this.options);
            return;
        }
        if (this.options.getApplicationArguments().isEmpty()) {
            NBootWorkspaceHelper.addError(NBootMsg.ofPlain(NBootI18n.of("missing command")), this.options);
        }
        if (!this.options.getErrors().isEmpty()) {
            this.showErrors();
            StringBuilder sb = new StringBuilder();
            sb.append(NBootI18n.of("Unable to run command")).append("\n");
            sb.append(NBootI18n.of("run using options :")).append("\n");
            sb.append(" minTime =").append(this.minTime).append("\n");
            sb.append(" waitTime=").append(this.waitTime).append("\n");
            sb.append(" maxCount=").append(this.maxCount).append("\n");
            sb.append(" cmd     =").append(this.options.getApplicationArguments().stream().map(x -> "\"" + x + "\"").collect(Collectors.joining(" "))).append("\n");
            throw new NBootException(NBootMsg.ofC("%s", sb));
        }
        long count = 0L;
        do {
            this.showDebugLine(NBootI18n.of("START COMMAND"));
            long start = System.currentTimeMillis();
            int i = this.execCommand();
            long end = System.currentTimeMillis();
            this.showDebugLine(NBootMsg.ofC(NBootI18n.of("END   COMMAND : ret=%s; time=%s"), i, end - start).toString());
            if (this.minTime > 0L && end - start < this.minTime) {
                this.showErrorLine(NBootI18n.of("PROCESS TOO FAST, exit"));
                throw new NBootException(NBootMsg.ofC(NBootI18n.of("PROCESS TOO FAST, exit with : %s"), i), i);
            }
            if (this.waitTime <= 0L) continue;
            try {
                this.showDebugLine(NBootI18n.of("WAITING..."));
                Thread.sleep(this.waitTime);
            }
            catch (InterruptedException ex) {
                throw new NBootException(NBootMsg.ofC(NBootI18n.of("PROCESS INTERRUPTED, exit with : %s"), i), i);
            }
        } while (this.maxCount <= 0L || ++count < this.maxCount);
    }

    private int execCommand() {
        int i = 1;
        try {
            ProcessBuilder pb = new ProcessBuilder(this.options.getApplicationArguments());
            pb.inheritIO();
            Process p = pb.start();
            i = p.waitFor();
        }
        catch (Exception ex) {
            this.showErrorLine(ex.toString());
        }
        return i;
    }

    private void showDebugLine(String err) {
        Level lvl;
        NBootLogConfig lc = this.options.getLogConfig();
        if (lc != null && (lvl = lc.getLogTermLevel()) != null && lvl.intValue() <= Level.FINE.intValue()) {
            this.bLog.outln(err, new Object[0]);
        }
    }

    private void showErrorLine(String err) {
        this.bLog.errln(err, new Object[0]);
    }

    private void showErrors() {
        for (String error : this.options.getErrors()) {
            this.showErrorLine(error);
        }
    }
}

