/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot.internal.util;

import java.io.Serializable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import net.thevpc.nuts.boot.internal.util.NBootClock;
import net.thevpc.nuts.boot.internal.util.NBootDuration;

public class NBootChronometer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long accumulatedNanos;
    private NBootClock startClock;
    private NBootClock endClock;
    private String name;
    private long lastNanos;
    private boolean running;
    private ChronoUnit smallestUnit;
    private ChronoUnit largestUnit;

    public static NBootChronometer startNow() {
        return NBootChronometer.startNow(null, null);
    }

    public static NBootChronometer startNow(String name) {
        return NBootChronometer.startNow(name, null);
    }

    public static NBootChronometer startNow(ChronoUnit smallestUnit) {
        return NBootChronometer.startNow(null, smallestUnit);
    }

    public static NBootChronometer startNow(String name, ChronoUnit smallestUnit) {
        return new NBootChronometer(name, smallestUnit).start();
    }

    public NBootChronometer() {
    }

    public NBootChronometer copy() {
        return new NBootChronometer(this.name, this.startClock, this.endClock, this.accumulatedNanos, this.lastNanos, this.running, this.smallestUnit, this.largestUnit);
    }

    public NBootChronometer(String name, NBootClock startClock, NBootClock endClock, long accumulatedNanos, long lastNanos, boolean running, ChronoUnit smallestUnit, ChronoUnit largestUnit) {
        this.accumulatedNanos = accumulatedNanos;
        this.startClock = startClock;
        this.endClock = endClock;
        this.name = name;
        this.lastNanos = lastNanos;
        this.running = running;
        this.smallestUnit = smallestUnit;
        this.largestUnit = largestUnit;
    }

    public NBootChronometer restart() {
        this.stop();
        NBootChronometer c = this.copy();
        this.start();
        return c;
    }

    public NBootChronometer restart(String newName) {
        this.stop();
        NBootChronometer c = this.copy();
        this.setName(newName);
        this.start();
        return c;
    }

    public NBootChronometer(String name) {
        this.name = name;
    }

    public NBootChronometer(String name, ChronoUnit smallestUnit) {
        this.name = name;
        this.smallestUnit = smallestUnit;
    }

    public NBootChronometer setName(String desc) {
        this.name = desc;
        return this;
    }

    public NBootChronometer updateDescription(String desc) {
        this.setName(desc);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStarted() {
        return this.startClock != null;
    }

    public boolean isStopped() {
        return this.endClock != null;
    }

    public NBootChronometer reset() {
        this.endClock = null;
        this.startClock = null;
        this.lastNanos = 0L;
        this.accumulatedNanos = 0L;
        this.running = false;
        return this;
    }

    public NBootChronometer start() {
        this.endClock = null;
        this.startClock = NBootClock.now();
        this.lastNanos = this.startClock.getTimeNanos();
        this.accumulatedNanos = 0L;
        this.running = true;
        return this;
    }

    public NBootChronometer accumulate() {
        if (this.running) {
            long n = System.nanoTime();
            this.accumulatedNanos += n - this.lastNanos;
            this.lastNanos = n;
        }
        return this;
    }

    public Duration lap() {
        if (this.running) {
            long n = System.nanoTime();
            long lapValue = n - this.lastNanos;
            this.accumulatedNanos += lapValue;
            this.lastNanos = n;
            return Duration.ofNanos(lapValue);
        }
        return Duration.ZERO;
    }

    public boolean isSuspended() {
        return !this.running;
    }

    public NBootChronometer suspend() {
        if (this.running) {
            long n = System.nanoTime();
            this.accumulatedNanos += n - this.lastNanos;
            this.lastNanos = -1L;
            this.running = false;
        }
        return this;
    }

    public NBootChronometer resume() {
        if (!this.running) {
            this.lastNanos = System.nanoTime();
            this.running = true;
        }
        return this;
    }

    public NBootChronometer stop() {
        if (this.running) {
            this.endClock = NBootClock.now();
            this.accumulatedNanos += this.endClock.getTimeNanos() - this.lastNanos;
            this.lastNanos = -1L;
            this.running = false;
        }
        return this;
    }

    public NBootClock getStartClock() {
        return this.startClock;
    }

    public NBootClock getEndClock() {
        return this.endClock;
    }

    public NBootDuration getDuration() {
        return NBootDuration.ofNanos(this.getDurationNanos(), this.getSmallestUnit(), this.getLargestUnit());
    }

    public long getDurationMs() {
        return this.getDurationNanos() / 1000000L;
    }

    public long getDurationNanos() {
        if (this.startClock == null) {
            return 0L;
        }
        if (this.running) {
            long curr = System.nanoTime() - this.lastNanos;
            return curr + this.accumulatedNanos;
        }
        return this.accumulatedNanos;
    }

    public String toString() {
        String s = this.name == null ? "" : this.name + "=";
        return s + this.getDuration().toString();
    }

    public ChronoUnit getSmallestUnit() {
        return this.smallestUnit;
    }

    public NBootChronometer setSmallestUnit(ChronoUnit smallestUnit) {
        this.smallestUnit = smallestUnit;
        return this;
    }

    public ChronoUnit getLargestUnit() {
        return this.largestUnit;
    }

    public NBootChronometer setLargestUnit(ChronoUnit largestUnit) {
        this.largestUnit = largestUnit;
        return this;
    }
}

