/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot.internal.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import net.thevpc.nuts.boot.NBootException;
import net.thevpc.nuts.boot.internal.util.NBootChronometer;
import net.thevpc.nuts.boot.internal.util.NBootContext;
import net.thevpc.nuts.boot.internal.util.NBootLog;
import net.thevpc.nuts.boot.internal.util.NBootMsg;

public class NBootMonitoredURLInputStream
extends FilterInputStream {
    public static final int M = 0x100000;
    private NBootChronometer chronometer;
    private final long contentLength;
    private final URL url;
    long lastSec = -1L;
    long readCount = 0L;
    boolean preDestroyed = false;

    private NBootMonitoredURLInputStream(InputStream in, URL url, NBootChronometer chronometer, long contentLength) {
        super(in);
        this.chronometer = chronometer;
        this.url = url;
        this.contentLength = contentLength;
    }

    public static NBootMonitoredURLInputStream of(URL url) {
        NBootLog log = NBootContext.log();
        if (log != null) {
            log.with().level(Level.FINE).verbStart().log(NBootMsg.ofC("download %s", url));
        }
        NBootChronometer chronometer = NBootChronometer.startNow();
        URLConnection c = null;
        try {
            c = url.openConnection();
        }
        catch (IOException ex) {
            if (log != null) {
                log.with().level(Level.FINE).verbFail().log(NBootMsg.ofC("failed to download %s", url));
            }
            throw new UncheckedIOException("url not accessible " + url, ex);
        }
        Integer bootConnectionTimout = null;
        if (NBootContext.context() != null) {
            bootConnectionTimout = NBootContext.context().connectionTimout;
        }
        if (bootConnectionTimout == null) {
            bootConnectionTimout = 3000;
        }
        bootConnectionTimout = Math.max(0, bootConnectionTimout);
        c.setConnectTimeout(bootConnectionTimout);
        c.setReadTimeout(bootConnectionTimout);
        long contentLength = c.getContentLengthLong();
        try {
            return new NBootMonitoredURLInputStream(c.getInputStream(), url, chronometer, contentLength);
        }
        catch (IOException ex) {
            if (log != null) {
                log.with().level(Level.FINE).verbFail().log(NBootMsg.ofC("failed to download %s", url));
            }
            throw new UncheckedIOException("url not accessible " + url, ex);
        }
    }

    @Override
    public int read() throws IOException {
        int r = super.read();
        if (r >= 0) {
            ++this.readCount;
        } else {
            this.preDestroy();
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int t = super.read(b, off, len);
        if (t > 0) {
            this.readCount += (long)t;
            this.doLog(false);
        } else {
            this.preDestroy();
        }
        return t;
    }

    @Override
    public long skip(long n) throws IOException {
        long t = super.skip(n);
        if (t > 0L) {
            this.readCount += t;
            this.doLog(false);
        } else {
            this.preDestroy();
        }
        return t;
    }

    @Override
    public void close() throws IOException {
        this.preDestroy();
        super.close();
    }

    private void preDestroy() {
        if (!this.preDestroyed) {
            this.preDestroyed = true;
            this.chronometer.stop();
            this.doLog(true);
            NBootLog log = NBootContext.log();
            if (this.contentLength >= 0L && this.readCount != this.contentLength) {
                log.with().level(Level.FINE).verbFail().log(NBootMsg.ofC("failed to downloaded %s. stream closed unexpectedly", this.url));
                throw new NBootException(NBootMsg.ofC("failed to downloaded %s. stream closed unexpectedly", this.url));
            }
            if (log != null) {
                log.with().level(Level.FINE).verbSuccess().log(NBootMsg.ofC("successfully downloaded %s", this.url));
            }
        }
    }

    private void doLog(boolean force) {
        long sec = this.chronometer.getDuration().getTimeAsSeconds();
        if (sec == this.lastSec && !force) {
            return;
        }
        this.lastSec = sec;
        NBootLog log = NBootContext.log();
        if (sec == 0L) {
            if (this.contentLength <= 0L) {
                String v = this.formatSize(this.readCount) + "/s";
                if (log != null) {
                    log.with().level(Level.FINE).verbRead().log(NBootMsg.ofC("%-8s %s/s", v, this.url));
                }
            } else {
                float f = (float)((double)this.readCount / (double)this.contentLength * 100.0);
                String v = this.formatSize(this.readCount) + "/s";
                if (log != null) {
                    log.with().level(Level.FINE).verbRead().log(NBootMsg.ofC("%.2f%% %-8s %s", Float.valueOf(f), v, this.url));
                }
            }
        } else if (this.contentLength <= 0L) {
            String v = this.formatSize(this.readCount / sec) + "/s";
            if (log != null) {
                log.with().level(Level.FINE).verbRead().log(NBootMsg.ofC("%-8s %s", v, this.url));
            }
        } else {
            float f = (float)((double)this.readCount / (double)this.contentLength * 100.0);
            String v = this.formatSize(this.readCount / sec) + "/s";
            if (log != null) {
                log.with().level(Level.FINE).verbRead().log(NBootMsg.ofC("%.2f%% %-8s %s", Float.valueOf(f), v, this.url));
            }
        }
    }

    private String formatSize(long s) {
        if (s > 0x100000L) {
            long mega = s / 0x100000L;
            if ((s %= 0x100000L) == 0L) {
                return mega + "M";
            }
            String x = String.valueOf((int)((double)s / 1048576.0 * 100.0));
            if (x.length() < 2) {
                return mega + ".0" + x + "M";
            }
            return mega + "." + x + "M";
        }
        if (s > 1024L) {
            long kilo = s / 1024L;
            if ((s %= 1024L) == 0L) {
                return kilo + "K";
            }
            String x = String.valueOf((int)((double)s / 1024.0 * 100.0));
            if (x.length() < 2) {
                return kilo + ".0" + x + "K";
            }
            return kilo + "." + x + "K";
        }
        return s + "B";
    }
}

