/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.thevpc.nuts.boot.NBootOptionsInfo;
import net.thevpc.nuts.boot.internal.util.NBootContext;
import net.thevpc.nuts.boot.internal.util.NBootLog;
import net.thevpc.nuts.boot.internal.util.NBootMsg;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public class NBootWorkspaceHelper {
    public static void printDryCommand(String cmd, NBootOptionsInfo options) {
        String f = NBootUtils.firstNonNull(options.getOutputFormat(), "PLAIN");
        NBootLog log = NBootContext.log();
        if (NBootUtils.firstNonNull(options.getDry(), false).booleanValue()) {
            switch (NBootUtils.enumName(f)) {
                case "JSON": {
                    log.outln("{", new Object[0]);
                    log.outln("  \"dryCommand\": \"%s\"", cmd);
                    log.outln("}", new Object[0]);
                    return;
                }
                case "TSON": {
                    log.outln("{", new Object[0]);
                    log.outln("  dryCommand: \"%s\"", cmd);
                    log.outln("}", new Object[0]);
                    return;
                }
                case "YAML": {
                    log.outln("dryCommand: %s", cmd);
                    return;
                }
                case "TREE": {
                    log.outln("- dryCommand: %s", cmd);
                    return;
                }
                case "TABLE": {
                    log.outln("dryCommand  %s", cmd);
                    return;
                }
                case "XML": {
                    log.outln("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>", new Object[0]);
                    log.outln("<object>", new Object[0]);
                    log.outln("  <string key=\"%s\" value=\"%s\"/>", "dryCommand", cmd);
                    log.outln("</object>", new Object[0]);
                    return;
                }
                case "PROPS": {
                    log.outln("dryCommand=%s", cmd);
                    return;
                }
            }
            log.outln("[Dry] %s", "0.8.9");
        }
    }

    public static void runCommandVersion(Supplier<String> digest, NBootOptionsInfo options) {
        String f = NBootUtils.firstNonNull(options.getOutputFormat(), "PLAIN");
        if (NBootUtils.firstNonNull(options.getDry(), false).booleanValue()) {
            NBootWorkspaceHelper.printDryCommand("version", options);
            return;
        }
        NBootLog log = NBootContext.log();
        switch (NBootUtils.enumName(f)) {
            case "JSON": {
                log.outln("{", new Object[0]);
                log.outln("  \"version\": \"%s\",", "0.8.9");
                if (digest != null) {
                    log.outln("  \"digest\": \"%s\"", digest.get());
                }
                log.outln("}", new Object[0]);
                return;
            }
            case "TSON": {
                log.outln("{", new Object[0]);
                log.outln("  version: \"%s\",", "0.8.9");
                if (digest != null) {
                    log.outln("  digest: \"%s\"", digest.get());
                }
                log.outln("}", new Object[0]);
                return;
            }
            case "YAML": {
                log.outln("version: %s", "0.8.9");
                if (digest != null) {
                    log.outln("digest: %s", digest.get());
                }
                return;
            }
            case "TREE": {
                log.outln("- version: %s", "0.8.9");
                if (digest != null) {
                    log.outln("- digest: %s", digest.get());
                }
                return;
            }
            case "TABLE": {
                log.outln("version      %s", "0.8.9");
                if (digest != null) {
                    log.outln("digest  %s", digest.get());
                }
                return;
            }
            case "XML": {
                log.outln("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>", new Object[0]);
                log.outln("<object>", new Object[0]);
                log.outln("  <string key=\"%s\" value=\"%s\"/>", "version", "0.8.9");
                if (digest != null) {
                    log.outln("  <string key=\"%s\" value=\"%s\"/>", "digest", digest.get());
                }
                log.outln("</object>", new Object[0]);
                return;
            }
            case "PROPS": {
                log.outln("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>", new Object[0]);
                log.outln("version=%s", "0.8.9");
                if (digest != null) {
                    log.outln("digest=%s", digest.get());
                }
                log.outln("</object>", new Object[0]);
                return;
            }
        }
        log.outln("%s", "0.8.9");
    }

    public static void addError(NBootMsg err, NBootOptionsInfo options) {
        List<String> showError = options.getErrors();
        if (showError == null) {
            showError = new ArrayList<String>();
        }
        showError.add(err.toString());
    }

    public static void runCommandHelp(NBootOptionsInfo options) {
        String f = NBootUtils.firstNonNull(options.getOutputFormat(), "PLAIN");
        NBootLog log = NBootContext.log();
        if (NBootUtils.firstNonNull(options.getDry(), false).booleanValue()) {
            NBootWorkspaceHelper.printDryCommand("help", options);
        } else {
            String msg = "nuts is an open source package manager mainly for java applications. Type 'nuts help' or visit https://github.com/thevpc/nuts for more help.";
            switch (NBootUtils.enumName(f)) {
                case "JSON": {
                    log.outln("{", new Object[0]);
                    log.outln("  \"help\": \"%s\"", msg);
                    log.outln("}", new Object[0]);
                    return;
                }
                case "TSON": {
                    log.outln("{", new Object[0]);
                    log.outln("  help: \"%s\"", msg);
                    log.outln("}", new Object[0]);
                    return;
                }
                case "YAML": {
                    log.outln("help: %s", msg);
                    return;
                }
                case "TREE": {
                    log.outln("- help: %s", msg);
                    return;
                }
                case "TABLE": {
                    log.outln("help  %s", msg);
                    return;
                }
                case "XML": {
                    log.outln("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>", new Object[0]);
                    log.outln("<string>", new Object[0]);
                    log.outln(" %s", msg);
                    log.outln("</string>", new Object[0]);
                    return;
                }
                case "PROPS": {
                    log.outln("help=%s", msg);
                    return;
                }
            }
            log.outln("%s", msg);
        }
    }
}

